/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.pdo.AbstractSessionTask;
import org.tentackle.pdo.DefaultSessionTaskDispatcher;
import org.tentackle.pdo.ExclusiveSessionProvider;
import org.tentackle.pdo.ModificationEvent;
import org.tentackle.pdo.ModificationEventDetail;
import org.tentackle.pdo.ModificationListener;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbModification;
import org.tentackle.persist.MasterSerial;
import org.tentackle.persist.ModificationTally;
import org.tentackle.persist.rmi.ModificationTrackerRemoteDelegate;
import org.tentackle.task.Task;

public class ModificationTracker
extends DefaultSessionTaskDispatcher
implements ExclusiveSessionProvider {
    public static long defaultPollingInterval = 2000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ModificationTracker.class);
    private static final AtomicInteger LISTENER_KEY_INSTANCE_COUNTER = new AtomicInteger();
    private static int delegateId;
    private final List<Runnable> shutdownRunnables;
    private final Map<String, ModificationTally> countersByName;
    private final Map<Long, ModificationTally> countersById;
    private final Set<ListenerEntry> listenerEntries;
    private final Map<String, TableEntry> tableEntriesByName;
    private final Map<Long, TableEntry> tableEntriesById;
    private volatile TableEntry masterEntry;
    private final Random timeRandom;
    private final Map<ModificationListener, DelayedEvent> delayedListeners;
    private final Set<DelayedEvent> delayedEvents;
    private long delayedSleepInterval;
    private DbModification masterModification;

    private static int getRemoteDelegateId() {
        if (delegateId == 0) {
            delegateId = Db.prepareRemoteDelegate(ModificationTracker.class);
        }
        return delegateId;
    }

    public ModificationTracker(String name) {
        super(name);
        this.setDaemon(false);
        this.setSleepInterval(defaultPollingInterval);
        this.countersByName = new ConcurrentHashMap<String, ModificationTally>();
        this.countersById = new HashMap<Long, ModificationTally>();
        this.listenerEntries = new TreeSet<ListenerEntry>();
        this.delayedListeners = new HashMap<ModificationListener, DelayedEvent>();
        this.delayedEvents = new TreeSet<DelayedEvent>();
        this.tableEntriesByName = new ConcurrentHashMap<String, TableEntry>();
        this.tableEntriesById = new ConcurrentHashMap<Long, TableEntry>();
        this.timeRandom = new Random();
        this.shutdownRunnables = new ArrayList<Runnable>();
    }

    public Session requestSession() {
        this.lock(Thread.currentThread());
        return this.getSession();
    }

    public boolean releaseSession(Session session) {
        return this.unlock(Thread.currentThread());
    }

    public Db getSession() {
        Db db = (Db)super.getSession();
        if (db == null) {
            throw new PersistenceException("no session configured for " + (Object)((Object)this));
        }
        return db;
    }

    public void setSession(Session session) {
        super.setSession(session);
        try {
            this.masterModification = new DbModification((Db)session);
            this.selectMasterSerial();
        }
        catch (PersistenceException ex) {
            DbModification.initializeModificationTable(this.getSession());
        }
    }

    protected void cleanup() {
        super.cleanup();
        this.invokeShutdownRunnables();
    }

    public synchronized void addShutdownRunnable(Runnable runnable) {
        this.shutdownRunnables.add(runnable);
    }

    public synchronized boolean removeShutdownRunnable(Runnable runnable) {
        return this.shutdownRunnables.remove(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModificationListener(ModificationListener listener) {
        if (listener.getNames() == null || listener.getNames().length == 0) {
            if (this.masterEntry == null) {
                this.configureMaster();
            }
            ModificationTracker modificationTracker = this;
            synchronized (modificationTracker) {
                this.listenerEntries.add(new ListenerEntry(listener, this.masterEntry));
            }
        } else {
            for (String name : listener.getNames()) {
                TableEntry entry = this.tableEntriesByName.get(name);
                if (entry == null) {
                    this.configureName(name);
                    entry = this.tableEntriesByName.get(name);
                }
                ModificationTracker modificationTracker = this;
                synchronized (modificationTracker) {
                    this.listenerEntries.add(new ListenerEntry(listener, entry));
                }
            }
        }
    }

    public synchronized boolean removeModificationListener(ModificationListener listener) {
        boolean removed = false;
        Iterator<ListenerEntry> iter = this.listenerEntries.iterator();
        while (iter.hasNext()) {
            ListenerEntry listenerEntry = iter.next();
            if (listener != listenerEntry.listener) continue;
            iter.remove();
            removed = true;
        }
        return removed;
    }

    public long getMasterSerial() {
        if (this.masterEntry == null) {
            this.configureMaster();
        }
        return this.masterEntry.serial;
    }

    public IdSerialTuple getIdSerialForName(String tableName) {
        TableEntry entry = this.tableEntriesByName.get(tableName);
        if (entry == null) {
            this.configureName(tableName);
            entry = this.tableEntriesByName.get(tableName);
        }
        return new IdSerialTuple(entry.id, entry.serial);
    }

    public List<IdSerialTuple> getAllSerials() {
        ArrayList<IdSerialTuple> idSerList = new ArrayList<IdSerialTuple>();
        for (TableEntry entry : this.tableEntriesByName.values()) {
            idSerList.add(new IdSerialTuple(entry.id, entry.serial));
        }
        return idSerList;
    }

    public long countModification(String tableName) {
        long tableSerial = 0L;
        if (this.isAlive()) {
            ModificationTally counter = this.getCounter(tableName);
            counter.countPending();
            tableSerial = counter.getLatestSerial();
        }
        return tableSerial;
    }

    public void invalidate() {
        AbstractSessionTask task = new AbstractSessionTask(){

            public void run() {
                ModificationTracker.this.countersByName.clear();
                ModificationTracker.this.countersById.clear();
                if (ModificationTracker.this.masterEntry != null) {
                    ModificationTracker.this.masterEntry.serial = 1L;
                }
                DbModification.initializeModificationTable(ModificationTracker.this.getSession());
                ModificationTracker.this.refreshTableEntries();
            }
        };
        if (this.isTaskDispatcherThread() || !this.isAlive()) {
            task.run();
        } else {
            this.addTaskAndWait((Task)task);
        }
    }

    protected void lockInternal() {
        this.poll();
        this.invokeDelayedListeners();
        super.lockInternal();
    }

    protected void unlockInternal(long sleepMs) {
        if (this.delayedSleepInterval > 0L) {
            if (this.delayedSleepInterval < sleepMs) {
                sleepMs = this.delayedSleepInterval;
            }
            this.delayedSleepInterval = 0L;
        }
        super.unlockInternal(sleepMs);
    }

    protected ModificationEvent createModificationEvent(Collection<ModificationEventDetail> details) {
        return details == null || details.isEmpty() ? new ModificationEvent((Session)this.getSession(), this.getMasterSerial()) : new ModificationEvent((Session)this.getSession(), details);
    }

    private void poll() {
        for (ModificationTally counter : this.countersByName.values()) {
            counter.performPendingCount();
        }
        long serial = this.selectMasterSerial();
        if (serial != this.getMasterSerial()) {
            if (serial < this.getMasterSerial()) {
                this.invalidate();
            }
            HashMap detailMap = new HashMap();
            for (IdSerialTuple idSerialTuple : this.selectAllIdSerials()) {
                TableEntry entry;
                ModificationTally counter;
                if (idSerialTuple.getId() > 0L && (counter = this.countersById.get(idSerialTuple.getId())) != null) {
                    counter.setLastSerial(idSerialTuple.getSerial());
                }
                if ((entry = this.tableEntriesById.get(idSerialTuple.getId())) == null) continue;
                for (ListenerEntry listenerEntry : this.listenerEntries) {
                    if (listenerEntry.tableEntry.id != idSerialTuple.getId() || listenerEntry.tableEntry.serial == idSerialTuple.getSerial()) continue;
                    LOGGER.fine("modification detected for {0}", new Object[]{listenerEntry.tableEntry});
                    HashSet<ModificationEventDetail> details = (HashSet<ModificationEventDetail>)detailMap.get(listenerEntry.listener);
                    if (details == null) {
                        details = new HashSet<ModificationEventDetail>();
                        detailMap.put(listenerEntry.listener, details);
                    }
                    if (listenerEntry.isMaster()) continue;
                    this.getCounter(listenerEntry.tableEntry.tableName);
                    details.add(listenerEntry.createDetail());
                }
                entry.serial = idSerialTuple.getSerial();
            }
            this.masterEntry.serial = serial;
            for (Map.Entry entry : detailMap.entrySet()) {
                ModificationListener listener = (ModificationListener)entry.getKey();
                Set details = (Set)entry.getValue();
                long timeFrame = listener.getTimeFrame();
                long timeDelay = listener.getTimeDelay();
                if (timeFrame > 0L || timeDelay > 0L) {
                    DelayedEvent event = this.delayedListeners.get(listener);
                    if (event == null) {
                        long epochalExecutionTime = System.currentTimeMillis();
                        if (timeDelay > 0L) {
                            epochalExecutionTime += timeDelay;
                        }
                        if (timeFrame > 0L) {
                            epochalExecutionTime += (long)(this.timeRandom.nextDouble() * (double)timeFrame);
                        }
                        event = new DelayedEvent(epochalExecutionTime, listener);
                        event.addDetails(details);
                        this.delayedListeners.put(listener, event);
                        this.delayedEvents.add(event);
                        continue;
                    }
                    event.addDetails(details);
                    continue;
                }
                listener.dataChanged(this.createModificationEvent(details));
            }
        }
    }

    private void invokeDelayedListeners() {
        long currentTime = System.currentTimeMillis();
        this.delayedSleepInterval = this.getSleepInterval();
        Iterator<DelayedEvent> iter = this.delayedEvents.iterator();
        while (iter.hasNext()) {
            DelayedEvent delayedEvent = iter.next();
            long msLeft = delayedEvent.invocationTime - currentTime;
            if (msLeft <= 0L) {
                ModificationEvent event = this.createModificationEvent(delayedEvent.getDetails());
                delayedEvent.listener.dataChanged(event);
                iter.remove();
                this.delayedListeners.remove(delayedEvent.listener);
                continue;
            }
            if (msLeft >= this.delayedSleepInterval) continue;
            this.delayedSleepInterval = msLeft;
        }
    }

    private void refreshTableEntries() {
        for (TableEntry entry : this.tableEntriesByName.values()) {
            this.getCounter(entry.tableName);
            IdSerialTuple idSer = this.selectIdSerialForName(entry.tableName);
            if (idSer == null) continue;
            entry.id = idSer.getId();
            entry.serial = idSer.getSerial();
        }
    }

    protected long extractMasterSerial(MasterSerial masterSerial) {
        return masterSerial.serial;
    }

    private long selectMasterSerial() {
        if (this.getSession().isRemote()) {
            try {
                return this.extractMasterSerial(((ModificationTrackerRemoteDelegate)this.getSession().getRemoteDelegate(ModificationTracker.getRemoteDelegateId())).selectMasterSerial());
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        return this.masterModification.selectMasterSerial();
    }

    private List<IdSerialTuple> selectAllIdSerials() {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationTrackerRemoteDelegate)this.getSession().getRemoteDelegate(ModificationTracker.getRemoteDelegateId())).selectAllSerials();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        return this.masterModification.selectAllIdSerial();
    }

    private IdSerialTuple selectIdSerialForName(String tableName) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationTrackerRemoteDelegate)this.getSession().getRemoteDelegate(ModificationTracker.getRemoteDelegateId())).selectIdSerialForName(tableName);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        return this.masterModification.selectIdSerial(tableName);
    }

    private ModificationTally getCounter(String tableName) {
        ModificationTally counter = this.countersByName.get(tableName);
        if (counter == null) {
            counter = this.configureCounter(tableName);
        }
        return counter;
    }

    private ModificationTally configureCounter(final String tableName) {
        AbstractSessionTask task = new AbstractSessionTask(){

            public void run() {
                ModificationTally counter = new ModificationTally(ModificationTracker.this.getSession(), tableName);
                IdSerialTuple idSer = ModificationTracker.this.selectIdSerialForName(tableName);
                long lastSerial = idSer == null ? 0L : idSer.getSerial();
                counter.setLastSerial(lastSerial);
                ModificationTracker.this.countersByName.put(tableName, counter);
                ModificationTracker.this.countersById.put(counter.getId(), counter);
            }
        };
        if (this.isTaskDispatcherThread() || !this.isAlive()) {
            task.run();
        } else {
            this.addTaskAndWait((Task)task);
        }
        return this.countersByName.get(tableName);
    }

    private void configureMaster() {
        AbstractSessionTask task = new AbstractSessionTask(){

            public void run() {
                long serial = ModificationTracker.this.selectMasterSerial();
                ModificationTracker.this.masterEntry = new TableEntry(null, 0L, serial);
            }
        };
        if (this.isTaskDispatcherThread() || !this.isAlive()) {
            task.run();
        } else {
            this.addTaskAndWait((Task)task);
        }
    }

    private void configureName(final String name) {
        AbstractSessionTask task = new AbstractSessionTask(){

            public void run() {
                IdSerialTuple idSer = ModificationTracker.this.selectIdSerialForName(name);
                if (idSer == null) {
                    ModificationTracker.this.getCounter(name).addToModificationTable();
                    idSer = ModificationTracker.this.selectIdSerialForName(name);
                }
                TableEntry entry = new TableEntry(name, idSer.getId(), idSer.getSerial());
                ModificationTracker.this.tableEntriesByName.put(name, entry);
                ModificationTracker.this.tableEntriesById.put(idSer.getId(), entry);
            }
        };
        if (this.isTaskDispatcherThread() || !this.isAlive()) {
            task.run();
        } else {
            this.addTaskAndWait((Task)task);
        }
    }

    private void invokeShutdownRunnables() {
        ArrayList<Runnable> tempList = new ArrayList<Runnable>(this.shutdownRunnables);
        this.shutdownRunnables.clear();
        for (Runnable r : tempList) {
            try {
                r.run();
            }
            catch (Exception ex) {
                LOGGER.logStacktrace(Logger.Level.SEVERE, (Throwable)ex);
            }
        }
    }

    private static class DelayedEvent
    implements Comparable<DelayedEvent> {
        private final ModificationListener listener;
        private final Map<String, ModificationEventDetail> details;
        private final long invocationTime;

        private DelayedEvent(long invocationTime, ModificationListener listener) {
            this.invocationTime = invocationTime;
            this.listener = listener;
            this.details = new HashMap<String, ModificationEventDetail>();
        }

        private void addDetails(Collection<ModificationEventDetail> details) {
            for (ModificationEventDetail detail : details) {
                this.details.put(detail.getName(), detail);
            }
        }

        private Collection<ModificationEventDetail> getDetails() {
            return this.details.values();
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Objects.hashCode(this.listener);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DelayedEvent other = (DelayedEvent)obj;
            return Objects.equals(this.listener, other.listener);
        }

        @Override
        public int compareTo(DelayedEvent o) {
            return Long.compare(this.invocationTime, o.invocationTime);
        }
    }

    private static class TableEntry {
        private final String tableName;
        private long id;
        private volatile long serial;

        private TableEntry(String tableName, long id, long serial) {
            this.tableName = tableName;
            this.id = id;
            this.serial = serial;
        }

        private boolean isMaster() {
            return this.id == 0L;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.tableName != null) {
                buf.append("tablename='");
                buf.append(this.tableName);
                buf.append("', id=");
                buf.append(this.id);
            } else {
                buf.append("master");
            }
            buf.append(", serial=");
            buf.append(this.serial);
            return buf.toString();
        }
    }

    private static class ListenerEntry
    implements Comparable<ListenerEntry> {
        private final ModificationListener listener;
        private final TableEntry tableEntry;
        private final int priority;
        private final int instanceNumber;
        private final long timeFrame;

        private ListenerEntry(ModificationListener listener, TableEntry tableEntry) {
            this.listener = listener;
            this.tableEntry = tableEntry;
            if (listener.getTimeFrame() > 0L) {
                this.timeFrame = listener.getTimeFrame();
                this.priority = 0;
            } else {
                this.timeFrame = 0L;
                this.priority = listener.getPriority();
            }
            this.instanceNumber = LISTENER_KEY_INSTANCE_COUNTER.incrementAndGet();
        }

        private boolean isMaster() {
            return this.tableEntry.isMaster();
        }

        private ModificationEventDetail createDetail() {
            return new ModificationEventDetail(this.tableEntry.tableName, this.tableEntry.serial);
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.instanceNumber;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.instanceNumber == ((ListenerEntry)obj).instanceNumber;
        }

        @Override
        public int compareTo(ListenerEntry obj) {
            if (obj == null) {
                return Integer.MAX_VALUE;
            }
            int rv = this.priority - obj.priority;
            if (rv == 0) {
                rv = this.instanceNumber - obj.instanceNumber;
            }
            return rv;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("order=");
            buf.append(this.instanceNumber);
            if (this.timeFrame != 0L) {
                buf.append(" window=");
                buf.append(this.timeFrame);
            } else {
                buf.append(" prio=");
                buf.append(this.priority);
            }
            return buf.toString();
        }
    }
}

