/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.concurrent.atomic.AtomicLong;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.Identifiable;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.PersistentObjectClassVariables;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbModification;
import org.tentackle.persist.DbObjectClassVariables;

public class ModificationTally {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModificationTally.class);
    private final DbModification dbModification;
    private DbObjectClassVariables<?> clazzVar;
    private Boolean isTableSerialProvided;
    private String tableSerialTableName;
    private final AtomicLong lastSerial = new AtomicLong();
    private final AtomicLong pendingCount = new AtomicLong();

    public ModificationTally(Db db, String trackedName) {
        String className;
        this.dbModification = new DbModification(db, trackedName);
        this.clazzVar = DbObjectClassVariables.getVariables(trackedName);
        if (this.clazzVar == null && (className = PdoUtilities.getInstance().getPdoClassName(trackedName)) != null) {
            try {
                Pdo.create((String)className);
                this.clazzVar = DbObjectClassVariables.getVariables(trackedName);
            }
            catch (PdoRuntimeException pdoRuntimeException) {
                // empty catch block
            }
        }
        if (this.clazzVar == null) {
            LOGGER.info("counter created for {0} not assigned to any class variable", new Object[]{trackedName});
        } else {
            LOGGER.info("counter created for {0} assigned to class variable {1}", new Object[]{trackedName, this.clazzVar});
        }
    }

    public long getId() {
        return this.dbModification.getId();
    }

    public long countPending() {
        return this.pendingCount.incrementAndGet();
    }

    public long getPendingCount() {
        return this.pendingCount.get();
    }

    public void setLastSerial(long lastSerial) {
        this.lastSerial.set(lastSerial);
    }

    public long getLatestSerial() {
        return this.lastSerial.get() + this.pendingCount.get();
    }

    public void performPendingCount() {
        long count = this.pendingCount.getAndSet(0L);
        if (count > 0L) {
            this.lastSerial.addAndGet(count);
            LOGGER.fine("increment serial for {0} by {1}", new Object[]{this.dbModification, count});
            if (this.dbModification.countModification(count) != 2) {
                this.dbModification.addToModificationTable(this.clazzVar != null, this.getTableSerialTableName());
                if (this.dbModification.countModification(count) != 2) {
                    throw new PersistenceException((Identifiable)this.dbModification, "updating modification count failed");
                }
            }
        }
    }

    public void addToModificationTable() {
        this.dbModification.addToModificationTable(this.clazzVar != null, this.getTableSerialTableName());
        this.lastSerial.set(this.getModificationCount());
    }

    public long getModificationCount() {
        return this.dbModification.refresh();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized String getTableSerialTableName() {
        if (this.isTableSerialProvided != null) return this.tableSerialTableName;
        if (this.clazzVar != null) {
            try {
                Object po = AbstractDbObject.newInstance(this.clazzVar.clazz);
                this.isTableSerialProvided = ((AbstractDbObject)po).isTableSerialProvided();
                if (!this.isTableSerialProvided.booleanValue()) return this.tableSerialTableName;
                this.tableSerialTableName = ((AbstractDbObject)po).getTableName();
                if (!(this.clazzVar instanceof PersistentObjectClassVariables)) return this.tableSerialTableName;
                PersistentObjectClassVariables cv = (PersistentObjectClassVariables)this.clazzVar;
                while (cv != null) {
                    if (cv.tableName != null) {
                        this.tableSerialTableName = cv.tableName;
                    }
                    cv = cv.superClassVariables;
                }
                return this.tableSerialTableName;
            }
            catch (Exception ex) {
                throw new IllegalStateException("can't evaluate isTableSerialProvided() for " + this.clazzVar, ex);
            }
        } else {
            this.isTableSerialProvided = false;
        }
        return this.tableSerialTableName;
    }
}

