/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.MappedDiagnosticContext;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.ConnectionManager;
import org.tentackle.persist.Db;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementHistory;
import org.tentackle.persist.StatementKey;
import org.tentackle.persist.StatementStatistics;
import org.tentackle.persist.StatementWrapper;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.sql.Backend;

public class ManagedConnection {
    private static final Set<WeakReference<ManagedConnection>> MANAGED_CONNECTIONS = Collections.newSetFromMap(new ConcurrentHashMap());
    public static long logMinAttachMillis;
    public static boolean collectStatistics;
    public static long logStatisticsMillis;
    public static Pattern mdcFilter;
    public static boolean checkStatementResultSetParameters;
    private static final Logger LOGGER;
    private static final AtomicLong INSTANCE_COUNTER;
    private final ConnectionManager manager;
    private final Backend backend;
    private Connection connection;
    private final String backendId;
    private final long instanceNumber;
    private Db db;
    private long establishedSince;
    private long expireAt;
    private long attachedSince;
    private long detachedSince;
    private int index;
    private int attachCount;
    private int maxCountForClearWarnings;
    private int counterForClearWarnings;
    private boolean dead;
    private StatementHistory currentStatement;
    private final List<StatementHistory> statementHistory;
    private final Map<StatementKey, PreparedStatementWrapper> preparedStatements;
    private final Set<WeakReference<ResultSetWrapper>> openResultSets;
    private final Set<WeakReference<StatementWrapper>> runningStatements;

    public static Collection<ManagedConnection> getManagedConnections() {
        ArrayList<ManagedConnection> mgcons = new ArrayList<ManagedConnection>();
        Iterator<WeakReference<ManagedConnection>> iter = MANAGED_CONNECTIONS.iterator();
        while (iter.hasNext()) {
            ManagedConnection mgcon = (ManagedConnection)iter.next().get();
            if (mgcon != null && !mgcon.isClosed()) {
                mgcons.add(mgcon);
                continue;
            }
            iter.remove();
        }
        return mgcons;
    }

    public ManagedConnection(ConnectionManager manager, Backend backend, Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        this.manager = manager;
        this.backend = backend;
        this.connection = connection;
        this.backendId = backend.getBackendId(connection);
        this.instanceNumber = INSTANCE_COUNTER.incrementAndGet();
        MANAGED_CONNECTIONS.add(new WeakReference<ManagedConnection>(this));
        this.detachedSince = this.establishedSince = System.currentTimeMillis();
        this.index = -1;
        this.statementHistory = new ArrayList<StatementHistory>();
        this.preparedStatements = new ConcurrentHashMap<StatementKey, PreparedStatementWrapper>();
        this.openResultSets = Collections.newSetFromMap(new ConcurrentHashMap());
        this.runningStatements = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public ConnectionManager getManager() {
        return this.manager;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public long getEstablishedSince() {
        return this.establishedSince;
    }

    public void setExpireAt(long expireAt) {
        this.expireAt = expireAt;
    }

    public long getExpireAt() {
        return this.expireAt;
    }

    public long getAttachedSince() {
        return this.attachedSince;
    }

    public long getDetachedSince() {
        return this.detachedSince;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public boolean isDead() {
        return this.dead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyConnection() {
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeQuery("SELECT 1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            this.setDead(true);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attachSession(Db db) {
        if (db == null) {
            throw new IllegalArgumentException("db is null");
        }
        if (this.db != null) {
            if (this.db != db) throw new PersistenceException((Session)db, "connection " + this + " already attached to " + this.db);
            if (db.getConnection() != this) {
                throw new PersistenceException((Session)db, "db lost current connection " + this + ", count=" + this.attachCount);
            }
            ++this.attachCount;
        } else {
            if (this.attachCount != 0) {
                throw new PersistenceException((Session)db, "attach count of unattached connection " + this + " is not 0, but " + this.attachCount);
            }
            this.db = db;
            db.setConnection(this);
            this.attachCount = 1;
            this.attachedSince = System.currentTimeMillis();
            this.detachedSince = 0L;
        }
        LOGGER.finer("{0} attached to {1}, count={2}", new Object[]{db, this, this.attachCount});
    }

    public boolean isAttached() {
        return this.db != null;
    }

    public boolean isTxRunning() {
        return this.isAttached() && this.db.isTxRunning();
    }

    public void detachSession(Db db) {
        if (db == null) {
            throw new IllegalArgumentException("db is null");
        }
        if (this.db != db) {
            throw new PersistenceException((Session)db, "connection " + this + " not attached to " + db + " (instead attached to " + this.db + ")");
        }
        LOGGER.finer("{0} detached from {1}, count={2}", new Object[]{db, this, this.attachCount});
        --this.attachCount;
        if (this.attachCount == 0) {
            this.detachedSince = System.currentTimeMillis();
            if (logMinAttachMillis != 0L && this.detachedSince - this.attachedSince > logMinAttachMillis) {
                if (this.isMDCValid()) {
                    LOGGER.warning("attached for " + (this.detachedSince - this.attachedSince) + "ms: " + this.toDiagnosticString(), new Object[0]);
                }
            } else if (LOGGER.isFineLoggable() && this.isMDCValid()) {
                LOGGER.fine(this.toDiagnosticString(), new Object[0]);
            }
            this.db = null;
            db.setConnection(null);
            this.attachedSince = 0L;
            if (collectStatistics) {
                if (logStatisticsMillis > 0L && this.detachedSince - StatementStatistics.getSince() > logStatisticsMillis) {
                    StatementStatistics.log(LOGGER, Logger.Level.INFO, true);
                }
                if (this.isMDCValid()) {
                    for (StatementHistory history : this.statementHistory) {
                        StatementStatistics.collect(history);
                    }
                    if (this.currentStatement != null) {
                        StatementStatistics.collect(this.currentStatement);
                    }
                }
            }
            this.statementHistory.clear();
            this.currentStatement = null;
        } else {
            if (db.getConnection() != this) {
                throw new PersistenceException((Session)db, "db lost current connection " + this + ", count=" + this.attachCount++);
            }
            if (this.attachCount < 0) {
                throw new PersistenceException((Session)db, "connection " + this + " detached too often, attachcount = " + this.attachCount++);
            }
        }
    }

    public Db getSession() {
        return this.db;
    }

    public long getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getBackendId() {
        return this.backendId;
    }

    public String getName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.instanceNumber);
        if (this.backendId != null) {
            buf.append('/');
            buf.append(this.backendId);
        }
        return buf.toString();
    }

    public String toString() {
        Connection con = this.connection;
        return (con == null ? "<closed connection>" : con.toString()) + '[' + this.getName() + ']';
    }

    protected boolean isMDCValid() {
        if (mdcFilter == null) {
            return true;
        }
        MappedDiagnosticContext mdc = LOGGER.getMappedDiagnosticContext();
        return mdc != null && mdc.matchesPattern(mdcFilter);
    }

    StatementHistory logStatementHistory(StatementWrapper statement) {
        StatementHistory history = new StatementHistory(statement);
        if (this.isTxRunning()) {
            this.statementHistory.add(history);
        } else {
            this.currentStatement = history;
        }
        return history;
    }

    public List<StatementHistory> getStatementHistory() {
        return this.statementHistory;
    }

    public void addResultSet(ResultSetWrapper rs) {
        this.openResultSets.add(new WeakReference<ResultSetWrapper>(rs));
    }

    public void removeResultSet(ResultSetWrapper rs) {
        Iterator<WeakReference<ResultSetWrapper>> iter = this.openResultSets.iterator();
        while (iter.hasNext()) {
            WeakReference<ResultSetWrapper> ref = iter.next();
            ResultSetWrapper refRs = (ResultSetWrapper)ref.get();
            if (refRs != null && refRs != rs) continue;
            iter.remove();
        }
    }

    public Collection<ResultSetWrapper> getOpenResultSets() {
        ArrayList<ResultSetWrapper> rsList = new ArrayList<ResultSetWrapper>();
        Iterator<WeakReference<ResultSetWrapper>> iter = this.openResultSets.iterator();
        while (iter.hasNext()) {
            WeakReference<ResultSetWrapper> ref = iter.next();
            ResultSetWrapper refRs = (ResultSetWrapper)ref.get();
            if (refRs != null) {
                rsList.add(refRs);
                continue;
            }
            iter.remove();
        }
        return rsList;
    }

    public String toDiagnosticString() {
        StringBuilder buf = new StringBuilder(this.toString());
        if (this.dead) {
            buf.append(" *** DEAD *** ");
        }
        buf.append(": ");
        buf.append(this.manager);
        buf.append('[');
        buf.append(this.index);
        buf.append("] valid ");
        buf.append(new Date(this.establishedSince));
        buf.append(" - ");
        if (this.expireAt != 0L) {
            buf.append(new Date(this.expireAt));
        } else {
            buf.append(" <unlimited>");
        }
        Db lDb = this.db;
        if (lDb != null) {
            Object ownerThread;
            buf.append("\n    -> ");
            buf.append(lDb.getName());
            if (lDb.getTxName() != null) {
                buf.append("/");
                buf.append(lDb.getTxName());
            }
            if ((ownerThread = lDb.getOwnerThread()) != null) {
                buf.append(", ");
                buf.append(lDb.getOwnerThread());
            }
            for (RemoteDbSessionImpl session : RemoteDbSessionImpl.getOpenSessions()) {
                if (session.getSession() != lDb) continue;
                buf.append(", ");
                buf.append(session);
            }
        }
        try {
            if (!this.statementHistory.isEmpty() || this.currentStatement != null) {
                buf.append("\n\n    Statements:");
                for (StatementHistory stmt : this.statementHistory) {
                    buf.append("\n    ");
                    buf.append(stmt);
                }
                StatementHistory stmt = this.currentStatement;
                if (stmt != null) {
                    buf.append("\n    ");
                    buf.append(stmt);
                }
                buf.append("\n");
            }
        }
        catch (ConcurrentModificationException cmx) {
            buf.append("\n*** connection still in use by other thread(s) -> statement history aborted ***\n");
        }
        catch (RuntimeException rex) {
            LOGGER.warning("cannot dump statement history", (Throwable)rex);
        }
        try {
            Collection<ResultSetWrapper> rsList = this.getOpenResultSets();
            if (!rsList.isEmpty()) {
                buf.append("\n\n    Resultsets:");
                for (ResultSetWrapper rs : rsList) {
                    buf.append("\n    ");
                    buf.append(rs);
                }
                buf.append("\n");
            }
        }
        catch (RuntimeException rex) {
            LOGGER.warning("cannot dump open result sets", (Throwable)rex);
        }
        return buf.toString();
    }

    private void assertAttached() {
        if (this.db == null) {
            throw new PersistenceException("connection " + this + " not attached to any Db");
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.assertAttached();
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            throw new PersistenceException((Session)this.db, "setting autocommit failed", (Throwable)ex);
        }
    }

    public boolean getAutoCommit() {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException ex) {
            throw new PersistenceException((Session)this.db, "getting autocommit failed", (Throwable)ex);
        }
    }

    public void commit() {
        this.assertAttached();
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            throw new PersistenceException((Session)this.db, "commit failed", (Throwable)ex);
        }
    }

    public void rollback(boolean withLog) {
        this.assertAttached();
        try {
            if (withLog && LOGGER.isInfoLoggable()) {
                LOGGER.info(this.toDiagnosticString(), new Object[0]);
            }
            this.connection.rollback();
            this.unmarkPreparedStatements();
        }
        catch (SQLException ex) {
            throw new PersistenceException((Session)this.db, "rollback failed: " + this.toDiagnosticString(), (Throwable)ex);
        }
    }

    public void addRunningStatement(StatementWrapper statement) {
        this.runningStatements.add(new WeakReference<StatementWrapper>(statement));
    }

    public void removeRunningStatement(StatementWrapper statement) {
        Iterator<WeakReference<StatementWrapper>> iter = this.runningStatements.iterator();
        while (iter.hasNext()) {
            WeakReference<StatementWrapper> ref = iter.next();
            StatementWrapper stmt = (StatementWrapper)ref.get();
            if (stmt != null && stmt != statement) continue;
            iter.remove();
        }
    }

    public void cancelRunningStatements() {
        Iterator<WeakReference<StatementWrapper>> iter = this.runningStatements.iterator();
        while (iter.hasNext()) {
            WeakReference<StatementWrapper> ref = iter.next();
            StatementWrapper stmt = (StatementWrapper)ref.get();
            if (stmt != null && stmt.isRunning()) {
                try {
                    stmt.cancel();
                }
                catch (RuntimeException ex) {
                    LOGGER.warning("canceling statement failed: " + stmt, (Throwable)ex);
                }
            }
            iter.remove();
        }
    }

    public void unmarkPreparedStatements() {
        for (PreparedStatementWrapper stmt : this.preparedStatements.values()) {
            if (stmt == null || !stmt.isMarkedReady()) continue;
            try {
                stmt.consume();
            }
            catch (RuntimeException ex) {
                if (stmt.isCancelled()) continue;
                LOGGER.warning("unmarking statement failed: " + stmt, (Throwable)ex);
            }
        }
    }

    public void logAndClearWarnings() {
        try {
            SQLWarning warning;
            for (warning = this.connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                LOGGER.warning(warning.getMessage(), new Object[0]);
            }
            this.connection.clearWarnings();
            for (PreparedStatementWrapper stmt : this.preparedStatements.values()) {
                if (stmt.isClosed()) continue;
                for (warning = stmt.getStatement().getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    LOGGER.warning(warning.getMessage(), new Object[0]);
                }
                stmt.getStatement().clearWarnings();
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Session)this.db, "reading warnings failed", (Throwable)e);
        }
    }

    public void setMaxCountForClearWarnings(int max) {
        this.maxCountForClearWarnings = max;
    }

    public int getMaxCountForClearWarnings() {
        return this.maxCountForClearWarnings;
    }

    public void countForClearWarnings() {
        if (this.maxCountForClearWarnings > 0) {
            ++this.counterForClearWarnings;
            if (this.counterForClearWarnings >= this.maxCountForClearWarnings) {
                this.logAndClearWarnings();
                this.counterForClearWarnings = 0;
            }
        }
    }

    void forceDetached() {
        if (this.isAttached()) {
            LOGGER.warning("forcing detach of connection " + this + " attached to " + this.db, new Object[0]);
            this.closePreparedStatements(true);
            if (!this.isClosed()) {
                try {
                    if (!this.getAutoCommit()) {
                        LOGGER.severe("rolling back pending transaction for " + this.db, new Object[0]);
                        this.rollback(true);
                    }
                }
                catch (PersistenceException pex) {
                    LOGGER.severe("connection is broken", (Throwable)pex);
                    this.closeImpl();
                }
            }
            if (this.db != null) {
                this.db.setConnection(null);
                this.db = null;
            }
            this.attachCount = 0;
            this.statementHistory.clear();
            this.currentStatement = null;
            this.openResultSets.clear();
        }
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                if (!this.connection.getAutoCommit()) {
                    LOGGER.warning("closing connection while in transaction:\n" + this.toDiagnosticString(), new Object[0]);
                    this.connection.rollback();
                }
            }
            catch (SQLException ex) {
                LOGGER.warning("low level rollback failed: " + ex.getMessage(), new Object[0]);
            }
            this.logAndClearWarnings();
            this.forceDetached();
            this.closePreparedStatements(false);
            this.closeImpl();
        }
    }

    private void closeImpl() {
        try {
            this.connection.close();
        }
        catch (SQLException ex) {
            LOGGER.warning("low level close failed: " + ex.getMessage() + " -> " + this + " marked closed!", new Object[0]);
        }
        finally {
            this.connection = null;
            ManagedConnection.getManagedConnections();
        }
    }

    public boolean isClosed() {
        return this.connection == null;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                LOGGER.warning("closing unreferenced open connection: " + this, new Object[0]);
                this.close();
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.warning("closing unreferenced connection '" + this + "' failed in finalizer", (Throwable)ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    public void closePreparedStatements(boolean onlyMarkedReady) {
        Iterator<PreparedStatementWrapper> iter = this.preparedStatements.values().iterator();
        while (iter.hasNext()) {
            PreparedStatementWrapper stmt = iter.next();
            if (!(stmt.isClosed() || onlyMarkedReady && !stmt.isMarkedReady())) {
                try {
                    stmt.close();
                }
                catch (RuntimeException ex) {
                    LOGGER.warning("closing statement failed: " + stmt, (Throwable)ex);
                }
            }
            if (!onlyMarkedReady) continue;
            iter.remove();
        }
        if (!onlyMarkedReady) {
            this.preparedStatements.clear();
        }
    }

    public void removePreparedStatement(PreparedStatementWrapper st) {
        if (!st.isClosed()) {
            throw new PersistenceException((Session)this.db, "statement still open: " + st);
        }
        StatementKey key = st.getStatementKey();
        if (key != null) {
            this.preparedStatements.remove(st.getStatementKey());
        }
    }

    public StatementWrapper createStatement(int resultSetType, int resultSetConcurrency) {
        try {
            Statement stmt = this.connection.createStatement(resultSetType, resultSetConcurrency);
            return new StatementWrapper(this, stmt);
        }
        catch (SQLException ex) {
            throw new PersistenceException((Session)this.db, "creating statement failed for " + this, (Throwable)ex);
        }
    }

    public PreparedStatementWrapper createPreparedStatement(StatementKey statementKey, String sql, int resultSetType, int resultSetConcurrency) {
        try {
            sql = this.backend.optimizeSql(sql);
            return new PreparedStatementWrapper(this, this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency), statementKey, sql);
        }
        catch (SQLException e) {
            throw new PersistenceException((Session)this.db, "creating prepared statement failed", (Throwable)e);
        }
    }

    public PreparedStatementWrapper getPreparedStatement(StatementKey statementKey, boolean alwaysPrepare, int resultSetType, int resultSetConcurrency, Supplier<String> sqlSupplier) {
        if (statementKey == null) {
            throw new PersistenceException("statement key required");
        }
        this.assertAttached();
        PreparedStatementWrapper prepStmt = this.preparedStatements.get(statementKey);
        if (prepStmt == null || prepStmt.isClosed() || alwaysPrepare) {
            prepStmt = this.createPreparedStatement(statementKey, sqlSupplier.get(), resultSetType, resultSetConcurrency);
            this.preparedStatements.put(statementKey, prepStmt);
            LOGGER.finer("statement {0} prepared on {1}", new Object[]{prepStmt, this});
        } else {
            if (checkStatementResultSetParameters) {
                this.checkStatement(prepStmt, resultSetType, resultSetConcurrency);
            }
            LOGGER.finer("statement {0} re-used on {1}", new Object[]{prepStmt, this});
        }
        return prepStmt;
    }

    private void checkStatement(PreparedStatementWrapper prepStmt, int resultSetType, int resultSetConcurrency) {
        PreparedStatement stmt = prepStmt.getStatement();
        try {
            if (stmt.getResultSetType() != resultSetType) {
                throw new PersistenceException("wrong requested resultset type: " + resultSetType + " != statement: " + stmt.getResultSetType() + " for '" + prepStmt.getSql() + "'");
            }
            if (stmt.getResultSetConcurrency() != resultSetConcurrency) {
                throw new PersistenceException("wrong requested resultset concurrency: " + resultSetConcurrency + " != statement: " + stmt.getResultSetConcurrency() + " for '" + prepStmt.getSql() + "'");
            }
        }
        catch (SQLException sqx) {
            throw new PersistenceException("cannot determine prepared statement configuration for '" + prepStmt.getSql() + "'", (Throwable)sqx);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ManagedConnection.class);
        INSTANCE_COUNTER = new AtomicLong();
    }
}

