/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.HashSet;
import java.util.Set;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.PersistenceVisitor;

public class IgnoreDuplicatesPersistenceVisitor
extends PersistenceVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IgnoreDuplicatesPersistenceVisitor.class);
    private static final long serialVersionUID = 8166893128074169609L;
    private final Set<AbstractDbObject<?>> objectSet = new HashSet();
    private boolean persistenceOperationAllowed;

    public void visit(AbstractDbObject<?> object, Character modType) {
        this.persistenceOperationAllowed = this.objectSet.add(object);
    }

    @Override
    public boolean isPersistenceOperationAllowed(AbstractDbObject<?> object, char modType) {
        if (!this.persistenceOperationAllowed && LOGGER.isInfoLoggable()) {
            LOGGER.info(object.toGenericString() + " already persisted -> '" + modType + "' ignored", new Object[0]);
        }
        return this.persistenceOperationAllowed;
    }
}

