/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.ConnectionManager;
import org.tentackle.persist.Db;
import org.tentackle.persist.ManagedConnection;

public class DefaultConnectionManager
extends Thread
implements ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnectionManager.class);
    private static final long LOOP_MS = 1000L;
    protected final String name;
    protected final int iniSize;
    protected final int idOffset;
    protected int dbSize;
    protected int maxDbSize;
    protected int[] freeDbList;
    protected int freeDbCount;
    protected ManagedConnection[] conList;
    protected final int maxConSize;
    protected int[] freeConList;
    protected int freeConCount;
    private long attachTimeout;
    private int maxCountForClearWarnings = 1000;
    private volatile boolean shutdownRequested;

    public DefaultConnectionManager(String name, int iniSize, int maxSize, int idOffset) {
        super(name);
        if (iniSize < 1) {
            throw new IllegalArgumentException("initial size must be > 0");
        }
        if (idOffset < 1) {
            throw new IllegalArgumentException("connection ID offset must be > 0");
        }
        if (maxSize != 0 && maxSize < iniSize) {
            throw new IllegalArgumentException("maxSize must be 0 or >= iniSize");
        }
        this.name = name;
        this.iniSize = iniSize;
        this.idOffset = idOffset;
        this.maxDbSize = maxSize;
        this.maxConSize = maxSize;
        this.dbSize = iniSize;
        this.conList = new ManagedConnection[iniSize];
        this.freeDbList = new int[iniSize];
        this.freeConList = new int[iniSize];
        for (int i = iniSize - 1; i >= 0; --i) {
            this.freeDbList[this.freeDbCount++] = i;
            this.freeConList[this.freeConCount++] = i;
            this.conList[i] = null;
        }
    }

    public DefaultConnectionManager() {
        this("default-mgr", 2, 8, 1);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public void setMaxCountForClearWarnings(int maxCountForClearWarnings) {
        this.maxCountForClearWarnings = maxCountForClearWarnings;
    }

    public int getMaxCountForClearWarnings() {
        return this.maxCountForClearWarnings;
    }

    public long getAttachTimeout() {
        return this.attachTimeout;
    }

    public void setAttachTimeout(long attachTimeout) {
        this.attachTimeout = attachTimeout;
    }

    protected int addDb(Db db) {
        if (this.freeDbCount == 0) {
            if (this.maxDbSize > 0 && this.dbSize >= this.maxDbSize) {
                throw new PersistenceException((Session)db, this + ": max. number of Db instances exceeded (" + this.maxDbSize + ")");
            }
            int newSize = this.dbSize << 1;
            if (this.maxDbSize > 0 && newSize > this.maxDbSize) {
                newSize = this.maxDbSize;
            }
            int[] nFreeDbList = new int[newSize];
            System.arraycopy(this.freeDbList, 0, nFreeDbList, 0, this.dbSize);
            for (int i = newSize - 1; i >= this.dbSize; --i) {
                nFreeDbList[this.freeDbCount++] = i;
                nFreeDbList[i] = -1;
            }
            this.dbSize = newSize;
            this.freeDbList = nFreeDbList;
        }
        return this.freeDbList[--this.freeDbCount];
    }

    protected void removeDb(int index) {
        this.freeDbList[this.freeDbCount++] = index;
    }

    protected int addConnection(ManagedConnection con) {
        if (this.freeConCount == 0) {
            if (this.maxConSize > 0 && this.conList.length >= this.maxConSize) {
                throw new PersistenceException(this + ": max. number of connections exceeded (" + this.maxConSize + ")");
            }
            int newSize = this.conList.length << 1;
            if (this.maxConSize > 0 && newSize > this.maxConSize) {
                newSize = this.maxConSize;
            }
            ManagedConnection[] nConList = new ManagedConnection[newSize];
            System.arraycopy(this.conList, 0, nConList, 0, this.conList.length);
            int[] nFreeConList = new int[newSize];
            System.arraycopy(this.freeConList, 0, nFreeConList, 0, this.conList.length);
            for (int i = newSize - 1; i >= this.conList.length; --i) {
                nFreeConList[this.freeConCount++] = i;
                nFreeConList[i] = -1;
                nConList[i] = null;
            }
            this.conList = nConList;
            this.freeConList = nFreeConList;
        }
        int index = this.freeConList[--this.freeConCount];
        this.conList[index] = con;
        con.setIndex(index);
        return index;
    }

    protected ManagedConnection removeConnection(int index) {
        ManagedConnection con = this.conList[index];
        this.conList[index] = null;
        this.freeConList[this.freeConCount++] = index;
        con.setIndex(-1);
        return con;
    }

    public synchronized int getConnectionCount() {
        return this.conList.length - this.freeConCount;
    }

    public int getMaxSessions() {
        return this.maxDbSize;
    }

    public int getNumSessions() {
        return this.dbSize - this.freeDbCount;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConSize;
    }

    @Override
    public synchronized int getNumConnections() {
        return this.conList.length - this.freeConCount;
    }

    @Override
    public synchronized Collection<ManagedConnection> getConnections() {
        ArrayList<ManagedConnection> connections = new ArrayList<ManagedConnection>();
        for (ManagedConnection con : this.conList) {
            if (con == null) continue;
            connections.add(con);
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int login(Session session) {
        ManagedConnection con = this.createConnection((Db)session);
        DefaultConnectionManager defaultConnectionManager = this;
        synchronized (defaultConnectionManager) {
            int id = this.addDb((Db)session);
            if (this.addConnection(con) != id) {
                con.close();
                this.removeDb(id);
                throw new PersistenceException(this + ": db- and connection-list out of sync");
            }
            LOGGER.info("{0}: assigned {1} to connection {2}, id={3}", new Object[]{this, session, con, id += this.idOffset});
            return id;
        }
    }

    public synchronized void logout(Session session) {
        this.assertSessionBelongsToMe(session);
        int id = session.getSessionId();
        int index = this.convertConnectionIdToIndex(id);
        this.removeDb(index);
        ManagedConnection con = this.removeConnection(index);
        LOGGER.info("{0}: released {1} from connection {2}, id={3}", new Object[]{this, session, con, id});
        con.close();
    }

    @Override
    public synchronized void attach(Session session) {
        this.assertSessionBelongsToMe(session);
        int index = this.convertConnectionIdToIndex(session.getSessionId());
        ManagedConnection con = this.conList[index];
        if (con.isDead()) {
            LOGGER.warning(this + ": closing **DEAD** connection " + con, new Object[0]);
            try {
                con.close();
            }
            catch (RuntimeException ex) {
                LOGGER.warning("closing DEAD connection failed: ignored...", (Throwable)ex);
            }
            this.conList[index] = con = this.createConnection((Db)session);
            LOGGER.warning(this + ": connection " + con + " reopened", new Object[0]);
        }
        con.attachSession((Db)session);
    }

    @Override
    public synchronized void detach(Session session) {
        this.assertSessionBelongsToMe(session);
        int index = this.convertConnectionIdToIndex(session.getSessionId());
        ManagedConnection con = this.conList[index];
        con.detachSession((Db)session);
    }

    @Override
    public synchronized void forceDetach(Session session) {
        this.assertSessionBelongsToMe(session);
        int index = this.convertConnectionIdToIndex(session.getSessionId());
        ManagedConnection con = this.conList[index];
        con.forceDetached();
    }

    public synchronized void shutdown() {
        this.shutdownRequested = true;
        for (int i = 0; i < this.conList.length; ++i) {
            if (this.conList[i] == null) continue;
            ManagedConnection con = this.removeConnection(i);
            LOGGER.info("{0}: close connection {1}", new Object[]{this, con});
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block10: while (!this.shutdownRequested) {
            if (this.getAttachTimeout() <= 0L) {
                try {
                    DefaultConnectionManager.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                DefaultConnectionManager.sleep(this.attachTimeout);
                long curTime = System.currentTimeMillis();
                ManagedConnection[] managedConnectionArray = this;
                // MONITORENTER : this
                ManagedConnection[] connections = (ManagedConnection[])this.conList.clone();
                // MONITOREXIT : managedConnectionArray
                managedConnectionArray = connections;
                int n = managedConnectionArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block10;
                    ManagedConnection con = managedConnectionArray[n2];
                    if (con != null) {
                        long attachedMillis = curTime - con.getAttachedSince();
                        if (con.isAttached() && attachedMillis > this.attachTimeout) {
                            Db db;
                            Db db2 = db = con.getSession();
                            // MONITORENTER : db2
                            if (db.getConnection() == con && con.isAttached()) {
                                try {
                                    LOGGER.warning("detaching timed out connection " + con + " from " + db.getName() + " (" + attachedMillis + "ms)", new Object[0]);
                                    con.forceDetached();
                                }
                                catch (RuntimeException rex) {
                                    LOGGER.severe("detaching " + con + " failed", (Throwable)rex);
                                }
                            }
                            // MONITOREXIT : db2
                        }
                    }
                    ++n2;
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected int convertConnectionIdToIndex(int id) {
        int ndx = id - this.idOffset;
        if (ndx < 0 || ndx >= this.dbSize) {
            throw new PersistenceException(this + ": invalid connection id=" + id + ", expected " + this.idOffset + " - " + (this.idOffset + this.dbSize - 1));
        }
        return ndx;
    }

    protected void assertSessionBelongsToMe(Session session) {
        if (session.getSessionManager() != this) {
            throw new PersistenceException(session, "session " + session + " does not belong to " + this + " but to " + session.getSessionManager());
        }
    }

    private ManagedConnection createConnection(Db db) {
        ManagedConnection con;
        try {
            con = new ManagedConnection(this, db.getBackend(), db.connect());
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        if (!con.getAutoCommit()) {
            con.close();
            throw new PersistenceException(this + ": connection " + con + " is not in autoCommit mode");
        }
        con.setMaxCountForClearWarnings(this.maxCountForClearWarnings);
        return con;
    }
}

