/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.tentackle.pdo.ClassId;
import org.tentackle.pdo.ModificationEvent;
import org.tentackle.pdo.ModificationListener;
import org.tentackle.pdo.ModificationListenerAdapter;
import org.tentackle.pdo.PdoTracker;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.TableName;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbObjectClassVariables;
import org.tentackle.persist.DbPreferencesFactory;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.rmi.DbPreferencesNodeRemoteDelegate;
import org.tentackle.prefs.PersistedPreferencesFactory;

@ClassId(value=3)
@TableName(value="prefnode")
public class DbPreferencesNode
extends AbstractDbObject<DbPreferencesNode> {
    private static final long serialVersionUID = 4677525106428955014L;
    public static final String TABLENAME = "prefnode";
    private static final DbObjectClassVariables<DbPreferencesNode> CLASSVARIABLES = new DbObjectClassVariables<DbPreferencesNode>(DbPreferencesNode.class, 3, "prefnode");
    private static final StatementId SELECT_BY_PARENT_ID_STMT;
    private static final StatementId selectChildIdsStatementId;
    private static final StatementId SELECT_BY_USER_AND_NAME_STMT;
    private String user;
    private String name;
    private long parentId;
    public static final String CN_USER = "username";
    public static final String CN_NAME = "nodename";
    public static final String CN_PARENTID = "parentid";

    public DbPreferencesNode(Db db) {
        super(db);
    }

    public DbPreferencesNode() {
    }

    @Override
    public boolean isCountingModification(char modType) {
        return true;
    }

    @Override
    public DbObjectClassVariables<DbPreferencesNode> getClassVariables() {
        return CLASSVARIABLES;
    }

    public List<DbPreferencesNode> selectByParentId(long parentId) {
        if (this.getSession().isRemote()) {
            try {
                List<DbPreferencesNode> list = ((DbPreferencesNodeRemoteDelegate)this.getRemoteDelegate()).selectByParentId(parentId);
                this.getSession().applyTo(list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_PARENT_ID_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_PARENTID);
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, parentId);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean derived;
            ArrayList<DbPreferencesNode> list = new ArrayList<DbPreferencesNode>();
            boolean bl = derived = this.getClass() != DbPreferencesNode.class;
            while (rs.next()) {
                DbPreferencesNode obj;
                DbPreferencesNode dbPreferencesNode = obj = derived ? (DbPreferencesNode)this.newInstance() : new DbPreferencesNode(this.getSession());
                if ((obj = (DbPreferencesNode)obj.readFromResultSetWrapper(rs)) == null) continue;
                list.add(obj);
            }
            ArrayList<DbPreferencesNode> arrayList = list;
            return arrayList;
        }
    }

    public Set<Long> selectChildIds() {
        if (this.getSession().isRemote()) {
            try {
                return ((DbPreferencesNodeRemoteDelegate)this.getRemoteDelegate()).selectChildIds(this.getId());
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(selectChildIdsStatementId, () -> "SELECT id FROM prefnode WHERE parentid=?");
        st.setLong(1, this.getId());
        TreeSet<Long> set = new TreeSet<Long>();
        try (ResultSetWrapper rs = st.executeQuery();){
            while (rs.next()) {
                set.add(rs.getALong(1));
            }
        }
        return set;
    }

    public DbPreferencesNode selectByUserAndName(String user, String name) {
        if (this.getSession().isRemote()) {
            try {
                DbPreferencesNode obj = ((DbPreferencesNodeRemoteDelegate)this.getRemoteDelegate()).selectByUserAndName(user, name);
                this.getSession().applyTo(obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_USER_AND_NAME_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_USER);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_NAME);
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx++, user, true);
        st.setString(ndx++, name);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                DbPreferencesNode dbPreferencesNode = (DbPreferencesNode)this.readFromResultSetWrapper(rs);
                return dbPreferencesNode;
            }
            DbPreferencesNode dbPreferencesNode = null;
            return dbPreferencesNode;
        }
    }

    @Override
    public boolean isTableSerialProvided() {
        return true;
    }

    @Override
    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn("tableserial");
            rs.configureColumn(CN_USER);
            rs.configureColumn(CN_NAME);
            rs.configureColumn(CN_PARENTID);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.setTableSerial(rs.getLong());
        this.user = rs.getString(true);
        this.name = rs.getString();
        this.parentId = rs.getLong();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    @Override
    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setLong(++ndx, this.getTableSerial());
        st.setString(++ndx, this.user, true);
        st.setString(++ndx, this.name);
        st.setLong(++ndx, this.parentId);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    @Override
    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + "tableserial" + "," + CN_USER + "," + CN_NAME + "," + CN_PARENTID + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?," + "?," + "?," + "?" + ") ";
    }

    @Override
    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + "tableserial" + "=?," + CN_USER + "=?," + CN_NAME + "=?," + CN_PARENTID + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.assertMutable();
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.assertMutable();
        this.name = name;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.assertMutable();
        this.parentId = parentId;
    }

    public String getBaseName() {
        int lastSlash = this.name.lastIndexOf(47);
        return lastSlash >= 0 ? this.name.substring(lastSlash + 1) : this.name;
    }

    @Override
    public String toString() {
        return "ID=" + this.getId() + ", parentId=" + this.parentId + (this.user == null ? ", <system>" : ", user='" + this.user + "'") + ", name='" + this.name + "'";
    }

    static {
        PdoTracker.getInstance().addModificationListener((ModificationListener)new ModificationListenerAdapter(new String[]{TABLENAME}){

            public void dataChanged(ModificationEvent ev) {
                DbPreferencesFactory factory = (DbPreferencesFactory)PersistedPreferencesFactory.getInstance();
                if (factory.isAutoSync()) {
                    factory.expireNodes(ev.getSerial());
                }
            }
        });
        SELECT_BY_PARENT_ID_STMT = new StatementId();
        selectChildIdsStatementId = new StatementId();
        SELECT_BY_USER_AND_NAME_STMT = new StatementId();
    }
}

