/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tentackle.pdo.ClassId;
import org.tentackle.pdo.ModificationEvent;
import org.tentackle.pdo.ModificationListener;
import org.tentackle.pdo.ModificationListenerAdapter;
import org.tentackle.pdo.PdoTracker;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.TableName;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbObjectClassVariables;
import org.tentackle.persist.DbPreferencesFactory;
import org.tentackle.persist.DbPreferencesNode;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.rmi.DbPreferencesKeyRemoteDelegate;
import org.tentackle.prefs.PersistedPreferencesFactory;

@ClassId(value=4)
@TableName(value="prefkey")
public class DbPreferencesKey
extends AbstractDbObject<DbPreferencesKey> {
    private static final long serialVersionUID = 5733105489734329678L;
    public static final String TABLENAME = "prefkey";
    private static final DbObjectClassVariables<DbPreferencesKey> CLASSVARIABLES = new DbObjectClassVariables<DbPreferencesKey>(DbPreferencesKey.class, 4, "prefkey");
    private DbPreferencesNode lazyNode;
    private static final StatementId SELECT_BY_NODE_ID_STMT;
    private static final StatementId SELECT_BY_NODE_ID_KEY_STMT;
    private static final StatementId DELETE_BY_NODE_ID_STMT;
    private long nodeId;
    private String key;
    private String value;
    public static final String CN_NODEID = "nodeid";
    public static final String CN_KEY = "pkey";
    public static final String CN_VALUE = "pvalue";

    public DbPreferencesKey(Db db) {
        super(db);
    }

    public DbPreferencesKey() {
    }

    @Override
    public String toString() {
        return (this.lazyNode != null ? "(node: " + this.lazyNode + ")" : "nodeId=" + this.nodeId) + ", key='" + this.key + "', value='" + this.value + "'";
    }

    @Override
    public boolean isCountingModification(char modType) {
        return true;
    }

    public void setLazyNode(DbPreferencesNode node) {
        this.lazyNode = node;
    }

    public DbPreferencesNode getLazyNode() {
        return this.lazyNode;
    }

    @Override
    public void prepareSetFields() {
        if (this.nodeId == 0L && this.lazyNode != null) {
            this.nodeId = this.lazyNode.getId();
            if (this.nodeId == 0L) {
                this.lazyNode.saveObject();
                this.nodeId = this.lazyNode.getId();
            }
        }
    }

    @Override
    public DbObjectClassVariables<DbPreferencesKey> getClassVariables() {
        return CLASSVARIABLES;
    }

    public List<DbPreferencesKey> selectByNodeId(long nodeId) {
        if (this.getSession().isRemote()) {
            try {
                List<DbPreferencesKey> list = ((DbPreferencesKeyRemoteDelegate)this.getRemoteDelegate()).selectByNodeId(nodeId);
                this.getSession().applyTo(list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_NODE_ID_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_NODEID);
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, nodeId);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean derived;
            ArrayList<DbPreferencesKey> list = new ArrayList<DbPreferencesKey>();
            boolean bl = derived = this.getClass() != DbPreferencesKey.class;
            while (rs.next()) {
                DbPreferencesKey obj;
                DbPreferencesKey dbPreferencesKey = obj = derived ? (DbPreferencesKey)this.newInstance() : new DbPreferencesKey(this.getSession());
                if ((obj = (DbPreferencesKey)obj.readFromResultSetWrapper(rs)) == null) continue;
                list.add(obj);
            }
            ArrayList<DbPreferencesKey> arrayList = list;
            return arrayList;
        }
    }

    public DbPreferencesKey selectByNodeIdKey(long nodeId, String key) {
        if (this.getSession().isRemote()) {
            try {
                DbPreferencesKey obj = ((DbPreferencesKeyRemoteDelegate)this.getRemoteDelegate()).selectByNodeIdKey(nodeId, key);
                this.getSession().applyTo(obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_NODE_ID_KEY_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_NODEID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_KEY);
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, nodeId);
        st.setString(ndx++, key);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                DbPreferencesKey dbPreferencesKey = (DbPreferencesKey)this.readFromResultSetWrapper(rs);
                return dbPreferencesKey;
            }
            DbPreferencesKey dbPreferencesKey = null;
            return dbPreferencesKey;
        }
    }

    public int deleteByNodeId(long nodeId) {
        if (this.getSession().isRemote()) {
            try {
                return ((DbPreferencesKeyRemoteDelegate)this.getRemoteDelegate()).deleteByNodeId(nodeId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_BY_NODE_ID_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_NODEID);
            sql.append("=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, nodeId);
        return st.executeUpdate();
    }

    @Override
    public boolean isTableSerialProvided() {
        return true;
    }

    @Override
    public boolean isTracked() {
        return true;
    }

    @Override
    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn("tableserial");
            rs.configureColumn(CN_NODEID);
            rs.configureColumn(CN_KEY);
            rs.configureColumn(CN_VALUE);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.setTableSerial(rs.getLong());
        this.nodeId = rs.getLong();
        this.key = rs.getString();
        this.value = rs.getString();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    @Override
    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setLong(++ndx, this.getTableSerial());
        st.setLong(++ndx, this.nodeId);
        st.setString(++ndx, this.key);
        st.setString(++ndx, this.value);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    @Override
    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + "tableserial" + "," + CN_NODEID + "," + CN_KEY + "," + CN_VALUE + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?," + "?," + "?," + "?" + ") ";
    }

    @Override
    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + "tableserial" + "=?," + CN_NODEID + "=?," + CN_KEY + "=?," + CN_VALUE + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.assertMutable();
        if (this.nodeId != nodeId) {
            this.setModified(true);
        }
        this.nodeId = nodeId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.assertMutable();
        if (!Objects.equals(this.key, key)) {
            this.setModified(true);
        }
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.assertMutable();
        if (!Objects.equals(this.value, value)) {
            this.setModified(true);
        }
        this.value = value;
    }

    static {
        PdoTracker.getInstance().addModificationListener((ModificationListener)new ModificationListenerAdapter(new String[]{TABLENAME}){

            public void dataChanged(ModificationEvent ev) {
                DbPreferencesFactory factory = (DbPreferencesFactory)PersistedPreferencesFactory.getInstance();
                if (factory.isAutoSync()) {
                    factory.expireKeys(ev.getSerial());
                }
            }
        });
        SELECT_BY_NODE_ID_STMT = new StatementId();
        SELECT_BY_NODE_ID_KEY_STMT = new StatementId();
        DELETE_BY_NODE_ID_STMT = new StatementId();
    }
}

