/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.IdSource;
import org.tentackle.persist.IdSourceConfigurator;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.TableSerialExpirationBacklog;
import org.tentackle.persist.rmi.AbstractDbObjectRemoteDelegate;
import org.tentackle.reflect.ReflectionHelper;

public class DbObjectClassVariables<P extends AbstractDbObject<P>> {
    private static final Map<String, DbObjectClassVariables<? extends AbstractDbObject<?>>> CLASSMAP = new HashMap();
    protected final Set<ForeignReference> foreignReferences = new TreeSet<ForeignReference>();
    public final Class<P> clazz;
    public final int classId;
    public final String classBaseName;
    public Properties properties;
    public String tableName;
    public int remoteDelegateId;
    public int columnCount;
    public boolean alwaysPrepare;
    public final StatementId selectObjectStatementId = new StatementId();
    public final StatementId selectAllObjectsStatementId = new StatementId();
    public final StatementId selectAllIdSerialStatementId = new StatementId();
    public final StatementId selectLockedStatementId = new StatementId();
    public final StatementId selectSerialStatementId = new StatementId();
    public final StatementId selectMaxIdStatementId = new StatementId();
    public final StatementId selectMaxTableSerialStatementId = new StatementId();
    public final StatementId insertStatementId = new StatementId();
    public final StatementId updateStatementId = new StatementId();
    public final StatementId deleteStatementId = new StatementId();
    public final StatementId dummyUpdateStatementId = new StatementId();
    public final StatementId updateSerialStatementId = new StatementId();
    public final StatementId updateTableSerialStatementId = new StatementId();
    public final StatementId updateSerialAndTableSerialStatementId = new StatementId();
    public final StatementId selectExpiredTableSerials1StatementId = new StatementId();
    public final StatementId selectExpiredTableSerials2StatementId = new StatementId();
    public final TableSerialExpirationBacklog expirationBacklog;
    public IdSource idSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends AbstractDbObject<P>> DbObjectClassVariables<P> getVariables(String tableName) {
        Map<String, DbObjectClassVariables<? extends AbstractDbObject<?>>> map = CLASSMAP;
        synchronized (map) {
            return CLASSMAP.get(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends AbstractDbObject<P>> void putVariables(DbObjectClassVariables<P> variables) {
        if (variables.tableName != null) {
            Map<String, DbObjectClassVariables<? extends AbstractDbObject<?>>> map = CLASSMAP;
            synchronized (map) {
                DbObjectClassVariables<? extends AbstractDbObject<?>> classVar = CLASSMAP.get(variables.tableName);
                if (classVar != null) {
                    if (!classVar.clazz.isAssignableFrom(variables.clazz)) {
                        throw new PersistenceException("classvariables for '" + variables.tableName + "' already registered, old=" + classVar.clazz.getName() + ", new=" + variables.clazz.getName());
                    }
                } else {
                    CLASSMAP.put(variables.tableName, variables);
                }
            }
        }
    }

    public DbObjectClassVariables(Class<P> clazz, int classId, String tableName) {
        this.clazz = clazz;
        this.classId = classId;
        this.tableName = tableName;
        this.classBaseName = ReflectionHelper.getClassBaseName(clazz);
        this.expirationBacklog = this.createBacklog();
        this.loadProperties();
        DbObjectClassVariables.putVariables(this);
    }

    protected TableSerialExpirationBacklog createBacklog() {
        return new TableSerialExpirationBacklog();
    }

    protected void loadProperties() {
        this.properties = new Properties();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.clazz.getName());
            for (String key : bundle.keySet()) {
                this.properties.setProperty(key, bundle.getString(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized IdSource getIdSource(Db db) {
        if (this.idSource == null) {
            String idConfig = this.getProperty("idsource");
            this.idSource = idConfig == null ? db.getDefaultIdSource() : IdSourceConfigurator.getInstance().configure(db, idConfig);
        }
        return this.idSource;
    }

    protected int determineReferencePriority(Class<? extends AbstractDbObject<?>> clazz) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReferencingClass(Class<? extends AbstractDbObject<?>> clazz, String methodName) {
        ForeignReference ref = this.createForeignReference(clazz, methodName);
        Set<ForeignReference> set = this.foreignReferences;
        synchronized (set) {
            return this.foreignReferences.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReferencingClass(Class<? extends AbstractDbObject<?>> clazz, String methodName) {
        ForeignReference ref = this.createForeignReference(clazz, methodName);
        Set<ForeignReference> set = this.foreignReferences;
        synchronized (set) {
            return this.foreignReferences.remove(ref);
        }
    }

    private ForeignReference createForeignReference(Class<? extends AbstractDbObject<?>> clazz, String methodName) {
        if (methodName == null) {
            methodName = "isReferencing" + this.classBaseName;
        }
        try {
            Method method;
            try {
                method = clazz.getMethod(methodName, Long.TYPE);
            }
            catch (NoSuchMethodException e1) {
                method = clazz.getMethod(methodName, Long.class);
            }
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                throw new PersistenceException(clazz.getName() + "." + method.getName() + " must be public and non-static");
            }
            return new ForeignReference(method, this.determineReferencePriority(clazz));
        }
        catch (NoSuchMethodException ex) {
            throw new PersistenceException("please add an *IsReferencing-wurblet to generate " + clazz.getName() + "." + methodName, (Throwable)ex);
        }
    }

    public boolean isReferenced(Db db, long id) {
        return this.isReferencedImpl(db, id, this.foreignReferences);
    }

    protected boolean isReferencedImpl(Db db, long id, Set<ForeignReference> foreignReferences) {
        for (ForeignReference ref : foreignReferences) {
            try {
                Object obj = AbstractDbObject.newInstance(db, ref.method.getDeclaringClass());
                if (!(ref.method.getParameterTypes()[0] == Long.TYPE ? ref.method.invoke(obj, id).equals(Boolean.TRUE) : ref.method.invoke(obj, id).equals(Boolean.TRUE))) continue;
                return true;
            }
            catch (Exception ex) {
                throw new PersistenceException("couldn't invoke " + ref.method, (Throwable)ex);
            }
        }
        return false;
    }

    public int getRemoteDelegateId() {
        if (this.remoteDelegateId == 0) {
            this.remoteDelegateId = Db.prepareRemoteDelegate(this.clazz);
        }
        return this.remoteDelegateId;
    }

    public AbstractDbObjectRemoteDelegate<P> getRemoteDelegate(Db db) {
        return (AbstractDbObjectRemoteDelegate)db.getRemoteDelegate(this.getRemoteDelegateId());
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String putProperty(String key, String value) {
        return (String)this.properties.put(key, value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.clazz.getName());
        if (this.tableName != null) {
            buf.append("/'").append(this.tableName).append("'");
        }
        return buf.toString();
    }

    protected static class ForeignReference
    implements Comparable<ForeignReference> {
        private final Method method;
        private final int priority;

        ForeignReference(Method method, int priority) {
            this.method = method;
            this.priority = priority;
        }

        @Override
        public int compareTo(ForeignReference o) {
            int rv = this.priority - o.priority;
            if (rv == 0) {
                rv = this.method.hashCode() - o.method.hashCode();
            }
            return rv;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForeignReference other = (ForeignReference)obj;
            if (!(this.method == other.method || this.method != null && this.method.equals(other.method))) {
                return false;
            }
            return this.priority == other.priority;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + (this.method != null ? this.method.hashCode() : 0);
            hash = 67 * hash + this.priority;
            return hash;
        }
    }
}

