/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.io.Serializable;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionDependable;
import org.tentackle.pdo.SessionHolder;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbOperationClassVariables;
import org.tentackle.persist.rmi.AbstractDbOperationRemoteDelegate;

public abstract class AbstractDbOperation<P extends AbstractDbOperation<P>>
implements SessionDependable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Db db;
    private transient boolean sessionImmutable;
    private transient SessionHolder sessionHolder;

    public AbstractDbOperation(Db session) {
        this.setSession(session);
    }

    public AbstractDbOperation() {
    }

    public P clone() {
        AbstractDbOperation obj;
        try {
            obj = (AbstractDbOperation)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        return (P)obj;
    }

    public DbOperationClassVariables<P> getClassVariables() {
        throw new PersistenceException("classvariables not initialized for " + this.getClass());
    }

    public void setSessionHolder(SessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
    }

    public SessionHolder getSessionHolder() {
        return this.sessionHolder;
    }

    public void setSessionImmutable(boolean sessionImmutable) {
        this.sessionImmutable = sessionImmutable;
    }

    public boolean isSessionImmutable() {
        SessionHolder holder = this.getSessionHolder();
        if (holder != null) {
            return holder.isSessionImmutable();
        }
        return this.sessionImmutable;
    }

    public void setSession(Session session) {
        SessionHolder holder = this.getSessionHolder();
        if (holder != null) {
            holder.setSession(session);
        } else {
            if (this.isSessionImmutable() && this.db != session) {
                throw new PersistenceException((Session)this.db, "illegal attempt to change the immutable Db of " + this + " from " + this.db + " to " + session);
            }
            this.db = (Db)session;
        }
    }

    public Db getSession() {
        SessionHolder holder = this.getSessionHolder();
        if (holder != null) {
            return (Db)holder.getSession();
        }
        return this.db;
    }

    public AbstractDbOperationRemoteDelegate<P> getRemoteDelegate() {
        return this.getClassVariables().getRemoteDelegate(this.getSession());
    }
}

