/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.tentackle.app.AbstractApplication;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.Immutable;
import org.tentackle.misc.ImmutableException;
import org.tentackle.misc.SerialNumbered;
import org.tentackle.pdo.NotFoundException;
import org.tentackle.pdo.PdoTracker;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Persistent;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionDependable;
import org.tentackle.pdo.SessionHolder;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbObjectClassVariables;
import org.tentackle.persist.IdComparator;
import org.tentackle.persist.IdSource;
import org.tentackle.persist.ModificationLog;
import org.tentackle.persist.ModificationLogFactory;
import org.tentackle.persist.ModificationTracker;
import org.tentackle.persist.NameComparator;
import org.tentackle.persist.NameIdComparator;
import org.tentackle.persist.PersistenceVisitor;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.StatementKey;
import org.tentackle.persist.TableSerialExpirationBacklog;
import org.tentackle.persist.rmi.AbstractDbObjectRemoteDelegate;
import org.tentackle.persist.rmi.DbObjectResult;
import org.tentackle.sql.Backend;

public abstract class AbstractDbObject<P extends AbstractDbObject<P>>
implements Immutable,
Identifiable,
SerialNumbered,
SessionDependable,
Serializable,
Comparable<P>,
Cloneable {
    public static final String CN_ID = "id";
    public static final String AN_ID = "id";
    public static final String CN_SERIAL = "serial";
    public static final String AN_SERIAL = "serial";
    public static final String CN_TABLESERIAL = "tableserial";
    public static final String AN_TABLESERIAL = "tableSerial";
    public static final String CN_CLASSID = "classid";
    public static final String AN_CLASSID = "classId";
    public static IdComparator<AbstractDbObject<?>> idComparator = new IdComparator();
    public static NameComparator<AbstractDbObject<?>> nameComparator = new NameComparator();
    public static NameIdComparator<AbstractDbObject<?>> nameIdComparator = new NameIdComparator();
    public static final String TX_INSERT_PLAIN = "insert plain";
    public static final String TX_INSERT_OBJECT = "insert object";
    public static final String TX_UPDATE_PLAIN = "update plain";
    public static final String TX_DUMMY_UPDATE = "dummy update";
    public static final String TX_UPDATE_SERIAL = "update serial";
    public static final String TX_UPDATE_SERIAL_AND_TABLESERIAL = "update serial and tableserial";
    public static final String TX_UPDATE_TABLESERIAL = "update tableserial";
    public static final String TX_UPDATE_OBJECT = "update object";
    public static final String TX_SAVE = "save";
    public static final String TX_SYNC = "sync";
    public static final String TX_DELETE_OBJECT = "delete object";
    public static final String TX_SAVE_LIST = "save list";
    public static final String TX_DELETE_LIST = "delete list";
    public static final String TX_DELETE_MISSING_IN_LIST = "delete missing in list";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDbObject.class);
    private static final long serialVersionUID = 3452560056309085969L;
    @Persistent(value="object id")
    private long id;
    @Persistent(value="object version")
    private long serial;
    @Persistent(value="class id")
    private int classId;
    @Persistent(value="table version")
    private long tableSerial;
    private boolean modified;
    private boolean immutable;
    private Logger.Level immutableLoggingLevel;
    protected boolean preparePending;
    private transient Db session;
    private transient boolean sessionImmutable;
    private SessionHolder sessionHolder;
    private transient boolean overloadable;
    private transient ModificationLog modlog;
    private volatile transient PropertyChangeSupport changeSupport;

    public static <P extends AbstractDbObject<?>> P newInstance(Class<P> clazz) {
        try {
            return (P)((AbstractDbObject)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PersistenceException("creating object for " + clazz + " failed", (Throwable)e);
        }
    }

    public static <P extends AbstractDbObject<?>> P newInstance(Session session, Class<P> clazz) {
        P obj = AbstractDbObject.newInstance(clazz);
        ((AbstractDbObject)obj).setSession(session);
        return obj;
    }

    public AbstractDbObject(Db db) {
        this.setSession(db);
    }

    public AbstractDbObject() {
    }

    public String toString() {
        return this.toGenericString();
    }

    public final String toGenericString() {
        return this.getClass().getName() + '[' + this.id + '/' + this.serial + ']';
    }

    public final String toIdString() {
        return this.getClassId() + ":" + this.getId();
    }

    public DbObjectClassVariables<P> getClassVariables() {
        throw new PersistenceException((Identifiable)this, "classvariables not initialized for " + this.getClass());
    }

    public String getClassBaseName() {
        return this.getClassVariables().classBaseName;
    }

    public int getClassId() {
        return this.classId != 0 ? this.classId : this.getClassVariables().classId;
    }

    public void setClassId(int classId) {
        this.classId = classId;
    }

    public P clone() {
        AbstractDbObject obj;
        try {
            obj = (AbstractDbObject)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        obj.id = 0L;
        obj.serial = 0L;
        return (P)obj;
    }

    protected void createAttributesInSnapshot(AbstractDbObject snapshot) {
        snapshot.id = this.id;
        snapshot.serial = this.serial;
    }

    protected void revertAttributesToSnapshot(AbstractDbObject snapshot) {
        this.id = snapshot.id;
        this.serial = snapshot.serial;
        this.tableSerial = snapshot.tableSerial;
        this.modified = snapshot.modified;
        this.immutable = snapshot.immutable;
        this.preparePending = snapshot.preparePending;
        this.session = snapshot.session;
        this.sessionImmutable = snapshot.sessionImmutable;
        this.sessionHolder = snapshot.sessionHolder;
        this.overloadable = snapshot.overloadable;
        this.modlog = snapshot.modlog;
        this.changeSupport = snapshot.changeSupport;
    }

    public void acceptPersistenceVisitor(PersistenceVisitor visitor, char modType) {
        try {
            visitor.visit(new Object[]{this, Character.valueOf(modType)});
        }
        catch (NoSuchMethodException nsm) {
            throw new PersistenceException((Session)this.getSession(), "no visit method for " + this.getClass().getName() + " in " + visitor.getClass().getName(), (Throwable)nsm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            AbstractDbObject abstractDbObject = this;
            synchronized (abstractDbObject) {
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                }
                this.changeSupport.addPropertyChangeListener(listener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyChangeListener[] getPropertyChangeListeners() {
        AbstractDbObject abstractDbObject = this;
        synchronized (abstractDbObject) {
            if (this.changeSupport == null) {
                return new PropertyChangeListener[0];
            }
            return this.changeSupport.getPropertyChangeListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener != null) {
            AbstractDbObject abstractDbObject = this;
            synchronized (abstractDbObject) {
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                }
                this.changeSupport.addPropertyChangeListener(propertyName, listener);
            }
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener != null && this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        AbstractDbObject abstractDbObject = this;
        synchronized (abstractDbObject) {
            if (this.changeSupport == null) {
                return new PropertyChangeListener[0];
            }
            return this.changeSupport.getPropertyChangeListeners(propertyName);
        }
    }

    public void removeAllPropertyChangeListeners() {
        this.changeSupport = null;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null && !Objects.equals(oldValue, newValue)) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void setModificationLog(ModificationLog modlog) {
        this.modlog = modlog;
    }

    public ModificationLog getModificationLog() {
        return this.modlog;
    }

    public void setOverloadable(boolean overloadable) {
        this.overloadable = overloadable;
    }

    public boolean isOverloadable() {
        return this.overloadable;
    }

    public boolean isEntity() {
        return true;
    }

    public P newInstance() {
        try {
            AbstractDbObject obj = (AbstractDbObject)this.getClass().newInstance();
            obj.session = this.session;
            obj.sessionHolder = this.sessionHolder;
            return (P)obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PersistenceException((Identifiable)this, "creating new object failed", (Throwable)e);
        }
    }

    public void setSessionHolder(SessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
    }

    public SessionHolder getSessionHolder() {
        return this.sessionHolder;
    }

    public void setSessionImmutable(boolean sessionImmutable) {
        this.sessionImmutable = sessionImmutable;
    }

    public boolean isSessionImmutable() {
        SessionHolder holder = this.getSessionHolder();
        if (holder != null) {
            return holder.isSessionImmutable();
        }
        return this.sessionImmutable;
    }

    public void setSession(Session session) {
        SessionHolder holder = this.getSessionHolder();
        if (holder != null) {
            holder.setSession(session);
        } else {
            if (this.isSessionImmutable() && this.session != session) {
                throw new PersistenceException((Session)this.session, "illegal attempt to change the immutable Db of " + this + " from " + this.session + " to " + session);
            }
            this.session = (Db)session;
        }
    }

    public Db getSession() {
        SessionHolder holder = this.getSessionHolder();
        if (holder != null) {
            return (Db)holder.getSession();
        }
        return this.session;
    }

    public Backend getBackend() {
        return this.getSession().getBackend();
    }

    public void setId(long id) {
        this.assertMutable();
        this.id = id;
    }

    public long getId() {
        return this.id < 0L ? -this.id : this.id;
    }

    public void setSerial(long serial) {
        this.assertMutable();
        this.serial = serial;
    }

    public long getSerial() {
        return this.serial;
    }

    public void setTableSerial(long tableSerial) {
        this.assertMutable();
        this.tableSerial = tableSerial;
    }

    public long getTableSerial() {
        return this.tableSerial;
    }

    public void newId() {
        this.assertNotRemote();
        if (this.id == 0L) {
            this.assertMutable();
            this.id = this.getIdSource().nextId(this.getSession());
        }
    }

    public void reserveId() {
        if (this.id == 0L) {
            if (this.getSession().isRemote()) {
                try {
                    this.id = this.getRemoteDelegate().obtainReservedId();
                }
                catch (RemoteException e) {
                    throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
                }
            } else {
                this.newId();
                this.id = -this.id;
            }
        }
    }

    public boolean isNew() {
        return this.id <= 0L;
    }

    public boolean isIdValid() {
        return this.id != 0L;
    }

    public boolean isDeleted() {
        return this.id < 0L && this.serial > 0L;
    }

    public boolean isVirgin() {
        return this.serial == 0L;
    }

    public void setModified(boolean modified) {
        this.assertMutable();
        this.modified = modified;
        if (!modified) {
            this.removeAllPropertyChangeListeners();
        }
    }

    public void setImmutable(boolean immutable) {
        if (immutable && this.attributesModified()) {
            throw new PersistenceException((Identifiable)this, (Throwable)new ImmutableException("object is already modified"));
        }
        this.immutable = immutable;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutableLoggingLevel(Logger.Level immutableLoggingLevel) {
        this.immutableLoggingLevel = immutableLoggingLevel;
    }

    public Logger.Level getImmutableLoggingLevel() {
        return this.immutableLoggingLevel;
    }

    public boolean isTracked() {
        return false;
    }

    public boolean isModified() {
        if (!this.isTracked()) {
            throw new PersistenceException((Identifiable)this, "isModified() invoked on untracked object");
        }
        return this.attributesModified() || this.isNew();
    }

    public boolean attributesModified() {
        return this.modified;
    }

    public boolean differsPersisted() {
        return false;
    }

    public boolean isPersistable() {
        return !this.isImmutable();
    }

    public PreparedStatementWrapper getPreparedStatement(StatementId stmtId, int resultSetType, int resultSetConcurrency, Supplier<String> sqlsupplier) {
        return this.getSession().getPreparedStatement(new StatementKey(stmtId, this.getClass()), this.isStatementAlwaysPrepared(), resultSetType, resultSetConcurrency, sqlsupplier);
    }

    public PreparedStatementWrapper getPreparedStatement(StatementId stmtId, Supplier<String> sqlsupplier) {
        return this.getSession().getPreparedStatement(new StatementKey(stmtId, this.getClass()), this.isStatementAlwaysPrepared(), sqlsupplier);
    }

    public PreparedStatementWrapper createPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return this.getSession().createPreparedStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatementWrapper createPreparedStatement(String sql) {
        return this.getSession().createPreparedStatement(sql);
    }

    public void saveReferencingRelations(boolean update) {
    }

    public void saveReferencedRelations(boolean update) {
    }

    public void deleteReferencingRelations() {
    }

    public void deleteReferencedRelations() {
    }

    public void loadLazyReferences() {
    }

    public boolean isReferenced() {
        if (this.getSession().isRemote()) {
            if (this.isNew()) {
                return false;
            }
            try {
                return this.getRemoteDelegate().isReferenced(this.id);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.getClassVariables().isReferenced(this.getSession(), this.getId());
    }

    public boolean isRemovable() {
        return !this.isNew() && !this.isReferenced();
    }

    public boolean isCountingModification(char modType) {
        return this.isTableSerialProvided();
    }

    public boolean isTableSerialProvided() {
        return false;
    }

    public boolean isLoggingModification(char modType) {
        return false;
    }

    public boolean equals(Object object) {
        try {
            long objectId = ((AbstractDbObject)object).getId();
            if (objectId == 0L || this.getId() == 0L) {
                return super.equals(object);
            }
            return objectId == this.getId() && this.getClass() == object.getClass();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public int compareTo(P obj) {
        try {
            int rv = Long.compare(this.getId(), ((AbstractDbObject)obj).getId());
            if (rv == 0 && this.getClass() != obj.getClass()) {
                rv = this.getClass().getName().compareTo(obj.getClass().getName());
            }
            return rv;
        }
        catch (Exception ex) {
            return 1;
        }
    }

    public int hashCode() {
        if (this.getId() == 0L) {
            return super.hashCode();
        }
        return (int)this.getId();
    }

    public IdSource getIdSource() {
        return this.getClassVariables().getIdSource(this.getSession());
    }

    public P readFromResultSetWrapper(ResultSetWrapper rs) {
        this.assertNotOverloaded();
        this.getSession().setAlive(true);
        try {
            this.getFields(rs);
            this.setModified(false);
            return (P)this;
        }
        catch (PersistenceException de) {
            throw de;
        }
        catch (RuntimeException re) {
            if (!this.getSession().isTxRunning()) {
                this.getSession().forceDetached();
            }
            throw re;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public P selectObject(long id) {
        void var3_6;
        Object var3_2 = null;
        if (id <= 0L) return var3_6;
        if (this.getSession().isRemote()) {
            try {
                P p = this.getRemoteDelegate().selectObject(id);
                if (p == null) return var3_6;
                ((AbstractDbObject)p).setSession(this.getSession());
                return var3_6;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectObjectStatementId, () -> this.createSelectSql(false));
        st.setLong(1, id);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (!rs.next()) return var3_6;
            P p = this.readFromResultSetWrapper(rs);
            return var3_6;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public P selectLockedObject(long id) {
        void var3_6;
        Object var3_2 = null;
        if (id <= 0L) return var3_6;
        if (this.getSession().isRemote()) {
            try {
                P p = this.getRemoteDelegate().selectLockedObject(id);
                if (p == null) return var3_6;
                ((AbstractDbObject)p).setSession(this.getSession());
                return var3_6;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectLockedStatementId, () -> this.createSelectSql(true));
        st.setLong(1, id);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (!rs.next()) return var3_6;
            P p = this.readFromResultSetWrapper(rs);
            return var3_6;
        }
    }

    public P reloadObject() {
        return ((AbstractDbObject)this.newInstance()).selectObject(this.id);
    }

    public P reloadLockedObject() {
        return ((AbstractDbObject)this.newInstance()).selectLockedObject(this.id);
    }

    public ResultSetWrapper resultAllObjects() {
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectAllObjectsStatementId, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            this.getSession().getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        return st.executeQuery();
    }

    public ResultSetWrapper resultAllIdSerial() {
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectAllIdSerialStatementId, () -> {
            StringBuilder sql = this.createSelectAllIdSerialInnerSql();
            this.getSession().getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        return st.executeQuery();
    }

    public P selectNextObject(ResultSetWrapper rs) {
        this.getSession().assertNotRemote();
        if (rs.next()) {
            return this.readFromResultSetWrapper(rs);
        }
        return null;
    }

    public List<? extends P> selectAllObjects() {
        if (this.getSession().isRemote()) {
            try {
                List<P> list = this.getRemoteDelegate().selectAllObjects();
                for (AbstractDbObject obj : list) {
                    obj.setSession(this.getSession());
                }
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        ArrayList<P> list = new ArrayList<P>();
        try (ResultSetWrapper rs = this.resultAllObjects();){
            P obj;
            while ((obj = ((AbstractDbObject)this.newInstance()).selectNextObject(rs)) != null) {
                list.add(obj);
            }
            ArrayList<P> arrayList = list;
            return arrayList;
        }
    }

    public List<IdSerialTuple> selectAllIdSerial() {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().selectAllIdSerial();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        ArrayList<IdSerialTuple> list = new ArrayList<IdSerialTuple>();
        try (ResultSetWrapper rs = this.resultAllIdSerial();){
            while (rs.next()) {
                IdSerialTuple idSerial = new IdSerialTuple(rs.getLong(1), rs.getLong(2));
                list.add(idSerial);
            }
            ArrayList<IdSerialTuple> arrayList = list;
            return arrayList;
        }
    }

    public long selectSerial(long id) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().selectSerial(id);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectSerialStatementId, this::createSelectSerialSql);
        st.setLong(1, id);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    public long selectMaxId() {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().selectMaxId();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectMaxIdStatementId, this::createSelectMaxIdSql);
        try (ResultSetWrapper rs = st.executeQuery();){
            Long val;
            long maxId = -1L;
            if (rs.next() && (val = rs.getALong(1)) != null) {
                maxId = val;
            }
            long l = maxId;
            return l;
        }
    }

    public long selectMaxTableSerial() {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().selectMaxTableSerial();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectMaxTableSerialStatementId, this::createSelectMaxTableSerialSql);
        try (ResultSetWrapper rs = st.executeQuery();){
            Long val;
            long maxTableSerial = -1L;
            if (rs.next() && (val = rs.getALong(1)) != null) {
                maxTableSerial = val;
            }
            long l = maxTableSerial;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToDb(Db destDb, boolean plain) {
        Db oldDb = this.getSession();
        this.setSession(destDb);
        try {
            if (plain) {
                this.insertPlain();
            } else {
                this.insertObject();
            }
        }
        finally {
            this.setSession(oldDb);
        }
    }

    public int getColumnCount() {
        this.assertNotRemote();
        DbObjectClassVariables<P> classVariables = this.getClassVariables();
        if (classVariables.columnCount <= 0) {
            String sql = this.getBackend().optimizeSql("SELECT " + this.createSelectAllInnerSql() + " AND " + "1=0");
            try (ResultSetWrapper rs = this.getSession().createStatement().executeQuery(sql);){
                classVariables.columnCount = rs.getColumnCount();
            }
        }
        return classVariables.columnCount;
    }

    public void insertPlain() {
        if (this.getSession().isRemote()) {
            try {
                this.getRemoteDelegate().insertPlain(this);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else if (this.getSession().isPersistenceOperationAllowed(this, 'I')) {
            this.insertImpl(this.getClassVariables(), this::createInsertSql);
        }
    }

    protected void insertImpl(DbObjectClassVariables<P> classVariables, Supplier<String> sqlsupplier) {
        PreparedStatementWrapper st = this.getPreparedStatement(classVariables.insertStatementId, sqlsupplier);
        this.setFields(st);
        this.assertThisRowAffected(st.executeUpdate());
    }

    public void deletePlain() {
        if (this.getSession().isRemote()) {
            try {
                this.getRemoteDelegate().deletePlain(this.id, this.serial);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else if (this.getSession().isPersistenceOperationAllowed(this, 'D')) {
            this.deleteImpl(this.getClassVariables(), this::createDeleteSql);
        }
    }

    protected void deleteImpl(DbObjectClassVariables<P> classVariables, Supplier<String> sqlsupplier) {
        PreparedStatementWrapper st = this.getPreparedStatement(classVariables.deleteStatementId, sqlsupplier);
        st.setLong(1, this.id);
        st.setLong(2, this.serial);
        this.assertThisRowAffected(st.executeUpdate());
    }

    public void updatePlain() {
        if (this.getSession().isRemote()) {
            try {
                this.getRemoteDelegate().updatePlain(this);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else if (this.getSession().isPersistenceOperationAllowed(this, 'U')) {
            this.updateImpl(this.getClassVariables(), this::createUpdateSql);
            ++this.serial;
        }
    }

    protected void updateImpl(DbObjectClassVariables<P> classVariables, Supplier<String> sqlsupplier) {
        PreparedStatementWrapper st = this.getPreparedStatement(classVariables.updateStatementId, sqlsupplier);
        this.setFields(st);
        this.assertThisRowAffected(st.executeUpdate());
    }

    public void dummyUpdate() {
        if (this.getSession().isRemote()) {
            try {
                this.getRemoteDelegate().dummyUpdate(this);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().dummyUpdateStatementId, this::createDummyUpdateSql);
            st.setLong(1, this.id);
            this.assertThisRowAffected(st.executeUpdate());
        }
    }

    public void updateSerial() {
        if (this.getSession().isRemote()) {
            try {
                this.getRemoteDelegate().updateSerial(this.id, this.serial);
                ++this.serial;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else if (this.getSession().isPersistenceOperationAllowed(this, 'U')) {
            PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().updateSerialStatementId, this::createUpdateSerialSql);
            st.setLong(1, this.id);
            st.setLong(2, this.serial);
            this.assertThisRowAffected(st.executeUpdate());
            ++this.serial;
        }
    }

    public void updateSerialAndTableSerial() {
        if (this.getSession().isRemote()) {
            try {
                this.getRemoteDelegate().updateSerialAndTableSerial(this.id, this.serial, this.tableSerial);
                ++this.serial;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else if (this.getSession().isPersistenceOperationAllowed(this, 'U')) {
            PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().updateSerialAndTableSerialStatementId, this::createUpdateSerialAndTableSerialSql);
            st.setLong(1, this.tableSerial);
            st.setLong(2, this.id);
            st.setLong(3, this.serial);
            this.assertThisRowAffected(st.executeUpdate());
            ++this.serial;
        }
    }

    public boolean isUpdatingSerialEvenIfNotModified() {
        return false;
    }

    public void initModification(char modType) {
        if (this.isCountingModification(modType)) {
            this.setTableSerial(this.countModification());
        }
    }

    public void finishModification(char modType) {
        if (this.isLoggingModification(modType)) {
            this.logModification(modType);
        }
    }

    public void finishNotUpdated(char modType) {
    }

    protected long beginTx(String txName) {
        long txVoucher = this.getSession().begin(txName);
        if (txVoucher != 0L) {
            this.getSession().setTxObject(this);
        }
        return txVoucher;
    }

    public void insertObject() {
        this.assertPersistable();
        this.prepareSetFields();
        if (this.getSession().isRemote()) {
            try {
                DbObjectResult result = this.getRemoteDelegate().insertObject(this);
                this.id = result.getId();
                this.serial = result.getSerial();
                this.tableSerial = result.getTableSerial();
                this.setModified(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        if (this.getSession().isPersistenceOperationAllowed(this, 'I')) {
            long oldId = this.id;
            long oldSerial = this.serial;
            long txVoucher = this.beginTx(TX_INSERT_OBJECT);
            try {
                this.initModification('I');
                if (this.id < 0L) {
                    this.id = -this.id;
                }
                ++this.serial;
                this.saveReferencedRelations(false);
                this.insertImpl(this.getClassVariables(), this::createInsertSql);
                this.saveReferencingRelations(false);
                this.finishModification('I');
                this.getSession().commit(txVoucher);
                this.setModified(false);
            }
            catch (RuntimeException ex) {
                this.getSession().rollback(txVoucher);
                this.serial = oldSerial;
                this.id = oldId;
                if (ex instanceof PersistenceException) {
                    ((PersistenceException)((Object)ex)).updateDbObject((Identifiable)this);
                    throw ex;
                }
                throw new PersistenceException((Identifiable)this, (Throwable)ex);
            }
        }
    }

    protected boolean isUpdateNecessary() {
        return !this.isTracked() || this.attributesModified() || this.isNew();
    }

    public void updateObject() {
        this.assertPersistable();
        this.prepareSetFields();
        if (this.getSession().isRemote()) {
            try {
                DbObjectResult result = this.getRemoteDelegate().updateObject(this);
                this.id = result.getId();
                this.serial = result.getSerial();
                this.tableSerial = result.getTableSerial();
                this.setModified(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        if (this.getSession().isPersistenceOperationAllowed(this, 'U')) {
            long oldId = this.id;
            long oldSerial = this.serial;
            long txVoucher = this.beginTx(TX_UPDATE_OBJECT);
            try {
                boolean updated = true;
                if (!this.isUpdateNecessary()) {
                    if (this.isUpdatingSerialEvenIfNotModified()) {
                        this.initModification('U');
                        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().updateSerialStatementId, () -> this.isTableSerialProvided() ? this.createUpdateSerialAndTableSerialSql() : this.createUpdateSerialSql());
                        this.saveReferencedRelations(true);
                        int ndx = 0;
                        if (this.isTableSerialProvided()) {
                            st.setLong(++ndx, this.tableSerial);
                        }
                        st.setLong(++ndx, this.id);
                        st.setLong(++ndx, this.serial);
                        this.assertThisRowAffected(st.executeUpdate());
                        this.saveReferencingRelations(true);
                        this.finishModification('U');
                    } else {
                        this.saveReferencedRelations(true);
                        this.saveReferencingRelations(true);
                        this.finishNotUpdated('U');
                        updated = false;
                    }
                } else {
                    this.initModification('U');
                    if (this.id < 0L) {
                        this.id = -this.id;
                    }
                    this.saveReferencedRelations(true);
                    this.updateImpl(this.getClassVariables(), this::createUpdateSql);
                    this.saveReferencingRelations(true);
                    this.finishModification('U');
                }
                this.getSession().commit(txVoucher);
                if (updated) {
                    ++this.serial;
                }
                this.setModified(false);
            }
            catch (RuntimeException ex) {
                this.getSession().rollback(txVoucher);
                this.id = oldId;
                this.serial = oldSerial;
                if (ex instanceof PersistenceException) {
                    ((PersistenceException)((Object)ex)).updateDbObject((Identifiable)this);
                    throw ex;
                }
                throw new PersistenceException((Identifiable)this, (Throwable)ex);
            }
        }
    }

    public void prepareSave() {
        this.preparePending = false;
    }

    public void clearOnRemoteSave() {
    }

    public void saveObject() {
        this.preparePending = true;
        if (this.getSession().isRemote()) {
            this.clearOnRemoteSave();
            this.prepareSave();
            try {
                DbObjectResult result = this.getRemoteDelegate().saveObject(this);
                this.id = result.getId();
                this.serial = result.getSerial();
                this.tableSerial = result.getTableSerial();
                this.setModified(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        if (this.preparePending) {
            this.prepareSave();
        }
        long oldId = this.id;
        long txVoucher = this.beginTx(TX_SAVE);
        try {
            if (this.id <= 0L) {
                if (this.id == 0L) {
                    this.newId();
                }
                this.insertObject();
            } else {
                this.updateObject();
            }
            this.getSession().commit(txVoucher);
        }
        catch (RuntimeException ex) {
            this.getSession().rollback(txVoucher);
            this.id = oldId;
            if (ex instanceof PersistenceException) {
                ((PersistenceException)((Object)ex)).updateDbObject((Identifiable)this);
                throw ex;
            }
            throw new PersistenceException((Identifiable)this, (Throwable)ex);
        }
    }

    public P persistObject() {
        if (this.getSession().isRemote()) {
            this.clearOnRemoteSave();
            this.preparePending = true;
            this.prepareSave();
            try {
                AbstractDbObject obj = this.getRemoteDelegate().persistObject(this);
                if (obj != null) {
                    obj.setSession(this.getSession());
                }
                return (P)obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.saveObject();
        return (P)this;
    }

    public void prepareDelete() {
        this.preparePending = false;
    }

    public void deleteObject() {
        this.assertNotNew();
        this.assertPersistable();
        this.preparePending = true;
        if (this.getSession().isRemote()) {
            this.prepareDelete();
            try {
                DbObjectResult result = this.getRemoteDelegate().deleteObject(this);
                this.id = result.getId();
                this.serial = result.getSerial();
                this.tableSerial = result.getTableSerial();
                this.setModified(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        if (this.preparePending) {
            this.prepareDelete();
        }
        if (this.getSession().isPersistenceOperationAllowed(this, 'D')) {
            long txVoucher = this.beginTx(TX_DELETE_OBJECT);
            try {
                this.initModification('D');
                this.deleteReferencingRelations();
                this.deleteImpl(this.getClassVariables(), this::createDeleteSql);
                this.deleteReferencedRelations();
                this.finishModification('D');
                this.getSession().commit(txVoucher);
                this.id = -this.id;
                this.setModified(false);
            }
            catch (RuntimeException ex) {
                this.getSession().rollback(txVoucher);
                if (ex instanceof PersistenceException) {
                    ((PersistenceException)((Object)ex)).updateDbObject((Identifiable)this);
                    throw ex;
                }
                throw new PersistenceException((Identifiable)this, (Throwable)ex);
            }
        }
    }

    public void markDeleted() {
        this.setId(-this.getId());
    }

    public void unmarkDeleted() {
        this.setId(this.getId());
    }

    public long countModification() {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().countModification();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.getSession().isCountModificationAllowed() ? PdoTracker.getInstance().countModification(this.getTableName()) : -1L;
    }

    public long getModificationCount() {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().getModificationCount();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return ((ModificationTracker)PdoTracker.getInstance()).getIdSerialForName(this.getTableName()).getSerial();
    }

    public List<IdSerialTuple> selectExpiredTableSerials(long oldSerial) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().selectExpiredTableSerials(oldSerial);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectExpiredTableSerials1StatementId, this::createSelectExpiredTableSerials1Sql);
        st.setLong(1, oldSerial);
        try (ResultSetWrapper rs = st.executeQuery();){
            ArrayList<IdSerialTuple> expireList = new ArrayList<IdSerialTuple>();
            while (rs.next()) {
                expireList.add(new IdSerialTuple(rs.getLong(1), rs.getLong(2)));
            }
            ArrayList<IdSerialTuple> arrayList = expireList;
            return arrayList;
        }
    }

    public List<IdSerialTuple> selectExpiredTableSerials(long oldSerial, long maxSerial) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().selectExpiredTableSerials(oldSerial, maxSerial);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(this.getClassVariables().selectExpiredTableSerials2StatementId, this::createSelectExpiredTableSerials2Sql);
        st.setLong(1, oldSerial);
        st.setLong(2, maxSerial);
        ArrayList<IdSerialTuple> expireList = new ArrayList<IdSerialTuple>();
        try (ResultSetWrapper rs = st.executeQuery();){
            while (rs.next()) {
                expireList.add(new IdSerialTuple(rs.getLong(1), rs.getLong(2)));
            }
            ArrayList<IdSerialTuple> arrayList = expireList;
            return arrayList;
        }
    }

    public List<IdSerialTuple> getExpirationBacklog(long minSerial, long maxSerial) {
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().getExpirationBacklog(minSerial, maxSerial);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.getClassVariables().expirationBacklog.getExpiration(minSerial, maxSerial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IdSerialTuple> getExpiredTableSerials(long oldSerial, long maxSerial) {
        List<IdSerialTuple> exp;
        if (this.getSession().isRemote()) {
            try {
                return this.getRemoteDelegate().getExpiredTableSerials(oldSerial, maxSerial);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        if (AbstractApplication.getRunningApplication().isServer()) {
            TableSerialExpirationBacklog backlog;
            TableSerialExpirationBacklog tableSerialExpirationBacklog = backlog = this.getClassVariables().expirationBacklog;
            synchronized (tableSerialExpirationBacklog) {
                exp = backlog.getExpiration(oldSerial, maxSerial);
                if (exp == null) {
                    exp = this.selectExpiredTableSerials(oldSerial, maxSerial);
                    backlog.addExpiration(oldSerial, maxSerial, exp);
                    LOGGER.fine("added expiration set {0}-{1}[{2}] for {3}", new Object[]{oldSerial, maxSerial, exp.size(), this.getTableName()});
                }
            }
        } else {
            exp = this.selectExpiredTableSerials(oldSerial, maxSerial);
        }
        return exp;
    }

    public ModificationLog createModificationLog(char modType) {
        return ModificationLogFactory.getInstance().createModificationLog(this, modType);
    }

    public void logModification(char modType) {
        this.getSession().assertNotRemote();
        if (this.getSession().isLogModificationAllowed()) {
            this.getSession().logBeginTx();
            this.createModificationLog(modType).saveObject();
        }
    }

    public AbstractDbObjectRemoteDelegate<P> getRemoteDelegate() {
        return this.getClassVariables().getRemoteDelegate(this.getSession());
    }

    public boolean isStatementAlwaysPrepared() {
        return this.getClassVariables().alwaysPrepare;
    }

    public void setStatementAlwaysPrepared(boolean alwaysPrepare) {
        this.getClassVariables().alwaysPrepare = alwaysPrepare;
    }

    public String getTableName() {
        return this.getClassVariables().tableName;
    }

    public void getFields(ResultSetWrapper rs) {
    }

    public void prepareSetFields() {
    }

    public int setFields(PreparedStatementWrapper st) {
        return 0;
    }

    public StringBuilder createSelectAllInnerSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("*");
        sql.append(" FROM ");
        sql.append(this.getTableName());
        sql.append(" WHERE 1=1");
        return sql;
    }

    public StringBuilder createSelectAllIdSerialInnerSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("id");
        sql.append(",");
        sql.append("serial");
        sql.append(" FROM ");
        sql.append(this.getTableName());
        sql.append(" WHERE 1=1");
        return sql;
    }

    public StringBuilder createSelectAllByIdInnerSql() {
        StringBuilder sql = this.createSelectAllInnerSql();
        sql.append(" AND ");
        sql.append("id");
        sql.append("=?");
        return sql;
    }

    public StringBuilder createSelectIdInnerSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("id");
        sql.append(" FROM ");
        sql.append(this.getTableName());
        sql.append(" WHERE 1=1");
        return sql;
    }

    public StringBuilder createDeleteAllSql() {
        StringBuilder sql = new StringBuilder("DELETE ");
        sql.append(" FROM ");
        sql.append(this.getTableName());
        sql.append(" WHERE 1=1");
        return sql;
    }

    public StringBuilder createSqlUpdate() {
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(this.getTableName());
        sql.append(" SET ");
        return sql;
    }

    public String createUpdateSql() {
        throw new PersistenceException((Identifiable)this, "method createUpdateSql not implemented in " + this.getClass());
    }

    public String createInsertSql() {
        throw new PersistenceException((Identifiable)this, "method createInsertSql not implemented in " + this.getClass());
    }

    public String createSelectSql(boolean locked) {
        StringBuilder sql = this.createSelectAllByIdInnerSql();
        this.getSession().getBackend().buildSelectSql(sql, locked, 0, 0);
        return sql.toString();
    }

    public String createSelectSerialSql() {
        return "SELECT serial FROM " + this.getTableName() + " WHERE " + "id" + "=?";
    }

    public String createSelectMaxIdSql() {
        return "SELECT MAX(id) FROM " + this.getTableName();
    }

    public String createSelectMaxTableSerialSql() {
        return "SELECT MAX(tableserial) FROM " + this.getTableName();
    }

    public String createDeleteSql() {
        return "DELETE  FROM " + this.getTableName() + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public String createDummyUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + "id" + "=" + "id" + " WHERE " + "id" + "=?";
    }

    public String createUpdateSerialSql() {
        return "UPDATE " + this.getTableName() + " SET " + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public String createUpdateSerialAndTableSerialSql() {
        return "UPDATE " + this.getTableName() + " SET " + "serial" + "=" + "serial" + "+1, " + CN_TABLESERIAL + "=?" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public String createSelectExpiredTableSerials1Sql() {
        return "SELECT id,tableserial FROM " + this.getTableName() + " WHERE " + CN_TABLESERIAL + ">?" + " ORDER BY " + CN_TABLESERIAL + "," + "id";
    }

    public String createSelectExpiredTableSerials2Sql() {
        return "SELECT id,tableserial FROM " + this.getTableName() + " WHERE " + CN_TABLESERIAL + ">?" + " AND " + CN_TABLESERIAL + "<=?" + " ORDER BY " + CN_TABLESERIAL + "," + "id";
    }

    protected void assertNotRemote() {
        if (this.getSession().isRemote()) {
            throw new PersistenceException((Identifiable)this, "operation not allowed for objects belonging to a remote session");
        }
    }

    protected void assertRemote() {
        if (!this.getSession().isRemote()) {
            throw new PersistenceException((Identifiable)this, "operation only allowed for objects belonging to a remote session");
        }
    }

    protected void assertNumberOfRowsAffected(int count, int expected) {
        if (count != expected) {
            String message = "unexpected number of rows affected: " + count + ", expected: " + expected;
            if (count < 1) {
                throw new NotFoundException((Session)this.getSession(), message);
            }
            throw new PersistenceException((Session)this.getSession(), message);
        }
    }

    protected void assertThisRowAffected(int count) {
        if (count != 1) {
            if (count < 1) {
                String message = "no rows affected";
                if (!this.isVirgin()) {
                    long persistedSerial = this.selectSerial(this.getId());
                    message = persistedSerial > 0L ? message + " (persisted serial=" + persistedSerial + ")" : message + " (object with id=" + this.id + " doesn't exist in table " + this.getTableName() + ")";
                }
                throw new NotFoundException((Identifiable)this, message);
            }
            throw new PersistenceException((Identifiable)this, "more than one row affected: " + count);
        }
    }

    protected void assertPersistable() {
        if (!this.isPersistable()) {
            throw new PersistenceException((Identifiable)this, "object is not persistable");
        }
    }

    protected void assertNotNew() {
        if (this.isNew()) {
            throw new NotFoundException((Identifiable)this, this.id == 0L ? "object is new" : "object is deleted");
        }
    }

    protected void assertNotOverloaded() {
        if (!this.isOverloadable() && !this.isVirgin()) {
            throw new PersistenceException((Identifiable)this, "object is already loaded");
        }
    }

    protected void assertMutable() {
        if (this.isImmutable()) {
            PersistenceException ex = new PersistenceException((Identifiable)this, (Throwable)new ImmutableException("object is immutable"));
            if (this.immutableLoggingLevel == null) {
                throw ex;
            }
            LOGGER.log(this.immutableLoggingLevel, ex.getMessage(), (Throwable)ex);
        }
    }
}

