/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.rmi;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.tentackle.common.Compare;
import org.tentackle.common.Timestamp;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.AdminExtension;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.pdo.rmi.AdminExtensionRemoteDelegate;
import org.tentackle.persist.Db;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.persist.rmi.RemoteDelegateImpl;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityManager;
import org.tentackle.security.SecurityResult;

public class AdminExtensionRemoteDelegateImpl
extends RemoteDelegateImpl<AdminExtension>
implements AdminExtensionRemoteDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminExtensionRemoteDelegateImpl.class);

    public AdminExtensionRemoteDelegateImpl(RemoteDbSessionImpl session, Class<AdminExtension> clazz) throws RemoteException {
        super(session, clazz);
    }

    @Override
    public List<AdminExtension.SessionData> getSessions(DomainContext context) throws RemoteException {
        try {
            context.setSession((Session)this.getSession());
            this.checkPermission(context);
            ArrayList<AdminExtension.SessionData> sessions = new ArrayList<AdminExtension.SessionData>();
            for (RemoteDbSessionImpl remoteSession : RemoteDbSessionImpl.getOpenSessions()) {
                sessions.add(new SessionDataImpl(remoteSession));
            }
            Collections.sort(sessions, (o1, o2) -> {
                int rv = Compare.compare((Comparable)((Object)o1.getUserName()), (Comparable)((Object)o2.getUserName()));
                if (rv == 0) {
                    rv = Long.compare(o1.getSessionNumber(), o2.getSessionNumber());
                }
                return rv;
            });
            return sessions;
        }
        catch (RuntimeException ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public int kill(DomainContext context, long userId, long sessionGroupId, String applicationName, long applicationId) throws RemoteException {
        LOGGER.warning("killing session(s) for userId {0}, groupId {1}, application {2}, applicationId {3}", new Object[]{userId, sessionGroupId, applicationName, applicationId});
        try {
            context.setSession((Session)this.getSession());
            this.checkPermission(context);
            int count = 0;
            for (RemoteDbSessionImpl openSession : RemoteDbSessionImpl.getOpenSessions()) {
                if (openSession.getClientSessionInfo().getUserId() != userId || sessionGroupId != 0L && (long)openSession.getSession().getSessionGroupId() != sessionGroupId || applicationName != null && !Objects.equals(openSession.getClientSessionInfo().getApplicationName(), applicationName) || applicationId != 0L && openSession.getClientSessionInfo().getApplicationId() != applicationId) continue;
                Db db = openSession.getSession();
                if (db != null) {
                    db.setOwnerThread(Thread.currentThread());
                }
                openSession.close();
                ++count;
            }
            return count;
        }
        catch (RuntimeException ex) {
            throw this.createException(ex);
        }
    }

    private void checkPermission(DomainContext context) {
        SecurityFactory sf = SecurityFactory.getInstance();
        SecurityManager sm = sf.getSecurityManager();
        SecurityResult sr = sm.evaluate(context, (Permission)sf.getExecutePermission(), this.getServicedClass());
        if (!sr.isAccepted()) {
            throw new SecurityException(sr.explain("no execute permission for " + this.getServicedClass().getName()));
        }
    }

    private static class SessionDataImpl
    implements AdminExtension.SessionData,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final NumberFormat OFFSET_FMT = new DecimalFormat("+#0.#");
        private final long userId;
        private final String userName;
        private final Timestamp since;
        private final String applicationName;
        private final long applicationId;
        private final String clientVersionInfo;
        private final String locale;
        private final String vmInfo;
        private final String osInfo;
        private final String hostInfo;
        private final String timeZone;
        private final String clientHost;
        private final long sessionNumber;
        private final long sessionGroup;
        private final String options;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SessionDataImpl(RemoteDbSessionImpl remoteSession) {
            SessionInfo info = remoteSession.getClientSessionInfo();
            this.userId = info.getUserId();
            this.userName = info.getUserName();
            this.since = new Timestamp(info.getSince());
            this.applicationName = info.getApplicationName();
            this.applicationId = info.getApplicationId();
            this.clientVersionInfo = info.getClientVersionInfo() == null ? "?" : info.getClientVersionInfo().toString();
            this.locale = info.getLocale() == null ? "?" : info.getLocale().toString();
            this.vmInfo = info.getVmInfo();
            this.osInfo = info.getOsInfo();
            this.hostInfo = info.getHostInfo();
            double tzOffsetH = (double)info.getTimeZone().getOffset(System.currentTimeMillis()) / 3600000.0;
            NumberFormat numberFormat = OFFSET_FMT;
            synchronized (numberFormat) {
                this.timeZone = info.getTimeZone() == null ? "?" : info.getTimeZone().getID() + " (" + OFFSET_FMT.format(tzOffsetH) + "h)";
            }
            this.clientHost = remoteSession.getClientHostString();
            this.sessionNumber = remoteSession.getSessionNumber();
            this.sessionGroup = remoteSession.getSession().getSessionGroupId();
            this.options = remoteSession.getOptions();
        }

        public long getUserId() {
            return this.userId;
        }

        public String getUserName() {
            return this.userName;
        }

        public Timestamp getSince() {
            return this.since;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public long getApplicationId() {
            return this.applicationId;
        }

        public String getClientVersionInfo() {
            return this.clientVersionInfo;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getVmInfo() {
            return this.vmInfo;
        }

        public String getOsInfo() {
            return this.osInfo;
        }

        public String getHostInfo() {
            return this.hostInfo;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getClientHost() {
            return this.clientHost;
        }

        public long getSessionNumber() {
            return this.sessionNumber;
        }

        public long getSessionGroup() {
            return this.sessionGroup;
        }

        public String getOptions() {
            return this.options;
        }
    }
}

