/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Created on November 14, 2003, 2:35 PM

package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.common.Timestamp;
import org.tentackle.persist.ModificationLog;



/**
 * Remote delegate interface for {@link ModificationLog}.
 *
 * @author  harald
 */
public interface ModificationLogRemoteDelegate extends AbstractDbObjectRemoteDelegate<ModificationLog> {

  void updateProcessed(Timestamp processed, ModificationLog obj) throws RemoteException;

  void updateDiagnostics(Timestamp processed, String comment, ModificationLog obj) throws RemoteException;

  // @wurblet inclrmi Include --missingok .$classname/methods

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi

  ModificationLog selectFirstUnprocessed() throws RemoteException;
  ModificationLog selectFirstUnprocessedGreater(long id) throws RemoteException;
  ModificationLog selectGreaterId(long id) throws RemoteException;
  ModificationLog selectLastProcessed() throws RemoteException;
  List<ModificationLog> selectByObject(int objectClassId, long objectId) throws RemoteException;
  List<ModificationLog> selectByUserAndType(String user, char modType) throws RemoteException;
  boolean isReferencingUser(String user) throws RemoteException;
  boolean isReferencingObject(int objectClassId, long objectId) throws RemoteException;
  int updateByObjectTypeSerial(Timestamp processed, int objectClassId, long objectId, char modType, long serial) throws RemoteException;
  int deleteByObjectTypeSerial(int objectClassId, long objectId, char modType, long serial) throws RemoteException;
  List<? extends ModificationLog> selectByTxId(long txId) throws RemoteException;
  int updateUnprocessedByTxId(Timestamp processed, long txId) throws RemoteException;
  int deleteByTxId(long txId) throws RemoteException;
  int deleteProcessed(Timestamp processed) throws RemoteException;
  List<ModificationLog> selectUpTo(Timestamp processed) throws RemoteException;

  // </editor-fold>//GEN-END:inclrmi

}
