/*
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.tentackle.persist;

import org.tentackle.common.ServiceFactory;
import org.tentackle.pdo.RemoteSession;
import org.tentackle.persist.rmi.RemoteDbSession;

interface RemoteSessionFactory$Singleton {
  RemoteSessionFactory INSTANCE = ServiceFactory.createService(RemoteSessionFactory.class);
}

/**
 * Factory for remote sessions.
 *
 * @author harald
 */
public interface RemoteSessionFactory {

  /**
   * The singleton.
   *
   * @return the singleton
   */
  static RemoteSessionFactory getInstance() {
    return RemoteSessionFactory$Singleton.INSTANCE;
  }

  /**
   * Creates the remote session.
   *
   * @param remoteDbSession the remote object
   * @return the remote session
   */
  RemoteSession create(RemoteDbSession remoteDbSession);

}
