/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.persist;

import org.tentackle.common.Service;


/**
 * Default implementation of a modification log factory.
 *
 * @author harald
 */
@Service(ModificationLogFactory.class)
public class DefaultModificationLogFactory implements ModificationLogFactory {

  @Override
  public ModificationLog createModificationLog() {
    return new ModificationLog();
  }

  @Override
  public ModificationLog createModificationLog(Db db) {
    return new ModificationLog(db);
  }

  @Override
  public ModificationLog createModificationLog(Db db, char modType) {
    return new ModificationLog(db, modType);
  }

  @Override
  public <P extends AbstractDbObject<P>> ModificationLog createModificationLog(AbstractDbObject<P> object, char modType) {
    return new ModificationLog(object, modType);
  }

  @Override
  public ModificationLog createModificationLog(ModificationLog template, char modType) {
    return new ModificationLog(template, modType);
  }

}
