/**
 * NumberRangeRemoteDelegateImpl.java
 *
 */

package org.tentackle.ns.pdo.rmi;

import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.ns.pdo.NumberRangePersistenceImpl;
import java.rmi.RemoteException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.rmi.AbstractPersistentObjectRemoteDelegateImpl;
import org.tentackle.misc.TrackedList;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;


/**
 * Remote delegate implementation for {@link NumberRangePersistenceImpl}.
 */
public class NumberRangeRemoteDelegateImpl
             extends AbstractPersistentObjectRemoteDelegateImpl<NumberRange,NumberRangePersistenceImpl>
             implements NumberRangeRemoteDelegate {


  /**
   * Creates the remote delegate for {@link NumberRangePersistenceImpl}.
   *
   * @param session the RMI session
   * @param persistenceClass the persistence implementation class
   * @param pdoClass the pdo interface class
   * @throws java.rmi.RemoteException
   */
  public NumberRangeRemoteDelegateImpl(RemoteDbSessionImpl session, Class<NumberRangePersistenceImpl> persistenceClass, Class<NumberRange> pdoClass) throws RemoteException {
    super(session, persistenceClass, pdoClass);
  }
  /**
   * Include wurblet-generated method declarations.
   *
   * @wurblet inclrmi Include --missingok .$classname/methods
   */
  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi


  @Override
  public TrackedList<NumberRange> selectByNumberPoolId(DomainContext context, long numberPoolId) throws RemoteException {
    try {
      setDomainContext(context);
      return dbObject.selectByNumberPoolId(numberPoolId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  // </editor-fold>//GEN-END:inclrmi

}
