/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Created on November 19, 2003, 6:40 PM

package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.common.Timestamp;
import org.tentackle.persist.ModificationLog;

/**
 * Remote delegate implementation  for {@link ModificationLog}.
 * 
 * @author  harald
 */
public class ModificationLogRemoteDelegateImpl
             extends AbstractDbObjectRemoteDelegateImpl<ModificationLog>
             implements ModificationLogRemoteDelegate {


  public ModificationLogRemoteDelegateImpl(RemoteDbSessionImpl session, Class<ModificationLog> clazz) throws RemoteException {
    super(session, clazz);
  }


  @Override
  public void updateProcessed(Timestamp processed, ModificationLog obj) throws RemoteException {
    try {
      obj.setSession(getSession());
      obj.updateProcessed(processed);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public void updateDiagnostics(Timestamp processed, String comment, ModificationLog obj) throws RemoteException {
    try {
      obj.setSession(getSession());
      obj.updateDiagnostics(processed, comment);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }


  // @wurblet inclrmi Include --missingok .$classname/methods

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi


  @Override
  public ModificationLog selectFirstUnprocessed() throws RemoteException {
    try {
      return newInstance().selectFirstUnprocessed();
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public ModificationLog selectFirstUnprocessedGreater(long id) throws RemoteException {
    try {
      return newInstance().selectFirstUnprocessedGreater(id);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public ModificationLog selectGreaterId(long id) throws RemoteException {
    try {
      return newInstance().selectGreaterId(id);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public ModificationLog selectLastProcessed() throws RemoteException {
    try {
      return newInstance().selectLastProcessed();
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public List<ModificationLog> selectByObject(int objectClassId, long objectId) throws RemoteException {
    try {
      return dbObject.selectByObject(objectClassId, objectId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public List<ModificationLog> selectByUserAndType(String user, char modType) throws RemoteException {
    try {
      return dbObject.selectByUserAndType(user, modType);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public boolean isReferencingUser(String user) throws RemoteException {
    try {
      return dbObject.isReferencingUser(user);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public boolean isReferencingObject(int objectClassId, long objectId) throws RemoteException {
    try {
      return dbObject.isReferencingObject(objectClassId, objectId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int updateByObjectTypeSerial(Timestamp processed, int objectClassId, long objectId, char modType, long serial) throws RemoteException {
    try {
      return dbObject.updateByObjectTypeSerial(processed, objectClassId, objectId, modType, serial);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteByObjectTypeSerial(int objectClassId, long objectId, char modType, long serial) throws RemoteException {
    try {
      return dbObject.deleteByObjectTypeSerial(objectClassId, objectId, modType, serial);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public List<? extends ModificationLog> selectByTxId(long txId) throws RemoteException {
    try {
      return dbObject.selectByTxId(txId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int updateUnprocessedByTxId(Timestamp processed, long txId) throws RemoteException {
    try {
      return dbObject.updateUnprocessedByTxId(processed, txId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteByTxId(long txId) throws RemoteException {
    try {
      return dbObject.deleteByTxId(txId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteProcessed(Timestamp processed) throws RemoteException {
    try {
      return dbObject.deleteProcessed(processed);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public List<ModificationLog> selectUpTo(Timestamp processed) throws RemoteException {
    try {
      return dbObject.selectUpTo(processed);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  // </editor-fold>//GEN-END:inclrmi

}
