/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Created on November 19, 2003, 6:51 PM

package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import org.tentackle.persist.DbPreferencesNode;

/**
 * Remote delegate implementation for {@link DbPreferencesNode}.
 *
 * @author harald
 */
public class DbPreferencesNodeRemoteDelegateImpl
             extends AbstractDbObjectRemoteDelegateImpl<DbPreferencesNode>
             implements DbPreferencesNodeRemoteDelegate {


  public DbPreferencesNodeRemoteDelegateImpl(RemoteDbSessionImpl session, Class<DbPreferencesNode> clazz) throws RemoteException {
    super(session, clazz);
  }


  @Override
  public Set<Long> selectChildIds(long parentId) throws RemoteException {
    try {
      return selectObject(parentId).selectChildIds();
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  // @wurblet inclrmi Include --missingok .DbPreferencesNodeRemoteDelegateImpl/methods

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi


  @Override
  public List<DbPreferencesNode> selectByParentId(long parentId) throws RemoteException {
    try {
      return dbObject.selectByParentId(parentId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public DbPreferencesNode selectByUserAndName(String user, String name) throws RemoteException {
    try {
      return newInstance().selectByUserAndName(user, name);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  // </editor-fold>//GEN-END:inclrmi

}
