/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Created on November 19, 2003, 6:51 PM

package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.persist.DbPreferencesKey;

/**
 * Remote delegate implementation for {@link DbPreferencesKey}.
 *
 * @author harald
 */
public class DbPreferencesKeyRemoteDelegateImpl
       extends AbstractDbObjectRemoteDelegateImpl<DbPreferencesKey>
       implements DbPreferencesKeyRemoteDelegate {


  public DbPreferencesKeyRemoteDelegateImpl(RemoteDbSessionImpl session, Class<DbPreferencesKey> clazz) throws RemoteException {
    super(session, clazz);
  }


  // @wurblet inclrmi Include --missingok .DbPreferencesKeyRemoteDelegateImpl/methods

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi


  @Override
  public List<DbPreferencesKey> selectByNodeId(long nodeId) throws RemoteException {
    try {
      return dbObject.selectByNodeId(nodeId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public DbPreferencesKey selectByNodeIdKey(long nodeId, String key) throws RemoteException {
    try {
      return newInstance().selectByNodeIdKey(nodeId, key);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public int deleteByNodeId(long nodeId) throws RemoteException {
    try {
      return dbObject.deleteByNodeId(nodeId);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  // </editor-fold>//GEN-END:inclrmi

}
