/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// Created on November 19, 2003, 6:50 PM

package org.tentackle.persist.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.persist.DbPreferencesKey;

/**
 * Remote delegate interface for {@link DbPreferencesKey}.
 * @author harald
 */
public interface DbPreferencesKeyRemoteDelegate extends AbstractDbObjectRemoteDelegate<DbPreferencesKey> {

  // @wurblet inclrmi Include --missingok .DbPreferencesKeyRemoteDelegate/methods

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi

  List<DbPreferencesKey> selectByNodeId(long nodeId) throws RemoteException;
  DbPreferencesKey selectByNodeIdKey(long nodeId, String key) throws RemoteException;
  int deleteByNodeId(long nodeId) throws RemoteException;

  // </editor-fold>//GEN-END:inclrmi

}
