/**
 * NumberPoolRemoteDelegateImpl.java
 *
 */

package org.tentackle.ns.pdo.rmi;

import org.tentackle.ns.pdo.NumberPool;
import org.tentackle.ns.pdo.NumberPoolPersistenceImpl;
import java.rmi.RemoteException;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.rmi.AbstractPersistentObjectRemoteDelegateImpl;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;


/**
 * Remote delegate implementation for {@link NumberPoolPersistenceImpl}.
 */
public class NumberPoolRemoteDelegateImpl
             extends AbstractPersistentObjectRemoteDelegateImpl<NumberPool,NumberPoolPersistenceImpl>
             implements NumberPoolRemoteDelegate {


  /**
   * Creates the remote delegate for {@link NumberPoolPersistenceImpl}.
   *
   * @param session the RMI session
   * @param persistenceClass the persistence implementation class
   * @param pdoClass the pdo interface class
   * @throws java.rmi.RemoteException
   */
  public NumberPoolRemoteDelegateImpl(RemoteDbSessionImpl session, Class<NumberPoolPersistenceImpl> persistenceClass, Class<NumberPool> pdoClass) throws RemoteException {
    super(session, persistenceClass, pdoClass);
  }
  /**
   * Include wurblet-generated method declarations.
   *
   * @wurblet inclrmi Include --missingok .$classname/methods
   */
  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:inclrmi


  @Override
  public NumberPool selectByUniqueDomainKey(DomainContext context, String name) throws RemoteException {
    try {
      return newInstance(context).selectByUniqueDomainKey(name);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  @Override
  public NumberPool selectByNameRealm(DomainContext context, String name, String realm) throws RemoteException {
    try {
      return newInstance(context).selectByNameRealm(name, realm);
    }
    catch (Exception e) {
      throw createException(e);
    }
  }

  // </editor-fold>//GEN-END:inclrmi

}
