/**
 * Tentackle - http://www.tentackle.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package org.tentackle.ns.pdo;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Objects;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.IdentifiableMap;
import org.tentackle.misc.TrackedArrayList;
import org.tentackle.misc.TrackedList;
import org.tentackle.ns.pdo.rmi.NumberPoolRemoteDelegate;
import org.tentackle.pdo.AbstractPersistentObject;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Persistent;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObjectClassVariables;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.pdo.Session;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.sql.Backend;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationUtilities;



/**
 * Number Space persistence implementation.
 *
 * @author harald
 */
@PersistentObjectService(NumberPool.class)
public class NumberPoolPersistenceImpl extends AbstractPersistentObject<NumberPool, NumberPoolPersistenceImpl> implements NumberPoolPersistence {

  private static final long serialVersionUID = -1178387730540795339L;

  /**
   * logger for this class.
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(NumberPoolPersistenceImpl.class);


  // @wurblet classVariables ClassVariables

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:classVariables

  /** Variables common to all instances of NumberPoolPersistenceImpl. */
  @SuppressWarnings("unchecked")
  public static final PersistentObjectClassVariables<NumberPool, NumberPoolPersistenceImpl> CLASSVARIABLES =
            new PersistentObjectClassVariables<>(
                    NumberPool.class,
                    NumberPoolPersistenceImpl.class,
                    "npool",
                    null,
                    null);

  @Override
  public PersistentObjectClassVariables<NumberPool, NumberPoolPersistenceImpl> getClassVariables() {
    return CLASSVARIABLES;
  }

  // </editor-fold>//GEN-END:classVariables

  // @wurblet fieldnames ColumnNames

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:fieldnames


  /** database column name for 'name'. */
  public static final String CN_NAME = "name";

  /** database column name for 'realm'. */
  public static final String CN_REALM = "realm";

  /** database column name for 'description'. */
  public static final String CN_DESCRIPTION = "description";

  /** database column name for 'online'. */
  public static final String CN_ONLINE = "poolonline";

  /** database column name for 'lowWaterMark'. */
  public static final String CN_LOWWATERMARK = "lowmark";

  /** database column name for 'requestSize'. */
  public static final String CN_REQUESTSIZE = "reqsize";

  /** database column name for 'uplink'. */
  public static final String CN_UPLINK = "uplink";

  // </editor-fold>//GEN-END:fieldnames

  // @wurblet declare Declare

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:declare


  /** the number pool name. */
  @Persistent("the number pool name")
  private String name;
  /** true if name has been modified. */
  private boolean nameModified;
  /** the last persisted value of name. */
  private String namePersisted;

  /** pool realm, optional. */
  @Persistent("pool realm, optional")
  private String realm;
  /** true if realm has been modified. */
  private boolean realmModified;
  /** the last persisted value of realm. */
  private String realmPersisted;

  /** short description. */
  @Persistent("short description")
  private String description;
  /** true if description has been modified. */
  private boolean descriptionModified;
  /** the last persisted value of description. */
  private String descriptionPersisted;

  /** true if online, else offline. */
  @Persistent("true if online, else offline")
  private boolean online;
  /** true if online has been modified. */
  private boolean onlineModified;
  /** the last persisted value of online. */
  private boolean onlinePersisted;

  /** minimum number count before request to fill up from uplink, 0 if disable. */
  @Persistent("minimum number count before request to fill up from uplink, 0 if disable")
  private long lowWaterMark;
  /** true if lowWaterMark has been modified. */
  private boolean lowWaterMarkModified;
  /** the last persisted value of lowWaterMark. */
  private long lowWaterMarkPersisted;

  /** number count to request from uplink, 0 if disable. */
  @Persistent("number count to request from uplink, 0 if disable")
  private long requestSize;
  /** true if requestSize has been modified. */
  private boolean requestSizeModified;
  /** the last persisted value of requestSize. */
  private long requestSizePersisted;

  /** uplink configuration (optional). */
  @Persistent("uplink configuration (optional)")
  private String uplink;
  /** true if uplink has been modified. */
  private boolean uplinkModified;
  /** the last persisted value of uplink. */
  private String uplinkPersisted;

  // </editor-fold>//GEN-END:declare


  /**
   * Creates a number space.
   *
   * @param pdo the number space PDO
   * @param context the domain context
   */
  public NumberPoolPersistenceImpl (NumberPool pdo, DomainContext context)    {
    super(pdo, context);
  }

  /**
   * Creates a number space with a session only.
   *
   * @param pdo the number space PDO
   * @param session the session
   */
  public NumberPoolPersistenceImpl(NumberPool pdo, Session session) {
    super(pdo, session);
  }

  /**
   * Creates a number space without domain context or session.
   *
   * @param pdo the number space PDO
   */
  public NumberPoolPersistenceImpl(NumberPool pdo) {
    super(pdo);
  }

  /**
   * Creates a number space without domain context or session.
   */
  public NumberPoolPersistenceImpl() {
    super();
  }

  @Override
  public boolean isUpdatingSerialEvenIfNotModified() {
    // don't update the pool if only ranges changed (even though it's a root entity)
    return false;
  }

  // @wurblet methods MethodsImpl

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:methods


  @Override
  public NumberPoolRemoteDelegate getRemoteDelegate() {
    return (NumberPoolRemoteDelegate) super.getRemoteDelegate();
  }

  /**
   * Object is a root entity.
   * @return true
   */
  @Override
  public boolean isRootEntity() {
    return true;
  }

  /**
   * Overridden cause of "--tracked".
   * @return true = setters check for modification
   */
  @Override
  public boolean isTracked() {
    return true;    // invoking isModified() is ok
  }

  /**
   * Overridden cause of "--attracked".
   */
  @Override
  public void setModified(boolean modified) {
    super.setModified(modified);
    if (!modified) {
      nameModified = false;
      namePersisted = name;
      realmModified = false;
      realmPersisted = realm;
      descriptionModified = false;
      descriptionPersisted = description;
      onlineModified = false;
      onlinePersisted = online;
      lowWaterMarkModified = false;
      lowWaterMarkPersisted = lowWaterMark;
      requestSizeModified = false;
      requestSizePersisted = requestSize;
      uplinkModified = false;
      uplinkPersisted = uplink;
    }
  }

  @Override
  public void getFields(ResultSetWrapper rs) {
    super.getFields(rs);
    if (rs.configureSection(CLASSVARIABLES)) {
      rs.configureColumn(CN_NAME);
      rs.configureColumn(CN_REALM);
      rs.configureColumn(CN_DESCRIPTION);
      rs.configureColumn(CN_ONLINE);
      rs.configureColumn(CN_LOWWATERMARK);
      rs.configureColumn(CN_REQUESTSIZE);
      rs.configureColumn(CN_UPLINK);
      rs.configureColumn(CN_ID);
      rs.configureColumn(CN_SERIAL);
    }
    if (rs.getRow() <= 0) {
      throw new PersistenceException(getSession(), "no valid row");
    }
    name = rs.getString();
    realm = rs.getString(true);
    description = rs.getString();
    online = rs.getBoolean();
    lowWaterMark = rs.getLong();
    requestSize = rs.getLong();
    uplink = rs.getString();
    setId(rs.getLong());
    setSerial(rs.getLong());
  }

  @Override
  public int setFields(PreparedStatementWrapper st) {
    int ndx = super.setFields(st);
    st.setString(++ndx, name);
    st.setString(++ndx, realm, true);
    st.setString(++ndx, description);
    st.setBoolean(++ndx, online);
    st.setLong(++ndx, lowWaterMark);
    st.setLong(++ndx, requestSize);
    st.setString(++ndx, uplink);
    st.setLong(++ndx, getId());
    st.setLong(++ndx, getSerial());
    return ndx;
  }

  @Override
  public String createInsertSql() {
    return Backend.SQL_INSERT_INTO + getTableName() + Backend.SQL_LEFT_PARENTHESIS +
           CN_NAME + Backend.SQL_COMMA +
           CN_REALM + Backend.SQL_COMMA +
           CN_DESCRIPTION + Backend.SQL_COMMA +
           CN_ONLINE + Backend.SQL_COMMA +
           CN_LOWWATERMARK + Backend.SQL_COMMA +
           CN_REQUESTSIZE + Backend.SQL_COMMA +
           CN_UPLINK + Backend.SQL_COMMA +
           CN_ID + Backend.SQL_COMMA +
           CN_SERIAL +
           Backend.SQL_INSERT_VALUES +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR_COMMA +
           Backend.SQL_PAR + Backend.SQL_RIGHT_PARENTHESIS;
  }

  @Override
  public String createUpdateSql() {
    return Backend.SQL_UPDATE + getTableName() + Backend.SQL_SET +
           CN_NAME + Backend.SQL_EQUAL_PAR_COMMA +
           CN_REALM + Backend.SQL_EQUAL_PAR_COMMA +
           CN_DESCRIPTION + Backend.SQL_EQUAL_PAR_COMMA +
           CN_ONLINE + Backend.SQL_EQUAL_PAR_COMMA +
           CN_LOWWATERMARK + Backend.SQL_EQUAL_PAR_COMMA +
           CN_REQUESTSIZE + Backend.SQL_EQUAL_PAR_COMMA +
           CN_UPLINK + Backend.SQL_EQUAL_PAR_COMMA +
           CN_SERIAL + Backend.SQL_EQUAL + CN_SERIAL + Backend.SQL_PLUS_ONE +
           Backend.SQL_WHERE + CN_ID + Backend.SQL_EQUAL_PAR +
           Backend.SQL_AND + CN_SERIAL + Backend.SQL_EQUAL_PAR;
  }

  /**
   * Gets the attribute name.
   *
   * @return the number pool name
   */
  @Override
  public String getName()    {
    return name;
  }

  /**
   * Sets the attribute name.
   *
   * @param name the number pool name
   */
  @Override
  public void setName(String name) {
    assertMutable();
    if (!Objects.equals(this.name, name)) {
      setModified(true);
      nameModified = true;
      firePropertyChange(AN_NAME, this.name, name);
    }
    this.name = name;
  }

  /**
   * Gets the modification state of name.
   *
   * @return true if name has been modified
   */
  @Override
  public boolean isNameModified() {
    return nameModified;
  }

  /**
   * Gets the last persisted value of name.
   *
   * @return the last persisted value
   */
  @Override
  public String getNamePersisted() {
    return namePersisted;
  }

  /**
   * Gets the attribute realm.
   *
   * @return pool realm, optional
   */
  @Override
  public String getRealm()    {
    return realm;
  }

  /**
   * Sets the attribute realm.
   *
   * @param realm pool realm, optional
   */
  @Override
  public void setRealm(String realm) {
    assertMutable();
    if (!Objects.equals(this.realm, realm)) {
      setModified(true);
      realmModified = true;
      firePropertyChange(AN_REALM, this.realm, realm);
    }
    this.realm = realm;
  }

  /**
   * Gets the modification state of realm.
   *
   * @return true if realm has been modified
   */
  @Override
  public boolean isRealmModified() {
    return realmModified;
  }

  /**
   * Gets the last persisted value of realm.
   *
   * @return the last persisted value
   */
  @Override
  public String getRealmPersisted() {
    return realmPersisted;
  }

  /**
   * Gets the attribute description.
   *
   * @return short description
   */
  @Override
  public String getDescription()    {
    return description;
  }

  /**
   * Sets the attribute description.
   *
   * @param description short description
   */
  @Override
  public void setDescription(String description) {
    assertMutable();
    if (!Objects.equals(this.description, description)) {
      setModified(true);
      descriptionModified = true;
      firePropertyChange(AN_DESCRIPTION, this.description, description);
    }
    this.description = description;
  }

  /**
   * Gets the modification state of description.
   *
   * @return true if description has been modified
   */
  @Override
  public boolean isDescriptionModified() {
    return descriptionModified;
  }

  /**
   * Gets the last persisted value of description.
   *
   * @return the last persisted value
   */
  @Override
  public String getDescriptionPersisted() {
    return descriptionPersisted;
  }

  /**
   * Gets the attribute online.
   *
   * @return true if online, else offline
   */
  @Override
  public boolean isOnline()    {
    return online;
  }

  /**
   * Sets the attribute online.
   *
   * @param online true if online, else offline
   */
  @Override
  public void setOnline(boolean online) {
    assertMutable();
    if (this.online != online) {
      setModified(true);
      onlineModified = true;
      firePropertyChange(AN_ONLINE, this.online, online);
    }
    this.online = online;
  }

  /**
   * Gets the modification state of online.
   *
   * @return true if online has been modified
   */
  @Override
  public boolean isOnlineModified() {
    return onlineModified;
  }

  /**
   * Gets the last persisted value of online.
   *
   * @return the last persisted value
   */
  @Override
  public boolean isOnlinePersisted() {
    return onlinePersisted;
  }

  /**
   * Gets the attribute lowWaterMark.
   *
   * @return minimum number count before request to fill up from uplink, 0 if disable
   */
  @Override
  public long getLowWaterMark()    {
    return lowWaterMark;
  }

  /**
   * Sets the attribute lowWaterMark.
   *
   * @param lowWaterMark minimum number count before request to fill up from uplink, 0 if disable
   */
  @Override
  public void setLowWaterMark(long lowWaterMark) {
    assertMutable();
    if (this.lowWaterMark != lowWaterMark) {
      setModified(true);
      lowWaterMarkModified = true;
      firePropertyChange(AN_LOWWATERMARK, this.lowWaterMark, lowWaterMark);
    }
    this.lowWaterMark = lowWaterMark;
  }

  /**
   * Gets the modification state of lowWaterMark.
   *
   * @return true if lowWaterMark has been modified
   */
  @Override
  public boolean isLowWaterMarkModified() {
    return lowWaterMarkModified;
  }

  /**
   * Gets the last persisted value of lowWaterMark.
   *
   * @return the last persisted value
   */
  @Override
  public long getLowWaterMarkPersisted() {
    return lowWaterMarkPersisted;
  }

  /**
   * Gets the attribute requestSize.
   *
   * @return number count to request from uplink, 0 if disable
   */
  @Override
  public long getRequestSize()    {
    return requestSize;
  }

  /**
   * Sets the attribute requestSize.
   *
   * @param requestSize number count to request from uplink, 0 if disable
   */
  @Override
  public void setRequestSize(long requestSize) {
    assertMutable();
    if (this.requestSize != requestSize) {
      setModified(true);
      requestSizeModified = true;
      firePropertyChange(AN_REQUESTSIZE, this.requestSize, requestSize);
    }
    this.requestSize = requestSize;
  }

  /**
   * Gets the modification state of requestSize.
   *
   * @return true if requestSize has been modified
   */
  @Override
  public boolean isRequestSizeModified() {
    return requestSizeModified;
  }

  /**
   * Gets the last persisted value of requestSize.
   *
   * @return the last persisted value
   */
  @Override
  public long getRequestSizePersisted() {
    return requestSizePersisted;
  }

  /**
   * Gets the attribute uplink.
   *
   * @return uplink configuration (optional)
   */
  @Override
  public String getUplink()    {
    return uplink;
  }

  /**
   * Sets the attribute uplink.
   *
   * @param uplink uplink configuration (optional)
   */
  @Override
  public void setUplink(String uplink) {
    assertMutable();
    if (!Objects.equals(this.uplink, uplink)) {
      setModified(true);
      uplinkModified = true;
      firePropertyChange(AN_UPLINK, this.uplink, uplink);
    }
    this.uplink = uplink;
  }

  /**
   * Gets the modification state of uplink.
   *
   * @return true if uplink has been modified
   */
  @Override
  public boolean isUplinkModified() {
    return uplinkModified;
  }

  /**
   * Gets the last persisted value of uplink.
   *
   * @return the last persisted value
   */
  @Override
  public String getUplinkPersisted() {
    return uplinkPersisted;
  }

  /**
   * Updates the attributes in snapshot object.<br>
   * The snapshot object is assumed to be a clone of this object.
   *
   * @param snapshot the snapshot
   */
  protected void createAttributesInSnapshot(NumberPoolPersistenceImpl snapshot) {
    super.createAttributesInSnapshot(snapshot);
  }

  /**
   * Copies all attributes from a snapshot back to this object.
   *
   * @param snapshot the snapshot object
   */
  protected void revertAttributesToSnapshot(NumberPoolPersistenceImpl snapshot) {
    super.revertAttributesToSnapshot(snapshot);
    // the number pool name
    name = snapshot.name;
    nameModified = snapshot.nameModified;
    namePersisted = snapshot.namePersisted;
    // pool realm, optional
    realm = snapshot.realm;
    realmModified = snapshot.realmModified;
    realmPersisted = snapshot.realmPersisted;
    // short description
    description = snapshot.description;
    descriptionModified = snapshot.descriptionModified;
    descriptionPersisted = snapshot.descriptionPersisted;
    // true if online, else offline
    online = snapshot.online;
    onlineModified = snapshot.onlineModified;
    onlinePersisted = snapshot.onlinePersisted;
    // minimum number count before request to fill up from uplink, 0 if disable
    lowWaterMark = snapshot.lowWaterMark;
    lowWaterMarkModified = snapshot.lowWaterMarkModified;
    lowWaterMarkPersisted = snapshot.lowWaterMarkPersisted;
    // number count to request from uplink, 0 if disable
    requestSize = snapshot.requestSize;
    requestSizeModified = snapshot.requestSizeModified;
    requestSizePersisted = snapshot.requestSizePersisted;
    // uplink configuration (optional)
    uplink = snapshot.uplink;
    uplinkModified = snapshot.uplinkModified;
    uplinkPersisted = snapshot.uplinkPersisted;
  }

  // selects by unique domain key
  // @wurblet selectByUniqueDomainKey PdoSelectUnique name

  // </editor-fold>//GEN-END:methods

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:selectByUniqueDomainKey


  private static final StatementId SELECT_BY_UNIQUE_DOMAIN_KEY_STMT = new StatementId();

  @Override
  public NumberPool selectByUniqueDomainKey(String name) {
    if (getSession().isRemote())  {
      // invoke remote method
      try {
        NumberPool obj = getRemoteDelegate().selectByUniqueDomainKey(getDomainContext(), name);
        configureRemoteObject(getDomainContext(), obj);
        return obj;
      }
      catch (RemoteException e) {
        throw PersistenceException.createFromRemoteException(this, e);
      }
    }
    // else: local mode
    PreparedStatementWrapper st = getPreparedStatement(SELECT_BY_UNIQUE_DOMAIN_KEY_STMT,
      () -> {
        StringBuilder sql = createSelectAllInnerSql();
        sql.append(Backend.SQL_AND);
        sql.append(getColumnName(CN_NAME));
        sql.append(Backend.SQL_EQUAL_PAR);
        getBackend().buildSelectSql(sql, false, 0, 0);
        return sql.toString();
      }
    );
    int ndx = 1;
    st.setString(ndx++, name);
    return executeFirstPdoQuery(st);
  }

  // </editor-fold>//GEN-END:selectByUniqueDomainKey

  // @wurblet relations PdoRelations

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:relations

  /**
   * # Relations for NumberPool:
   *
   * NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange)
   */

  // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange)
  @Persistent("numberRange")
  private TrackedList<NumberRange> numberRangeList;
  private boolean numberRangeListLoaded;
  private transient TrackedList<NumberRange> numberRangeListSnapshot;

  /**
   * Gets numberRangeList via NumberRange#numberPoolId.
   *
   * @return numberRangeList numberRange
   */
  @Override
  public TrackedList<NumberRange> getNumberRangeList()  {
    if (!numberRangeListLoaded) {
      numberRangeList = isNew() ? new TrackedArrayList<>(false) : on(NumberRange.class).selectByNumberPoolId(getId());
      for (NumberRange obj: numberRangeList)  {
        obj.setNumberPool(pdo());
      }
      if (isImmutable()) {
        numberRangeList.setImmutable(true);
      }
      numberRangeListLoaded = true;
    }
    return numberRangeList;
  }

  /**
   * Gets numberRangeList without performing a select if not loaded.
   *
   * @return numberRangeList numberRange
   */
  public TrackedList<NumberRange> getNumberRangeListBlunt() {
    if (!numberRangeListLoaded) {
      numberRangeList = new TrackedArrayList<>(false);
      numberRangeListLoaded = true;
    }
    return numberRangeList;
  }

  /**
   * Sets the session in this and all related objects.
   *
   * @param session the session
   */
  @Override
  public void setSession(Session session)  {
    super.setSession(session);
    session.applyTo(numberRangeList);
  }

  /**
   * Sets the context in this and all related objects.
   *
   * @param context the domain context
   */
  @Override
  public void setDomainContext(DomainContext context)  {
    super.setDomainContext(context);
    context.applyTo(numberRangeList);
  }

  /**
   * Deletes all referencing composite relations from storage.
   */
  @Override
  public void deleteReferencingRelations() {
    super.deleteReferencingRelations();
    deleteReferencingRelations(true);
  }


  /**
   * Deletes referencing composite relations.
   * This method is invoked from deleteReferencingRelations() or saveReferencingRelations().
   * When invoked from saveReferencingRelations() lazy relations not
   * already loaded will be considered to be unchanged, i.e.
   * need no update or insert.
   *
   * @param delete is true if invoked from deleteReferencingRelations()
   */
  private void deleteReferencingRelations(boolean delete)  {
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    if (delete) {
      delete(getNumberRangeList());
    }
    if (numberRangeList != null && numberRangeList.isSomeRemoved()) {
      delete(numberRangeList.getRemovedObjects());
    }
  }

  /**
   * Saves composite relations referencing NumberPool.
   */
  @Override
  public void saveReferencingRelations(boolean update)  {
    super.saveReferencingRelations(update);
    if (update) {
      deleteReferencingRelations(false);
    }
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    if (numberRangeList != null) {
      getDomainContext().applyTo(numberRangeList);
      for (NumberRange obj: numberRangeList)  {
        obj.setNumberPool(pdo());
      }
      save(numberRangeList, true);
    }
  }

  /**
   * Validates the object.
   *
   * @param validationPath the validation path
   * @param scope the validation scope
   * @return the list of validation results, never null
   */
  @Override
  public List<ValidationResult> validate(String validationPath, ValidationScope scope) {
    List<ValidationResult> results = super.validate(validationPath, scope);
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    if (numberRangeList != null) {
      results.addAll(ValidationUtilities.getInstance().validateCollection(
                numberRangeList, validationPath + ".numberRangeList", scope));
    }
    return results;
  }

  /**
   * Sets the mutable flag for this object and all its components.
   *
   * @param immutable true if object is immutable
   */
  @Override
  public void setImmutable(boolean immutable) {
    super.setImmutable(immutable);
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    if (numberRangeList != null) {
      numberRangeList.setImmutable(immutable);
    }
  }

  /**
   * Checks composite relations for modification recursively.
   *
   * @return true if this or any composition is modified
   */
  @Override
  public boolean isModified()  {
    return super.isModified()
           // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
           || isModified(numberRangeList)
           ;
  }

  /**
   * This is a composite object.
   */
  @Override
  public boolean isComposite()  {
    return true;
  }


  /**
   * Loads components.<br>
   *
   * @param onlyLoaded true if return only already loaded components
   * @return the map of all components, including this object.
   */
  @Override
  public IdentifiableMap<? extends PersistentDomainObject<?>> loadComponents(boolean onlyLoaded) {
    IdentifiableMap<PersistentDomainObject<?>> components = new IdentifiableMap<>();
    addComponents(components, onlyLoaded);
    return components;
  }

  @Override
  public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, boolean onlyLoaded)  {
    int count = 0;
    count += super.addComponents(components, onlyLoaded);
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    if (!onlyLoaded || numberRangeListLoaded) {
      count += addComponents(components, getNumberRangeList(), onlyLoaded);
    }
    return count;
  }

  /**
   * Inserts this object and all components.
   */
  @Override
  public void insertPlainWithComponents()  {
    insertPlain();
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    insertPlainWithComponents(getNumberRangeList());
  }

  /**
   * Deletes this object and all components.
   */
  @Override
  public void deletePlainWithComponents()  {
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    deletePlainWithComponents(getNumberRangeList());
    deletePlain();
  }

  /**
   * Marks this object and all its components to be deleted.
   */
  @Override
  public void markDeleted() {
    super.markDeleted();
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    markDeleted(numberRangeList);
  }

  /**
   * Updates the components in snapshot object.<br>
   * The snapshot object is assumed to be a clone of this object.
   *
   * @param snapshot the snapshot
   */
  @SuppressWarnings("unchecked")
  protected void createComponentsInSnapshot(NumberPoolPersistenceImpl snapshot) {
    super.createComponentsInSnapshot(snapshot);
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    if (numberRangeList != null) {
      snapshot.numberRangeListSnapshot = numberRangeList.createSnapshot();
    }
  }

  /**
   * Reverts all components of this object to a given snapshot.
   *
   * @param snapshot the snapshot object
   */
  @SuppressWarnings("unchecked")
  protected void revertComponentsToSnapshot(NumberPoolPersistenceImpl snapshot) {
    super.revertComponentsToSnapshot(snapshot);
    // NumberPool: composite list of NumberRange numberRangeList via NumberRange#numberPoolId (numberRange). numberRange
    numberRangeList = snapshot.numberRangeList;
    if (numberRangeList != null) {
      numberRangeList.clear();
      numberRangeList.addAll(snapshot.numberRangeListSnapshot);
    }
    numberRangeListLoaded = snapshot.numberRangeListLoaded;
  }

  // </editor-fold>//GEN-END:relations

  // @wurblet selectByNameRealm PdoSelectUnique name realm

  // <editor-fold defaultstate="collapsed" desc=" Code generated by wurblet. Do not edit! ">//GEN-BEGIN:selectByNameRealm


  private static final StatementId SELECT_BY_NAME_REALM_STMT = new StatementId();

  @Override
  public NumberPool selectByNameRealm(String name, String realm) {
    if (getSession().isRemote())  {
      // invoke remote method
      try {
        NumberPool obj = getRemoteDelegate().selectByNameRealm(getDomainContext(), name, realm);
        configureRemoteObject(getDomainContext(), obj);
        return obj;
      }
      catch (RemoteException e) {
        throw PersistenceException.createFromRemoteException(this, e);
      }
    }
    // else: local mode
    PreparedStatementWrapper st = getPreparedStatement(SELECT_BY_NAME_REALM_STMT,
      () -> {
        StringBuilder sql = createSelectAllInnerSql();
        sql.append(Backend.SQL_AND);
        sql.append(getColumnName(CN_NAME));
        sql.append(Backend.SQL_EQUAL_PAR);
        sql.append(Backend.SQL_AND);
        sql.append(getColumnName(CN_REALM));
        sql.append(Backend.SQL_EQUAL_PAR);
        getBackend().buildSelectSql(sql, false, 0, 0);
        return sql.toString();
      }
    );
    int ndx = 1;
    st.setString(ndx++, name);
    st.setString(ndx++, realm, true);
    return executeFirstPdoQuery(st);
  }

  // </editor-fold>//GEN-END:selectByNameRealm

  @Override
  public void reloadRanges() {
    numberRangeListLoaded = false;
    numberRangeList = null;
  }

}

