/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.io.IOException;
import java.net.Socket;
import java.util.Objects;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.tentackle.io.SocketConfigurator;
import org.tentackle.io.SocketConfiguratorHolder;

public class SslClientSocketFactory
extends SslRMIClientSocketFactory
implements SocketConfiguratorHolder {
    private static final long serialVersionUID = 2357672465175511279L;
    private volatile SocketConfigurator socketConfigurator;

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = super.createSocket(host, port);
        if (this.socketConfigurator != null) {
            this.socketConfigurator.configure(socket);
        }
        return socket;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + this.getClass().hashCode();
        hash = 11 * hash + Objects.hashCode(this.socketConfigurator);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SslClientSocketFactory other = (SslClientSocketFactory)obj;
        return SocketConfigurator.equals((SocketConfigurator)this.socketConfigurator, (SocketConfigurator)other.socketConfigurator);
    }

    public SocketConfigurator getSocketConfigurator() {
        return this.socketConfigurator;
    }

    public void setSocketConfigurator(SocketConfigurator socketConfigurator) {
        this.socketConfigurator = socketConfigurator;
    }
}

