/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.util.StringTokenizer;

public enum SocketFactoryType {
    SYSTEM,
    DEFAULT,
    PLAIN,
    SSL,
    COMPRESSED,
    SSL_COMPRESSED;


    public static SocketFactoryType parse(String config) {
        SocketFactoryType type = SYSTEM;
        if (config != null) {
            StringTokenizer stok = new StringTokenizer(config, ", \t");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                switch (token.toLowerCase()) {
                    case "default": {
                        type = DEFAULT;
                        break;
                    }
                    case "system": {
                        type = SYSTEM;
                        break;
                    }
                    case "plain": {
                        type = PLAIN;
                        break;
                    }
                    case "ssl": {
                        type = type == COMPRESSED ? SSL_COMPRESSED : SSL;
                        break;
                    }
                    case "compressed": {
                        type = type == SSL ? SSL_COMPRESSED : COMPRESSED;
                    }
                }
            }
        }
        return type;
    }
}

