/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.tentackle.common.Service;
import org.tentackle.persist.rmi.ClientSocketFactory;
import org.tentackle.persist.rmi.CompressedClientSocketFactory;
import org.tentackle.persist.rmi.CompressedServerSocketFactory;
import org.tentackle.persist.rmi.CompressedSslClientSocketFactory;
import org.tentackle.persist.rmi.CompressedSslServerSocketFactory;
import org.tentackle.persist.rmi.ServerSocketFactory;
import org.tentackle.persist.rmi.SocketFactoryFactory$Singleton;
import org.tentackle.persist.rmi.SocketFactoryType;
import org.tentackle.persist.rmi.SslClientSocketFactory;
import org.tentackle.persist.rmi.SslServerSocketFactory;

@Service(value=SocketFactoryFactory.class)
public class SocketFactoryFactory {
    public static String[] enabledCipherSuites;
    public static String[] enabledProtocols;
    public static boolean needClientAuth;

    public static SocketFactoryFactory getInstance() {
        return SocketFactoryFactory$Singleton.INSTANCE;
    }

    public RMIClientSocketFactory createClientSocketFactory(RMIClientSocketFactory defaultFactory, SocketFactoryType factoryType) {
        RMIClientSocketFactory factory = null;
        switch (factoryType) {
            case DEFAULT: {
                factory = defaultFactory;
                break;
            }
            case PLAIN: {
                factory = new ClientSocketFactory();
                break;
            }
            case SSL: {
                factory = new SslClientSocketFactory();
                break;
            }
            case COMPRESSED: {
                factory = new CompressedClientSocketFactory();
                break;
            }
            case SSL_COMPRESSED: {
                factory = new CompressedSslClientSocketFactory();
            }
        }
        return factory;
    }

    public RMIServerSocketFactory createServerSocketFactory(RMIServerSocketFactory defaultFactory, SocketFactoryType factoryType) {
        RMIServerSocketFactory factory = null;
        switch (factoryType) {
            case DEFAULT: {
                factory = defaultFactory;
                break;
            }
            case PLAIN: {
                factory = new ServerSocketFactory();
                break;
            }
            case SSL: {
                factory = new SslServerSocketFactory(enabledCipherSuites, enabledProtocols, needClientAuth);
                break;
            }
            case COMPRESSED: {
                factory = new CompressedServerSocketFactory();
                break;
            }
            case SSL_COMPRESSED: {
                factory = new CompressedSslServerSocketFactory(enabledCipherSuites, enabledProtocols, needClientAuth);
            }
        }
        return factory;
    }
}

