/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;
import org.tentackle.common.LocaleProvider;
import org.tentackle.log.Loggable;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.MappedDiagnosticContext;
import org.tentackle.misc.Duration;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.Session;
import org.tentackle.persist.Db;
import org.tentackle.persist.rmi.InvocationLocals;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.persist.rmi.RemoteDelegateImpl;
import org.tentackle.persist.rmi.RemoteSessionClosedException;
import org.tentackle.reflect.ReflectionHelper;

public class RemoteDelegateInvocationHandler
implements InvocationHandler {
    public static final String MDC_SESSION_KEY = "session";
    public static boolean collectStatistics;
    public boolean logInvocations;
    public boolean logInvocationDetails;
    public static long logMinDurationMillis;
    public static int logMinReturnedCollectionSize;
    public static Pattern mdcFilter;
    private static final String RMI_THREAD_NAME = "RMI TCP Connection";
    private static final Logger LOGGER;
    protected RemoteDelegateImpl<?> delegate;

    public RemoteDelegateInvocationHandler(RemoteDelegateImpl<?> delegate) {
        this.delegate = delegate;
    }

    protected void updateMDC() {
        MappedDiagnosticContext mdc = LOGGER.getMappedDiagnosticContext();
        RemoteDbSessionImpl session = this.delegate.getServerSession();
        mdc.put(MDC_SESSION_KEY, session.getSessionNumber() + ":" + session.getClientSessionInfo().getUserName());
    }

    protected void clearMDC() {
        MappedDiagnosticContext mdc = LOGGER.getMappedDiagnosticContext();
        mdc.remove(MDC_SESSION_KEY);
    }

    protected boolean isMDCValid() {
        if (mdcFilter == null) {
            return true;
        }
        MappedDiagnosticContext mdc = LOGGER.getMappedDiagnosticContext();
        return mdc != null && mdc.matchesPattern(mdcFilter);
    }

    protected void updateThreadLocal() {
        this.delegate.getSession().makeCurrent();
        LocaleProvider.getInstance().setCurrentLocale(this.delegate.getSession().getSessionInfo().getLocale());
    }

    protected void lockDbForThread() {
        this.delegate.getSession().setOwnerThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteException handleInvocationException(Object proxy, Method method, Object[] args, Throwable cause) {
        boolean crashed;
        Logger.Level loggingLevel;
        block10: {
            boolean crashed2;
            String message;
            RemoteException remoteException;
            Throwable nextCause;
            while (cause instanceof InvocationTargetException && (nextCause = cause.getCause()) != null) {
                cause = nextCause;
            }
            loggingLevel = Logger.Level.SEVERE;
            try {
                if (!(cause instanceof RemoteException)) break block10;
                Throwable realCause = cause.getCause();
                loggingLevel = realCause instanceof Loggable ? ((Loggable)realCause).getLogLevel() : Logger.Level.INFO;
                remoteException = (RemoteException)cause;
                message = "delegate method " + method + " failed";
                Db db = this.delegate.getSession();
                boolean bl = crashed2 = db != null && db.isCrashed();
            }
            catch (Throwable throwable) {
                boolean crashed3;
                String message2 = "delegate method " + method + " failed";
                Db db = this.delegate.getSession();
                boolean bl = crashed3 = db != null && db.isCrashed();
                if (crashed3) {
                    loggingLevel = Logger.Level.WARNING;
                    message2 = message2 + " due to session cleanup";
                }
                if (loggingLevel != null) {
                    LOGGER.log(loggingLevel, message2, cause);
                }
                this.cleanupDbAfterException();
                throw throwable;
            }
            if (crashed2) {
                loggingLevel = Logger.Level.WARNING;
                message = message + " due to session cleanup";
            }
            if (loggingLevel != null) {
                LOGGER.log(loggingLevel, message, cause);
            }
            this.cleanupDbAfterException();
            return remoteException;
        }
        RemoteException remoteException = new RemoteException("remote method execution failed", cause);
        String message = "delegate method " + method + " failed";
        Db db = this.delegate.getSession();
        boolean bl = crashed = db != null && db.isCrashed();
        if (crashed) {
            loggingLevel = Logger.Level.WARNING;
            message = message + " due to session cleanup";
        }
        if (loggingLevel != null) {
            LOGGER.log(loggingLevel, message, cause);
        }
        this.cleanupDbAfterException();
        return remoteException;
    }

    protected void cleanupDbAfterException() {
        Db db = this.delegate.getSession();
        if (db != null && !db.isCrashed()) {
            try {
                db.rollbackImmediately();
            }
            catch (RuntimeException ex) {
                LOGGER.severe("*** immediate rollback failed ***", (Throwable)ex);
            }
        }
    }

    protected Object invokeImpl(Object proxy, Method method, Object[] args) throws RemoteException {
        try {
            return method.invoke(this.delegate, args);
        }
        catch (Exception cause) {
            throw this.handleInvocationException(proxy, method, args, cause);
        }
    }

    protected boolean needDuration() {
        return this.logInvocations || collectStatistics || logMinDurationMillis > 0L || logMinReturnedCollectionSize > 0;
    }

    protected void log(Method method, Object[] args, Object retval, Duration duration) {
        boolean durationExceeded = false;
        if (duration != null) {
            if (!duration.isValid()) {
                duration.end();
            }
            if (logMinDurationMillis > 0L && duration.millis() > (double)logMinDurationMillis) {
                durationExceeded = true;
            }
            if (collectStatistics && this.isMDCValid()) {
                this.delegate.getServerSession().countMethodInvocation(method, this.delegate.getServicedClass(), duration);
            }
        }
        if (this.isMDCValid()) {
            boolean collectionSizeExceeded;
            int collectionSize = retval instanceof Collection ? ((Collection)retval).size() : 0;
            boolean bl = collectionSizeExceeded = logMinReturnedCollectionSize > 0 && collectionSize > logMinReturnedCollectionSize;
            if (this.logInvocations || durationExceeded || collectionSizeExceeded) {
                StringBuilder buf = new StringBuilder();
                if (this.logInvocationDetails) {
                    buf.append(ReflectionHelper.getClassBaseName(this.delegate.getServicedClass())).append(": ").append(ReflectionHelper.getClassBaseName(this.delegate.getClass())).append('.').append(method.getName()).append('(');
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            if (i > 0) {
                                buf.append(',');
                            }
                            buf.append(StringHelper.objectToLoggableString((Object)args[i]));
                        }
                    }
                    buf.append(") = ").append(StringHelper.objectToLoggableString((Object)retval)).append(" {").append(duration != null ? duration.millisToString() : "<unknown>").append("ms");
                    if (collectionSize > 0) {
                        buf.append(", ").append(collectionSize).append(" items");
                    }
                    buf.append('}');
                } else {
                    buf.append(this.delegate.getClass().getName()).append('.').append(method.getName()).append(" [").append(duration != null ? duration.millisToString() : "<unknown>").append("ms]");
                }
                if (durationExceeded || collectionSizeExceeded) {
                    if (durationExceeded) {
                        buf.insert(0, ">>> duration >>> ");
                    }
                    if (collectionSizeExceeded) {
                        buf.insert(0, ">>> size >>> ");
                    }
                    LOGGER.warning(buf.toString(), new Object[0]);
                } else {
                    LOGGER.info(buf.toString(), new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RemoteDbSessionImpl serverSession;
        RemoteDbSessionImpl remoteDbSessionImpl = serverSession = this.delegate.getServerSession();
        synchronized (remoteDbSessionImpl) {
            Object object;
            block11: {
                InvocationLocals locals;
                if (!serverSession.isOpen()) {
                    throw new RemoteSessionClosedException(serverSession + " already closed since " + new Date(serverSession.getClosedSince()));
                }
                InvocationLocals invocationLocals = locals = Thread.currentThread().getName().startsWith(RMI_THREAD_NAME) ? new InvocationLocals(this.delegate, LOGGER.getMappedDiagnosticContext(), MDC_SESSION_KEY) : null;
                if (locals != null) {
                    this.delegate.getSession().setAlive(true);
                    try {
                        this.updateThreadLocal();
                        this.updateMDC();
                        this.lockDbForThread();
                    }
                    catch (Throwable t) {
                        LOGGER.severe("cleanup server session locals after exception", t);
                        this.delegate.getSession().setOwnerThread(null);
                        Session.setCurrentSession(null);
                        LocaleProvider.getInstance().setCurrentLocale(null);
                        this.clearMDC();
                        throw t;
                    }
                }
                try {
                    Duration duration = this.needDuration() ? new Duration() : null;
                    Object retval = this.invokeImpl(proxy, method, args);
                    this.log(method, args, retval, duration);
                    object = retval;
                    if (locals == null) break block11;
                    locals.restore();
                }
                catch (Throwable throwable) {
                    if (locals != null) {
                        locals.restore();
                    }
                    throw throwable;
                }
            }
            return object;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(RemoteDelegateInvocationHandler.class);
    }
}

