/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.io.Serializable;
import java.net.BindException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.io.ServerSocketConfigurator;
import org.tentackle.io.ServerSocketConfiguratorHolder;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.pdo.VersionInfoIncompatibleException;
import org.tentackle.persist.rmi.DbServer;
import org.tentackle.persist.rmi.Exportable;
import org.tentackle.persist.rmi.RemoteDbConnection;
import org.tentackle.persist.rmi.RemoteDbSession;
import org.tentackle.persist.rmi.RemoteServerObject;

public abstract class RemoteDbConnectionImpl
extends RemoteServerObject
implements RemoteDbConnection {
    private static final long serialVersionUID = -1008588987968414154L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDbConnectionImpl.class);
    private final DbServer server;

    public RemoteDbConnectionImpl(DbServer server, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.server = server;
    }

    public DbServer getServer() {
        return this.server;
    }

    public int getSessionTimeout(Session session, SessionInfo clientInfo, SessionInfo serverInfo) {
        return this.getServer().getSessionTimeout();
    }

    public int getPort(Session session, SessionInfo clientInfo, SessionInfo serverInfo) {
        return this.getRMIPort();
    }

    public RMIClientSocketFactory getClientSocketFactory(Session session, SessionInfo clientInfo, SessionInfo serverInfo) {
        return this.getRMICsf();
    }

    public RMIServerSocketFactory getServerSocketFactory(Session session, SessionInfo clientInfo, SessionInfo serverInfo) {
        return this.getRMISsf();
    }

    public void checkClientVersionInfo(Serializable clientVersionInfo) throws VersionInfoIncompatibleException {
    }

    public abstract RemoteDbSession createSession(SessionInfo var1) throws RemoteException;

    public int exportRemoteObject(Remote remoteObject, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        ServerSocketConfiguratorHolder sscd;
        ServerSocketConfigurator ssc;
        if (remoteObject instanceof UnicastRemoteObject) {
            throw new RemoteException("delegate " + remoteObject.getClass().getName() + " must not extend UnicastRemoteObject!");
        }
        int portRange = 0;
        if (ssf instanceof ServerSocketConfiguratorHolder && (ssc = (sscd = (ServerSocketConfiguratorHolder)ssf).getSocketConfigurator()) != null) {
            portRange = ssc.getPortRange();
            if (ssc.getPort() > 0) {
                port = ssc.getPort();
            }
        }
        if (portRange < 1 || port == 0) {
            portRange = 1;
        }
        RemoteException lastEx = null;
        int effectivePort = -1;
        int maxPort = port + portRange;
        for (int p = port; p < maxPort; ++p) {
            try {
                UnicastRemoteObject.exportObject(remoteObject, p, csf, ssf);
                effectivePort = p;
                break;
            }
            catch (RemoteException ex) {
                if (ExceptionHelper.extractException(BindException.class, (boolean)true, (Throwable)ex) == null) {
                    throw ex;
                }
                lastEx = ex;
                continue;
            }
        }
        if (effectivePort == -1) {
            throw lastEx;
        }
        LOGGER.fine("{0} exported on port {1}", new Object[]{remoteObject, effectivePort});
        return effectivePort;
    }

    public void unexportRemoteObject(Remote remoteObject) throws RemoteException {
        UnicastRemoteObject.unexportObject(remoteObject, true);
        LOGGER.fine("{0} unexported", new Object[]{remoteObject});
    }

    protected void finalize() throws Throwable {
        try {
            LOGGER.warning("Connection object " + this.getClass().getName() + " finalized unexpectedly:\n" + this, new Object[0]);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Serializable getServerVersionInfo() throws RemoteException {
        return null;
    }

    @Override
    public RemoteDbSession login(SessionInfo clientInfo) throws RemoteException {
        this.checkClientVersionInfo(clientInfo.getClientVersionInfo());
        RemoteDbSession session = this.createSession(clientInfo);
        if (session instanceof Exportable) {
            ((Exportable)((Object)session)).exportMe();
        }
        return session;
    }

    @Override
    public void logout(RemoteDbSession session) throws RemoteException {
        session.close();
    }
}

