/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.util.Locale;
import org.tentackle.common.LocaleProvider;
import org.tentackle.log.MappedDiagnosticContext;
import org.tentackle.pdo.Session;
import org.tentackle.persist.rmi.RemoteDelegateImpl;

public class InvocationLocals {
    private final RemoteDelegateImpl<?> delegate;
    private final MappedDiagnosticContext mdc;
    private final String mdcKey;
    private final Thread ownerThread;
    private final Session currentSession;
    private final Locale currentLocale;
    private final String mdcValue;

    public InvocationLocals(RemoteDelegateImpl<?> delegate, MappedDiagnosticContext mdc, String mdcKey) {
        this.delegate = delegate;
        this.mdc = mdc;
        this.mdcKey = mdcKey;
        this.ownerThread = delegate.getSession().getOwnerThread();
        this.currentSession = Session.getCurrentSession();
        this.currentLocale = LocaleProvider.getInstance().getCurrentLocale();
        this.mdcValue = mdc.get(mdcKey);
    }

    public void restore() {
        Session.setCurrentSession((Session)this.currentSession);
        this.delegate.getSession().setOwnerThread(this.ownerThread);
        LocaleProvider.getInstance().setCurrentLocale(this.currentLocale);
        if (this.mdcValue != null) {
            this.mdc.put(this.mdcKey, this.mdcValue);
        } else {
            this.mdc.remove(this.mdcKey);
        }
    }
}

