/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.io.OutputStream;
import java.rmi.RemoteException;
import org.tentackle.io.NotifyingByteArrayOutputStream;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.persist.rmi.InputStreamRemoteDelegate;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.persist.rmi.RemoteDelegateImpl;

public class InputStreamRemoteDelegateImpl
extends RemoteDelegateImpl<OutputStream>
implements InputStreamRemoteDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamRemoteDelegateImpl.class);
    private final NotifyingByteArrayOutputStream out = new NotifyingByteArrayOutputStream();

    public InputStreamRemoteDelegateImpl(RemoteDbSessionImpl serverSession, Class<OutputStream> servicedClass) throws RemoteException {
        super(serverSession, servicedClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read() throws RemoteException {
        while (true) {
            NotifyingByteArrayOutputStream notifyingByteArrayOutputStream = this.out;
            synchronized (notifyingByteArrayOutputStream) {
                if (this.out.size() == 0) {
                    try {
                        this.out.wait();
                    }
                    catch (InterruptedException iex) {
                        LOGGER.warning("interrupted -> ignored", new Object[0]);
                    }
                } else {
                    byte[] buf = this.out.toByteArray();
                    this.out.reset();
                    return buf;
                }
            }
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }
}

