/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist.rmi;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import org.tentackle.persist.CommitTxRunnable;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbTransaction;
import org.tentackle.persist.DbTransactionHandle;
import org.tentackle.persist.ModificationLog;
import org.tentackle.persist.PersistenceVisitor;
import org.tentackle.persist.RollbackTxRunnable;
import org.tentackle.persist.rmi.DbRemoteDelegate;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.persist.rmi.RemoteDelegateImpl;

public class DbRemoteDelegateImpl
extends RemoteDelegateImpl<Db>
implements DbRemoteDelegate {
    private Method beginMethod;

    public DbRemoteDelegateImpl(RemoteDbSessionImpl session, Class<Db> dbClass) throws RemoteException {
        super(session, dbClass);
        try {
            this.beginMethod = dbClass.getDeclaredMethod("begin", String.class, Boolean.TYPE);
            this.beginMethod.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new RemoteException(dbClass.getName() + " provides no begin(String,boolean)", ex);
        }
    }

    @Override
    public int getSessionId() throws RemoteException {
        try {
            return this.getSession().getSessionId();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public void setSessionGroupId(int number) throws RemoteException {
        try {
            this.getSession().setSessionGroupId(number);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public int getSessionGroupId() throws RemoteException {
        try {
            return this.getSession().getSessionGroupId();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public int groupWith(int number) throws RemoteException {
        try {
            return this.getSession().groupWith(number);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public boolean isAlive() throws RemoteException {
        try {
            return this.getSession().isAlive();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public void setAlive(boolean alive) throws RemoteException {
        try {
            this.getSession().setAlive(alive);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public boolean commit(long txVoucher) throws RemoteException {
        try {
            return this.getSession().commit(txVoucher);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public boolean rollback(long txVoucher) throws RemoteException {
        try {
            return this.getSession().rollback(txVoucher);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public DbTransaction begin(String txName) throws RemoteException {
        try {
            DbTransaction transaction = (DbTransaction)this.beginMethod.invoke((Object)this.getSession(), txName, true);
            return transaction;
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public void setReadOnly(boolean flag) throws RemoteException {
        try {
            this.getSession().setReadOnly(flag);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public void setCountModificationAllowed(boolean flag) throws RemoteException {
        try {
            this.getSession().setCountModificationAllowed(flag);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public void setLogModificationAllowed(boolean flag) throws RemoteException {
        try {
            this.getSession().setLogModificationAllowed(flag);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public void setLogModificationTxEnabled(boolean flag) throws RemoteException {
        try {
            this.getSession().setLogModificationTxEnabled(flag);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public void setLogModificationTxId(long txId) throws RemoteException {
        try {
            this.getSession().setLogModificationTxId(txId);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public long getLogModificationTxId() throws RemoteException {
        try {
            return this.getSession().getLogModificationTxId();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public boolean setLogModificationDeferred(boolean flag) throws RemoteException {
        try {
            this.getSession().setLogModificationDeferred(flag);
            return this.getSession().isLogModificationDeferred();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public List<ModificationLog> popModificationLogsOfTransaction() throws RemoteException {
        try {
            return this.getSession().popModificationLogsOfTransaction();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public DbTransactionHandle registerPersistenceVisitor(PersistenceVisitor visitor) throws RemoteException {
        try {
            return this.getSession().registerPersistenceVisitor(visitor);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public PersistenceVisitor unregisterPersistenceVisitor(DbTransactionHandle handle) throws RemoteException {
        try {
            return this.getSession().unregisterPersistenceVisitor(handle);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public Collection<PersistenceVisitor> getPersistenceVisitors() throws RemoteException {
        try {
            return this.getSession().getPersistenceVisitors();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public DbTransactionHandle registerCommitTxRunnable(CommitTxRunnable runnable) throws RemoteException {
        try {
            return this.getSession().registerCommitTxRunnable(runnable);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public CommitTxRunnable unregisterCommitTxRunnable(DbTransactionHandle handle) throws RemoteException {
        try {
            return this.getSession().unregisterCommitTxRunnable(handle);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public Collection<CommitTxRunnable> getCommitTxRunnables() throws RemoteException {
        try {
            return this.getSession().getCommitTxRunnables();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public DbTransactionHandle registerRollbackTxRunnable(RollbackTxRunnable runnable) throws RemoteException {
        try {
            return this.getSession().registerRollbackTxRunnable(runnable);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public RollbackTxRunnable unregisterRollbackTxRunnable(DbTransactionHandle handle) throws RemoteException {
        try {
            return this.getSession().unregisterRollbackTxRunnable(handle);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    @Override
    public Collection<RollbackTxRunnable> getRollbackTxRunnables() throws RemoteException {
        try {
            return this.getSession().getRollbackTxRunnables();
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }
}

