/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.ResultSetWrapper;

public class ResultSetSkipBlock {
    private final ResultSetWrapper rs;
    private final int skippedColumns;
    private final Map<String, Integer> columnMap;
    private int maxColumnIndex;

    public ResultSetSkipBlock(ResultSetWrapper rs, int skippedColumns) {
        this.rs = rs;
        this.skippedColumns = skippedColumns;
        this.maxColumnIndex = skippedColumns;
        this.columnMap = new HashMap<String, Integer>();
        int max = rs.getColumnCount();
        ResultSetMetaData meta = rs.getMetaData();
        for (int i = skippedColumns + 1; i <= max; ++i) {
            try {
                this.columnMap.putIfAbsent(meta.getColumnName(i).toLowerCase(), i);
                continue;
            }
            catch (SQLException e) {
                throw new PersistenceException((Session)rs.getSession(), (Throwable)e);
            }
        }
    }

    public int getSkippedColumns() {
        return this.skippedColumns;
    }

    public int getMaxColumnIndex() {
        return this.maxColumnIndex;
    }

    public int findColumn(String name) {
        Integer ndx = this.columnMap.get(name);
        if (ndx == null) {
            throw new PersistenceException((Session)this.rs.getSession(), "no such column '" + name + "' beyond " + this.skippedColumns + " skipped columns in " + this.rs);
        }
        this.applyColumnIndex(ndx);
        return ndx;
    }

    public void applyColumnIndex(int ndx) {
        if (ndx > this.maxColumnIndex) {
            this.maxColumnIndex = ndx;
        }
    }
}

