/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.rmi.RemoteException;
import org.tentackle.log.Logger;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.RemoteSession;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.persist.rmi.RemoteDbSession;

public class RemoteSessionAdapter
implements RemoteSession {
    private final RemoteDbSession rs;

    public RemoteSessionAdapter(RemoteDbSession rs) {
        this.rs = rs;
    }

    public RemoteDbSession getRemoteDbSession() {
        return this.rs;
    }

    public SessionInfo getClientSessionInfo() {
        try {
            return this.rs.getClientSessionInfo();
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public String getServerName() {
        try {
            return this.rs.getServerName();
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public void log(Logger.Level level, String message) {
        try {
            this.rs.log(level, message);
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }

    public void logStatistics(Logger.Level level, boolean clear) {
        try {
            this.rs.logStatistics(level, clear);
        }
        catch (RemoteException rex) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)rex);
        }
    }
}

