/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.AbstractIdSource;
import org.tentackle.persist.Db;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.StatementKey;

public class ObjectSequenceId
extends AbstractIdSource {
    private static final long serialVersionUID = -2463189262257268747L;
    public static final int GLOBAL_MULTIPLIER = 1;
    public static final int SEQUENCE_MULTIPLIER = 100;
    private static final StatementId SELECT_ID = new StatementId();
    private static long sequenceNo;
    private final int sequenceMultiplier;
    private final int globalMultiplier;
    private int idCount;

    public ObjectSequenceId(String name, int sequenceMultiplier, int globalMultiplier) {
        super(name);
        this.sequenceMultiplier = sequenceMultiplier;
        this.globalMultiplier = globalMultiplier;
        this.idCount = sequenceMultiplier;
    }

    public ObjectSequenceId(String name) {
        this(name, 100, 1);
    }

    @Override
    public boolean isLockFree() {
        return true;
    }

    @Override
    public synchronized long nextId(Db db) {
        block17: {
            this.assertDbNotRemote(db);
            if (this.idCount >= this.sequenceMultiplier) {
                try {
                    PreparedStatementWrapper selectStatement = db.getPreparedStatement(new StatementKey(SELECT_ID, this.getClass()), false, () -> db.getBackend().sqlNextFromSequene(this.getName()));
                    try (ResultSetWrapper rs = selectStatement.executeQuery();){
                        if (rs.next()) {
                            sequenceNo = rs.getLong(1);
                            this.idCount = 0;
                            break block17;
                        }
                        throw new PersistenceException((Session)db, "cannot retrieve ID from sequence");
                    }
                }
                catch (RuntimeException e) {
                    if (e instanceof PersistenceException) {
                        throw (PersistenceException)((Object)e);
                    }
                    throw new PersistenceException((Session)db, (Throwable)e);
                }
            }
        }
        long nextId = (sequenceNo * (long)this.sequenceMultiplier + (long)this.idCount++) * (long)this.globalMultiplier;
        nextId = this.addGlobalOffset(nextId);
        return nextId;
    }

    protected long addGlobalOffset(long nextId) {
        return nextId;
    }
}

