/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.Canonicalizer;
import org.tentackle.misc.DateHelper;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.ParameterString;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Persistent;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.Session;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbObjectClassVariables;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.rmi.ModificationLogRemoteDelegate;
import org.tentackle.sql.BackendPreparedStatement;

public class ModificationLog
extends AbstractDbObject<ModificationLog> {
    private static final long serialVersionUID = 7997968053729155282L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ModificationLog.class);
    public static final String TABLENAME = "modlog";
    private static final DbObjectClassVariables<ModificationLog> CLASSVARIABLES = new DbObjectClassVariables<ModificationLog>(ModificationLog.class, 2, "modlog");
    public static final char BEGIN = 'B';
    public static final char COMMIT = 'C';
    public static final char INSERT = 'I';
    public static final char UPDATE = 'U';
    public static final char DELETE = 'D';
    public static final String CN_OBJECTID = "objectid";
    public static final String CN_OBJECTCLASSID = "classid";
    public static final String CN_TXID = "txid";
    public static final String CN_TXNAME = "txname";
    public static final String CN_MODTYPE = "modtype";
    public static final String CN_WHEN = "modtime";
    public static final String CN_USER = "moduser";
    public static final String CN_MESSAGE = "message";
    public static final String CN_PROCESSED = "processed";
    public static final int CL_TXNAME = 64;
    public static final int CL_USER = 32;
    protected AbstractDbObject<?> lazyObject;
    protected ParameterString messageParameters;
    private long objectId;
    private int objectClassId;
    private long txId;
    private String txName;
    private char modType;
    private org.tentackle.common.Timestamp when;
    private transient org.tentackle.common.Timestamp whenSnapshot;
    private String user;
    private String message;
    private org.tentackle.common.Timestamp processed;
    private transient org.tentackle.common.Timestamp processedSnapshot;
    private static final StatementId SELECT_FIRST_UNPROCESSED_STMT = new StatementId();
    private static final StatementId RESULT_SET_UNPROCESSED_STMT = new StatementId();
    private static final StatementId SELECT_FIRST_UNPROCESSED_GREATER_STMT = new StatementId();
    private static final StatementId RESULT_SET_SINCE_STMT = new StatementId();
    private static final StatementId SELECT_GREATER_ID_STMT = new StatementId();
    private static final StatementId RESULT_SET_GREATER_ID_STMT = new StatementId();
    private static final StatementId SELECT_LAST_PROCESSED_STMT = new StatementId();
    private static final StatementId SELECT_BY_OBJECT_STMT = new StatementId();
    private static final StatementId SELECT_BY_USER_AND_TYPE_STMT = new StatementId();
    private static final StatementId IS_REFERENCING_USER_STMT = new StatementId();
    private static final StatementId IS_REFERENCING_OBJECT_STMT = new StatementId();
    private static final StatementId UPDATE_BY_OBJECT_TYPE_SERIAL_STMT = new StatementId();
    private static final StatementId DELETE_BY_OBJECT_TYPE_SERIAL_STMT = new StatementId();
    private static final StatementId SELECT_BY_TX_ID_STMT = new StatementId();
    private static final StatementId UPDATE_UNPROCESSED_BY_TX_ID_STMT = new StatementId();
    private static final StatementId DELETE_BY_TX_ID_STMT = new StatementId();
    private static final StatementId DELETE_PROCESSED_STMT = new StatementId();
    private static final StatementId SELECT_UP_TO_STMT = new StatementId();
    private static final StatementId UPDATE_PROCESSES_STMTID = new StatementId();
    private static final StatementId UPDATE_DIAGNOSTICS_STMTID = new StatementId();

    public ModificationLog(Db db) {
        super(db);
    }

    public ModificationLog(Db db, char modType) {
        this(db);
        this.modType = modType;
        this.txName = db.getTxName();
        this.txId = db.getLogModificationTxId();
        this.when = DateHelper.now();
        this.user = db.getSessionInfo().getUserName();
    }

    public <P extends AbstractDbObject<P>> ModificationLog(AbstractDbObject<P> object, char modType) {
        this(object.getSession(), modType);
        if (modType == 'B' || modType == 'C') {
            throw new PersistenceException((Identifiable)this, "illegal BEGIN or COMMIT in object logging");
        }
        this.objectId = object.getId();
        this.setSerial(object.getSerial() - (long)(modType == 'U' ? 0 : 1));
        this.objectClassId = object.getClassId();
        if (modType == 'I' || modType == 'U') {
            this.lazyObject = object;
        }
    }

    public ModificationLog(ModificationLog template, char modType) {
        super(template.getSession());
        this.objectId = template.objectId;
        this.objectClassId = template.objectClassId;
        this.txId = template.txId;
        this.txName = template.txName;
        this.when = template.when;
        this.user = template.user;
        this.message = template.message;
        this.modType = modType;
    }

    public ModificationLog() {
    }

    @Override
    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_OBJECTID);
            rs.configureColumn(CN_OBJECTCLASSID);
            rs.configureColumn(CN_TXID);
            rs.configureColumn(CN_TXNAME);
            rs.configureColumn(CN_MODTYPE);
            rs.configureColumn(CN_WHEN);
            rs.configureColumn(CN_USER);
            rs.configureColumn(CN_MESSAGE);
            rs.configureColumn(CN_PROCESSED);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.objectId = rs.getLong();
        this.objectClassId = rs.getInt();
        this.txId = rs.getLong();
        this.txName = rs.getString();
        this.modType = rs.getChar();
        this.when = rs.getTimestamp();
        this.user = rs.getString();
        this.message = rs.getString();
        this.processed = rs.getTimestamp(true);
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    @Override
    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setLong(++ndx, this.objectId);
        st.setInt(++ndx, this.objectClassId);
        st.setLong(++ndx, this.txId);
        st.setString(++ndx, StringHelper.trim((String)this.txName, (int)64));
        st.setChar(++ndx, this.modType);
        st.setTimestamp(++ndx, (Timestamp)this.when);
        st.setString(++ndx, StringHelper.trim((String)this.user, (int)32));
        st.setString(++ndx, this.message);
        st.setTimestamp(++ndx, (Timestamp)this.processed, true);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    @Override
    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + CN_OBJECTID + "," + CN_OBJECTCLASSID + "," + CN_TXID + "," + CN_TXNAME + "," + CN_MODTYPE + "," + CN_WHEN + "," + CN_USER + "," + CN_MESSAGE + "," + CN_PROCESSED + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?," + "?," + "?," + "?," + "?," + "?," + "?," + "?," + "?" + ") ";
    }

    @Override
    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + CN_OBJECTID + "=?," + CN_OBJECTCLASSID + "=?," + CN_TXID + "=?," + CN_TXNAME + "=?," + CN_MODTYPE + "=?," + CN_WHEN + "=?," + CN_USER + "=?," + CN_MESSAGE + "=?," + CN_PROCESSED + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.assertMutable();
        this.objectId = objectId;
    }

    public int getObjectClassId() {
        return this.objectClassId;
    }

    public void setObjectClassId(int objectClassId) {
        this.assertMutable();
        this.objectClassId = objectClassId;
    }

    public long getTxId() {
        return this.txId;
    }

    public void setTxId(long txId) {
        this.assertMutable();
        this.txId = txId;
    }

    public String getTxName() {
        return this.txName;
    }

    public void setTxName(String txName) {
        this.assertMutable();
        this.txName = txName;
    }

    public char getModType() {
        return this.modType;
    }

    public void setModType(char modType) {
        this.assertMutable();
        this.modType = modType;
    }

    public org.tentackle.common.Timestamp getWhen() {
        return this.when;
    }

    public void setWhen(org.tentackle.common.Timestamp when) {
        this.assertMutable();
        this.when = when;
        if (when != null) {
            when.setUTC(false);
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.assertMutable();
        this.user = user;
    }

    public org.tentackle.common.Timestamp getProcessed() {
        return this.processed;
    }

    public void setProcessed(org.tentackle.common.Timestamp processed) {
        this.assertMutable();
        this.processed = processed;
        if (processed != null) {
            processed.setUTC(false);
        }
    }

    public void canonicalize(Canonicalizer<String> stringCanonicalizer, Canonicalizer<AbstractDbObject<?>> objectCanonicalizer) {
        if (stringCanonicalizer != null) {
            this.txName = (String)stringCanonicalizer.canonicalize((Object)this.txName);
            this.user = (String)stringCanonicalizer.canonicalize((Object)this.user);
            this.message = (String)stringCanonicalizer.canonicalize((Object)this.message);
            this.messageParameters = null;
        }
        if (objectCanonicalizer != null) {
            this.lazyObject = (AbstractDbObject)objectCanonicalizer.canonicalize(this.lazyObject);
        }
    }

    @Override
    public void setSession(Session session) {
        super.setSession(session);
        if (this.lazyObject != null) {
            this.lazyObject.setSession(session);
        }
    }

    public void clearLazyObject() {
        this.lazyObject = null;
    }

    @Override
    public ModificationLog readFromResultSetWrapper(ResultSetWrapper rs) {
        ModificationLog log = (ModificationLog)super.readFromResultSetWrapper(rs);
        if (log != null) {
            log.clearLazyObject();
            log.messageParameters = null;
        }
        return log;
    }

    public boolean isModifyingData() {
        return this.modType == 'D' || this.modType == 'I' || this.modType == 'U';
    }

    public boolean isLogOfTransaction() {
        return this.getSession().isTxRunning();
    }

    public boolean isDestinationReferringLog() {
        return this.modType == 'D';
    }

    @Override
    public void saveObject() {
        if (this.getSession().isRemote()) {
            AbstractDbObject<?> oldLazyObject = this.lazyObject;
            this.lazyObject = null;
            super.saveObject();
            this.lazyObject = oldLazyObject;
        } else if (this.isLogOfTransaction()) {
            if (this.getSession().isLogModificationDeferred()) {
                this.newId();
                this.setSerial(this.getSerial() + 1L);
            } else {
                super.saveObject();
            }
            this.getSession().pushModificationLogOfTransaction(this);
        } else {
            super.saveObject();
        }
    }

    public ParameterString getMessageParameters() throws ParseException {
        if (this.messageParameters == null) {
            this.messageParameters = new ParameterString(this.getMessage());
        }
        return this.messageParameters;
    }

    public void setMessageParameters(ParameterString messageParameters) {
        this.messageParameters = messageParameters;
        this.message = messageParameters == null ? null : messageParameters.toString();
    }

    public String getMessageParameter(String name) throws ParseException {
        return this.getMessageParameters().getParameter(name);
    }

    public void setMessageParameter(String name, String value) throws ParseException {
        this.getMessageParameters().setParameter(name, value);
        this.message = this.messageParameters.toString();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(this.getId()).append('/').append(this.modType).append(':');
        if (this.user == null) {
            buf.append("no-user");
        } else {
            buf.append(this.user);
        }
        if (this.txId != 0L) {
            buf.append(',').append(this.txId);
            if (this.txName != null) {
                buf.append('/').append(this.txName);
            }
        }
        buf.append(',');
        if (this.when == null) {
            buf.append("no-time");
        } else {
            buf.append(this.when);
        }
        buf.append(">");
        if (this.objectClassId != 0 && this.objectId != 0L) {
            buf.append(' ').append(PdoUtilities.getInstance().getPdoClassName(this.objectClassId)).append('[').append(this.objectId).append('/').append(this.getSerial()).append(']');
        }
        if (this.message != null) {
            buf.append(" \"").append(this.message).append("\"");
        }
        return buf.toString();
    }

    public AbstractDbObject<?> getDbObject(Db db) {
        if (this.lazyObject != null && this.lazyObject.getSession().equals(db)) {
            return this.lazyObject;
        }
        String className = PdoUtilities.getInstance().getPdoClassName(this.objectClassId);
        if (className == null) {
            throw new PersistenceException((Identifiable)this, "unknown class id " + this.objectClassId);
        }
        try {
            if (db.isRemote()) {
                LOGGER.warning("inefficient remote object load while processing " + this, new Object[0]);
            }
            this.lazyObject = null;
            Class<?> clazz = Class.forName(className);
            if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
                PersistentDomainObject lazyPdo = Pdo.create(clazz, (Session)db).select(this.objectId);
                if (lazyPdo != null) {
                    lazyPdo.setDomainContext(lazyPdo.createValidContext());
                    this.lazyObject = (AbstractDbObject)lazyPdo.getPersistenceDelegate();
                }
            } else {
                this.lazyObject = ((AbstractDbObject)AbstractDbObject.newInstance(db, clazz)).selectObject(this.objectId);
            }
            if (this.lazyObject != null) {
                this.lazyObject.loadLazyReferences();
            }
            return this.lazyObject;
        }
        catch (Exception ex) {
            throw new PersistenceException((Identifiable)this, "can't load object " + className + "[" + this.objectId + "]", (Throwable)ex);
        }
    }

    public AbstractDbObject<?> getDbObject() {
        return this.getDbObject(this.getSession());
    }

    public ModificationLog selectFirstUnprocessed() {
        if (this.getSession().isRemote()) {
            try {
                ModificationLog obj = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectFirstUnprocessed();
                this.getSession().applyTo(obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_FIRST_UNPROCESSED_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 1, 0);
            return sql.toString();
        });
        int ndx = this.getBackend().setLeadingSelectParameters((BackendPreparedStatement)st, 1, 0);
        st.setTimestamp(ndx++, null, true);
        this.getBackend().setTrailingSelectParameters((BackendPreparedStatement)st, ndx, 1, 0);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                ModificationLog modificationLog = this.readFromResultSetWrapper(rs);
                return modificationLog;
            }
            ModificationLog modificationLog = null;
            return modificationLog;
        }
    }

    public ResultSetWrapper resultSetUnprocessed() {
        PreparedStatementWrapper st = this.getPreparedStatement(RESULT_SET_UNPROCESSED_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, null, true);
        return st.executeQuery();
    }

    public ModificationLog selectFirstUnprocessedGreater(long id) {
        if (this.getSession().isRemote()) {
            try {
                ModificationLog obj = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectFirstUnprocessedGreater(id);
                this.getSession().applyTo(obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_FIRST_UNPROCESSED_GREATER_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append("id");
            sql.append(">?");
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 1, 0);
            return sql.toString();
        });
        int ndx = this.getBackend().setLeadingSelectParameters((BackendPreparedStatement)st, 1, 0);
        st.setLong(ndx++, id);
        st.setTimestamp(ndx++, null, true);
        this.getBackend().setTrailingSelectParameters((BackendPreparedStatement)st, ndx, 1, 0);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                ModificationLog modificationLog = this.readFromResultSetWrapper(rs);
                return modificationLog;
            }
            ModificationLog modificationLog = null;
            return modificationLog;
        }
    }

    public ResultSetWrapper resultSetSince(org.tentackle.common.Timestamp when) {
        PreparedStatementWrapper st = this.getPreparedStatement(RESULT_SET_SINCE_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_WHEN);
            sql.append(">=?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, (Timestamp)when);
        return st.executeQuery();
    }

    public ModificationLog selectGreaterId(long id) {
        if (this.getSession().isRemote()) {
            try {
                ModificationLog obj = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectGreaterId(id);
                this.getSession().applyTo(obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_GREATER_ID_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append("id");
            sql.append(">?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 1, 0);
            return sql.toString();
        });
        int ndx = this.getBackend().setLeadingSelectParameters((BackendPreparedStatement)st, 1, 0);
        st.setLong(ndx++, id);
        this.getBackend().setTrailingSelectParameters((BackendPreparedStatement)st, ndx, 1, 0);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                ModificationLog modificationLog = this.readFromResultSetWrapper(rs);
                return modificationLog;
            }
            ModificationLog modificationLog = null;
            return modificationLog;
        }
    }

    public ResultSetWrapper resultSetGreaterId(long id) {
        PreparedStatementWrapper st = this.getPreparedStatement(RESULT_SET_GREATER_ID_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append("id");
            sql.append(">?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, id);
        return st.executeQuery();
    }

    public ModificationLog selectLastProcessed() {
        if (this.getSession().isRemote()) {
            try {
                ModificationLog obj = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectLastProcessed();
                this.getSession().applyTo(obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_LAST_PROCESSED_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("<>?");
            sql.append(" ORDER BY ").append("id").append(" DESC");
            this.getBackend().buildSelectSql(sql, false, 1, 0);
            return sql.toString();
        });
        int ndx = this.getBackend().setLeadingSelectParameters((BackendPreparedStatement)st, 1, 0);
        st.setTimestamp(ndx++, null, true);
        this.getBackend().setTrailingSelectParameters((BackendPreparedStatement)st, ndx, 1, 0);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                ModificationLog modificationLog = this.readFromResultSetWrapper(rs);
                return modificationLog;
            }
            ModificationLog modificationLog = null;
            return modificationLog;
        }
    }

    public List<ModificationLog> selectByObject(int objectClassId, long objectId) {
        if (this.getSession().isRemote()) {
            try {
                List<ModificationLog> list = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectByObject(objectClassId, objectId);
                this.getSession().applyTo(list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_OBJECT_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTID);
            sql.append("=?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, null, true);
        st.setInt(ndx++, objectClassId);
        st.setLong(ndx++, objectId);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean derived;
            ArrayList<ModificationLog> list = new ArrayList<ModificationLog>();
            boolean bl = derived = this.getClass() != ModificationLog.class;
            while (rs.next()) {
                ModificationLog obj;
                ModificationLog modificationLog = obj = derived ? (ModificationLog)this.newInstance() : new ModificationLog(this.getSession());
                if ((obj = obj.readFromResultSetWrapper(rs)) == null) continue;
                list.add(obj);
            }
            ArrayList<ModificationLog> arrayList = list;
            return arrayList;
        }
    }

    public List<ModificationLog> selectByUserAndType(String user, char modType) {
        if (this.getSession().isRemote()) {
            try {
                List<ModificationLog> list = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectByUserAndType(user, modType);
                this.getSession().applyTo(list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_USER_AND_TYPE_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_USER);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_MODTYPE);
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, null, true);
        st.setString(ndx++, user);
        st.setChar(ndx++, modType);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean derived;
            ArrayList<ModificationLog> list = new ArrayList<ModificationLog>();
            boolean bl = derived = this.getClass() != ModificationLog.class;
            while (rs.next()) {
                ModificationLog obj;
                ModificationLog modificationLog = obj = derived ? (ModificationLog)this.newInstance() : new ModificationLog(this.getSession());
                if ((obj = obj.readFromResultSetWrapper(rs)) == null) continue;
                list.add(obj);
            }
            ArrayList<ModificationLog> arrayList = list;
            return arrayList;
        }
    }

    public boolean isReferencingUser(String user) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).isReferencingUser(user);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(IS_REFERENCING_USER_STMT, () -> {
            StringBuilder sql = this.createSelectIdInnerSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_USER);
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 1, 0);
            return sql.toString();
        });
        int ndx = this.getBackend().setLeadingSelectParameters((BackendPreparedStatement)st, 1, 0);
        st.setTimestamp(ndx++, null, true);
        st.setString(ndx++, user);
        this.getBackend().setTrailingSelectParameters((BackendPreparedStatement)st, ndx, 1, 0);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean bl = rs.next();
            return bl;
        }
    }

    public boolean isReferencingObject(int objectClassId, long objectId) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).isReferencingObject(objectClassId, objectId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(IS_REFERENCING_OBJECT_STMT, () -> {
            StringBuilder sql = this.createSelectIdInnerSql();
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTID);
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 1, 0);
            return sql.toString();
        });
        int ndx = this.getBackend().setLeadingSelectParameters((BackendPreparedStatement)st, 1, 0);
        st.setInt(ndx++, objectClassId);
        st.setLong(ndx++, objectId);
        this.getBackend().setTrailingSelectParameters((BackendPreparedStatement)st, ndx, 1, 0);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean bl = rs.next();
            return bl;
        }
    }

    public int updateByObjectTypeSerial(org.tentackle.common.Timestamp processed, int objectClassId, long objectId, char modType, long serial) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).updateByObjectTypeSerial(processed, objectClassId, objectId, modType, serial);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(UPDATE_BY_OBJECT_TYPE_SERIAL_STMT, () -> {
            StringBuilder sql = this.createSqlUpdate();
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" WHERE 1=1");
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_MODTYPE);
            sql.append("=?");
            sql.append(" AND ");
            sql.append("serial");
            sql.append("<=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, (Timestamp)processed, true);
        st.setTimestamp(ndx++, null, true);
        st.setInt(ndx++, objectClassId);
        st.setLong(ndx++, objectId);
        st.setChar(ndx++, modType);
        st.setLong(ndx++, serial);
        return st.executeUpdate();
    }

    public int deleteByObjectTypeSerial(int objectClassId, long objectId, char modType, long serial) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).deleteByObjectTypeSerial(objectClassId, objectId, modType, serial);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_BY_OBJECT_TYPE_SERIAL_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTCLASSID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_OBJECTID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_MODTYPE);
            sql.append("=?");
            sql.append(" AND ");
            sql.append("serial");
            sql.append("<=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, null, true);
        st.setInt(ndx++, objectClassId);
        st.setLong(ndx++, objectId);
        st.setChar(ndx++, modType);
        st.setLong(ndx++, serial);
        return st.executeUpdate();
    }

    public List<? extends ModificationLog> selectByTxId(long txId) {
        if (this.getSession().isRemote()) {
            try {
                List<? extends ModificationLog> list = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectByTxId(txId);
                this.getSession().applyTo(list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_TX_ID_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(CN_TXID);
            sql.append("=?");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, txId);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean derived;
            ArrayList<ModificationLog> list = new ArrayList<ModificationLog>();
            boolean bl = derived = this.getClass() != ModificationLog.class;
            while (rs.next()) {
                ModificationLog obj;
                ModificationLog modificationLog = obj = derived ? (ModificationLog)this.newInstance() : new ModificationLog(this.getSession());
                if ((obj = obj.readFromResultSetWrapper(rs)) == null) continue;
                list.add(obj);
            }
            ArrayList<ModificationLog> arrayList = list;
            return arrayList;
        }
    }

    public int updateUnprocessedByTxId(org.tentackle.common.Timestamp processed, long txId) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).updateUnprocessedByTxId(processed, txId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(UPDATE_UNPROCESSED_BY_TX_ID_STMT, () -> {
            StringBuilder sql = this.createSqlUpdate();
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" WHERE 1=1");
            sql.append(" AND ");
            sql.append(CN_TXID);
            sql.append("=?");
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, (Timestamp)processed, true);
        st.setLong(ndx++, txId);
        st.setTimestamp(ndx++, null, true);
        return st.executeUpdate();
    }

    public int deleteByTxId(long txId) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).deleteByTxId(txId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_BY_TX_ID_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_TXID);
            sql.append("=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setLong(ndx++, txId);
        return st.executeUpdate();
    }

    public int deleteProcessed(org.tentackle.common.Timestamp processed) {
        if (this.getSession().isRemote()) {
            try {
                return ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).deleteProcessed(processed);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(DELETE_PROCESSED_STMT, () -> {
            StringBuilder sql = this.createDeleteAllSql();
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("<>?");
            sql.append(" AND ");
            sql.append(CN_PROCESSED);
            sql.append("<=?");
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, null, true);
        st.setTimestamp(ndx++, (Timestamp)processed, true);
        return st.executeUpdate();
    }

    public List<ModificationLog> selectUpTo(org.tentackle.common.Timestamp processed) {
        if (this.getSession().isRemote()) {
            try {
                List<ModificationLog> list = ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).selectUpTo(processed);
                this.getSession().applyTo(list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_UP_TO_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ").append(" (");
            sql.append(CN_PROCESSED);
            sql.append("=?");
            sql.append(" OR ");
            sql.append(CN_PROCESSED);
            sql.append(">=?");
            sql.append(") ");
            sql.append(" ORDER BY ").append("id").append(" ASC");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setTimestamp(ndx++, null, true);
        st.setTimestamp(ndx++, (Timestamp)processed, true);
        try (ResultSetWrapper rs = st.executeQuery();){
            boolean derived;
            ArrayList<ModificationLog> list = new ArrayList<ModificationLog>();
            boolean bl = derived = this.getClass() != ModificationLog.class;
            while (rs.next()) {
                ModificationLog obj;
                ModificationLog modificationLog = obj = derived ? (ModificationLog)this.newInstance() : new ModificationLog(this.getSession());
                if ((obj = obj.readFromResultSetWrapper(rs)) == null) continue;
                list.add(obj);
            }
            ArrayList<ModificationLog> arrayList = list;
            return arrayList;
        }
    }

    public void updateProcessed(org.tentackle.common.Timestamp processed) {
        if (this.getSession().isRemote()) {
            try {
                ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).updateProcessed(processed, this);
                this.processed = processed;
                return;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(UPDATE_PROCESSES_STMTID, () -> "UPDATE " + this.getTableName() + " SET " + CN_PROCESSED + "=?" + " WHERE " + "id" + "=?");
        st.setTimestamp(1, (Timestamp)processed, true);
        st.setLong(2, this.getId());
        this.assertThisRowAffected(st.executeUpdate());
        this.processed = processed;
    }

    public void updateDiagnostics(org.tentackle.common.Timestamp processed, String comment) throws ParseException {
        String parStr;
        if (comment != null) {
            ParameterString ps = new ParameterString(this.message);
            ps.setParameter("comment", comment);
            parStr = ps.toString();
        } else {
            parStr = this.message;
        }
        if (this.getSession().isRemote()) {
            try {
                ((ModificationLogRemoteDelegate)this.getRemoteDelegate()).updateDiagnostics(processed, comment, this);
                this.processed = processed;
                this.message = parStr;
                return;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this.getSession(), (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(UPDATE_DIAGNOSTICS_STMTID, () -> "UPDATE " + this.getTableName() + " SET " + CN_PROCESSED + "=?," + CN_MESSAGE + "=?" + " WHERE " + "id" + "=?");
        int ndx = 1;
        st.setTimestamp(ndx++, (Timestamp)processed, true);
        st.setString(ndx++, parStr);
        st.setLong(ndx++, this.getId());
        this.assertThisRowAffected(st.executeUpdate());
        this.processed = processed;
        this.message = parStr;
    }

    @Override
    public DbObjectClassVariables<ModificationLog> getClassVariables() {
        return CLASSVARIABLES;
    }

    @Persistent(value="optional informational or error message")
    public String getMessage() {
        return this.message;
    }

    @Persistent(value="optional informational or error message")
    public void setMessage(String message) {
        this.assertMutable();
        this.message = message;
        this.messageParameters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(ModificationLog modlog, Db toDb) {
        LOGGER.fine("replaying modlog {0} to {1}", new Object[]{modlog, toDb});
        boolean retrieveFromDestination = modlog.isDestinationReferringLog();
        Db db = retrieveFromDestination ? toDb : modlog.getSession();
        AbstractDbObject<?> object = modlog.getDbObject(db);
        if (object == null) {
            this.handleMissingObject(modlog, toDb);
            return;
        }
        if (!retrieveFromDestination) {
            object.setSession(toDb);
        }
        try {
            this.replayInitModification(modlog, object);
            switch (modlog.getModType()) {
                case 'I': {
                    this.replayInsert(modlog, object);
                    break;
                }
                case 'U': {
                    this.replayUpdate(modlog, object);
                    break;
                }
                case 'D': {
                    this.replayDelete(modlog, object);
                    break;
                }
                default: {
                    throw new PersistenceException((Identifiable)modlog, "illegal modType " + modlog.getModType() + " for replay");
                }
            }
            this.replayFinishModification(modlog, object);
        }
        finally {
            if (!retrieveFromDestination) {
                object.setSession(modlog.getSession());
            }
        }
    }

    public void replayInitModification(ModificationLog modlog, AbstractDbObject<?> object) {
        try {
            object.initModification(modlog.getModType());
        }
        catch (RuntimeException re) {
            LOGGER.severe("replaying init-modification failed for " + modlog, (Throwable)re);
            throw re;
        }
    }

    public void replayFinishModification(ModificationLog modlog, AbstractDbObject<?> object) {
        try {
            object.finishModification(modlog.getModType());
        }
        catch (RuntimeException re) {
            LOGGER.severe("replaying finish modification failed for " + modlog, (Throwable)re);
            throw re;
        }
    }

    public void replayInsert(ModificationLog modlog, AbstractDbObject<?> object) {
        try {
            object.setModificationLog(modlog);
            long oldSerial = object.getSerial();
            object.setSerial(modlog.getSerial());
            object.insertPlain();
            object.setSerial(oldSerial);
        }
        catch (RuntimeException re) {
            LOGGER.severe("replaying update failed for " + modlog, (Throwable)re);
            throw re;
        }
    }

    public void replayUpdate(ModificationLog modlog, AbstractDbObject<?> object) {
        try {
            object.setModificationLog(modlog);
            if (object.getSerial() > modlog.getSerial()) {
                long oldSerial = object.getSerial();
                object.setSerial(modlog.getSerial() - 1L);
                object.updateSerial();
                object.setSerial(oldSerial);
            } else {
                if (object.getSerial() < modlog.getSerial()) {
                    throw new PersistenceException((Identifiable)modlog, "unexpected modlog serial " + modlog.getSerial() + " > object serial " + object.getSerial());
                }
                long oldSerial = object.getSerial();
                object.setSerial(object.getSerial() - 1L);
                object.updatePlain();
                object.setSerial(oldSerial);
            }
        }
        catch (RuntimeException re) {
            LOGGER.severe("replaying update failed for " + modlog, (Throwable)re);
            throw re;
        }
    }

    public void replayDelete(ModificationLog modlog, AbstractDbObject<?> object) {
        try {
            object.setModificationLog(modlog);
            long oldSerial = object.getSerial();
            object.setSerial(modlog.getSerial());
            object.deletePlain();
            object.setSerial(oldSerial);
        }
        catch (RuntimeException re) {
            LOGGER.severe("replaying delete failed for " + modlog, (Throwable)re);
            throw re;
        }
    }

    public ReplayState replay(ReplayState state, List<? extends ModificationLog> modList, boolean copyLog, Db toDb) {
        if (state.first) {
            state.oldLogModificationAllowed = toDb.isLogModificationAllowed();
            toDb.setLogModificationAllowed(false);
            state.txVoucher = toDb.begin("replay");
        }
        try {
            for (ModificationLog modificationLog : modList) {
                if (modificationLog.getModType() != 'B' && modificationLog.getModType() != 'C') {
                    this.replay(modificationLog, toDb);
                }
                if (!copyLog) continue;
                LOGGER.fine("copying modlog {0} to {1}", new Object[]{modificationLog, toDb});
                modificationLog.clearLazyObject();
                if (modificationLog.getModType() == 'B') {
                    state.pendingTxId = modificationLog.getId();
                }
                Db db = modificationLog.getSession();
                modificationLog.setSession(toDb);
                modificationLog.setId(0L);
                modificationLog.newId();
                if (state.pendingTxId != 0L) {
                    modificationLog.setTxId(state.pendingTxId);
                }
                modificationLog.insertPlain();
                if (modificationLog.getModType() == 'C') {
                    state.pendingTxId = 0L;
                }
                modificationLog.setSession(db);
            }
            if (state.last) {
                toDb.commit(state.txVoucher);
                toDb.setLogModificationAllowed(state.oldLogModificationAllowed);
            }
            state.modlogIDs = new long[modList.size()];
            int ndx = 0;
            for (ModificationLog modificationLog : modList) {
                state.modlogIDs[ndx++] = modificationLog.getId();
            }
            return state;
        }
        catch (RuntimeException e) {
            toDb.rollback(state.txVoucher);
            toDb.setLogModificationAllowed(state.oldLogModificationAllowed);
            if (e instanceof PersistenceException) {
                throw (PersistenceException)((Object)e);
            }
            throw new PersistenceException("replay modList failed", (Throwable)e);
        }
    }

    protected void handleMissingObject(ModificationLog modlog, Db toDb) {
        throw new PersistenceException((Session)(modlog.getModType() == 'D' ? modlog.getSession() : toDb), "object " + PdoUtilities.getInstance().getPdoClassName(modlog.getObjectClassId()) + "[" + modlog.getObjectId() + "] does not exist");
    }

    public static class ReplayState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean oldLogModificationAllowed;
        public long txVoucher;
        public long pendingTxId;
        public long[] modlogIDs;
        public boolean first;
        public boolean last;
    }
}

