/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.StringTokenizer;
import org.tentackle.common.Service;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.persist.Db;
import org.tentackle.persist.IdSource;
import org.tentackle.persist.IdSourceConfigurator;
import org.tentackle.persist.ObjectId;
import org.tentackle.persist.ObjectSequenceId;
import org.tentackle.sql.Backend;

@Service(value=IdSourceConfigurator.class)
public class DefaultIdSourceConfigurator
implements IdSourceConfigurator {
    public static final String TABLE_BASED = "table";
    public static final String SEQUENCE_BASED = "sequence";

    @Override
    public IdSource configure(Db db, String idConfig) {
        if (idConfig == null) {
            Backend backend = db.getBackend();
            idConfig = backend.supportsSequences() ? "sequence:object_sequence_id" : "table:object_id";
        }
        String type = null;
        String name = null;
        Integer sequenceMultiplier = null;
        Integer globalMultiplier = null;
        StringTokenizer stok = new StringTokenizer(idConfig, ":");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (type == null) {
                type = token;
                continue;
            }
            if (name == null) {
                name = token;
                continue;
            }
            if (sequenceMultiplier == null) {
                sequenceMultiplier = Integer.parseInt(token);
                continue;
            }
            if (globalMultiplier == null) {
                globalMultiplier = Integer.parseInt(token);
                continue;
            }
            throw new PersistenceException("malformed idSource configuration: " + idConfig);
        }
        switch (type) {
            case "sequence": {
                if (sequenceMultiplier == null && globalMultiplier == null) {
                    return new ObjectSequenceId(name);
                }
                if (sequenceMultiplier != null && globalMultiplier != null) {
                    return new ObjectSequenceId(name, sequenceMultiplier, globalMultiplier);
                }
                throw new PersistenceException("sequenceMultiplier and globalMultiplier must be defined both or not at all");
            }
            case "table": {
                return new ObjectId(name);
            }
        }
        throw new PersistenceException("unsupported idSource type: " + type);
    }
}

