/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.CommitTxRunnable;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbTransactionHandle;
import org.tentackle.persist.PersistenceVisitor;
import org.tentackle.persist.RollbackTxRunnable;

public class DbTransaction
implements Serializable {
    private static final AtomicLong TX_COUNT = new AtomicLong();
    private static final String DEFAULT_TXNAME = "<unnamed>";
    private static final long serialVersionUID = -3091432011090916426L;
    private transient Db db;
    private final long creationTime;
    private final long txNumber;
    private final String txName;
    private final long txVoucher;
    private int handleCount;
    private int txLevel;
    private int updateCount;
    private AbstractDbObject<?> txObject;
    private Map<DbTransactionHandle, PersistenceVisitor> visitors;
    private Map<DbTransactionHandle, CommitTxRunnable> commitTxRunnables;
    private Map<DbTransactionHandle, RollbackTxRunnable> rollbackTxRunnables;

    public DbTransaction(Db db, String txName, boolean fromRemote) {
        long magic;
        this.db = db;
        this.txName = txName == null ? DEFAULT_TXNAME : txName;
        this.txNumber = TX_COUNT.incrementAndGet();
        this.txLevel = 1;
        this.creationTime = System.currentTimeMillis();
        while ((magic = UUID.randomUUID().getLeastSignificantBits()) == 0L) {
        }
        this.txVoucher = fromRemote && magic > 0L || !fromRemote && magic < 0L ? -magic : magic;
    }

    public void setSession(Db db) {
        this.db = db;
    }

    public Db getSession() {
        return this.db;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void addToUpdateCount(int count) {
        this.updateCount += count;
    }

    public String getTxName() {
        return this.txName;
    }

    public long getTxNumber() {
        return this.txNumber;
    }

    public int getTxLevel() {
        return this.txLevel;
    }

    public void invalidateTxLevel() {
        this.txLevel = Integer.MIN_VALUE;
    }

    public boolean isTxLevelValid() {
        return this.txLevel != Integer.MIN_VALUE;
    }

    public int incrementTxLevel() {
        if (this.isTxLevelValid()) {
            ++this.txLevel;
        }
        return this.txLevel;
    }

    public int decrementTxLevel() {
        if (this.isTxLevelValid()) {
            --this.txLevel;
            if (this.txLevel < 1) {
                throw new PersistenceException((Session)this.db, "unbalanced tx level");
            }
        }
        return this.txLevel;
    }

    public long getTxVoucher() {
        return this.txVoucher;
    }

    public void setTxObject(AbstractDbObject<?> txObject) {
        this.txObject = txObject;
    }

    public AbstractDbObject<?> getTxObject() {
        return this.txObject;
    }

    public String toString() {
        return "transaction-" + this.txNumber + (this.isTxLevelValid() ? "." + this.txLevel : "") + "(" + this.txName + ") on " + this.db;
    }

    public DbTransactionHandle registerPersistenceVisitor(PersistenceVisitor visitor) {
        if (this.visitors == null) {
            this.visitors = new HashMap<DbTransactionHandle, PersistenceVisitor>();
        }
        DbTransactionHandle handle = new DbTransactionHandle(this.txNumber, ++this.handleCount);
        this.visitors.put(handle, visitor);
        return handle;
    }

    public PersistenceVisitor unregisterPersistenceVisitor(DbTransactionHandle handle) {
        return this.visitors == null ? null : this.visitors.remove(handle);
    }

    public Collection<PersistenceVisitor> getPersistenceVisitors() {
        return this.visitors.values();
    }

    public DbTransactionHandle registerCommitTxRunnable(CommitTxRunnable commitRunnable) {
        if (this.commitTxRunnables == null) {
            this.commitTxRunnables = new HashMap<DbTransactionHandle, CommitTxRunnable>();
        }
        DbTransactionHandle handle = new DbTransactionHandle(this.txNumber, ++this.handleCount);
        this.commitTxRunnables.put(handle, commitRunnable);
        return handle;
    }

    public CommitTxRunnable unregisterCommitTxRunnable(DbTransactionHandle handle) {
        return this.commitTxRunnables == null ? null : this.commitTxRunnables.remove(handle);
    }

    public Collection<CommitTxRunnable> getCommitTxRunnables() {
        return this.commitTxRunnables.values();
    }

    public DbTransactionHandle registerRollbackTxRunnable(RollbackTxRunnable rollbackRunnable) {
        if (this.rollbackTxRunnables == null) {
            this.rollbackTxRunnables = new HashMap<DbTransactionHandle, RollbackTxRunnable>();
        }
        DbTransactionHandle handle = new DbTransactionHandle(this.txNumber, ++this.handleCount);
        this.rollbackTxRunnables.put(handle, rollbackRunnable);
        return handle;
    }

    public RollbackTxRunnable unregisterRollbackTxRunnable(DbTransactionHandle handle) {
        return this.rollbackTxRunnables == null ? null : this.rollbackTxRunnables.remove(handle);
    }

    public Collection<RollbackTxRunnable> getRollbackTxRunnables() {
        return this.rollbackTxRunnables.values();
    }

    public void invokeCommitTxRunnables() {
        if (this.commitTxRunnables != null) {
            for (CommitTxRunnable r : this.commitTxRunnables.values()) {
                r.commit(this.db);
            }
            this.commitTxRunnables = null;
        }
    }

    public void invokeRollbackTxRunnables() {
        if (this.rollbackTxRunnables != null) {
            for (RollbackTxRunnable r : this.rollbackTxRunnables.values()) {
                r.rollback(this.db);
            }
            this.rollbackTxRunnables = null;
        }
    }

    public boolean isPersistenceOperationAllowed(AbstractDbObject<?> object, char modType) {
        if (this.visitors != null) {
            for (PersistenceVisitor visitor : this.visitors.values()) {
                object.acceptPersistenceVisitor(visitor, modType);
                if (visitor.isPersistenceOperationAllowed(object, modType)) continue;
                return false;
            }
        }
        return true;
    }
}

