/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import org.tentackle.common.Compare;
import org.tentackle.common.Service;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.pdo.DefaultDomainContext;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionHolder;
import org.tentackle.persist.DbPreferences;
import org.tentackle.persist.DbPreferencesKey;
import org.tentackle.persist.DbPreferencesNode;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.prefs.PersistedPreferencesXmlSupport;

@Service(value=PersistedPreferencesFactory.class)
public class DbPreferencesFactory
implements PersistedPreferencesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbPreferencesFactory.class);
    private final Map<Long, DbPreferences> prefIdMap = new TreeMap<Long, DbPreferences>();
    private final Map<Long, DbPreferencesKey> keyIdMap = new TreeMap<Long, DbPreferencesKey>();
    private final Map<NodeIndex, DbPreferences> prefNameMap = new TreeMap<NodeIndex, DbPreferences>();
    private final SessionHolder sessionHolder = new DefaultDomainContext();
    private DbPreferences systemRoot;
    private DbPreferences userRoot;
    private boolean autoSync = true;
    private boolean readOnly;
    private boolean systemOnly;
    private long nodeTableSerial = this.createNode().getModificationCount();
    private long keyTableSerial = this.createKey().getModificationCount();

    public Session getSession() {
        return this.sessionHolder.getSession();
    }

    public void updateNodeTableSerial(long newTableSerial) {
        if (newTableSerial > this.nodeTableSerial) {
            this.nodeTableSerial = newTableSerial;
        }
    }

    public void updateKeyTableSerial(long newTableSerial) {
        if (newTableSerial > this.keyTableSerial) {
            this.keyTableSerial = newTableSerial;
        }
    }

    public void addPreferences(DbPreferences prefs) {
        if (!prefs.getNode().isNew()) {
            this.updateNodeTableSerial(prefs.getNode().getTableSerial());
            this.prefIdMap.put(prefs.getNode().getId(), prefs);
        }
        this.prefNameMap.put(new NodeIndex(prefs.getNode()), prefs);
    }

    public void removeNode(DbPreferencesNode node) {
        this.prefIdMap.remove(node.getId());
        this.prefNameMap.remove(new NodeIndex(node));
    }

    public DbPreferences getPreferences(long nodeId) {
        return this.prefIdMap.get(nodeId);
    }

    public DbPreferences getPreferences(String user, String path) {
        return this.prefNameMap.get(new NodeIndex(user, path));
    }

    public void addKey(DbPreferencesKey key) {
        if (!key.isNew()) {
            this.updateKeyTableSerial(key.getTableSerial());
            this.keyIdMap.put(key.getId(), key);
        }
    }

    public void removeKey(DbPreferencesKey key) {
        this.keyIdMap.remove(key.getId());
    }

    public void expireKeys(long maxSerial) {
        List<IdSerialTuple> expiredList = this.createKey().getExpiredTableSerials(this.keyTableSerial, maxSerial);
        for (IdSerialTuple idSer : expiredList) {
            DbPreferencesKey key = this.keyIdMap.get(idSer.getId());
            if (key == null || key.getTableSerial() >= idSer.getSerial()) continue;
            DbPreferencesKey nkey = (DbPreferencesKey)this.createKey().selectObject(idSer.getId());
            key.setValue(nkey.getValue());
            key.setSerial(nkey.getSerial());
            key.setTableSerial(nkey.getTableSerial());
            DbPreferences pref = this.prefIdMap.get(key.getNodeId());
            if (pref == null) continue;
            LOGGER.fine("key updated in {0}: {1}", new Object[]{pref, key});
            pref.enqueuePreferenceChangeEvent(key.getKey(), key.getValue());
        }
        this.keyTableSerial = maxSerial;
    }

    public void expireNodes(long maxSerial) {
        List<IdSerialTuple> expireSet = this.createNode().getExpiredTableSerials(this.nodeTableSerial, maxSerial);
        boolean someNodesRemoved = false;
        long lastSerial = -1L;
        for (IdSerialTuple idSer : expireSet) {
            if (lastSerial != -1L && idSer.getSerial() - lastSerial > 1L) {
                someNodesRemoved = true;
                break;
            }
            lastSerial = idSer.getSerial();
        }
        if (maxSerial - lastSerial > 1L) {
            someNodesRemoved = true;
        }
        if (someNodesRemoved) {
            LOGGER.fine("some nodes have been removed", new Object[0]);
        }
        for (IdSerialTuple idSer : expireSet) {
            DbPreferencesNode expiredNode = (DbPreferencesNode)this.createNode().selectObject(idSer.getId());
            DbPreferences pref = this.prefIdMap.get(idSer.getId());
            if (pref == null && (pref = this.prefNameMap.get(new NodeIndex(expiredNode))) != null && pref.getNode().isNew()) {
                pref.getNode().setId(expiredNode.getId());
                pref.getNode().setParentId(expiredNode.getParentId());
                this.prefIdMap.put(pref.getNode().getId(), pref);
                if (pref.getParent() != null) {
                    pref.getParent().getChildIds().add(expiredNode.getId());
                }
                LOGGER.fine("assigned ID(s) to node {0}", new Object[]{pref.getNode()});
            }
            if (pref == null || pref.getNode() == null) continue;
            if (pref.getNode().getTableSerial() < idSer.getSerial() && pref.getKeys() != null) {
                List<DbPreferencesKey> keyList = this.createKey().selectByNodeId(idSer.getId());
                for (DbPreferencesKey key : keyList) {
                    if (pref.getKeys().containsKey(key.getKey())) continue;
                    pref.getKeys().put(key.getKey(), key);
                    this.keyIdMap.put(key.getId(), key);
                    pref.enqueuePreferenceChangeEvent(key.getKey(), key.getValue());
                    LOGGER.fine("key added to node {0}: {1}", new Object[]{pref.getNode(), key});
                }
                Iterator<DbPreferencesKey> iter = pref.getKeys().values().iterator();
                while (iter.hasNext()) {
                    DbPreferencesKey key;
                    key = iter.next();
                    if (keyList.contains(key)) continue;
                    iter.remove();
                    this.keyIdMap.remove(key.getId());
                    pref.enqueuePreferenceChangeEvent(key.getKey(), null);
                    LOGGER.fine("key removed from node {0}: {1}", new Object[]{pref.getNode(), key});
                }
            }
            if (expiredNode != null) {
                pref.getNode().setSerial(expiredNode.getSerial());
                pref.getNode().setTableSerial(expiredNode.getTableSerial());
            }
            if (!someNodesRemoved && !pref.areNodeListenersRegistered()) continue;
            List<DbPreferencesNode> currentNodes = this.createNode().selectByParentId(pref.getNode().getId());
            if (pref.areNodeListenersRegistered()) {
                for (DbPreferencesNode node : currentNodes) {
                    if (pref.getChildIds().contains(node.getId())) continue;
                    try {
                        DbPreferences child = this.createPreferences(pref, node);
                        this.prefIdMap.put(node.getId(), child);
                        this.prefNameMap.put(new NodeIndex(node), child);
                        pref.getChildPrefs().put(child.getName(), child);
                        pref.getChildIds().add(node.getId());
                        pref.enqueueNodeAddedEvent(child);
                        LOGGER.fine("node {0} added to {1}", new Object[]{child, pref});
                    }
                    catch (BackingStoreException ex) {
                        throw new PersistenceException(this.sessionHolder.getSession(), "loading added node " + node + " failed", (Throwable)ex);
                    }
                }
            }
            if (!someNodesRemoved) continue;
            for (Long id : pref.getChildIds()) {
                boolean removed = true;
                for (DbPreferencesNode node : currentNodes) {
                    if (id.longValue() != node.getId()) continue;
                    removed = false;
                    break;
                }
                if (!removed) continue;
                try {
                    DbPreferences child = this.prefIdMap.get(id);
                    child.removeNode();
                    pref.enqueueNodeRemovedEvent(child);
                    LOGGER.fine("node {0} removed from {1}", new Object[]{child, pref});
                }
                catch (BackingStoreException ex) {
                    throw new PersistenceException(this.sessionHolder.getSession(), "removing deleted node " + pref.getNode() + " failed", (Throwable)ex);
                }
            }
        }
        this.nodeTableSerial = maxSerial;
    }

    public DbPreferences userRoot() {
        if (this.userRoot == null) {
            this.userRoot = this.createPreferences(true);
        }
        return this.userRoot;
    }

    public PersistedPreferences getUserRoot() {
        return this.userRoot();
    }

    public DbPreferences systemRoot() {
        if (this.systemRoot == null) {
            this.systemRoot = this.createPreferences(false);
        }
        return this.systemRoot;
    }

    public PersistedPreferences getSystemRoot() {
        return this.systemRoot();
    }

    public boolean isAutoSync() {
        return this.autoSync;
    }

    public void setAutoSync(boolean autoSync) {
        this.autoSync = autoSync;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSystemOnly() {
        return this.systemOnly;
    }

    public void setSystemOnly(boolean systemOnly) {
        this.systemOnly = systemOnly;
    }

    public DbPreferences userNodeForPackage(Class<?> c) {
        return this.userRoot().node(DbPreferencesFactory.nodeName(c));
    }

    public DbPreferences systemNodeForPackage(Class<?> c) {
        return this.systemRoot().node(DbPreferencesFactory.nodeName(c));
    }

    public void importPreferences(InputStream is) throws IOException, InvalidPreferencesFormatException {
        PersistedPreferencesXmlSupport.importPreferences((InputStream)is);
    }

    public DbPreferences createPreferences(boolean userMode) {
        return new DbPreferences(userMode);
    }

    public DbPreferences createPreferences(DbPreferences parent, String name) {
        return new DbPreferences(parent, name);
    }

    public DbPreferences createPreferences(DbPreferences parent, DbPreferencesNode node) throws BackingStoreException {
        return new DbPreferences(parent, node);
    }

    public DbPreferencesNode createNode() {
        DbPreferencesNode node = new DbPreferencesNode();
        node.setSessionHolder(this.sessionHolder);
        return node;
    }

    public DbPreferencesKey createKey() {
        DbPreferencesKey key = new DbPreferencesKey();
        key.setSessionHolder(this.sessionHolder);
        return key;
    }

    protected static String nodeName(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Arrays have no associated preferences node");
        }
        String className = clazz.getName();
        int pkgEndIndex = className.lastIndexOf(46);
        if (pkgEndIndex < 0) {
            return "/<unnamed>";
        }
        String packageName = className.substring(0, pkgEndIndex);
        return "/" + packageName.replace('.', '/');
    }

    private static class NodeIndex
    implements Comparable<NodeIndex> {
        private final String user;
        private final String name;

        private NodeIndex(String user, String name) {
            this.user = user;
            this.name = name;
        }

        private NodeIndex(DbPreferencesNode node) {
            this.user = node.getUser();
            this.name = node.getName();
        }

        @Override
        public int compareTo(NodeIndex o) {
            int rv = Compare.compare((Comparable)((Object)this.user), (Comparable)((Object)o.user));
            if (rv == 0) {
                rv = Compare.compare((Comparable)((Object)this.name), (Comparable)((Object)o.name));
            }
            return rv;
        }

        public boolean equals(Object obj) {
            return obj instanceof NodeIndex && this.compareTo((NodeIndex)obj) == 0;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.user != null ? this.user.hashCode() : 0);
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }
}

