/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.tentackle.common.Compare;
import org.tentackle.io.Base64;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.DbPreferencesFactory;
import org.tentackle.persist.DbPreferencesKey;
import org.tentackle.persist.DbPreferencesNode;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.prefs.PersistedPreferencesXmlSupport;

public class DbPreferences
extends Preferences
implements PersistedPreferences {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbPreferences.class);
    private static final String TX_FLUSH = "flush";
    private static final String TX_REMOVE_NODE = "remove node";
    private String name;
    private String absolutePath;
    private boolean userMode;
    private DbPreferences parent;
    private DbPreferences root;
    private DbPreferencesNode node;
    private Map<String, DbPreferencesKey> keys;
    private Set<Long> childIds;
    private Map<String, DbPreferences> childPrefs;
    private PreferenceChangeListener[] prefListeners;
    private NodeChangeListener[] nodeListeners;
    private static final List<EventObject> eventQueue = new LinkedList<EventObject>();
    private static Thread eventDispatchThread = null;

    public DbPreferences(DbPreferences parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("illegal constructor for root node");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("name '" + name + "' contains '/'");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("illegal name: empty string");
        }
        this.absolutePath = parent.parent == null ? "/" + name : parent.absolutePath() + "/" + name;
        this.name = name;
        this.parent = parent;
        this.userMode = parent.userMode;
        this.root = parent.root;
        this.initializeNode();
    }

    public DbPreferences(boolean userMode) {
        this.userMode = userMode;
        this.name = "";
        this.absolutePath = "/";
        this.root = this;
        this.initializeNode();
    }

    public DbPreferences(DbPreferences parent, DbPreferencesNode node) throws BackingStoreException {
        if (node.getParentId() != parent.node.getId()) {
            throw new BackingStoreException("parent-ID mismatch in node '" + node + "': got ID=" + node.getParentId() + ", expected ID=" + parent.node.getId());
        }
        this.node = node;
        this.absolutePath = node.getName();
        this.name = node.getBaseName();
        this.parent = parent;
        this.userMode = parent.userMode;
        this.root = parent.root;
        this.getFactory().updateNodeTableSerial(node.getTableSerial());
        this.childPrefs = new TreeMap<String, DbPreferences>();
        this.childIds = node.selectChildIds();
    }

    public DbPreferencesNode getNode() {
        return this.node;
    }

    public DbPreferences getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public boolean isUserMode() {
        return this.userMode;
    }

    public DbPreferences getRoot() {
        return this.root;
    }

    public Map<String, DbPreferences> getChildPrefs() {
        return this.childPrefs;
    }

    public Set<Long> getChildIds() {
        return this.childIds;
    }

    public Map<String, DbPreferencesKey> getKeys() {
        return this.keys;
    }

    private DbPreferencesFactory getFactory() {
        return (DbPreferencesFactory)PersistedPreferencesFactory.getInstance();
    }

    private void initializeNode() {
        this.childPrefs = new TreeMap<String, DbPreferences>();
        Session session = this.getFactory().getSession();
        this.node = this.getFactory().createNode().selectByUserAndName(this.userMode ? session.getSessionInfo().getUserName() : null, this.absolutePath);
        if (this.node == null) {
            this.childIds = new TreeSet<Long>();
            this.node = this.getFactory().createNode();
            this.node.setUser(this.userMode ? session.getSessionInfo().getUserName() : null);
            this.node.setName(this.absolutePath);
            if (this.parent != null) {
                this.node.setParentId(this.parent.node.getId());
            }
        } else {
            this.childIds = this.node.selectChildIds();
            this.getFactory().updateNodeTableSerial(this.node.getTableSerial());
        }
        this.getFactory().addPreferences(this);
    }

    private void loadKeys() {
        this.keys = new TreeMap<String, DbPreferencesKey>();
        for (DbPreferencesKey key : this.getFactory().createKey().selectByNodeId(this.node.getId())) {
            this.keys.put(key.getKey(), key);
            this.getFactory().addKey(key);
        }
    }

    private void unloadKeys() {
        if (this.keys != null) {
            for (DbPreferencesKey key : this.keys.values()) {
                this.getFactory().removeKey(key);
            }
        }
        this.keys = null;
    }

    private void loadNodes() {
        List<DbPreferencesNode> childNodes = this.getFactory().createNode().selectByParentId(this.node.getId());
        for (DbPreferences child : this.childPrefs.values()) {
            if (child.node == null) continue;
            this.getFactory().removeNode(child.node);
        }
        this.childPrefs.clear();
        this.childIds.clear();
        for (DbPreferencesNode n : childNodes) {
            String basename = n.getBaseName();
            try {
                DbPreferences childPref = this.getFactory().createPreferences(this, n);
                this.childPrefs.put(basename, childPref);
                this.childIds.add(n.getId());
                this.getFactory().addPreferences(childPref);
            }
            catch (BackingStoreException ex) {
                throw new IllegalStateException("loading child nodes failed for " + this, ex);
            }
        }
    }

    private DbPreferencesKey getKey(String key) {
        if (this.keys == null) {
            this.loadKeys();
        }
        return this.keys.get(key);
    }

    private void assertNotRemoved() throws IllegalStateException {
        if (this.node == null) {
            throw new IllegalStateException("node '" + this.absolutePath + "' has been removed");
        }
    }

    protected void updateParentNode(DbPreferencesNode node) throws BackingStoreException {
        try {
            node.saveObject();
        }
        catch (PersistenceException e) {
            throw new BackingStoreException(e);
        }
    }

    private void updateParentNode() throws BackingStoreException {
        if (this.parent != null && this.parent.node != null) {
            DbPreferences parentPref = this.getFactory().getPreferences(this.node.getParentId());
            if (parentPref == null) {
                throw new BackingStoreException("parent of " + this.node + " not in cache");
            }
            DbPreferencesNode parentNode = parentPref.node;
            if (parentNode == null) {
                throw new BackingStoreException("parentpref of " + this.node + " has no node");
            }
            this.updateParentNode(parentNode);
        }
    }

    private void flushImpl() throws BackingStoreException {
        if (this.node == null) {
            throw new BackingStoreException("node already removed");
        }
        boolean nodeIsNew = this.node.isNew();
        if (nodeIsNew) {
            if (this.parent != null) {
                this.node.setParentId(this.parent.node.getId());
            }
            try {
                this.node.saveObject();
            }
            catch (PersistenceException e) {
                throw new BackingStoreException(e);
            }
            this.getFactory().addPreferences(this);
            this.updateParentNode();
        }
        if (this.keys != null) {
            boolean updateNode = false;
            Iterator<DbPreferencesKey> iter = this.keys.values().iterator();
            while (iter.hasNext()) {
                DbPreferencesKey key = iter.next();
                if (key.isDeleted()) {
                    key.setId(key.getId());
                    try {
                        key.deleteObject();
                    }
                    catch (PersistenceException e) {
                        throw new BackingStoreException(e);
                    }
                    iter.remove();
                    this.getFactory().removeKey(key);
                    updateNode = true;
                    continue;
                }
                if (!key.isModified()) continue;
                if (key.isNew()) {
                    updateNode = true;
                }
                try {
                    key.saveObject();
                }
                catch (PersistenceException e) {
                    throw new BackingStoreException(e);
                }
                this.getFactory().addKey(key);
            }
            if (updateNode && !nodeIsNew) {
                this.updateParentNode(this.node);
            }
        }
        for (DbPreferences child : this.childPrefs.values()) {
            child.flushImpl();
        }
    }

    private void recover() {
        LOGGER.warning("*** recovering node " + this + " ***", new Object[0]);
        if (this.keys != null) {
            for (DbPreferencesKey key : this.keys.values()) {
                this.getFactory().removeKey(key);
            }
            this.keys = null;
        }
        if (this.parent != null) {
            if (this.node != null) {
                this.parent.childIds.remove(this.node.getId());
            }
            this.parent.childPrefs.remove(this.name);
        }
        if (this.node != null) {
            this.getFactory().removeNode(this.node);
        }
        this.node = null;
        this.nodeListeners = null;
        this.prefListeners = null;
        DbPreferences[] childs = new DbPreferences[this.childPrefs.size()];
        this.childPrefs.values().toArray(childs);
        for (DbPreferences child : childs) {
            child.recover();
        }
    }

    private DbPreferences node(StringTokenizer path) {
        String token = path.nextToken();
        if (token.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        DbPreferences child = this.childPrefs.get(token);
        if (child == null) {
            if (token.length() > 80) {
                throw new IllegalArgumentException("Node name " + token + " too long");
            }
            child = this.getFactory().createPreferences(this, token);
            if (child.node.isNew()) {
                this.enqueueNodeAddedEvent(child);
            } else {
                this.childIds.add(child.node.getId());
            }
            this.childPrefs.put(token, child);
        }
        if (!path.hasMoreTokens()) {
            return child;
        }
        path.nextToken();
        if (!path.hasMoreTokens()) {
            throw new IllegalArgumentException("Path ends with slash");
        }
        return child.node(path);
    }

    private void removeNodeImpl() throws BackingStoreException {
        if (this.node != null) {
            this.loadNodes();
            this.loadKeys();
            for (DbPreferences child : this.childPrefs.values()) {
                child.removeNodeImpl();
            }
            try {
                this.node.deleteObject();
            }
            catch (PersistenceException e) {
                throw new BackingStoreException(e);
            }
            this.getFactory().removeNode(this.node);
            if (!this.keys.isEmpty()) {
                DbPreferencesKey key = this.keys.values().iterator().next();
                if (key.isLoggingModification('D')) {
                    for (DbPreferencesKey k : this.keys.values()) {
                        k.deleteObject();
                    }
                } else {
                    key.deleteByNodeId(this.node.getId());
                }
            }
            this.unloadKeys();
            this.keys = null;
            this.childPrefs = null;
            this.childIds = null;
            this.nodeListeners = null;
            this.prefListeners = null;
            this.node = null;
            this.parent.enqueueNodeRemovedEvent(this);
        }
    }

    public boolean areNodeListenersRegistered() {
        return this.nodeListeners != null && this.nodeListeners.length > 0;
    }

    public boolean arePreferenceListenersRegistered() {
        return this.prefListeners != null && this.prefListeners.length > 0;
    }

    @Override
    public String toString() {
        if (this.node == null) {
            return this.absolutePath + " [deleted]";
        }
        if (this.userMode) {
            return this.node.getUser() + ":" + this.absolutePath;
        }
        return "<system>:" + this.absolutePath;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String absolutePath() {
        return this.absolutePath;
    }

    @Override
    public boolean isUserNode() {
        return this.userMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (key.length() > 80) {
            throw new IllegalArgumentException("key too long: <" + key + ">");
        }
        if (value.length() > 8192) {
            throw new IllegalArgumentException("value too long: <" + value + ">");
        }
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            if (!this.getFactory().isReadOnly()) {
                DbPreferencesKey k = this.getKey(key);
                if (k == null) {
                    k = this.getFactory().createKey();
                    if (!this.node.isIdValid()) {
                        k.setLazyNode(this.node);
                    } else {
                        k.setNodeId(this.node.getId());
                    }
                    k.setKey(key);
                    this.keys.put(key, k);
                } else if (k.isDeleted()) {
                    k.setId(-k.getId());
                }
                String oldValue = k.getValue();
                k.setValue(value);
                if (Compare.compare((Comparable)((Object)oldValue), (Comparable)((Object)value)) != 0) {
                    this.enqueuePreferenceChangeEvent(key, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key, String def) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            DbPreferencesKey k = this.getKey(key);
            return k == null || k.isDeleted() || k.getValue() == null ? def : k.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            DbPreferencesKey k;
            this.assertNotRemoved();
            if (!this.getFactory().isReadOnly() && (k = this.getKey(key)) != null) {
                if (k.isIdValid()) {
                    k.setId(-k.getId());
                } else {
                    this.keys.remove(key);
                }
                this.enqueuePreferenceChangeEvent(key, null);
            }
        }
    }

    @Override
    public void clear() throws BackingStoreException {
        if (!this.getFactory().isReadOnly()) {
            String[] keyArray;
            for (String keyArray1 : keyArray = this.keys()) {
                this.remove(keyArray1);
            }
        }
    }

    @Override
    public void sync() throws BackingStoreException {
        this.flush();
        this.getFactory().expireKeys(this.getFactory().createKey().getModificationCount());
        this.getFactory().expireNodes(this.getFactory().createNode().getModificationCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws BackingStoreException {
        if (!this.getFactory().isReadOnly()) {
            DbPreferencesFactory dbPreferencesFactory = this.getFactory();
            synchronized (dbPreferencesFactory) {
                Session session = this.getFactory().getSession();
                long txVoucher = session.begin(TX_FLUSH);
                try {
                    DbPreferences prefs = this;
                    while (prefs.parent != null && prefs.parent.node != null && prefs.parent.node.isNew()) {
                        prefs = prefs.parent;
                    }
                    prefs.flushImpl();
                    session.commit(txVoucher);
                }
                catch (BackingStoreException ex) {
                    session.rollback(txVoucher);
                    this.recover();
                    throw ex;
                }
            }
        }
    }

    @Override
    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    @Override
    public int getInt(String key, int def) {
        int result = def;
        try {
            String value = this.get(key, null);
            if (value != null) {
                result = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    @Override
    public long getLong(String key, long def) {
        long result = def;
        try {
            String value = this.get(key, null);
            if (value != null) {
                result = Long.parseLong(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        boolean result = def;
        String value = this.get(key, null);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    @Override
    public float getFloat(String key, float def) {
        float result = def;
        try {
            String value = this.get(key, null);
            if (value != null) {
                result = Float.parseFloat(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    @Override
    public double getDouble(String key, double def) {
        double result = def;
        try {
            String value = this.get(key, null);
            if (value != null) {
                result = Double.parseDouble(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.put(key, Base64.byteArrayToBase64((byte[])value));
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        byte[] result = def;
        String value = this.get(key, null);
        try {
            if (value != null) {
                result = Base64.base64ToByteArray((String)value);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] keys() throws BackingStoreException {
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            if (this.keys == null) {
                this.loadKeys();
            }
            String[] keyNames = new String[this.keys.size()];
            this.keys.keySet().toArray(keyNames);
            return keyNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] childrenNames() throws BackingStoreException {
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            this.loadNodes();
            String[] childNames = new String[this.childPrefs.size()];
            this.childPrefs.keySet().toArray(childNames);
            return childNames;
        }
    }

    @Override
    public DbPreferences parent() {
        this.assertNotRemoved();
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbPreferences node(String path) {
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            if (path.isEmpty()) {
                return this;
            }
            if (path.equals("/")) {
                return this.root;
            }
            if (path.charAt(0) != '/') {
                return this.node(new StringTokenizer(path, "/", true));
            }
        }
        return this.root.node(new StringTokenizer(path.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            DbPreferences pref;
            if (pathName.isEmpty()) {
                return this.node != null;
            }
            this.assertNotRemoved();
            if (pathName.equals("/")) {
                return true;
            }
            if (pathName.charAt(0) != '/') {
                pathName = this.absolutePath + "/" + pathName;
            }
            if ((pref = this.getFactory().getPreferences(this.node.getUser(), pathName)) != null && !pref.node.isNew()) {
                return true;
            }
            return this.getFactory().createNode().selectByUserAndName(this.node.getUser(), pathName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        if (this == this.root) {
            throw new UnsupportedOperationException("Can't remove the root!");
        }
        if (!this.getFactory().isReadOnly()) {
            DbPreferencesFactory dbPreferencesFactory = this.getFactory();
            synchronized (dbPreferencesFactory) {
                this.assertNotRemoved();
                Session session = this.getFactory().getSession();
                long txVoucher = session.begin(TX_REMOVE_NODE);
                try {
                    this.updateParentNode();
                    this.removeNodeImpl();
                    this.parent.childPrefs.remove(this.name);
                    session.commit(txVoucher);
                }
                catch (Exception e) {
                    session.rollback(txVoucher);
                    if (e instanceof BackingStoreException) {
                        throw (BackingStoreException)e;
                    }
                    throw new BackingStoreException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        if (pcl == null) {
            throw new NullPointerException("Change listener is null.");
        }
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            if (this.prefListeners == null) {
                this.prefListeners = new PreferenceChangeListener[1];
                this.prefListeners[0] = pcl;
            } else {
                PreferenceChangeListener[] old = this.prefListeners;
                this.prefListeners = new PreferenceChangeListener[old.length + 1];
                System.arraycopy(old, 0, this.prefListeners, 0, old.length);
                this.prefListeners[old.length] = pcl;
            }
            if (this.keys == null) {
                this.loadKeys();
            }
        }
        DbPreferences.startEventDispatchThreadIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            if (this.prefListeners == null || this.prefListeners.length == 0) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            PreferenceChangeListener[] newPl = new PreferenceChangeListener[this.prefListeners.length - 1];
            int i = 0;
            while (i < newPl.length && this.prefListeners[i] != pcl) {
                newPl[i] = this.prefListeners[i++];
            }
            if (i == newPl.length && this.prefListeners[i] != pcl) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            while (i < newPl.length) {
                newPl[i++] = this.prefListeners[i];
            }
            this.prefListeners = newPl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeChangeListener(NodeChangeListener ncl) {
        if (ncl == null) {
            throw new NullPointerException("Change listener is null.");
        }
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            if (this.nodeListeners == null) {
                this.nodeListeners = new NodeChangeListener[1];
                this.nodeListeners[0] = ncl;
            } else {
                NodeChangeListener[] old = this.nodeListeners;
                this.nodeListeners = new NodeChangeListener[old.length + 1];
                System.arraycopy(old, 0, this.nodeListeners, 0, old.length);
                this.nodeListeners[old.length] = ncl;
            }
        }
        DbPreferences.startEventDispatchThreadIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeChangeListener(NodeChangeListener ncl) {
        DbPreferencesFactory dbPreferencesFactory = this.getFactory();
        synchronized (dbPreferencesFactory) {
            this.assertNotRemoved();
            if (this.nodeListeners == null || this.nodeListeners.length == 0) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            NodeChangeListener[] newNl = new NodeChangeListener[this.nodeListeners.length - 1];
            int i = 0;
            while (i < this.nodeListeners.length && this.nodeListeners[i] != ncl) {
                newNl[i] = this.nodeListeners[i++];
            }
            if (i == this.nodeListeners.length) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            while (i < newNl.length) {
                newNl[i++] = this.nodeListeners[i];
            }
            this.nodeListeners = newNl;
        }
    }

    private static synchronized void startEventDispatchThreadIfNecessary() {
        if (eventDispatchThread == null) {
            eventDispatchThread = new EventDispatchThread();
            eventDispatchThread.setDaemon(true);
            eventDispatchThread.start();
        }
    }

    PreferenceChangeListener[] prefListeners() {
        return this.prefListeners;
    }

    NodeChangeListener[] nodeListeners() {
        return this.nodeListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueuePreferenceChangeEvent(String key, String newValue) {
        if (this.arePreferenceListenersRegistered()) {
            List<EventObject> list = eventQueue;
            synchronized (list) {
                eventQueue.add(new PreferenceChangeEvent(this, key, newValue));
                eventQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueNodeAddedEvent(Preferences child) {
        if (this.areNodeListenersRegistered()) {
            List<EventObject> list = eventQueue;
            synchronized (list) {
                eventQueue.add(new NodeAddedEvent(this, child));
                eventQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueNodeRemovedEvent(Preferences child) {
        if (this.areNodeListenersRegistered()) {
            List<EventObject> list = eventQueue;
            synchronized (list) {
                eventQueue.add(new NodeRemovedEvent(this, child));
                eventQueue.notify();
            }
        }
    }

    @Override
    public void exportNode(OutputStream os) throws IOException, BackingStoreException {
        PersistedPreferencesXmlSupport.export((OutputStream)os, (PersistedPreferences)this, (boolean)false);
    }

    @Override
    public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
        PersistedPreferencesXmlSupport.export((OutputStream)os, (PersistedPreferences)this, (boolean)true);
    }

    static /* synthetic */ List access$000() {
        return eventQueue;
    }

    private static class EventDispatchThread
    extends Thread {
        private EventDispatchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block5: while (true) lbl-1000:
            // 4 sources

            {
                block11: {
                    block10: {
                        var2_2 = DbPreferences.access$000();
                        synchronized (var2_2) {
                            try {
                                while (DbPreferences.access$000().isEmpty()) {
                                    DbPreferences.access$000().wait();
                                }
                                event = (EventObject)DbPreferences.access$000().remove(0);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        src = (DbPreferences)event.getSource();
                        if (!(event instanceof PreferenceChangeEvent)) break block10;
                        pce = (PreferenceChangeEvent)event;
                        var5_7 = listeners = src.prefListeners();
                        var6_8 = var5_7.length;
                        var7_9 = 0;
                        while (true) {
                            if (var7_9 >= var6_8) ** GOTO lbl-1000
                            listener = var5_7[var7_9];
                            listener.preferenceChange(pce);
                            ++var7_9;
                        }
                    }
                    nce = (NodeChangeEvent)event;
                    listeners = src.nodeListeners();
                    if (!(nce instanceof NodeAddedEvent)) break block11;
                    var5_7 = listeners;
                    var6_8 = var5_7.length;
                    var7_9 = 0;
                    while (true) {
                        if (var7_9 >= var6_8) ** GOTO lbl-1000
                        listener = var5_7[var7_9];
                        listener.childAdded(nce);
                        ++var7_9;
                    }
                }
                var5_7 = listeners;
                var6_8 = var5_7.length;
                var7_9 = 0;
                while (true) {
                    if (var7_9 >= var6_8) continue block5;
                    listener = var5_7[var7_9];
                    listener.childRemoved(nce);
                    ++var7_9;
                }
                break;
            }
        }
    }

    private class NodeRemovedEvent
    extends NodeChangeEvent {
        private static final long serialVersionUID = 8735497392918824837L;

        NodeRemovedEvent(Preferences parent, Preferences child) {
            super(parent, child);
        }
    }

    private class NodeAddedEvent
    extends NodeChangeEvent {
        private static final long serialVersionUID = -6743557530157328528L;

        NodeAddedEvent(Preferences parent, Preferences child) {
            super(parent, child);
        }
    }
}

