/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.misc.Identifiable;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbObjectClassVariables;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.persist.StatementWrapper;

public class DbModification
extends AbstractDbObject<DbModification> {
    public static final String TABLENAME = "modification";
    private static final DbObjectClassVariables<DbModification> CLASSVARIABLES = new DbObjectClassVariables<DbModification>(DbModification.class, 1, "modification");
    private static final long serialVersionUID = -1723181864077614924L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbModification.class);
    public static final String CN_TRACKEDNAME = "tablename";
    public static final int CL_TRACKEDNAME = 64;
    private String trackedName;
    private static final StatementId countModificationStatementId = new StatementId();
    private static final StatementId selectModificationStatementId = new StatementId();
    private static final StatementId selectIdStatementId = new StatementId();
    private static final StatementId selectTableNameStatementId = new StatementId();
    private static final StatementId selectMasterSerialStatementId = new StatementId();

    public static void initializeModificationTable(Db db) {
        LOGGER.info("initializing modification table", new Object[0]);
        long txVoucher = db.begin("initialize");
        try {
            db.createStatement().executeUpdate("DELETE  FROM modification");
            db.createStatement().executeUpdate("INSERT INTO modification (id,serial) VALUES (0,1)");
            db.commit(txVoucher);
        }
        catch (RuntimeException ex) {
            db.rollback(txVoucher);
            throw ex;
        }
    }

    public DbModification(Db db, String trackedName) {
        super(db);
        this.trackedName = trackedName;
    }

    public DbModification(Db db) {
        super(db);
    }

    public DbModification() {
    }

    @Override
    public DbObjectClassVariables<DbModification> getClassVariables() {
        return CLASSVARIABLES;
    }

    @Override
    public String toString() {
        return this.trackedName;
    }

    @Override
    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_TRACKEDNAME);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.trackedName = rs.getString();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    @Override
    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setString(++ndx, this.trackedName);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    @Override
    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + CN_TRACKEDNAME + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?" + ") ";
    }

    @Override
    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + CN_TRACKEDNAME + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public String getTrackedName() {
        return this.trackedName;
    }

    public void setTrackedName(String trackedName) {
        this.assertMutable();
        this.trackedName = trackedName;
    }

    public int countModification(long count) {
        this.assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(countModificationStatementId, () -> "UPDATE modification SET serial=serial+? WHERE tablename=? OR id=?");
        st.setLong(1, count);
        st.setString(2, this.trackedName);
        st.setLong(3, 0L);
        return st.executeUpdate();
    }

    public void addToModificationTable(boolean tableExists, String tableSerialTableName) {
        try (StatementWrapper st = this.getSession().createStatement();){
            int count = tableExists ? st.executeUpdate(this.getBackend().allowsExpressionsReferringToTablesBeingUpdated() ? "INSERT INTO modification (tablename,id,serial) VALUES ('" + this.trackedName + "',(SELECT MAX(" + "id" + ")+1 FROM " + TABLENAME + ")," + (tableSerialTableName != null ? "(SELECT " + this.getSession().getBackend().getCoalesceKeyword() + "(MAX(" + "tableserial" + "),0) FROM " + tableSerialTableName + ")" : "1") + ")" : "INSERT INTO modification SET tablename='" + this.trackedName + "', " + "id" + "=(SELECT * FROM (SELECT MAX(" + "id" + ")+1 FROM " + TABLENAME + ") AS x), " + "serial" + "=" + (tableSerialTableName != null ? "(SELECT " + this.getSession().getBackend().getCoalesceKeyword() + "(MAX(" + "tableserial" + "),0) FROM " + tableSerialTableName + ")" : "1")) : st.executeUpdate(this.getSession().getBackend().allowsExpressionsReferringToTablesBeingUpdated() ? "INSERT INTO modification (tablename,id,serial) VALUES ('" + this.trackedName + "',(SELECT MAX(" + "id" + ")+1 FROM " + TABLENAME + "),0)" : "INSERT INTO modification SET tablename='" + this.trackedName + "', " + "id" + "=(SELECT * FROM (SELECT MAX(" + "id" + ")+1 FROM " + TABLENAME + ") AS x), " + "serial" + "=0");
            if (count != 1) {
                throw new PersistenceException((Identifiable)this, "adding modification entry failed");
            }
        }
    }

    public long refresh() {
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(selectModificationStatementId, () -> "SELECT id,serial FROM modification WHERE tablename=?");
        st.setString(1, this.trackedName);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                this.setId(rs.getLong("id"));
                this.setSerial(rs.getLong("serial"));
            } else {
                this.setId(0L);
                this.setSerial(0L);
            }
            long l = this.getSerial();
            return l;
        }
    }

    public IdSerialTuple selectIdSerial(String tableName) {
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(selectIdStatementId, () -> "SELECT id,serial FROM modification WHERE tablename=?");
        st.setString(1, tableName);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                IdSerialTuple idSerialTuple = new IdSerialTuple(rs.getLong(1), rs.getLong(2));
                return idSerialTuple;
            }
            IdSerialTuple idSerialTuple = null;
            return idSerialTuple;
        }
    }

    public String selectTableNameForId(long id) {
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(selectTableNameStatementId, () -> "SELECT tablename FROM modification WHERE id=?");
        st.setLong(1, id);
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public long selectMasterSerial() {
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(selectMasterSerialStatementId, () -> "SELECT serial FROM modification WHERE id=?");
        st.setLong(1, 0L);
        Throwable throwable = null;
        try (ResultSetWrapper rs = st.executeQuery();){
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            try {
                throw new PersistenceException((Session)this.getSession(), "can't read master serial from modification");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

