/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import org.tentackle.app.AbstractApplication;
import org.tentackle.common.Service;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionCloseHandler;
import org.tentackle.pdo.SessionFactory;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.pdo.SessionManager;
import org.tentackle.pdo.SessionManagerProvider;
import org.tentackle.persist.ConnectionManager;
import org.tentackle.persist.Db;
import org.tentackle.persist.DefaultConnectionManager;

@Service(value=SessionFactory.class)
public class DbFactory
implements SessionFactory,
SessionManagerProvider {
    private ConnectionManager connectionManager;

    public Session create(SessionInfo sessionInfo) {
        return new Db(this.getSessionManager(), sessionInfo);
    }

    public Session create(SessionManager sessionManager, SessionInfo sessionInfo) {
        return new Db((ConnectionManager)sessionManager, sessionInfo);
    }

    public boolean registerGlobalCloseHandler(SessionCloseHandler closeHandler) {
        return Db.registerGlobalCloseHandler(closeHandler);
    }

    public boolean unregisterGlobalCloseHandler(SessionCloseHandler closeHandler) {
        return Db.unregisterGlobalCloseHandler(closeHandler);
    }

    public synchronized ConnectionManager getSessionManager() {
        if (this.connectionManager == null) {
            AbstractApplication application = AbstractApplication.getRunningApplication();
            if (application instanceof SessionManagerProvider) {
                this.connectionManager = (ConnectionManager)((SessionManagerProvider)application).getSessionManager();
            }
            if (this.connectionManager == null) {
                this.connectionManager = new DefaultConnectionManager();
            }
        }
        return this.connectionManager;
    }
}

