/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.lang.management.ThreadInfo;
import java.util.Collection;
import org.tentackle.common.Service;
import org.tentackle.misc.DiagnosticUtilities;
import org.tentackle.persist.Db;
import org.tentackle.persist.ManagedConnection;

@Service(value=DiagnosticUtilities.class)
public class DbDiagnosticUtilities
extends DiagnosticUtilities {
    protected void doCreateStackDump(StringBuilder buf, ThreadInfo info, Thread thread) {
        super.doCreateStackDump(buf, info, thread);
        for (ManagedConnection connection : ManagedConnection.getManagedConnections()) {
            Thread ownerThread;
            Db db = connection.getSession();
            if (db == null || (ownerThread = db.getOwnerThread()) == null || ownerThread.getId() != info.getThreadId()) continue;
            buf.append("    connection: ");
            this.doCreateConnectionDump(buf, connection);
            buf.append("\n\n");
            break;
        }
    }

    protected void doCreateConnectionDump(StringBuilder buf, ManagedConnection connection) {
        buf.append(connection.toDiagnosticString());
    }

    protected void doCreateStackDump(StringBuilder buf) {
        super.doCreateStackDump(buf);
        Collection<Db> openDb = Db.getAllOpenDb();
        if (openDb != null && !openDb.isEmpty()) {
            buf.append("\n\nopen Db sessions:\n");
            for (Db db : Db.getAllOpenDb()) {
                buf.append("\n    ");
                buf.append(db);
                buf.append(": ");
                ManagedConnection con = db.getConnection();
                if (con != null) {
                    this.doCreateConnectionDump(buf, con);
                    buf.append('\n');
                    continue;
                }
                buf.append("not attached\n");
            }
        }
    }
}

