/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.FileHelper;
import org.tentackle.daemon.Scavenger;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.pdo.BackendException;
import org.tentackle.pdo.DefaultSessionTaskDispatcher;
import org.tentackle.pdo.LoginFailedException;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.RemoteSession;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionCloseHandler;
import org.tentackle.pdo.SessionClosedException;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.pdo.SessionPool;
import org.tentackle.pdo.SessionTaskDispatcher;
import org.tentackle.pdo.TransactionEnvelope;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.CommitTxRunnable;
import org.tentackle.persist.ConnectionManager;
import org.tentackle.persist.DbTransaction;
import org.tentackle.persist.DbTransactionHandle;
import org.tentackle.persist.IdSource;
import org.tentackle.persist.IdSourceConfigurator;
import org.tentackle.persist.ManagedConnection;
import org.tentackle.persist.ModificationLog;
import org.tentackle.persist.ModificationLogFactory;
import org.tentackle.persist.PersistenceVisitor;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.RemoteSessionFactory;
import org.tentackle.persist.RollbackTxRunnable;
import org.tentackle.persist.StatementKey;
import org.tentackle.persist.StatementWrapper;
import org.tentackle.persist.rmi.DbRemoteDelegate;
import org.tentackle.persist.rmi.RemoteDbConnection;
import org.tentackle.persist.rmi.RemoteDbSession;
import org.tentackle.persist.rmi.RemoteDelegate;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.sql.Backend;
import org.tentackle.sql.BackendInfo;

public class Db
implements Session,
Cloneable {
    public static final String PROPERTY_IDSOURCE = "idsource";
    private static final Logger LOGGER = LoggerFactory.getLogger(Db.class);
    private static final Set<SessionCloseHandler> GLOBAL_CLOSE_HANDLERS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<WeakReference<Db>> DB_SET = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static Class<?>[] remoteClasses;
    private static int nextDelegateId;
    private int instanceNumber;
    private BackendInfo backendInfo;
    private String idConfig;
    private final ConnectionManager conMgr;
    private int conId;
    private int groupConId;
    private ManagedConnection con;
    private SessionPool dbPool;
    private int poolId;
    private SessionInfo sessionInfo;
    private Db clonedFromDb;
    private boolean autoCommit;
    private boolean countModificationAllowed = true;
    private boolean logModificationAllowed = true;
    private Set<SessionCloseHandler> closeHandlers = new HashSet<SessionCloseHandler>();
    private boolean readOnly;
    private IdSource defaultIdSource;
    private int fetchSize;
    private int maxRows;
    private boolean logModificationTxEnabled;
    private long logModificationTxId;
    private boolean logModificationDeferred;
    private List<ModificationLog> modificationLogList;
    private DbTransaction transaction;
    private int immediatelyRolledBack;
    private int immediatelyCommitted;
    private volatile boolean alive;
    private long keepAliveInterval;
    private boolean crashed;
    private volatile Thread ownerThread;
    private WeakReference<SessionTaskDispatcher> dispatcherRef;
    private RemoteDbConnection rcon;
    private RemoteDbSession rses;
    private DbRemoteDelegate rdel;
    private RemoteDelegate[] delegates;

    public static boolean registerGlobalCloseHandler(SessionCloseHandler closeHandler) {
        return GLOBAL_CLOSE_HANDLERS.add(closeHandler);
    }

    public static boolean unregisterGlobalCloseHandler(SessionCloseHandler closeHandler) {
        return GLOBAL_CLOSE_HANDLERS.remove(closeHandler);
    }

    private static void registerDb(Db db) {
        DB_SET.add(new WeakReference<Db>(db));
    }

    private static void unregisterDb(Db db) {
        Iterator<WeakReference<Db>> iter = DB_SET.iterator();
        while (iter.hasNext()) {
            WeakReference<Db> ref = iter.next();
            Db refDb = (Db)ref.get();
            if (refDb != null && refDb.isOpen() && refDb != db) continue;
            iter.remove();
        }
    }

    public static Collection<Db> getAllOpenDb() {
        ArrayList<Db> dbList = new ArrayList<Db>();
        Iterator<WeakReference<Db>> iter = DB_SET.iterator();
        while (iter.hasNext()) {
            WeakReference<Db> ref = iter.next();
            Db refDb = (Db)ref.get();
            if (refDb != null && refDb.isOpen()) {
                dbList.add(refDb);
                continue;
            }
            iter.remove();
        }
        return dbList;
    }

    public Db(ConnectionManager conMgr, SessionInfo sessionInfo) {
        this.instanceNumber = INSTANCE_COUNTER.incrementAndGet();
        this.setSessionInfo(sessionInfo);
        try {
            Properties sessionProperties;
            Properties backendProperties = sessionProperties = sessionInfo.getProperties();
            String technicalBackendInfoName = sessionInfo.getProperties().getProperty("backendinfo");
            if (technicalBackendInfoName != null) {
                try {
                    backendProperties = FileHelper.loadProperties((String)technicalBackendInfoName, (boolean)false);
                }
                catch (FileNotFoundException e1) {
                    try {
                        backendProperties = FileHelper.loadProperties((String)technicalBackendInfoName, (boolean)true);
                    }
                    catch (FileNotFoundException e2) {
                        throw new PersistenceException("technical backend properties '" + technicalBackendInfoName + "' not found");
                    }
                }
            }
            try {
                this.backendInfo = new BackendInfo(backendProperties);
            }
            catch (BackendException bex) {
                throw new PersistenceException((Session)this, "invalid configuration in " + sessionInfo.getPropertiesName(), (Throwable)bex);
            }
            if (this.backendInfo.isRemote()) {
                this.conMgr = null;
            } else {
                if (conMgr == null) {
                    throw new NullPointerException("connection manager required for local connections");
                }
                this.conMgr = conMgr;
            }
            String val = sessionProperties.getProperty(PROPERTY_IDSOURCE);
            if (val != null) {
                this.idConfig = val;
            }
        }
        catch (PersistenceException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw new PersistenceException((Session)this, "database configuration failed", (Throwable)ex);
        }
    }

    public final int getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getName() {
        StringBuilder buf = new StringBuilder();
        buf.append("Db");
        buf.append(this.instanceNumber);
        buf.append('c');
        buf.append(this.conId);
        if (this.groupConId > 0) {
            buf.append('g');
            buf.append(this.groupConId);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getName());
        if (this.conMgr != null || this.dbPool != null) {
            buf.append('{');
            if (this.conMgr != null) {
                buf.append(this.conMgr.getName());
            }
            if (this.conMgr != null && this.dbPool != null) {
                buf.append('/');
            }
            if (this.dbPool != null) {
                buf.append(this.dbPool.getName());
            }
            buf.append('}');
        }
        buf.append(':');
        buf.append(this.backendInfo);
        if (this.con != null) {
            buf.append('[');
            buf.append(this.con.getName());
            buf.append(']');
        }
        return buf.toString();
    }

    public int compareTo(Session session) {
        return this.instanceNumber - ((Db)session).instanceNumber;
    }

    public ConnectionManager getSessionManager() {
        return this.conMgr;
    }

    public void setPool(SessionPool sessionPool) {
        this.dbPool = sessionPool;
    }

    public SessionPool getPool() {
        return this.dbPool;
    }

    public boolean isPooled() {
        return this.dbPool != null;
    }

    public void setPoolId(int poolId) {
        this.poolId = poolId;
    }

    public int getPoolId() {
        return this.poolId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.rdel.setReadOnly(readOnly);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.readOnly = readOnly;
    }

    public RemoteDbConnection getRemoteConnection() {
        return this.rcon;
    }

    public RemoteDbSession getRemoteDbSession() {
        return this.rses;
    }

    public Connection connect() throws SQLException {
        Connection connection = null;
        try {
            connection = this.backendInfo.connect();
            if (!connection.getAutoCommit()) {
                connection.setAutoCommit(true);
            }
            return connection;
        }
        catch (SQLException sqx) {
            LOGGER.severe("connection to " + this.backendInfo + " failed", new Object[0]);
            if (connection != null) {
                connection.close();
            }
            throw sqx;
        }
    }

    public void assertOwnerThread() {
        Thread currentThread;
        Thread ownrThread = this.getOwnerThread();
        if (ownrThread != null && ownrThread != (currentThread = Thread.currentThread()) && !Scavenger.isScavenger((Thread)currentThread)) {
            throw new PersistenceException((Session)this, "illegal attempt to use Db owned by " + ownrThread + " by " + currentThread.getName());
        }
    }

    public void assertOpen() {
        try {
            if (!this.isOpen()) {
                if (this.getPool() != null) {
                    throw new SessionClosedException((Session)this, "database session already closed by pool " + this.getPool() + "! application still holding a reference to this Db after returning it to the pool!");
                }
                throw new SessionClosedException((Session)this, "database session is closed");
            }
        }
        catch (RuntimeException rex) {
            this.handleExceptionForScavenger(rex);
        }
    }

    public void assertTxRunning() {
        try {
            if (this.transaction == null) {
                throw new PersistenceException((Session)this, "no transaction running");
            }
        }
        catch (RuntimeException rex) {
            this.handleExceptionForScavenger(rex);
        }
    }

    public void assertNoTxRunning() {
        try {
            if (this.transaction != null) {
                throw new PersistenceException((Session)this, this.transaction + " still pending");
            }
        }
        catch (RuntimeException rex) {
            this.handleExceptionForScavenger(rex);
        }
    }

    public void assertNotRemote() {
        if (this.isRemote()) {
            throw new PersistenceException((Session)this, "operation not allowed for remote db connections");
        }
    }

    public void assertRemote() {
        if (!this.isRemote()) {
            throw new PersistenceException((Session)this, "operation not allowed for local db connections");
        }
    }

    private void handleExceptionForScavenger(RuntimeException rex) {
        Thread currentThread = Thread.currentThread();
        if (!Scavenger.isScavenger((Thread)currentThread)) {
            throw rex;
        }
        LOGGER.warning("exception ignored by scavenger " + currentThread, (Throwable)rex);
    }

    public boolean isAlive() {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                return this.rdel.isAlive();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.rdel.setAlive(alive);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.alive = alive;
        }
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        if (this.keepAliveInterval != keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            Pdo.keepAliveIntervalChanged((Session)this);
        }
    }

    public void setIdConfiguration(String idConfig) {
        this.idConfig = idConfig;
    }

    public String getIdSourceConfiguration() {
        return this.idConfig;
    }

    public synchronized SessionTaskDispatcher getDispatcher() {
        SessionTaskDispatcher dispatcher = null;
        if (this.dispatcherRef != null && (dispatcher = (SessionTaskDispatcher)this.dispatcherRef.get()) == null) {
            this.dispatcherRef = null;
        }
        if (dispatcher == null || !dispatcher.isAlive()) {
            dispatcher = new DefaultSessionTaskDispatcher("Task Dispatcher for " + this.getUrl());
            dispatcher.setShutdownIdleTimeout(300000L);
            this.dispatcherRef = new WeakReference<SessionTaskDispatcher>(dispatcher);
            dispatcher.start();
        }
        return dispatcher;
    }

    public void logException(Logger logger, Logger.Level level, String msg, Throwable e) {
        if (e == null) {
            e = new Exception("unknown (exception was null)");
        }
        try (PrintStream ps = new PrintStream((OutputStream)new LoggerOutputStream(logger, level));){
            ps.println();
            if (msg != null) {
                ps.println(msg);
            }
            SQLException sqlEx = (SQLException)ExceptionHelper.extractException(SQLException.class, (boolean)true, (Throwable)e);
            msg = ">>>DB>>>> " + this;
            if (sqlEx != null) {
                msg = msg + "\n>>>SQL>>> " + sqlEx.getMessage() + "\n>>>Code>> " + sqlEx.getErrorCode() + "\n>>>State> " + sqlEx.getSQLState();
            }
            ps.println(msg);
            e.printStackTrace(ps);
        }
    }

    public boolean checkForDeadLink(SQLException ex) {
        ManagedConnection mc;
        if (this.getBackend().isCommunicationLinkException(ex) && (mc = this.getConnection()) != null) {
            mc.setDead(true);
            LOGGER.severe("managed connection " + mc + " marked dead", (Throwable)ex);
            return true;
        }
        return false;
    }

    private void setupIdSource() {
        if (!this.isRemote()) {
            if (this.idConfig != null) {
                this.setDefaultIdSource(IdSourceConfigurator.getInstance().configure(this, this.idConfig));
            } else {
                IdSource idSource = IdSourceConfigurator.getInstance().configure(this, null);
                this.setDefaultIdSource(idSource);
            }
        }
    }

    private PersistenceException handleConnectException(Exception e) {
        if (e instanceof RemoteException) {
            e = PersistenceException.createFromRemoteException((Object)this, (RemoteException)((RemoteException)e));
        }
        if (e instanceof LoginFailedException) {
            LOGGER.warning("remote login failed", (Throwable)e);
            return (LoginFailedException)e;
        }
        this.logException(LOGGER, Logger.Level.WARNING, "login failed", e);
        if (e instanceof PersistenceException) {
            return (PersistenceException)((Object)e);
        }
        return new PersistenceException((Session)this, "connection error", (Throwable)e);
    }

    public void open() {
        if (this.isOpen()) {
            throw new PersistenceException((Session)this, "session is already open");
        }
        if (this.getPoolId() == -1) {
            throw new PersistenceException((Session)this, "db was closed and removed from pool " + this.getPool() + ", cannot be re-opened");
        }
        try {
            if (this.isRemote()) {
                this.rcon = (RemoteDbConnection)Naming.lookup(this.backendInfo.getUrl());
                this.sessionInfo.checkServerVersionInfo(this.rcon.getServerVersionInfo());
                this.rses = this.rcon.login(this.sessionInfo);
                this.rdel = this.rses.getDbRemoteDelegate();
                this.conId = this.rdel.getSessionId();
            } else {
                this.conId = this.conMgr.login(this);
            }
            this.autoCommit = true;
            this.transaction = null;
            this.setupIdSource();
            this.sessionInfo.setSince(System.currentTimeMillis());
            this.alive = true;
            if (!this.isCloned()) {
                LOGGER.info("connection {0} established", new Object[]{this});
            }
            Db.registerDb(this);
        }
        catch (Exception e) {
            throw this.handleConnectException(e);
        }
    }

    public void clearPassword() {
        this.sessionInfo.clearPassword();
        this.backendInfo.clearPassword();
    }

    public boolean registerCloseHandler(SessionCloseHandler closeHandler) {
        return this.closeHandlers.add(closeHandler);
    }

    public boolean unregisterCloseHandler(SessionCloseHandler closeHandler) {
        return this.closeHandlers.remove(closeHandler);
    }

    public synchronized void close() {
        if (this.isOpen()) {
            try {
                for (SessionCloseHandler closeHandler : this.closeHandlers) {
                    try {
                        closeHandler.beforeClose((Session)this);
                    }
                    catch (Exception ex) {
                        LOGGER.warning("closehandler.beforeClose failed for " + this, (Throwable)ex);
                    }
                }
                for (SessionCloseHandler closeHandler : GLOBAL_CLOSE_HANDLERS) {
                    try {
                        closeHandler.beforeClose((Session)this);
                    }
                    catch (Exception ex) {
                        LOGGER.warning("global closehandler.beforeClose failed for " + this, (Throwable)ex);
                    }
                }
                if (this.isRemote()) {
                    if (this.rcon != null && this.rses != null) {
                        this.rcon.logout(this.rses);
                        LOGGER.info("remote db {0} closed", new Object[]{this});
                    }
                } else if (this.conId > 0) {
                    if (this.con != null) {
                        try {
                            this.con.closePreparedStatements(true);
                        }
                        catch (Exception ex) {
                            LOGGER.warning("closing prepared statements failed for " + this, (Throwable)ex);
                        }
                    }
                    this.conMgr.logout(this);
                    LOGGER.info("db {0} closed", new Object[]{this});
                }
                for (SessionCloseHandler closeHandler : this.closeHandlers) {
                    try {
                        closeHandler.afterClose((Session)this);
                    }
                    catch (Exception ex) {
                        LOGGER.warning("closehandler.afterClose failed for " + this, (Throwable)ex);
                    }
                }
                for (SessionCloseHandler closeHandler : GLOBAL_CLOSE_HANDLERS) {
                    try {
                        closeHandler.afterClose((Session)this);
                    }
                    catch (Exception ex) {
                        LOGGER.warning("global closehandler.afterClose failed for " + this, (Throwable)ex);
                    }
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Session)this, "closing db failed", (Throwable)e);
            }
            finally {
                Db.clearMembers(this);
                Db.unregisterDb(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                LOGGER.warning("closing unreferenced open db: " + this, new Object[0]);
            }
            this.close();
        }
        catch (Exception ex) {
            try {
                LOGGER.severe("closing unreferenced db '" + this + "' failed in finalizer", new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void setCrashed(boolean crashed) {
        this.crashed = crashed;
    }

    public synchronized boolean isCrashed() {
        return this.crashed;
    }

    public boolean isOpen() {
        if (this.isRemote()) {
            return this.rdel != null;
        }
        return this.conId > 0;
    }

    public long getTxNumber() {
        return this.transaction == null ? 0L : this.transaction.getTxNumber();
    }

    public String getTxName() {
        return this.transaction == null ? null : this.transaction.getTxName();
    }

    public int getTxLevel() {
        return this.transaction == null ? 0 : this.transaction.getTxLevel();
    }

    public void invalidateTxLevel() {
        if (this.transaction != null) {
            this.transaction.invalidateTxLevel();
        }
    }

    public boolean isTxLevelValid() {
        return this.transaction != null && this.transaction.isTxLevelValid();
    }

    public int getImmediateRollbackTxLevel() {
        return this.immediatelyRolledBack;
    }

    public int getImmediateCommitTxLevel() {
        return this.immediatelyCommitted;
    }

    public void setTxObject(AbstractDbObject<?> txObject) {
        this.assertTxRunning();
        this.transaction.setTxObject(txObject);
    }

    public AbstractDbObject<?> getTxObject() {
        this.assertTxRunning();
        return this.transaction.getTxObject();
    }

    public <T> T transaction(TransactionEnvelope<T> txe, String txName) {
        if (txName == null) {
            Method method = txe.getClass().getEnclosingMethod();
            if (method != null) {
                txName = ReflectionHelper.getClassBaseName(method.getDeclaringClass()) + "#" + method.getName();
            } else {
                txName = ReflectionHelper.getClassBaseName(txe.getClass());
                int ndx = txName.indexOf(36);
                if (ndx > 0) {
                    txName = txName.substring(0, ndx);
                }
            }
        }
        long txVoucher = this.begin(txName);
        try {
            Object rv = txe.run();
            this.commit(txVoucher);
            return (T)rv;
        }
        catch (RuntimeException ex) {
            try {
                this.rollback(txVoucher);
            }
            catch (RuntimeException rex) {
                LOGGER.severe("rollback failed", (Throwable)rex);
            }
            throw ex;
        }
    }

    public <T> T transaction(TransactionEnvelope<T> txe) {
        return this.transaction(txe, null);
    }

    public long begin(String txName) {
        DbTransaction tx = this.begin(txName, false);
        return tx != null ? tx.getTxVoucher() : 0L;
    }

    public long begin() {
        return this.begin(null);
    }

    /*
     * Unable to fully structure code
     */
    private DbTransaction begin(String txName, boolean fromRemote) {
        Db.LOGGER.finer("begin transaction requested on {0} from {1}, txName={2}", new Object[]{this, fromRemote != false ? "remote client" : "local", txName});
        this.assertOpen();
        this.assertOwnerThread();
        tx = null;
        if (this.isRemote()) {
            try {
                tx = this.rdel.begin(txName);
                if (tx == null) ** GOTO lbl25
                tx.setSession(this);
                this.autoCommit = false;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.alive = true;
            this.immediatelyRolledBack = 0;
            this.immediatelyCommitted = 0;
            if (this.setAutoCommit(false)) {
                this.assertNoTxRunning();
                this.modificationLogList = null;
                tx = this.transaction = new DbTransaction(this, txName, fromRemote);
            } else {
                this.assertTxRunning();
                this.transaction.incrementTxLevel();
            }
        }
lbl25:
        // 4 sources

        Db.LOGGER.fine("{0} {1}", new Object[]{this.transaction, tx != null ? " begun" : " already running"});
        return tx;
    }

    public boolean isClientTx() {
        this.assertTxRunning();
        return this.transaction.getTxVoucher() < 0L;
    }

    public void logBeginTx() {
        if (this.logModificationTxEnabled && this.logModificationTxId == 0L && this.isTxRunning()) {
            ModificationLog log = ModificationLogFactory.getInstance().createModificationLog(this, 'B');
            log.reserveId();
            log.setTxId(log.getId());
            log.saveObject();
            this.logModificationTxId = log.getTxId();
        }
    }

    public void logCommitTx() {
        if (this.logModificationTxId != 0L) {
            if (this.logModificationTxEnabled) {
                ModificationLogFactory.getInstance().createModificationLog(this, 'C').saveObject();
            }
            this.logModificationTxId = 0L;
        }
    }

    public int getUpdateCount() {
        return this.transaction == null ? 0 : this.transaction.getUpdateCount();
    }

    void addToUpdateCount(int count) {
        if (this.transaction != null) {
            this.transaction.addToUpdateCount(count);
        }
    }

    public DbTransactionHandle registerPersistenceVisitor(PersistenceVisitor visitor) {
        if (this.isRemote()) {
            try {
                return this.rdel.registerPersistenceVisitor(visitor);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.assertTxRunning();
        return this.transaction.registerPersistenceVisitor(visitor);
    }

    public PersistenceVisitor unregisterPersistenceVisitor(DbTransactionHandle handle) {
        if (this.isRemote()) {
            try {
                return this.rdel.unregisterPersistenceVisitor(handle);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.transaction != null ? this.transaction.unregisterPersistenceVisitor(handle) : null;
    }

    public Collection<PersistenceVisitor> getPersistenceVisitors() {
        if (this.isRemote()) {
            try {
                return this.rdel.getPersistenceVisitors();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.transaction != null ? this.transaction.getPersistenceVisitors() : null;
    }

    public boolean isPersistenceOperationAllowed(AbstractDbObject<?> object, char modType) {
        return this.transaction == null || this.transaction.isPersistenceOperationAllowed(object, modType);
    }

    public DbTransactionHandle registerCommitTxRunnable(CommitTxRunnable commitRunnable) {
        if (this.isRemote()) {
            try {
                return this.rdel.registerCommitTxRunnable(commitRunnable);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.assertTxRunning();
        return this.transaction.registerCommitTxRunnable(commitRunnable);
    }

    public CommitTxRunnable unregisterCommitTxRunnable(DbTransactionHandle handle) {
        if (this.isRemote()) {
            try {
                return this.rdel.unregisterCommitTxRunnable(handle);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.transaction != null ? this.transaction.unregisterCommitTxRunnable(handle) : null;
    }

    public Collection<CommitTxRunnable> getCommitTxRunnables() {
        if (this.isRemote()) {
            try {
                return this.rdel.getCommitTxRunnables();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.transaction != null ? this.transaction.getCommitTxRunnables() : null;
    }

    public DbTransactionHandle registerRollbackTxRunnable(RollbackTxRunnable rollbackRunnable) {
        if (this.isRemote()) {
            try {
                return this.rdel.registerRollbackTxRunnable(rollbackRunnable);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.assertTxRunning();
        return this.transaction.registerRollbackTxRunnable(rollbackRunnable);
    }

    public RollbackTxRunnable unregisterRollbackTxRunnable(DbTransactionHandle handle) {
        if (this.isRemote()) {
            try {
                return this.rdel.unregisterRollbackTxRunnable(handle);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.transaction != null ? this.transaction.unregisterRollbackTxRunnable(handle) : null;
    }

    public Collection<RollbackTxRunnable> getRollbackTxRunnables() {
        if (this.isRemote()) {
            try {
                return this.rdel.getRollbackTxRunnables();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.transaction != null ? this.transaction.getRollbackTxRunnables() : null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean commit(long txVoucher) {
        block7: {
            Db.LOGGER.finer("committing {0}", new Object[]{this.transaction});
            this.assertOpen();
            this.assertOwnerThread();
            committed = false;
            if (!this.isRemote()) break block7;
            try {
                committed = this.rdel.commit(txVoucher);
                if (!committed) ** GOTO lbl39
                this.transaction = null;
                this.autoCommit = true;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.alive = true;
        if (this.immediatelyCommitted > 0) {
            this.assertNoTxRunning();
            --this.immediatelyCommitted;
            if (this.immediatelyCommitted < 0) {
                Db.LOGGER.warning(this + ": too many commits after commitImmediately, ignored", new Object[0]);
            }
            return true;
        }
        this.assertTxRunning();
        if (txVoucher == 0L) ** GOTO lbl37
        if (!this.autoCommit) {
            this.logCommitTx();
            if (this.transaction.isTxLevelValid() && this.transaction.getTxLevel() != 1) {
                Db.LOGGER.warning(this + ": txLevel=" + this.transaction.getTxLevel() + ", should be 1", new Object[0]);
            }
            this.transaction.invokeCommitTxRunnables();
            this.setAutoCommit(true);
            this.logModificationDeferred = false;
            this.transaction = null;
            this.modificationLogList = null;
            committed = true;
        } else {
            throw new PersistenceException((Session)this, "transaction ended unexpectedly before commit (valid voucher)");
lbl37:
            // 1 sources

            this.transaction.decrementTxLevel();
        }
lbl39:
        // 4 sources

        Db.LOGGER.fine("{0} {1}", new Object[]{this.transaction, committed != false ? " committed" : " nesting level decremented"});
        return committed;
    }

    public boolean commitImmediately() {
        if (this.transaction != null) {
            int currentTxLevel = this.transaction.getTxLevel();
            if (!this.isRemote()) {
                this.immediatelyCommitted = 0;
                this.immediatelyRolledBack = 0;
            }
            this.transaction.invalidateTxLevel();
            if (!this.commit(this.transaction.getTxVoucher())) {
                throw new PersistenceException((Session)this, this.transaction + " not committed despite valid voucher");
            }
            this.transaction = null;
            LOGGER.warning("*** immediate commit for " + this + " ***", new Object[0]);
            if (!this.isRemote()) {
                this.immediatelyCommitted = currentTxLevel;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rollback(long txVoucher) {
        LOGGER.finer("rolling back {0}", new Object[]{this.transaction});
        this.assertOpen();
        this.assertOwnerThread();
        boolean rolledBack = false;
        if (this.isRemote()) {
            try {
                rolledBack = this.rdel.rollback(txVoucher);
                if (!rolledBack) return rolledBack;
                this.transaction = null;
                this.autoCommit = true;
                return rolledBack;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.alive = true;
            if (this.immediatelyRolledBack > 0) {
                this.assertNoTxRunning();
                --this.immediatelyRolledBack;
                if (this.immediatelyRolledBack < 0) {
                    LOGGER.warning(this + ": too many rollbacks after rollbackImmediately, ignored", new Object[0]);
                }
                LOGGER.fine("pending immediate rollback counter decremented -> no physical rollback", new Object[0]);
                return true;
            }
            if (this.transaction != null) {
                if (txVoucher != 0L) {
                    if (this.autoCommit) throw new PersistenceException((Session)this, "transaction ended unexpectedly before rollback (valid voucher)");
                    if (this.transaction.isTxLevelValid() && this.transaction.getTxLevel() != 1) {
                        LOGGER.warning(this + ": txLevel=" + this.transaction.getTxLevel() + ", should be 1", new Object[0]);
                    }
                    this.transaction.invokeRollbackTxRunnables();
                    if (this.con != null) {
                        this.con.rollback();
                        this.setAutoCommit(true);
                    } else {
                        LOGGER.warning("rollback too late: connection already detached", new Object[0]);
                        this.autoCommit = true;
                    }
                    this.logModificationDeferred = false;
                    this.modificationLogList = null;
                    this.logModificationTxId = 0L;
                    this.transaction = null;
                    rolledBack = true;
                    LOGGER.fine("{0} rolled back", new Object[]{this.transaction});
                    return rolledBack;
                } else {
                    this.transaction.decrementTxLevel();
                    LOGGER.fine("{0} nesting level decremented -> no physical rollback", new Object[]{this.transaction});
                }
                return rolledBack;
            } else {
                LOGGER.fine("no transaction running -> no physical rollback", new Object[0]);
            }
        }
        return rolledBack;
    }

    public boolean rollbackImmediately() {
        try {
            if (this.con != null) {
                this.con.cancelRunningStatements();
            }
            if (this.transaction != null) {
                int currentTxLevel = this.transaction.getTxLevel();
                if (!this.isRemote()) {
                    this.immediatelyCommitted = 0;
                    this.immediatelyRolledBack = 0;
                }
                this.transaction.invalidateTxLevel();
                if (!this.rollback(this.transaction.getTxVoucher())) {
                    throw new PersistenceException((Session)this, this.transaction + " not rolled back despite valid voucher");
                }
                this.transaction = null;
                LOGGER.warning("*** immediate rollback for " + this + " ***", new Object[0]);
                if (!this.isRemote()) {
                    this.immediatelyRolledBack = currentTxLevel;
                }
                return true;
            }
            this.forceDetached();
            return false;
        }
        catch (RuntimeException rex) {
            if (this.con != null && !this.con.isClosed()) {
                boolean connectionInTransaction;
                try {
                    connectionInTransaction = this.con.getConnection().getAutoCommit();
                }
                catch (SQLException ex) {
                    LOGGER.warning("cannot determine transaction state of " + this.con + ": assume transaction still running", (Throwable)ex);
                    connectionInTransaction = true;
                }
                if (connectionInTransaction) {
                    LOGGER.warning(this.con + " still in transaction: performing low-level rollback", new Object[0]);
                    try {
                        this.con.getConnection().rollback();
                        this.con.getConnection().setAutoCommit(true);
                    }
                    catch (SQLException ex) {
                        LOGGER.warning("low-level connection rollback failed for " + this.con, (Throwable)ex);
                    }
                    try {
                        this.con.logAndClearWarnings();
                    }
                    catch (PersistenceException ex) {
                        LOGGER.warning("clear warnings failed for " + this.con, (Throwable)ex);
                    }
                }
                this.con.setDead(true);
                LOGGER.warning("connection " + this.con + " marked dead", new Object[0]);
            }
            this.handleExceptionForScavenger(rex);
            return this.transaction != null;
        }
    }

    synchronized void setConnection(ManagedConnection con) {
        this.con = con;
    }

    synchronized ManagedConnection getConnection() {
        return this.con;
    }

    public synchronized void forceDetached() {
        if (this.con != null) {
            this.conMgr.forceDetach(this);
        }
    }

    public int getSessionId() {
        return this.conId;
    }

    public void setSessionGroupId(int number) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.rdel.setSessionGroupId(number);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        if (number != this.groupConId) {
            if (number != 0) {
                LOGGER.info("{0} joined group {1}", new Object[]{this, number});
            } else {
                LOGGER.info("{0} removed from group {1}", new Object[]{this, this.groupConId});
            }
        }
        this.groupConId = number;
    }

    public int getSessionGroupId() {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                return this.rdel.getSessionGroupId();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.groupConId;
    }

    public int groupWith(int sessionId) {
        if (sessionId <= 0) {
            throw new PersistenceException((Session)this, "invalid session id " + sessionId);
        }
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.groupConId = this.rdel.groupWith(sessionId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            if (this.groupConId > 0 && sessionId != this.groupConId) {
                throw new PersistenceException((Session)this, "session to join group " + sessionId + " already belongs to group " + this.groupConId);
            }
            this.setSessionGroupId(sessionId);
            for (WeakReference<Db> dbRef : DB_SET) {
                Db db = (Db)dbRef.get();
                if (db == null || db.conId != sessionId) continue;
                if (db.groupConId > 0 && sessionId != db.groupConId) {
                    throw new PersistenceException((Session)db, "session already belongs to group " + db.groupConId);
                }
                db.setSessionGroupId(sessionId);
                break;
            }
        }
        return this.groupConId;
    }

    synchronized void attach() {
        this.assertOpen();
        this.assertOwnerThread();
        if (this.conMgr == null) {
            throw new PersistenceException((Session)this, "no connection manager");
        }
        if (this.isPooled() && this.getPoolId() == 0) {
            throw new PersistenceException((Session)this, "illegal attempt to attach a pooled Db which is not in use");
        }
        this.conMgr.attach(this);
    }

    synchronized void detach() {
        if (this.conId > 0) {
            this.assertOwnerThread();
            this.conMgr.detach(this);
        }
    }

    public void setOwnerThread(Thread ownerThread) {
        this.ownerThread = ownerThread;
    }

    public Thread getOwnerThread() {
        return this.ownerThread;
    }

    public StatementWrapper createStatement(int resultSetType, int resultSetConcurrency) {
        this.assertNotRemote();
        this.attach();
        StatementWrapper stmt = this.con.createStatement(resultSetType, resultSetConcurrency);
        stmt.markReady();
        return stmt;
    }

    public StatementWrapper createStatement(int resultSetType) {
        return this.createStatement(resultSetType, 1007);
    }

    public StatementWrapper createStatement() {
        return this.createStatement(1003);
    }

    public synchronized PreparedStatementWrapper getPreparedStatement(StatementKey stmtKey, boolean alwaysPrepare, int resultSetType, int resultSetConcurrency, Supplier<String> sqlSupplier) {
        this.assertNotRemote();
        this.attach();
        PreparedStatementWrapper stmt = this.con.getPreparedStatement(stmtKey, alwaysPrepare, resultSetType, resultSetConcurrency, sqlSupplier);
        stmt.markReady();
        return stmt;
    }

    public PreparedStatementWrapper getPreparedStatement(StatementKey stmtKey, boolean alwaysPrepare, Supplier<String> sqlSupplier) {
        return this.getPreparedStatement(stmtKey, alwaysPrepare, 1003, 1007, sqlSupplier);
    }

    public synchronized PreparedStatementWrapper createPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) {
        this.assertNotRemote();
        this.attach();
        PreparedStatementWrapper stmt = this.con.createPreparedStatement(null, sql, resultSetType, resultSetConcurrency);
        stmt.markReady();
        return stmt;
    }

    public PreparedStatementWrapper createPreparedStatement(String sql) {
        return this.createPreparedStatement(sql, 1003, 1007);
    }

    private boolean setAutoCommit(boolean autoCommit) {
        if (this.autoCommit != autoCommit) {
            if (autoCommit && this.getBackend().sqlRequiresExtraCommit()) {
                this.con.commit();
            }
            if (!autoCommit) {
                this.attach();
            }
            this.con.setAutoCommit(autoCommit);
            if (autoCommit) {
                this.detach();
            }
            this.autoCommit = autoCommit;
            LOGGER.finest("physically setAutoCommit({0})", new Object[]{autoCommit});
            return !autoCommit;
        }
        return autoCommit;
    }

    public boolean isTxRunning() {
        return !this.autoCommit;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public BackendInfo getBackendInfo() {
        return this.backendInfo;
    }

    public String getUrl() {
        return this.backendInfo.getUrl();
    }

    private static void clearMembers(Db db) {
        if (db.isRemote()) {
            db.rdel = null;
            db.rses = null;
            db.rcon = null;
            db.delegates = null;
        } else {
            db.defaultIdSource = null;
            db.transaction = null;
        }
        db.groupConId = 0;
        db.conId = 0;
        db.ownerThread = null;
        if (db.sessionInfo != null && !db.sessionInfo.isImmutable()) {
            db.sessionInfo.setSince(0L);
        }
    }

    public Db clone() {
        try {
            Db newDb = (Db)super.clone();
            if (this.sessionInfo != null) {
                newDb.setSessionInfo(this.sessionInfo.clone());
            }
            Db.clearMembers(newDb);
            newDb.instanceNumber = INSTANCE_COUNTER.incrementAndGet();
            newDb.clonedFromDb = this;
            if (this.isRemote()) {
                newDb.open();
            } else if (this.isOpen()) {
                if (newDb.sessionInfo != null) {
                    newDb.getSessionInfo().setSince(System.currentTimeMillis());
                }
                newDb.conId = this.conMgr.login(newDb);
                newDb.autoCommit = true;
                newDb.transaction = null;
                newDb.setupIdSource();
            }
            LOGGER.info("connection {0} cloned from {1}, state={2}", new Object[]{newDb, this, newDb.isOpen() ? "open" : "closed"});
            Db.registerDb(newDb);
            return newDb;
        }
        catch (Exception e) {
            throw this.handleConnectException(e);
        }
    }

    public Db getClonedFromDb() {
        return this.clonedFromDb;
    }

    public void clearCloned() {
        this.clonedFromDb = null;
    }

    public boolean isCloned() {
        return this.clonedFromDb != null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean isRemote() {
        return this.backendInfo.isRemote();
    }

    public RemoteSession getRemoteSession() {
        this.assertRemote();
        return RemoteSessionFactory.getInstance().create(this.rses);
    }

    public static synchronized int prepareRemoteDelegate(Class<?> clazz) {
        if (remoteClasses == null) {
            remoteClasses = new Class[16];
        }
        if (nextDelegateId >= remoteClasses.length) {
            Class<?>[] old = remoteClasses;
            remoteClasses = new Class[old.length << 1];
            System.arraycopy(old, 0, remoteClasses, 0, old.length);
        }
        Db.remoteClasses[Db.nextDelegateId++] = clazz;
        return nextDelegateId;
    }

    public RemoteDelegate getRemoteDelegate(int delegateId) {
        this.assertRemote();
        if (--delegateId < 0 || delegateId >= remoteClasses.length) {
            throw new PersistenceException((Session)this, "delegate handle out of range");
        }
        if (this.delegates == null) {
            this.delegates = new RemoteDelegate[remoteClasses.length];
            for (int i = 0; i < this.delegates.length; ++i) {
                this.delegates[i] = null;
            }
        }
        if (delegateId >= this.delegates.length) {
            RemoteDelegate[] old = this.delegates;
            this.delegates = new RemoteDelegate[remoteClasses.length];
            System.arraycopy(old, 0, this.delegates, 0, old.length);
            for (int i = old.length; i < this.delegates.length; ++i) {
                this.delegates[i] = null;
            }
        }
        if (this.delegates[delegateId] == null) {
            try {
                RemoteDelegate delegate;
                this.delegates[delegateId] = delegate = this.rses.getRemoteDelegate(remoteClasses[delegateId].getName());
                return delegate;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.delegates[delegateId];
    }

    public RemoteDelegate createRemoteDelegate(String className) throws RemoteException {
        this.assertOpen();
        return this.rses.getRemoteDelegate(className);
    }

    public boolean isCountModificationAllowed() {
        return this.countModificationAllowed;
    }

    public void setCountModificationAllowed(boolean countModificationAllowed) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.rdel.setCountModificationAllowed(countModificationAllowed);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.countModificationAllowed = countModificationAllowed;
    }

    public void setLogModificationAllowed(boolean logModificationAllowed) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.rdel.setLogModificationAllowed(logModificationAllowed);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.logModificationAllowed = logModificationAllowed;
    }

    public boolean isLogModificationAllowed() {
        return this.logModificationAllowed;
    }

    public void setLogModificationDeferred(boolean logModificationDeferred) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.logModificationDeferred = this.rdel.setLogModificationDeferred(logModificationDeferred);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            if (this.logModificationDeferred != logModificationDeferred && this.isTxRunning() && this.modificationLogList != null && !this.modificationLogList.isEmpty()) {
                if (logModificationDeferred) {
                    for (ModificationLog log : this.modificationLogList) {
                        log.deleteObject();
                        log.unmarkDeleted();
                    }
                } else {
                    return;
                }
            }
            this.logModificationDeferred = logModificationDeferred;
        }
    }

    public boolean isLogModificationDeferred() {
        return this.logModificationDeferred;
    }

    public void pushModificationLogOfTransaction(ModificationLog log) {
        if (this.modificationLogList == null) {
            this.modificationLogList = new ArrayList<ModificationLog>();
        }
        this.modificationLogList.add(log);
    }

    public List<ModificationLog> popModificationLogsOfTransaction() {
        this.assertOpen();
        List<ModificationLog> list = this.modificationLogList;
        if (this.isRemote()) {
            try {
                list = this.rdel.popModificationLogsOfTransaction();
                this.applyTo(list);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.modificationLogList = null;
        }
        return list;
    }

    public IdSource getDefaultIdSource() {
        return this.defaultIdSource;
    }

    public void setDefaultIdSource(IdSource idSource) {
        this.defaultIdSource = idSource;
    }

    public long getLogModificationTxId() {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                return this.rdel.getLogModificationTxId();
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return this.logModificationTxId;
    }

    public void setLogModificationTxId(long logModificationTxId) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.rdel.setLogModificationTxId(logModificationTxId);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.logModificationTxId = logModificationTxId;
        }
    }

    public boolean isLogModificationTxEnabled() {
        return this.logModificationTxEnabled;
    }

    public void setLogModificationTxEnabled(boolean logModificationTxEnabled) {
        this.assertOpen();
        if (this.isRemote()) {
            try {
                this.rdel.setLogModificationTxEnabled(logModificationTxEnabled);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.logModificationTxEnabled = logModificationTxEnabled;
    }

    public Backend getBackend() {
        return this.backendInfo.getBackend();
    }

    public String getRemoteName() {
        this.assertRemote();
        try {
            return this.getRemoteDbSession().getServerName();
        }
        catch (RemoteException re) {
            throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)re);
        }
    }
}

