/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Session;
import org.tentackle.persist.Db;
import org.tentackle.persist.IdSource;
import org.tentackle.persist.IdSourceException;

public abstract class AbstractIdSource
implements IdSource {
    private final String name;

    public AbstractIdSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected void assertDbNotRemote(Db db) {
        if (db.isRemote()) {
            throw new IdSourceException(db, "remote Db not allowed");
        }
    }

    protected void assertOneRowAffected(Db db, int rowCount) {
        if (rowCount != 1) {
            throw new PersistenceException((Session)db, "unexpected number of rows affected: " + rowCount);
        }
    }
}

