/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo.rmi;

import java.rmi.RemoteException;
import java.util.List;
import org.tentackle.common.Timestamp;
import org.tentackle.misc.IdSerialTuple;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.pdo.AbstractPersistentObject;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObject;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.TokenLock;
import org.tentackle.pdo.rmi.AbstractPersistentObjectRemoteDelegate;
import org.tentackle.persist.rmi.AbstractDbObjectRemoteDelegateImpl;
import org.tentackle.persist.rmi.DbObjectResult;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.persist.rmi.RemoteResultSetCursor;
import org.tentackle.persist.rmi.RemoteResultSetCursorImpl;

public class AbstractPersistentObjectRemoteDelegateImpl<T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>>
extends AbstractDbObjectRemoteDelegateImpl<P>
implements AbstractPersistentObjectRemoteDelegate<T, P> {
    private static final long serialVersionUID = 3420107982404335392L;
    private static final String ILLEGAL_METHOD_TEXT = "remote method not allowed for PDOs";
    protected final Class<T> pdoClass;
    protected T pdo;

    public AbstractPersistentObjectRemoteDelegateImpl(RemoteDbSessionImpl serverSession, Class<P> persistenceClass, Class<T> pdoClass) throws RemoteException {
        super(serverSession, persistenceClass);
        this.pdoClass = pdoClass;
    }

    @Override
    public void initialize() {
        try {
            this.pdo = this.newInstance(Pdo.createDomainContext((Session)this.getSession()));
        }
        catch (RuntimeException e) {
            this.pdo = this.newInstance(null);
        }
        this.dbObject = (AbstractPersistentObject)this.pdo.getPersistenceDelegate();
    }

    protected T newInstance(DomainContext context) {
        if (context != null) {
            context.setSession((Session)this.getSession());
        }
        PersistentDomainObject newPdo = context == null ? Pdo.create(this.pdoClass, (Session)this.getSession()) : Pdo.create(this.pdoClass, (DomainContext)context);
        ((AbstractPersistentObject)newPdo.getPersistenceDelegate()).setOverloadable(true);
        return (T)newPdo;
    }

    protected void setDomainContext(DomainContext context) {
        if (context != null) {
            context.setSession((Session)this.getSession());
        }
        ((AbstractPersistentObject)this.dbObject).setDomainContext(context);
    }

    @Override
    public P selectObject(long id) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public P selectLockedObject(long id) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public List<? extends P> selectAllObjects() throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public void dummyUpdate(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public void updateSerial(long id, long serial) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public void updateSerialAndTableSerial(long id, long serial, long tableSerial) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public void updatePlain(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public void deletePlain(long id, long serial) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public void insertPlain(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public DbObjectResult updateObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public DbObjectResult insertObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public DbObjectResult deleteObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public P persistObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public DbObjectResult saveObject(P obj) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public boolean isReferenced(long id) throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public List<IdSerialTuple> selectAllIdSerial() throws RemoteException {
        throw new RemoteException(ILLEGAL_METHOD_TEXT);
    }

    @Override
    public T persistImpl(T obj) throws RemoteException {
        try {
            obj.setSession((Session)this.getSession());
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            return po.persist();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public void saveImpl(T obj) throws RemoteException {
        try {
            obj.setSession((Session)this.getSession());
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            po.save();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public void deleteImpl(T obj) throws RemoteException {
        try {
            obj.setSession((Session)this.getSession());
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            po.delete();
            po.markDeleted();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> selectAll(DomainContext cb) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return ((AbstractPersistentObject)this.dbObject).selectAll();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public T select(DomainContext cb, long id, boolean locked) throws RemoteException {
        try {
            return ((AbstractPersistentObject)this.newInstance(cb).getPersistenceDelegate()).select(id, locked);
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> selectByNormText(DomainContext cb, String normText) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return ((AbstractPersistentObject)this.dbObject).selectByNormText(normText);
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public RemoteResultSetCursor<T> selectByNormTextAsCursor(DomainContext cb, String normText) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return this.createRemoteResultSetCursorDelegate(((AbstractPersistentObject)this.dbObject).selectByNormTextAsCursor(normText));
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public List<T> selectAllForCache(DomainContext cb) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return ((AbstractPersistentObject)this.dbObject).selectAllCached();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public T selectForCache(DomainContext cb, long id) throws RemoteException {
        try {
            return ((AbstractPersistentObject)this.newInstance(cb).getPersistenceDelegate()).selectCached(id);
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public RemoteResultSetCursor<T> selectAllAsCursor(DomainContext cb) throws RemoteException {
        try {
            this.setDomainContext(cb);
            ((AbstractPersistentObject)this.dbObject).assertRootEntity();
            return this.createRemoteResultSetCursorDelegate(((AbstractPersistentObject)this.dbObject).selectAllAsCursor());
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public boolean isReferenced(DomainContext cb, long id) throws RemoteException {
        try {
            return this.newInstance(cb).select(id).isReferenced();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public TokenLock updateTokenLock(long id, Timestamp tokenExpiry, long userId, Timestamp curTime) throws RemoteException {
        try {
            ((AbstractPersistentObject)this.dbObject).setId(id);
            ((AbstractPersistentObject)this.dbObject).updateTokenLock(tokenExpiry, userId, curTime);
            return new TokenLock((PersistentObject)this.dbObject);
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public T transferTokenLock(T pdo, long userId) throws RemoteException {
        try {
            return (T)pdo.transferTokenLock(userId);
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    @Override
    public void updateTokenLockOnly(long id, long editedBy, Timestamp editedSince, Timestamp editedExpiry) throws RemoteException {
        try {
            ((AbstractPersistentObject)this.dbObject).setId(id);
            ((AbstractPersistentObject)this.dbObject).setEditedBy(editedBy);
            ((AbstractPersistentObject)this.dbObject).setEditedSince(editedSince);
            ((AbstractPersistentObject)this.dbObject).setEditedExpiry(editedExpiry);
            ((AbstractPersistentObject)this.dbObject).updateTokenLockOnly();
        }
        catch (Exception e) {
            throw this.createException(e);
        }
    }

    public RemoteResultSetCursor<T> createRemoteResultSetCursorDelegate(ScrollableResource<T> cursor) throws RemoteException {
        try {
            RemoteResultSetCursor cursorDelegate = this.getServerSession().createRemoteDelegate(RemoteResultSetCursor.class, RemoteResultSetCursorImpl.class, this.pdoClass, null, cursor);
            this.getServerSession().exportRemoteDelegate(cursorDelegate);
            return cursorDelegate;
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }
}

