/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo;

import java.util.Collection;
import java.util.List;
import org.tentackle.pdo.AbstractPersistentObject;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Join;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.DbObjectClassVariables;
import org.tentackle.persist.StatementId;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.pdo.SecurityPersistenceImpl;

public class PersistentObjectClassVariables<T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>>
extends DbObjectClassVariables<P> {
    public static final String PROPERTY_CHECKSECURITY = "checksecurity";
    public static final String CLASSVARIABLES_NAME = "CLASSVARIABLES";
    public final Class<T> pdoClass;
    public final List<Join<T, ?>> eagerJoins;
    public final String pdoClassBaseName;
    public String tableAlias;
    public final PersistentObjectClassVariables<? super T, ? super P> superClassVariables;
    public PersistentObjectClassVariables<? super T, ? super P> topSuperClassVariables;
    public boolean checkSecurity;
    public final StatementId selectByNormTextStatementId = new StatementId();
    public final StatementId selectAllStatementId = new StatementId();
    public final StatementId selectByNormTextCursorStatementId = new StatementId();
    public final StatementId selectAllCursorStatementId = new StatementId();
    public final StatementId updateTokenLockStatementId = new StatementId();
    public final StatementId updateTokenLockOnlyStatementId = new StatementId();
    public final StatementId selectTokenLockStatementId = new StatementId();
    public final StatementId transferTokenLockStatementId = new StatementId();
    private String effectiveTableName;
    private String effectiveTableAlias;

    public PersistentObjectClassVariables(Class<T> pdoClass, Class<P> poClass, String tableAlias, PersistentObjectClassVariables<? super T, ? super P> superClassVariables, List<Join<T, ?>> eagerJoins) {
        super(poClass, PdoUtilities.getInstance().determineClassId(pdoClass), PdoUtilities.getInstance().determineTablename(pdoClass));
        this.pdoClass = pdoClass;
        this.tableAlias = tableAlias;
        this.superClassVariables = superClassVariables;
        this.eagerJoins = eagerJoins;
        this.pdoClassBaseName = ReflectionHelper.getClassBaseName(this.pdoClass);
        this.loadMoreProperties();
    }

    public PersistentObjectClassVariables(Class<T> pdoClass, Class<P> poClass, String alias) {
        this(pdoClass, poClass, alias, null, null);
    }

    public List<Join<T, ?>> getEagerJoins() {
        return this.eagerJoins;
    }

    public String getTableName() {
        if (this.effectiveTableName == null) {
            this.effectiveTableName = this.tableName;
            if (this.effectiveTableName == null) {
                PersistentObjectClassVariables<? super T, ? super P> superCV = this.superClassVariables;
                while (superCV != null) {
                    this.effectiveTableName = superCV.tableName;
                    if (this.effectiveTableName != null) break;
                    superCV = superCV.superClassVariables;
                }
            }
        }
        return this.effectiveTableName;
    }

    public String getTableAlias() {
        if (this.effectiveTableAlias == null) {
            this.effectiveTableAlias = this.tableAlias;
            if (this.effectiveTableAlias == null) {
                PersistentObjectClassVariables<? super T, ? super P> superCV = this.superClassVariables;
                while (superCV != null) {
                    this.effectiveTableAlias = superCV.tableAlias;
                    if (this.effectiveTableAlias != null) break;
                    superCV = superCV.superClassVariables;
                }
            }
        }
        return this.effectiveTableAlias;
    }

    public String getColumnName(String name) {
        StringBuilder buf = new StringBuilder();
        String alias = this.getTableAlias();
        if (alias != null) {
            buf.append(alias).append('.');
        }
        buf.append(name);
        return buf.toString();
    }

    public PersistentObjectClassVariables<? super T, ? super P> getTopSuperClassVariables() {
        if (this.topSuperClassVariables == null) {
            this.topSuperClassVariables = this;
            while (this.topSuperClassVariables.superClassVariables != null) {
                this.topSuperClassVariables = this.topSuperClassVariables.superClassVariables;
            }
        }
        return this.topSuperClassVariables;
    }

    protected void loadMoreProperties() {
        String prop = this.getProperty(PROPERTY_CHECKSECURITY);
        this.checkSecurity = prop != null ? !prop.equals("no") && !prop.equals("off") && !prop.equals("false") && !prop.equals("disabled") && !prop.equals("0") : true;
    }

    @Override
    public boolean isReferenced(Db db, long id) {
        PersistentObjectClassVariables<T, P> cv = this;
        boolean referenced = false;
        while (!referenced && cv != null) {
            referenced = cv.isReferencedImpl(db, id, cv.foreignReferences);
            cv = cv.superClassVariables;
        }
        return referenced;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.pdoClass.getName());
        buf.append("/").append(super.toString());
        if (!this.checkSecurity) {
            buf.append("/*NOSECURITY*");
        }
        return buf.toString();
    }

    public boolean isAbstract() {
        return this.classId == 0;
    }

    public boolean isReadAllowed(DomainContext context) {
        return this.clazz.isAssignableFrom(SecurityPersistenceImpl.class) || this.checkClassPermission(context, (Permission)SecurityFactory.getInstance().getReadPermission());
    }

    public boolean isReadAllowed() {
        return this.clazz.isAssignableFrom(SecurityPersistenceImpl.class) || this.checkClassPermission(null, (Permission)SecurityFactory.getInstance().getReadPermission());
    }

    public boolean isWriteAllowed(DomainContext context) {
        return this.checkClassPermission(context, (Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isWriteAllowed() {
        return this.checkClassPermission(null, (Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isReadAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.checkSecurity || !object.isRootEntity() || object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getReadPermission());
    }

    public boolean isWriteAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.checkSecurity || !object.isRootEntity() || object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getWritePermission());
    }

    public boolean isViewAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.checkSecurity || !object.isRootEntity() || object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getViewPermission());
    }

    public boolean isEditAllowed(AbstractPersistentObject<?, ?> object) {
        return !this.checkSecurity || !object.isRootEntity() || object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getEditPermission());
    }

    public <T extends AbstractPersistentObject<?, ?>, C extends Collection<T>> C isReadAllowed(C objects) {
        if (this.checkSecurity && objects != null && !this.clazz.isAssignableFrom(SecurityPersistenceImpl.class)) {
            try {
                Collection newObjects = (Collection)objects.getClass().newInstance();
                for (AbstractPersistentObject object : objects) {
                    if (!object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getReadPermission())) continue;
                    newObjects.add(object);
                }
                objects = newObjects;
            }
            catch (Exception ex) {
                throw new PersistenceException("can't instantiate collection for checking read security rules", (Throwable)ex);
            }
        }
        return objects;
    }

    public <T extends AbstractPersistentObject<?, ?>, C extends Collection<T>> C isWriteAllowed(C objects) {
        if (this.checkSecurity && objects != null) {
            try {
                Collection newObjects = (Collection)objects.getClass().newInstance();
                for (AbstractPersistentObject object : objects) {
                    if (!object.isPermissionAccepted((Permission)SecurityFactory.getInstance().getWritePermission())) continue;
                    newObjects.add(object);
                }
                objects = newObjects;
            }
            catch (Exception ex) {
                throw new PersistenceException("can't instantiate collection for checking write security rules", (Throwable)ex);
            }
        }
        return objects;
    }

    @Override
    protected int determineReferencePriority(Class<? extends AbstractDbObject<?>> clazz) {
        PdoCache cache = Pdo.getPdoCache(clazz);
        if (cache != null) {
            return cache.isPreloading() ? 1 : 2;
        }
        return 3;
    }

    protected boolean checkClassPermission(DomainContext context, Permission permission) {
        try {
            return !this.checkSecurity || SecurityFactory.getInstance().getSecurityManager().evaluate(context, permission, this.classId, 0L).isAccepted();
        }
        catch (Exception ex) {
            return false;
        }
    }
}

