/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.tentackle.pdo.AbstractPersistentObject;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.sql.JoinType;

public class Join<T extends PersistentDomainObject<T>, J extends PersistentDomainObject<J>> {
    private static final String ENDS_WITH_ID = ".id";
    private final JoinType type;
    private final String columnName;
    private final String joinedColumnName;
    private final Class<J> joinedClass;
    private final String joinAlias;
    private final BiConsumer<T, J> joiner;
    private final Map<Long, Set<Long>> idMap;
    private final boolean listJoin;
    private final boolean explicitIdAliasRequired;
    private J lastJoinedPdo;

    public Join(JoinType type, String columnName, String joinedColumnName, Class<J> joinedClass, String joinAlias, BiConsumer<T, J> joiner) {
        this.type = type;
        this.columnName = columnName;
        this.joinedColumnName = joinedColumnName;
        this.joinedClass = joinedClass;
        this.joinAlias = joinAlias;
        this.joiner = joiner;
        this.idMap = new HashMap<Long, Set<Long>>();
        this.listJoin = columnName.endsWith(ENDS_WITH_ID);
        this.explicitIdAliasRequired = !this.listJoin && ((AbstractPersistentObject)Pdo.create(joinedClass).getPersistenceDelegate()).isExplicitIdAliasRequiredInJoins();
    }

    public JoinType getType() {
        return this.type;
    }

    public boolean isListJoin() {
        return this.listJoin;
    }

    public boolean isExplicitIdAliasRequired() {
        return this.explicitIdAliasRequired;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getJoinedColumnName() {
        return this.joinedColumnName;
    }

    public Class<J> getJoinedClass() {
        return this.joinedClass;
    }

    public String getJoinAlias() {
        return this.joinAlias;
    }

    public BiConsumer<T, J> getJoiner() {
        return this.joiner;
    }

    public void initialize() {
        this.lastJoinedPdo = null;
        this.idMap.clear();
    }

    public J createJoinedPdo(T pdo) {
        return (J)Pdo.create(this.joinedClass, (DomainContext)pdo.getDomainContext());
    }

    public void join(T pdo, J pdoToJoin) {
        this.lastJoinedPdo = pdoToJoin;
        if (pdoToJoin != null) {
            Long pdoId = pdo.getPersistenceDelegate().getId();
            Long pdoToJoinId = pdoToJoin.getPersistenceDelegate().getId();
            Set<Long> idSet = this.idMap.get(pdoId);
            if (idSet == null) {
                idSet = new HashSet<Long>();
                this.idMap.put(pdoId, idSet);
            }
            if (!idSet.contains(pdoToJoinId)) {
                this.joiner.accept(pdo, pdoToJoin);
                idSet.add(pdoToJoinId);
            }
        }
    }

    public J getLastJoinedPdo() {
        return this.lastJoinedPdo;
    }
}

