/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.tentackle.app.AbstractApplication;
import org.tentackle.misc.DateHelper;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.IdentifiableMap;
import org.tentackle.misc.ImmutableException;
import org.tentackle.misc.ScrollableResource;
import org.tentackle.misc.TrackedArrayList;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainDelegate;
import org.tentackle.pdo.Join;
import org.tentackle.pdo.JoinedSelect;
import org.tentackle.pdo.LockException;
import org.tentackle.pdo.NotFoundException;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Persistent;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObject;
import org.tentackle.pdo.PersistentObjectClassVariables;
import org.tentackle.pdo.Session;
import org.tentackle.pdo.SessionHolder;
import org.tentackle.pdo.TokenLock;
import org.tentackle.pdo.rmi.AbstractPersistentObjectRemoteDelegate;
import org.tentackle.persist.AbstractDbObject;
import org.tentackle.persist.Db;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetCursor;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.rmi.RemoteResultSetCursor;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityException;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.SecurityResult;
import org.tentackle.validate.ValidationFailedException;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.scope.ChangeableScope;
import org.tentackle.validate.scope.MandatoryScope;
import org.tentackle.validate.scope.PersistenceScope;

public abstract class AbstractPersistentObject<T extends PersistentDomainObject<T>, P extends AbstractPersistentObject<T, P>>
extends AbstractDbObject<P>
implements PersistentObject<T> {
    private static final long serialVersionUID = 1921941642168910515L;
    private transient boolean contextImmutable;
    private T pdo;
    private transient T copiedObject;
    private boolean persistable = true;
    @Persistent(value="userId of token lock holder")
    private long editedBy;
    @Persistent(value="time since token lock given to user")
    private org.tentackle.common.Timestamp editedSince;
    @Persistent(value="time when token lock expires")
    private org.tentackle.common.Timestamp editedExpiry;
    @Persistent(value="normalized text")
    private String normText;
    @Persistent(value="root entity id")
    private long rootId;
    @Persistent(value="root entity class id")
    private int rootClassId;
    private transient boolean validated;
    private boolean renewTokenLock;
    private transient long cacheAccessCount;
    private transient long cacheAccessTime;
    private transient boolean expired;
    private transient List<T> snapshots;
    private transient org.tentackle.common.Timestamp editedSinceSnapshot;
    private transient org.tentackle.common.Timestamp editedExpirySnapshot;
    protected transient boolean objectIsSnapshot;
    public static final String CN_EDITEDBY = "editedby";
    public static final String AN_EDITEDBY = "editedBy";
    public static final String CN_EDITEDEXPIRY = "editedexpiry";
    public static final String AN_EDITEDEXPIRY = "editedExpiry";
    public static final String CN_EDITEDSINCE = "editedsince";
    public static final String AN_EDITEDSINCE = "editedSince";
    public static final String CN_NORMTEXT = "normtext";
    public static final String AN_NORMTEXT = "normText";
    public static final String CN_ROOTID = "rootid";
    public static final String AN_ROOTID = "rootId";
    public static final String CN_ROOTCLASSID = "rootclassid";
    public static final String AN_ROOTCLASSID = "rootClassId";
    public static final String TX_SAVE_COPY_IN_CONTEXT = "save copy in context";
    public static final String TX_DELETE_ALL_IN_CONTEXT = "delete all in context";
    public static final String TX_TRANSFER_TOKENLOCK = "transfer token lock";

    public AbstractPersistentObject(T pdo, DomainContext context) {
        this.pdo = pdo;
        this.setDomainContext(context);
    }

    public AbstractPersistentObject(T pdo, Session session) {
        super((Db)session);
        this.pdo = pdo;
    }

    public AbstractPersistentObject(T pdo) {
        this.pdo = pdo;
    }

    public AbstractPersistentObject() {
    }

    public DomainDelegate<T> getDomainDelegate() {
        return this.pdo.getDomainDelegate();
    }

    public T getPdo() {
        return this.pdo;
    }

    public T pdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    @Override
    public P clone() {
        AbstractPersistentObject obj = (AbstractPersistentObject)super.clone();
        obj.setPdo(null);
        return (P)obj;
    }

    public PersistentObject<T> clonePersistentObject() {
        return this.clone();
    }

    protected Method findSnapshotMethod(String methodName, Class<?> clazz) throws NoSuchMethodException {
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, clazz);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (NoSuchMethodException ex) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public T createSnapshot() {
        PersistentDomainObject snapshot = this.getPdo().clonePdo();
        PersistentObject persistentSnapshot = snapshot.getPersistenceDelegate();
        Class<?> persistentClass = persistentSnapshot.getClass();
        try {
            Method createAttributesInSnapshotMethod = this.findSnapshotMethod("createAttributesInSnapshot", persistentClass);
            Method createComponentsInSnapshotMethod = this.findSnapshotMethod("createComponentsInSnapshot", persistentClass);
            createAttributesInSnapshotMethod.invoke((Object)this, persistentSnapshot);
            createComponentsInSnapshotMethod.invoke((Object)this, persistentSnapshot);
            this.addSnapshot(snapshot);
            return (T)snapshot;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new PersistenceException((Identifiable)this, "creating snapshot incorrectly implemented", (Throwable)ex);
        }
    }

    protected void createAttributesInSnapshot(AbstractPersistentObject snapshot) {
        snapshot.objectIsSnapshot = true;
        if (this.editedSince != null) {
            snapshot.editedSinceSnapshot = (org.tentackle.common.Timestamp)this.editedSince.clone();
        }
        if (this.editedExpiry != null) {
            snapshot.editedExpirySnapshot = (org.tentackle.common.Timestamp)this.editedExpiry.clone();
        }
    }

    protected void createComponentsInSnapshot(AbstractPersistentObject snapshot) {
    }

    public void revertToSnapshot(T snapshot) {
        if (snapshot != null) {
            this.assertValidSnapshot(snapshot);
            PersistentObject persistentSnapshot = snapshot.getPersistenceDelegate();
            Class<?> persistentClass = persistentSnapshot.getClass();
            try {
                Method revertAttributesToSnapshotMethod = this.findSnapshotMethod("revertAttributesToSnapshot", persistentClass);
                Method revertComponentsToSnapshotMethod = this.findSnapshotMethod("revertComponentsToSnapshot", persistentClass);
                revertAttributesToSnapshotMethod.invoke((Object)this, persistentSnapshot);
                revertComponentsToSnapshotMethod.invoke((Object)this, persistentSnapshot);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
                throw new PersistenceException((Identifiable)this, "reverting snapshot incorrectly implemented", (Throwable)ex);
            }
        }
    }

    protected void revertAttributesToSnapshot(AbstractPersistentObject snapshot) {
        super.revertAttributesToSnapshot(snapshot);
        this.contextImmutable = snapshot.contextImmutable;
        this.pdo = snapshot.pdo;
        this.copiedObject = snapshot.copiedObject;
        this.editedBy = snapshot.editedBy;
        this.editedSince = snapshot.editedSince;
        if (this.editedSince != null) {
            this.editedSince.setTime(snapshot.editedSinceSnapshot.getTime());
        }
        this.editedExpiry = snapshot.editedExpiry;
        if (this.editedExpiry != null) {
            this.editedExpiry.setTime(snapshot.editedExpirySnapshot.getTime());
        }
        this.renewTokenLock = snapshot.renewTokenLock;
        this.cacheAccessCount = snapshot.cacheAccessCount;
        this.cacheAccessTime = snapshot.cacheAccessTime;
        this.expired = snapshot.expired;
        this.snapshots = snapshot.snapshots;
        this.normText = snapshot.normText;
        this.validated = snapshot.validated;
    }

    protected void revertComponentsToSnapshot(AbstractPersistentObject snapshot) {
    }

    public boolean isSnapshot() {
        return this.objectIsSnapshot;
    }

    public List<T> getSnapshots() {
        return this.snapshots;
    }

    protected void addSnapshot(T snapshot) {
        if (this.snapshots == null) {
            this.snapshots = new ArrayList<T>();
        }
        if (this.snapshots.contains(snapshot)) {
            throw new PersistenceException((Identifiable)this, "snapshot already added");
        }
        this.snapshots.add(snapshot);
    }

    protected void assertValidSnapshot(T snapshot) {
        if (!snapshot.isSnapshot()) {
            throw new PersistenceException((Identifiable)this, "not a snapshot");
        }
        if (this.snapshots == null || !this.snapshots.contains(snapshot)) {
            throw new PersistenceException((Identifiable)this, "invalid snapshot");
        }
    }

    protected void assertNotCached() {
        if (this.isCached()) {
            throw new PersistenceException((Identifiable)this, "object is a cached");
        }
    }

    @Override
    protected void assertMutable() {
        super.assertMutable();
        if (this.isSnapshot()) {
            throw new PersistenceException((Identifiable)this, (Throwable)new ImmutableException("object is a snapshot"));
        }
    }

    @Override
    public boolean isPersistable() {
        return this.persistable && super.isPersistable() && this.getDomainContext() != null && !this.isAbstract();
    }

    public void setPersistable(boolean persistable) {
        this.persistable = persistable;
    }

    @Override
    protected void assertPersistable() {
        super.assertPersistable();
        this.assertMutable();
    }

    public boolean isRootEntity() {
        return false;
    }

    public boolean isRootIdProvided() {
        return false;
    }

    public long getRootId() {
        return this.rootId;
    }

    public void setRootId(long rootId) {
        this.rootId = rootId;
    }

    public boolean isRootClassIdProvided() {
        return false;
    }

    public int getRootClassId() {
        return this.rootClassId;
    }

    public void setRootClassId(int rootClassId) {
        this.rootClassId = rootClassId;
    }

    public boolean isNormTextProvided() {
        return false;
    }

    protected void assertNormTextProvided() {
        if (!this.isNormTextProvided()) {
            throw new PersistenceException((Identifiable)this, "entity does not provide a normtext column");
        }
    }

    public void setNormText(String normText) {
        this.assertMutable();
        if (!Objects.equals(this.normText, normText)) {
            this.setModified(true);
        }
        this.normText = normText;
    }

    public String getNormText() {
        return this.normText;
    }

    public boolean isDomainContextImmutable() {
        return this.contextImmutable;
    }

    public void setDomainContextImmutable(boolean contextImmutable) {
        this.contextImmutable = contextImmutable;
    }

    protected void assertDomainContextMutable() {
        if (this.isDomainContextImmutable()) {
            throw new PersistenceException((Identifiable)this, "domain context is immutable");
        }
    }

    public void setDomainContext(DomainContext context) {
        if (this.getDomainContext() != context) {
            if (context == null) {
                throw new IllegalArgumentException("domain context cannot be cleared to null");
            }
            this.assertDomainContextMutable();
            if (this.isRootEntity()) {
                this.setSessionHolder((SessionHolder)context.getRootContext(this.pdo));
            } else {
                this.setSessionHolder((SessionHolder)context);
            }
            this.determineContextId();
        }
    }

    public DomainContext getDomainContext() {
        return (DomainContext)this.getSessionHolder();
    }

    public void determineContextId() {
    }

    public long getContextId() {
        return -1L;
    }

    public String getSqlContextCondition() {
        return null;
    }

    public String getSqlClassIdCondition() {
        if (this.isClassIdRequiredInWhereClause()) {
            StringBuilder buf = new StringBuilder(" AND ");
            buf.append(this.getTopSuperTableAlias()).append('.').append("classid");
            buf.append("=?");
            return buf.toString();
        }
        return null;
    }

    public DomainContext getBaseContext() {
        return this.getDomainContext();
    }

    public DomainContext createValidContext() {
        Object session = Session.getCurrentSession();
        session = session != null ? null : this.getSession();
        return Pdo.createDomainContext((Session)session);
    }

    public PersistentObjectClassVariables<T, P> getClassVariables() {
        throw new PersistenceException((Identifiable)this, "classvariables undefined for " + this.getClass());
    }

    @Override
    public String getTableName() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).getTableName();
    }

    public String getTableAlias() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).getTableAlias();
    }

    public String getColumnName(String name) {
        return ((PersistentObjectClassVariables)this.getClassVariables()).getColumnName(name);
    }

    public String getTopSuperTableAlias() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).getTopSuperClassVariables().getTableAlias();
    }

    public String getTopSuperTableName() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).getTopSuperClassVariables().getTableName();
    }

    public Class<T> getPdoClass() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).pdoClass;
    }

    public boolean isAbstract() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).isAbstract();
    }

    public void assertNotAbstract() {
        if (this.isAbstract()) {
            throw new PersistenceException((Identifiable)this, "operation not allowed for abstract entities");
        }
    }

    public int getValidClassId() {
        this.assertNotAbstract();
        return super.getClassId();
    }

    public boolean isClassIdRequiredInWhereClause() {
        return false;
    }

    public boolean isExplicitIdAliasRequiredInJoins() {
        return false;
    }

    public boolean isComposite() {
        return false;
    }

    public IdentifiableMap<? extends PersistentDomainObject<?>> loadComponents(boolean onlyLoaded) {
        if (this.isComposite()) {
            throw new PersistenceException("method not implemented");
        }
        return new IdentifiableMap(this.getPdo());
    }

    public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, boolean onlyLoaded) {
        return components.add(this.getPdo()) == null ? 1 : 0;
    }

    public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, Collection<? extends PersistentDomainObject<?>> objects, boolean onlyLoaded) {
        int count = 0;
        for (PersistentDomainObject<?> object : objects) {
            count += ((AbstractPersistentObject)object.getPersistenceDelegate()).addComponents(components, onlyLoaded);
        }
        return count;
    }

    public void deletePlainWithComponents() {
        this.assertNotRemote();
        if (this.isComposite()) {
            throw new PersistenceException((Identifiable)this, "local part of the method not implemented");
        }
        this.deletePlain();
    }

    public int deletePlainWithComponents(Collection<? extends PersistentDomainObject<?>> objects) {
        int count = 0;
        if (objects != null && objects.size() > 0) {
            Session session = null;
            long txVoucher = 0L;
            try {
                for (PersistentDomainObject<?> obj : objects) {
                    if (obj == null) continue;
                    if (session == null) {
                        session = obj.getSession();
                        if (session == null) {
                            throw new PersistenceException(obj, "db is null");
                        }
                        txVoucher = session.begin("delete plain with components collection");
                    } else if (obj.getSession() != session) {
                        throw new PersistenceException(obj, "unexpected db connection: " + obj.getSession() + ", expected: " + session);
                    }
                    ((AbstractPersistentObject)obj.getPersistenceDelegate()).deletePlainWithComponents();
                    ++count;
                }
                if (session != null) {
                    session.commit(txVoucher);
                }
            }
            catch (RuntimeException rex) {
                if (session != null) {
                    session.rollback(txVoucher);
                }
                throw rex;
            }
        }
        return count;
    }

    public void insertPlainWithComponents() {
        this.assertNotRemote();
        if (this.isComposite()) {
            throw new PersistenceException((Identifiable)this, "local part of the method not implemented");
        }
        this.insertPlain();
    }

    public int insertPlainWithComponents(Collection<? extends PersistentDomainObject<?>> objects) {
        int count = 0;
        if (objects != null && objects.size() > 0) {
            Session session = null;
            long txVoucher = 0L;
            try {
                for (PersistentDomainObject<?> obj : objects) {
                    if (obj == null) continue;
                    if (session == null) {
                        session = obj.getSession();
                        if (session == null) {
                            throw new PersistenceException(obj, "db is null");
                        }
                        txVoucher = session.begin("insert plain with components collection");
                    } else if (obj.getSession() != session) {
                        throw new PersistenceException(obj, "unexpected db connection: " + obj.getSession() + ", expected: " + session);
                    }
                    ((AbstractPersistentObject)obj.getPersistenceDelegate()).insertPlainWithComponents();
                    ++count;
                }
                if (session != null) {
                    session.commit(txVoucher);
                }
            }
            catch (RuntimeException rex) {
                if (session != null) {
                    session.rollback(txVoucher);
                }
                throw rex;
            }
        }
        return count;
    }

    public T findDuplicate() {
        PersistentDomainObject otherPdo;
        T thisPdo = this.getPdo();
        Object key = thisPdo.getUniqueDomainKey();
        if (key != null && (otherPdo = thisPdo.findByUniqueDomainKey(key)) != null && !otherPdo.equals(thisPdo)) {
            return (T)otherPdo;
        }
        return null;
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public long getCacheAccessTime() {
        return this.cacheAccessTime;
    }

    public long getCacheAccessCount() {
        return this.cacheAccessCount;
    }

    public void markCacheAccess() {
        ++this.cacheAccessCount;
        this.cacheAccessTime = System.currentTimeMillis();
        this.editedBy = 0L;
    }

    public boolean isCached() {
        return this.cacheAccessCount > 0L;
    }

    public SecurityResult getSecurityResult(Permission permission) {
        return SecurityFactory.getInstance().getSecurityManager().evaluate(this.getBaseContext(), permission, this.getClassId(), this.getId());
    }

    public boolean isPermissionAccepted(Permission permission) {
        return this.getSecurityResult(permission).isAccepted();
    }

    public T createCopyInContext(DomainContext otherContext) {
        AbstractDbObject apo = this.clone();
        ((AbstractPersistentObject)apo).setDomainContext(otherContext);
        PersistentDomainObject obj = Pdo.create(this.getPdoClass(), (PersistentObject)apo);
        this.copiedObject = this.pdo;
        return (T)obj;
    }

    public T getCopiedObject() {
        return this.copiedObject;
    }

    public T saveCopyInContext(DomainContext otherContext) {
        long txVoucher = this.beginTx(TX_SAVE_COPY_IN_CONTEXT);
        try {
            T obj = this.createCopyInContext(otherContext);
            obj.save();
            this.getSession().commit(txVoucher);
            return obj;
        }
        catch (RuntimeException ex) {
            this.getSession().rollback(txVoucher);
            if (ex instanceof PersistenceException) {
                ((PersistenceException)((Object)ex)).updateDbObject((Identifiable)this);
                throw (PersistenceException)((Object)ex);
            }
            throw new PersistenceException((Identifiable)this, (Throwable)ex);
        }
    }

    public T selectByTemplate(AbstractPersistentObject<T, P> template) {
        return this.select(template.getId());
    }

    public T copy() {
        throw new PersistenceException((Identifiable)this, "not implemented (consider @wurblet PdoCopy)");
    }

    public JoinedSelect<T> getEagerJoinedSelect() {
        List eagerJoins = this.getEagerJoins();
        return eagerJoins != null && !eagerJoins.isEmpty() ? new JoinedSelect(eagerJoins) : null;
    }

    @Override
    public P readFromResultSetWrapper(ResultSetWrapper rs) {
        AbstractDbObject po = (AbstractPersistentObject)super.readFromResultSetWrapper(rs);
        if (po != null) {
            if (((AbstractPersistentObject)po).isAbstract()) {
                int classId = po.getClassId();
                if (classId == 0) {
                    throw new PersistenceException((Identifiable)po, "class id is 0 in " + po.toGenericString());
                }
                String className = PdoUtilities.getInstance().getPdoClassName(classId);
                if (className == null) {
                    throw new PersistenceException((Identifiable)po, "no such PDO class for classId " + classId + " in " + po.toGenericString());
                }
                po = (AbstractPersistentObject)Pdo.create((String)className, (DomainContext)this.getDomainContext()).getPersistenceDelegate();
                po = ((AbstractPersistentObject)po).readFromResultSetWrapper(rs);
            }
            if (po != null) {
                if (((AbstractPersistentObject)po).getContextId() >= 0L || ((AbstractPersistentObject)po).getDomainContext() == null) {
                    long domainContextId;
                    long l = domainContextId = ((AbstractPersistentObject)po).getDomainContext() == null ? -1L : ((AbstractPersistentObject)po).getDomainContext().getContextId();
                    if (domainContextId != ((AbstractPersistentObject)po).getContextId()) {
                        ((AbstractPersistentObject)po).setDomainContext(((AbstractPersistentObject)po).createValidContext());
                    }
                }
                if (!((AbstractPersistentObject)po).isReadAllowed()) {
                    po = null;
                }
            }
        }
        return (P)po;
    }

    public void executeQueryToList(PreparedStatementWrapper st, JoinedSelect<T> js, List<T> list) {
        this.assertRootContextIsAccepted();
        try (ResultSetWrapper rs = st.executeQuery();){
            this.executeQueryToList(rs, js, list);
        }
    }

    public void executeQueryToList(ResultSetWrapper rs, JoinedSelect<T> js, List<T> list) {
        if (js == null) {
            while (rs.next()) {
                AbstractDbObject nextPo = (AbstractPersistentObject)this.newInstance();
                if ((nextPo = ((AbstractPersistentObject)nextPo).readFromResultSetWrapper(rs)) == null) continue;
                PersistentDomainObject nextPdo = Pdo.create(((AbstractPersistentObject)nextPo).getPdoClass(), (PersistentObject)nextPo);
                if ((nextPdo = this.derivePdoFromPo(nextPdo, nextPo)) == null) continue;
                list.add(nextPdo);
            }
        } else {
            js.initialize(list);
            while (rs.next()) {
                this.readJoinedRow(rs, js);
            }
        }
    }

    public List<T> executeListQuery(PreparedStatementWrapper st, JoinedSelect<T> js) {
        ArrayList list = new ArrayList();
        this.executeQueryToList(st, js, list);
        return list;
    }

    public List<T> executeListQuery(PreparedStatementWrapper st) {
        return this.executeListQuery(st, null);
    }

    public TrackedList<T> executeTrackedListQuery(PreparedStatementWrapper st, JoinedSelect<T> js) {
        TrackedArrayList list = new TrackedArrayList();
        this.executeQueryToList(st, js, (List<T>)list);
        list.setModified(false);
        return list;
    }

    public TrackedList<T> executeTrackedListQuery(PreparedStatementWrapper st) {
        return this.executeTrackedListQuery(st, null);
    }

    public List<Join<? super T, ?>> getEagerJoins() {
        ArrayList eagerJoins = null;
        PersistentObjectClassVariables cv = this.getClassVariables();
        while (cv != null) {
            if (cv.eagerJoins != null && !cv.eagerJoins.isEmpty()) {
                if (eagerJoins == null) {
                    eagerJoins = new ArrayList();
                }
                eagerJoins.addAll(cv.eagerJoins);
            }
            cv = cv.superClassVariables;
        }
        return eagerJoins;
    }

    public void readJoinedRow(ResultSetWrapper rs, JoinedSelect<T> js) {
        rs.startSkip();
        AbstractDbObject nextPo = (AbstractPersistentObject)this.newInstance();
        nextPo = ((AbstractPersistentObject)nextPo).readFromResultSetWrapper(rs);
        if (nextPo != null) {
            PersistentDomainObject nextPdo;
            if (js.currentPdo() == null || js.currentPdo().getPersistenceDelegate().getId() != nextPo.getId()) {
                nextPdo = Pdo.create(((AbstractPersistentObject)nextPo).getPdoClass(), (PersistentObject)nextPo);
                PersistentDomainObject knownPdo = js.nextPdo(nextPdo = this.derivePdoFromPo(nextPdo, nextPo));
                if (knownPdo != nextPdo) {
                    nextPdo = knownPdo;
                    nextPo = (AbstractPersistentObject)nextPdo.getPersistenceDelegate();
                }
            } else {
                nextPdo = js.currentPdo();
            }
            rs.skip(nextPo.getColumnCount());
            for (Join<PersistentDomainObject, ?> join : js.getJoins()) {
                Object joinedPdo = join.createJoinedPdo(nextPdo);
                AbstractDbObject joinedPo = (AbstractPersistentObject)joinedPdo.getPersistenceDelegate();
                if (rs.getObject(rs.findColumn("id")) != null && (joinedPo = ((AbstractPersistentObject)joinedPo).readFromResultSetWrapper(rs)) != null && (join.getLastJoinedPdo() == null || join.getLastJoinedPdo().getPersistenceDelegate().getId() != joinedPo.getId())) {
                    joinedPdo = ((AbstractPersistentObject)joinedPo).derivePdoFromPo(joinedPdo, joinedPo);
                    join.join(nextPdo, joinedPdo);
                }
                int columnCount = joinedPo.getColumnCount();
                if (join.isExplicitIdAliasRequired()) {
                    ++columnCount;
                }
                rs.skip(columnCount);
            }
        }
    }

    public T executeFirstPdoQuery(PreparedStatementWrapper st, JoinedSelect<T> js) {
        this.assertRootContextIsAccepted();
        T pDo = null;
        try (ResultSetWrapper rs = st.executeQuery();){
            if (js == null) {
                if (rs.next()) {
                    AbstractDbObject po = this.readFromResultSetWrapper(rs);
                    pDo = this.derivePdoFromPo(this.pdo, po);
                }
            } else {
                js.initialize(null);
                while (pDo == null && rs.next()) {
                    this.readJoinedRow(rs, js);
                    pDo = js.getLastPdo();
                }
                if (pDo == null) {
                    pDo = js.currentPdo();
                }
            }
            T t = pDo;
            return t;
        }
    }

    public T executeFirstPdoQuery(PreparedStatementWrapper st) {
        return this.executeFirstPdoQuery(st, null);
    }

    public T select(long id, boolean locked) {
        T obj = null;
        if (id > 0L) {
            if (this.getSession().isRemote()) {
                try {
                    DomainContext context = this.getDomainContext();
                    obj = this.getRemoteDelegate().select(context, id, locked);
                    this.configureRemoteObject(context, obj);
                }
                catch (RemoteException e) {
                    throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
                }
            } else {
                JoinedSelect<T> js = this.getEagerJoinedSelect();
                PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).selectObjectStatementId, () -> {
                    StringBuilder sql = new StringBuilder(this.createSelectSql(locked));
                    if (js != null) {
                        js.createJoinedSql(this.pdo, sql);
                    }
                    return sql.toString();
                });
                int ndx = 1;
                if (js != null) {
                    ndx = js.setClassIdsInStatement(st, ndx);
                }
                st.setLong(ndx++, id);
                obj = this.executeFirstPdoQuery(st, js);
            }
        }
        return obj;
    }

    public T select(long id) {
        return this.select(id, false);
    }

    public T reload() {
        return (T)Pdo.create(this.getPdo()).select(this.getId());
    }

    public T reloadLocked() {
        return (T)Pdo.create(this.getPdo()).selectLocked(this.getId());
    }

    public T selectLocked(long id) {
        return this.select(id, true);
    }

    public T derivePdoFromPo(T pdo, P po) {
        if (po != null) {
            T derivedPdo;
            if (po == pdo.getPersistenceDelegate()) {
                derivedPdo = pdo;
            } else if (pdo.isAbstract()) {
                derivedPdo = ((AbstractPersistentObject)po).getPdo();
            } else {
                throw new PersistenceException((Identifiable)this, "misconfigured PDO inheritance");
            }
            DomainContext context = this.getDomainContext();
            if (((AbstractPersistentObject)po).isRootEntity()) {
                ((AbstractDbObject)po).setSessionHolder((SessionHolder)context.getRootContext(derivedPdo));
            } else if (((AbstractPersistentObject)po).getRootId() != 0L && ((AbstractPersistentObject)po).getRootId() != context.getRootId() || ((AbstractPersistentObject)po).getRootClassId() != 0 && ((AbstractPersistentObject)po).getRootClassId() != context.getRootClassId()) {
                if (((AbstractPersistentObject)po).getRootId() != 0L && ((AbstractPersistentObject)po).getRootClassId() != 0) {
                    SecurityResult sr = SecurityFactory.getInstance().getSecurityManager().evaluate(context, (Permission)SecurityFactory.getInstance().getReadPermission(), ((AbstractPersistentObject)po).getRootClassId(), ((AbstractPersistentObject)po).getRootId());
                    if (sr.isAccepted()) {
                        return derivedPdo;
                    }
                    throw new SecurityException(po, sr.explain("no read permission for root entity " + ((AbstractPersistentObject)po).getRootClassId() + "[" + ((AbstractPersistentObject)po).getRootId() + "]"));
                }
                throw new SecurityException(po, "unexpected root context " + context.getRootClassId() + "[" + context.getRootId() + "], expected " + ((AbstractPersistentObject)po).getRootClassId() + "[" + ((AbstractPersistentObject)po).getRootId() + "]");
            }
            return derivedPdo;
        }
        return null;
    }

    public void assertRootContextIsAccepted() {
        SecurityResult result;
        DomainContext context = this.getDomainContext();
        if (context.isRootContext() && !(result = SecurityFactory.getInstance().getSecurityManager().evaluate(context, (Permission)SecurityFactory.getInstance().getReadPermission(), context.getRootClassId(), context.getRootId())).isAccepted()) {
            throw new SecurityException((Identifiable)this, result.explain("no read permission for root-entity " + context.getRootClassId() + "[" + context.getRootId() + "]"));
        }
    }

    @Override
    public StringBuilder createSelectAllInnerSql() {
        StringBuilder sql = new StringBuilder();
        String alias = this.getTableAlias();
        sql.append(alias).append('.').append("*");
        sql.append(" FROM ");
        sql.append(this.getTableName()).append(this.getBackend().sqlAsBeforeTableAlias()).append(alias);
        sql.append(" WHERE 1=1");
        return sql;
    }

    @Override
    public StringBuilder createSelectAllIdSerialInnerSql() {
        StringBuilder sql = new StringBuilder();
        String alias = this.getTopSuperTableAlias();
        sql.append(alias).append('.').append("id");
        sql.append(",");
        sql.append(alias).append('.').append("serial");
        sql.append(" FROM ");
        sql.append(this.getTableName()).append(this.getBackend().sqlAsBeforeTableAlias()).append(alias);
        sql.append(" WHERE 1=1");
        return sql;
    }

    @Override
    public StringBuilder createSelectAllByIdInnerSql() {
        StringBuilder sql = this.createSelectAllInnerSql();
        sql.append(" AND ");
        sql.append(this.getTopSuperTableAlias()).append('.').append("id");
        sql.append("=?");
        return sql;
    }

    public StringBuilder createSelectIdInnerSql(PersistentObjectClassVariables<? super T, ? super P> classVariables) {
        StringBuilder sql = new StringBuilder();
        String tName = classVariables.getTableName();
        String tAlias = classVariables.getTableAlias();
        sql.append(tAlias).append('.').append("id");
        sql.append(" FROM ");
        sql.append(tName).append(this.getBackend().sqlAsBeforeTableAlias()).append(tAlias);
        sql.append(" WHERE 1=1");
        return sql;
    }

    @Override
    public StringBuilder createSelectIdInnerSql() {
        return this.createSelectIdInnerSql((PersistentObjectClassVariables<? super T, ? super P>)this.getClassVariables());
    }

    public String createSelectByNormTextSql() {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append((CharSequence)this.createSelectAllInnerSql());
        String condition = this.getSqlClassIdCondition();
        if (condition != null) {
            sql.append(condition);
        }
        if ((condition = this.getSqlContextCondition()) != null) {
            sql.append(condition);
        }
        sql.append(" AND ");
        sql.append(this.getTopSuperTableAlias()).append('.').append(CN_NORMTEXT);
        sql.append(" LIKE ?");
        String orderSuffix = this.orderBy();
        if (orderSuffix != null) {
            sql.append(" ORDER BY ");
            sql.append(orderSuffix);
        }
        return sql.toString();
    }

    @Override
    public String createSelectSerialSql() {
        return "SELECT serial FROM " + this.getTopSuperTableName() + " WHERE " + "id" + "=?";
    }

    @Override
    public String createSelectMaxIdSql() {
        return "SELECT " + this.getBackend().sqlFunction("MAX", "id") + " FROM " + this.getTopSuperTableName();
    }

    @Override
    public String createSelectMaxTableSerialSql() {
        return "SELECT " + this.getBackend().sqlFunction("MAX", "tableserial") + " FROM " + this.getTopSuperTableName();
    }

    @Override
    public String createDummyUpdateSql() {
        return "UPDATE " + this.getTopSuperTableName() + " SET " + "id" + "=" + "id" + " WHERE " + "id" + "=?";
    }

    @Override
    public String createUpdateSerialSql() {
        return "UPDATE " + this.getTopSuperTableName() + " SET " + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    @Override
    public String createUpdateSerialAndTableSerialSql() {
        return "UPDATE " + this.getTopSuperTableName() + " SET " + "serial" + "=" + "serial" + "+1" + "," + "tableserial" + "=?" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    @Override
    public String createSelectExpiredTableSerials1Sql() {
        return "SELECT id,tableserial FROM " + this.getTopSuperTableName() + " WHERE " + "tableserial" + ">?" + " ORDER BY " + "tableserial" + "," + "id";
    }

    @Override
    public String createSelectExpiredTableSerials2Sql() {
        return "SELECT id,tableserial FROM " + this.getTopSuperTableName() + " WHERE " + "tableserial" + ">?" + " AND " + "tableserial" + "<=?" + " ORDER BY " + "tableserial" + "," + "id";
    }

    public ResultSetWrapper resultByNormText(String normText, JoinedSelect<T> js) {
        long contextId;
        if (normText == null || "%".equals(normText)) {
            return this.resultAll(js);
        }
        this.assertRootContextIsAccepted();
        this.assertNormTextProvided();
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).selectByNormTextStatementId, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectByNormTextSql());
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = js.setClassIdsInStatement(st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx++, contextId);
        }
        st.setString(ndx++, normText);
        return st.executeQuery();
    }

    public ResultSetWrapper resultByNormTextCursor(String normText, JoinedSelect<T> js) {
        long contextId;
        if (normText == null || "%".equals(normText)) {
            return this.resultAllCursor(js);
        }
        this.assertRootContextIsAccepted();
        this.assertNormTextProvided();
        this.getSession().assertNotRemote();
        PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).selectByNormTextCursorStatementId, 1004, 1007, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectByNormTextSql());
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
                sql.append(" ORDER BY ").append(this.getColumnName("id"));
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = js.setClassIdsInStatement(st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx++, contextId);
        }
        st.setString(ndx++, normText);
        return st.executeQuery();
    }

    public List<T> selectByNormText(String normText) {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                List list = this.getRemoteDelegate().selectByNormText(context, normText);
                this.configureRemoteObjects(context, list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        ArrayList list = new ArrayList();
        try (ResultSetWrapper rs = this.resultByNormText(normText, js);){
            this.executeQueryToList(rs, js, list);
            ArrayList arrayList = list;
            return arrayList;
        }
    }

    public ScrollableResource<T> selectByNormTextAsCursor(String normText) {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                RemoteResultSetCursor remoteCursor = this.getRemoteDelegate().selectByNormTextAsCursor(context, normText);
                return new ResultSetCursor(context, remoteCursor);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        return new ResultSetCursor<T>(this.pdo, this.resultByNormTextCursor(normText, js), js);
    }

    public String createSelectAllSql() {
        String orderSuffix;
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append((CharSequence)this.createSelectAllInnerSql());
        String condition = this.getSqlClassIdCondition();
        if (condition != null) {
            sql.append(condition);
        }
        if ((condition = this.getSqlContextCondition()) != null) {
            sql.append(condition);
        }
        if ((orderSuffix = this.orderBy()) != null) {
            sql.append(" ORDER BY ");
            sql.append(orderSuffix);
        }
        return sql.toString();
    }

    public ResultSetWrapper resultAll(JoinedSelect<T> js) {
        long contextId;
        this.getSession().assertNotRemote();
        this.assertRootContextIsAccepted();
        PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).selectAllStatementId, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectAllSql());
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = js.setClassIdsInStatement(st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx++, contextId);
        }
        return st.executeQuery();
    }

    public ResultSetWrapper resultAllCursor(JoinedSelect<T> js) {
        long contextId;
        this.getSession().assertNotRemote();
        this.assertRootContextIsAccepted();
        PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).selectAllCursorStatementId, 1004, 1007, () -> {
            StringBuilder sql = new StringBuilder(this.createSelectAllSql());
            if (js != null) {
                js.createJoinedSql(this.pdo, sql);
                sql.append(" ORDER BY ").append(this.getColumnName("id"));
            }
            return sql.toString();
        });
        int ndx = 1;
        if (js != null) {
            ndx = js.setClassIdsInStatement(st, ndx);
        }
        if (this.isClassIdRequiredInWhereClause()) {
            st.setInt(ndx++, this.getClassId());
        }
        if ((contextId = this.getContextId()) >= 0L) {
            st.setLong(ndx++, contextId);
        }
        return st.executeQuery();
    }

    public List<T> selectAll() {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                List list = this.getRemoteDelegate().selectAll(context);
                this.configureRemoteObjects(context, list);
                return list;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        ArrayList list = new ArrayList();
        try (ResultSetWrapper rs = this.resultAll(js);){
            this.executeQueryToList(rs, js, list);
            ArrayList arrayList = list;
            return arrayList;
        }
    }

    public ScrollableResource<T> selectAllAsCursor() {
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                return new ResultSetCursor(context, this.getRemoteDelegate().selectAllAsCursor(context));
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        JoinedSelect<T> js = this.getEagerJoinedSelect();
        return new ResultSetCursor<T>(this.pdo, this.resultAllCursor(js), js);
    }

    public PdoCache<T> getCache() {
        return null;
    }

    public boolean expireCache(long maxSerial) {
        return false;
    }

    public T selectCached(long id) {
        return this.select(id);
    }

    public T selectCachedOnly(long id) {
        return this.select(id);
    }

    public List<T> selectAllCached() {
        return this.selectAll();
    }

    public List<T> selectAllForCache() {
        List<T> list;
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                list = this.getRemoteDelegate().selectAllForCache(context);
                this.configureRemoteObjects(context, list);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            list = this.selectAll();
        }
        return list;
    }

    public T selectForCache(long id) {
        T obj;
        if (this.getSession().isRemote()) {
            try {
                DomainContext context = this.getDomainContext();
                obj = this.getRemoteDelegate().selectForCache(context, id);
                this.configureRemoteObject(context, obj);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            obj = this.select(id);
        }
        return obj;
    }

    @Override
    public long countModification() {
        long tableSerial = super.countModification();
        if (tableSerial >= 0L) {
            this.expireCache(tableSerial);
        }
        return tableSerial;
    }

    public <T extends PersistentDomainObject<T>> boolean addReferencingClass(Class<T> clazz, String methodName) {
        return this.getClassVariables().addReferencingClass(this.getPersistenceClass(clazz), methodName);
    }

    public <T extends PersistentDomainObject<T>> boolean removeReferencingClass(Class<T> clazz, String methodName) {
        return this.getClassVariables().removeReferencingClass(this.getPersistenceClass(clazz), methodName);
    }

    public <T extends PersistentDomainObject<T>> Class<? extends AbstractPersistentObject<?, ?>> getPersistenceClass(Class<T> clazz) {
        Class<?> persistenceClass = Pdo.create(clazz).getPersistenceDelegate().getClass();
        if (AbstractPersistentObject.class.isAssignableFrom(persistenceClass)) {
            return persistenceClass;
        }
        throw new PersistenceException((Identifiable)this, "persistence class not compatible: " + persistenceClass);
    }

    @Override
    public boolean isReferenced() {
        if (this.getSession().isRemote()) {
            if (this.isNew()) {
                return false;
            }
            try {
                return this.getRemoteDelegate().isReferenced(this.getDomainContext(), this.getId());
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        return super.isReferenced();
    }

    public boolean containsPattern(String pattern) {
        if (this.getNormText() != null && pattern != null) {
            return this.getNormText().contains(pattern);
        }
        return false;
    }

    public String orderBy() {
        return null;
    }

    @Override
    public void initModification(char modType) {
        super.initModification(modType);
        this.assertWritePermission();
        this.clearTokenLock();
    }

    @Override
    public void finishModification(char modType) {
        super.finishModification(modType);
        this.setRenewTokenLockRequested(false);
    }

    @Override
    public void finishNotUpdated(char modType) {
        if (this.getTokenLockTimeout() > 0L) {
            if (this.isRenewTokenLockRequested()) {
                if (this.getEditedSince() == null) {
                    this.setEditedSince(DateHelper.now());
                }
                this.updateTokenLock(DateHelper.now((long)this.getTokenLockTimeout()), this.getContextUserId(), this.getEditedSince());
            } else {
                this.updateTokenLock(null);
            }
        }
        this.setRenewTokenLockRequested(false);
    }

    public long getContextUserId() {
        long userId = this.getDomainContext().getSessionInfo().getUserId();
        if (userId == 0L) {
            throw new PersistenceException((Identifiable)this, "userId is 0");
        }
        return userId;
    }

    public void clearTokenLock() {
        if (this.isRenewTokenLockRequested() && this.getTokenLockTimeout() > 0L) {
            this.setEditedBy(this.getContextUserId());
            this.setEditedExpiry(DateHelper.now((long)this.getTokenLockTimeout()));
            if (this.getEditedSince() == null) {
                this.setEditedSince(DateHelper.now());
            }
        } else {
            this.setEditedBy(0L);
            this.setEditedExpiry(null);
        }
    }

    public void setRenewTokenLockRequested(boolean renewTokenLock) {
        this.renewTokenLock = renewTokenLock;
    }

    public boolean isRenewTokenLockRequested() {
        return this.renewTokenLock;
    }

    @Override
    protected boolean isUpdateNecessary() {
        return super.isUpdateNecessary() || this.getEditedBy() != 0L || this.isRenewTokenLockRequested();
    }

    @Override
    public void updateObject() {
        super.updateObject();
        if (this.getSession().isRemote()) {
            this.clearTokenLock();
        }
    }

    @Override
    public void insertObject() {
        super.insertObject();
        if (this.getSession().isRemote()) {
            this.clearTokenLock();
        }
    }

    @Override
    public void newId() {
        super.newId();
        if (!this.isRootEntity()) {
            DomainContext context = this.getDomainContext();
            if (this.isRootIdProvided()) {
                this.setRootId(context.getRootId());
            }
            if (this.isRootClassIdProvided()) {
                this.setRootClassId(context.getRootClassId());
            }
        }
    }

    public boolean updateRootContext() {
        if (this.isRootEntity()) {
            DomainContext context = this.getDomainContext();
            context.getRootContext(this.pdo);
            return true;
        }
        return false;
    }

    public void configureRemoteObject(DomainContext context, T obj) {
        if (obj != null) {
            AbstractPersistentObject po = (AbstractPersistentObject)obj.getPersistenceDelegate();
            if (po.isRootEntity()) {
                po.setSession(context.getSession());
                po.setSessionHolder((SessionHolder)po.getDomainContext().getRootContext(obj));
            } else {
                DomainContext poContext = po.getDomainContext();
                if (poContext.getRootId() == context.getRootId() && poContext.getRootClassId() == context.getRootClassId()) {
                    po.setDomainContext(context);
                }
            }
            po.validated = true;
        }
    }

    public void configureRemoteObjects(DomainContext context, Collection<T> objects) {
        if (objects != null) {
            for (PersistentDomainObject obj : objects) {
                this.configureRemoteObject(context, obj);
            }
        }
    }

    protected void assertRootContext() {
        if (!this.getDomainContext().isRootContext()) {
            throw new PersistenceException((Identifiable)this, "unexpected non-root domain context");
        }
    }

    protected <X extends PersistentDomainObject<X>> void markDeleted(Collection<X> pdos) {
        if (pdos != null) {
            for (PersistentDomainObject pDo : pdos) {
                AbstractPersistentObject po;
                if (pDo == null || (po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isNew()) continue;
                po.markDeleted();
            }
        }
    }

    protected void markDeleted(PersistentDomainObject<?> pdo) {
        if (pdo != null) {
            ((AbstractPersistentObject)pdo.getPersistenceDelegate()).markDeleted();
        }
    }

    protected <X extends PersistentDomainObject<X>> void delete(Collection<X> pdos) {
        if (pdos != null) {
            Db session = null;
            for (PersistentDomainObject pDo : pdos) {
                AbstractPersistentObject po;
                if (pDo == null || (po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isVirgin()) continue;
                if (session == null) {
                    session = po.getSession();
                    if (session == null) {
                        throw new PdoRuntimeException(pDo, "session is null");
                    }
                } else if (po.getSession() != session) {
                    throw new PdoRuntimeException(pDo, "unexpected session: " + po.getSession() + ", expected: " + session);
                }
                po.deleteImpl();
            }
            if (pdos instanceof TrackedList) {
                ((TrackedList)pdos).setModified(false);
            }
        }
    }

    protected void delete(PersistentDomainObject<?> pdo) {
        if (pdo != null) {
            ((AbstractPersistentObject)pdo.getPersistenceDelegate()).deleteImpl();
        }
    }

    protected <X extends PersistentDomainObject<X>> void deleteMissingInCollection(Collection<X> oldCollection, Collection<X> newCollection) {
        if (oldCollection != null && oldCollection.size() > 0) {
            Db session = null;
            for (PersistentDomainObject pDo : oldCollection) {
                AbstractPersistentObject po;
                if (pDo == null || (po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isVirgin() || newCollection != null && newCollection.contains(pDo)) continue;
                if (session == null) {
                    session = po.getSession();
                    if (session == null) {
                        throw new PersistenceException((Identifiable)pDo, "session is null");
                    }
                } else if (po.getSession() != session) {
                    throw new PersistenceException((Identifiable)pDo, "unexpected session: " + po.getSession() + ", expected: " + session);
                }
                po.deleteImpl();
            }
        }
    }

    public void assertRootEntity() {
        if (!this.isRootEntity()) {
            throw new PersistenceException((Identifiable)this, "not a root-entity");
        }
    }

    public void delete() {
        this.assertRootEntity();
        this.assertWritePermission();
        this.deleteImpl();
    }

    protected void deleteImpl() {
        if (this.getSession().isRemote()) {
            this.assertPersistable();
            this.preparePending = true;
            try {
                this.prepareDelete();
                this.getRemoteDelegate().deleteImpl(this.pdo);
                this.setPersistable(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.deleteObject();
        }
    }

    public void save() {
        this.assertRootEntity();
        this.saveImpl();
    }

    protected void saveImpl() {
        if (this.getSession().isRemote()) {
            this.assertPersistable();
            this.clearOnRemoteSave();
            this.preparePending = true;
            this.prepareSave();
            try {
                this.getRemoteDelegate().saveImpl(this.pdo);
                this.setPersistable(false);
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.assertWritePermission();
            if (!this.isValidated()) {
                this.validate();
            }
            super.saveObject();
        }
    }

    protected <X extends PersistentDomainObject<X>> void save(Collection<X> pdos, boolean modifiedOnly) {
        if (pdos != null) {
            Db session = null;
            for (PersistentDomainObject pDo : pdos) {
                if (pDo == null) continue;
                AbstractPersistentObject po = (AbstractPersistentObject)pDo.getPersistenceDelegate();
                if (session == null) {
                    session = po.getSession();
                    if (session == null) {
                        throw new PdoRuntimeException(pDo, "session is null");
                    }
                } else if (po.getSession() != session) {
                    throw new PdoRuntimeException(pDo, "unexpected session: " + po.getSession() + ", expected: " + session);
                }
                if (po.isPersistable()) {
                    if (modifiedOnly && !po.isModified()) continue;
                    po.saveImpl();
                    continue;
                }
                if (po.isNew()) continue;
                po.deleteImpl();
            }
            if (pdos instanceof TrackedList) {
                ((TrackedList)pdos).setModified(false);
            }
        }
    }

    protected void save(PersistentDomainObject<?> pdo) {
        if (pdo != null) {
            ((AbstractPersistentObject)pdo.getPersistenceDelegate()).saveImpl();
        }
    }

    public T persist() {
        this.assertRootEntity();
        return this.persistImpl();
    }

    public T persistTokenLocked() {
        this.setRenewTokenLockRequested(true);
        return this.persist();
    }

    protected T persistImpl() {
        if (this.getSession().isRemote()) {
            this.assertPersistable();
            this.clearOnRemoteSave();
            this.preparePending = true;
            this.prepareSave();
            try {
                T persistedPdo = this.getRemoteDelegate().persistImpl(this.pdo);
                this.configureRemoteObject(this.getDomainContext(), persistedPdo);
                return persistedPdo;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.assertWritePermission();
        if (!this.isValidated()) {
            this.validate();
        }
        if (super.persistObject() != this) {
            throw new PersistenceException((Identifiable)this, "local persist does not return same object");
        }
        return this.pdo;
    }

    @Override
    public boolean isUpdatingSerialEvenIfNotModified() {
        return this.isRootEntity();
    }

    protected <X extends PersistentDomainObject<X>> boolean isModified(Collection<X> pdos) {
        if (pdos instanceof TrackedList && ((TrackedList)pdos).isModified()) {
            return true;
        }
        if (pdos != null) {
            for (PersistentDomainObject pDo : pdos) {
                AbstractPersistentObject po;
                if (pDo == null || !(po = (AbstractPersistentObject)pDo.getPersistenceDelegate()).isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTokenLockProvided() {
        return false;
    }

    protected void assertTokenLockProvided() {
        if (!this.isTokenLockProvided()) {
            throw new PersistenceException((Identifiable)this, "entity does not provide the edited-token columns");
        }
    }

    public long getTokenLockTimeout() {
        return this.isTokenLockProvided() ? 300000L : 0L;
    }

    public String createUpdateTokenLockSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET " + CN_EDITEDBY + "=?," + CN_EDITEDSINCE + "=?," + CN_EDITEDEXPIRY + "=?" + " WHERE " + "id" + "=?" + " AND " + " (" + CN_EDITEDBY + "=?" + " OR " + CN_EDITEDBY + "=0" + " OR " + CN_EDITEDEXPIRY + "<?" + " OR " + CN_EDITEDEXPIRY + " IS NULL" + ") ";
    }

    public String createUpdateTokenLockWithCountSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET " + "serial" + "=" + "serial" + "+1" + "," + "tableserial" + "=?," + CN_EDITEDBY + "=?," + CN_EDITEDSINCE + "=?," + CN_EDITEDEXPIRY + "=?" + " WHERE " + "id" + "=?" + " AND " + " (" + CN_EDITEDBY + "=?" + " OR " + CN_EDITEDBY + "=0" + " OR " + CN_EDITEDEXPIRY + "<?" + " OR " + CN_EDITEDEXPIRY + " IS NULL" + ") ";
    }

    public String createUpdateTokenLockOnlySql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET " + CN_EDITEDBY + "=?," + CN_EDITEDSINCE + "=?," + CN_EDITEDEXPIRY + "=?" + " WHERE " + "id" + "=?";
    }

    public String createSelectTokenLockSql() {
        this.assertTokenLockProvided();
        return "SELECT editedby,editedsince,editedexpiry FROM " + this.getTopSuperTableName() + " WHERE " + "id" + "=?";
    }

    public String createTransferTokenLockSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET " + "serial" + "=" + "serial" + "+1" + "," + CN_EDITEDBY + "=?" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public String createTransferTokenLockWithTableSerialSql() {
        this.assertTokenLockProvided();
        return "UPDATE " + this.getTopSuperTableName() + " SET " + "serial" + "=" + "serial" + "+1" + "," + CN_EDITEDBY + "=?," + "tableserial" + "=?" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public long getEditedBy() {
        return this.editedBy;
    }

    public void setEditedBy(long editedBy) {
        this.editedBy = editedBy;
    }

    public void requestTokenLock() {
        this.updateTokenLock(DateHelper.now((long)this.getTokenLockTimeout()));
    }

    public void releaseTokenLock() {
        this.updateTokenLock(null);
    }

    public boolean isTokenLocked() {
        return this.getEditedBy() != 0L && this.getEditedExpiry() != null && this.getEditedExpiry().getTime() > System.currentTimeMillis();
    }

    public boolean isTokenLockedBy(long userId) {
        return this.isTokenLocked() && this.getEditedBy() == userId;
    }

    public boolean isTokenLockedByMe() {
        return this.isTokenLockedBy(this.getDomainContext().getSessionInfo().getUserId());
    }

    public org.tentackle.common.Timestamp getEditedSince() {
        return this.editedSince;
    }

    public void setEditedSince(org.tentackle.common.Timestamp editedSince) {
        this.editedSince = editedSince;
    }

    public org.tentackle.common.Timestamp getEditedExpiry() {
        return this.editedExpiry;
    }

    public void setEditedExpiry(org.tentackle.common.Timestamp editedExpiry) {
        this.editedExpiry = editedExpiry;
    }

    public <U extends PersistentDomainObject<U>> U getTokenLockObject() {
        AbstractApplication application = AbstractApplication.getRunningApplication();
        return (U)(application == null ? null : application.getUser(this.getDomainContext(), this.getEditedBy()));
    }

    public <U extends PersistentDomainObject<U>> void setTokenLockObject(U obj) {
        this.setEditedBy(obj == null ? 0L : obj.getId());
    }

    public boolean isCountingModificationForTokenLock() {
        return false;
    }

    public void updateTokenLock(org.tentackle.common.Timestamp tokenExpiry, long userId, org.tentackle.common.Timestamp curTime) {
        if (this.getSession().isRemote()) {
            try {
                TokenLock token = this.getRemoteDelegate().updateTokenLock(this.getId(), tokenExpiry, userId, curTime);
                token.applyTo((PersistentObject)this);
            }
            catch (RemoteException e) {
                LockException lx;
                TokenLock token;
                RuntimeException rex = PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
                if (rex instanceof LockException && (token = (lx = (LockException)rex).getTokenLock()) != null) {
                    token.applyTo((PersistentObject)this);
                }
                throw rex;
            }
        } else {
            this.assertNotCached();
            this.assertPersistable();
            this.assertWritePermission();
            if (this.getSession().isPersistenceOperationAllowed(this, 'U')) {
                PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).updateTokenLockStatementId, () -> this.createUpdateTokenLockSql());
                long newUser = tokenExpiry != null ? userId : 0L;
                st.setLong(1, newUser);
                st.setTimestamp(2, (Timestamp)curTime);
                st.setTimestamp(3, (Timestamp)tokenExpiry);
                st.setLong(4, this.getId());
                st.setLong(5, userId);
                st.setTimestamp(6, (Timestamp)curTime);
                if (st.executeUpdate() == 1) {
                    this.setEditedBy(newUser);
                    this.setEditedSince(curTime);
                    this.setEditedExpiry(tokenExpiry);
                } else {
                    st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).selectTokenLockStatementId, () -> this.createSelectTokenLockSql());
                    st.setLong(1, this.getId());
                    ResultSetWrapper rs = st.executeQuery();
                    Throwable throwable = null;
                    try {
                        try {
                            if (rs.next()) {
                                this.setEditedBy(rs.getLong(CN_EDITEDBY));
                                this.setEditedSince(rs.getTimestamp(CN_EDITEDSINCE));
                                this.setEditedExpiry(rs.getTimestamp(CN_EDITEDEXPIRY));
                                throw new LockException((Session)this.getSession(), new TokenLock(this.editedBy, this.editedSince, this.editedExpiry));
                            }
                            throw new NotFoundException((Identifiable)this, "could not retrieve token lock");
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                rs.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }

    public void updateTokenLock(org.tentackle.common.Timestamp tokenExpiry) {
        this.updateTokenLock(tokenExpiry, this.getDomainContext().getSessionInfo().getUserId(), DateHelper.now());
    }

    public void updateTokenLockOnly() {
        if (this.getSession().isRemote()) {
            try {
                this.getRemoteDelegate().updateTokenLockOnly(this.getId(), this.getEditedBy(), this.getEditedSince(), this.getEditedExpiry());
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        } else {
            this.assertNotCached();
            this.assertPersistable();
            this.assertWritePermission();
            if (this.getSession().isPersistenceOperationAllowed(this, 'U')) {
                PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).updateTokenLockOnlyStatementId, () -> this.createUpdateTokenLockOnlySql());
                st.setLong(1, this.getEditedBy());
                st.setTimestamp(2, (Timestamp)this.getEditedSince());
                st.setTimestamp(3, (Timestamp)this.getEditedExpiry());
                st.setLong(4, this.getId());
                this.assertThisRowAffected(st.executeUpdate());
            }
        }
    }

    public T transferTokenLock(long userId) {
        if (this.getSession().isRemote()) {
            try {
                T tPdo = this.getRemoteDelegate().transferTokenLock(this.pdo, userId);
                this.configureRemoteObject(this.getDomainContext(), tPdo);
                return tPdo;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        this.assertNotCached();
        this.assertPersistable();
        this.assertWritePermission();
        if (this.getSession().isPersistenceOperationAllowed(this, 'U')) {
            long txVoucher = this.getSession().begin(TX_TRANSFER_TOKENLOCK);
            try {
                boolean withTableSerial = this.isTableSerialProvided();
                PreparedStatementWrapper st = this.getPreparedStatement(((PersistentObjectClassVariables)this.getClassVariables()).transferTokenLockStatementId, () -> withTableSerial ? this.createTransferTokenLockWithTableSerialSql() : this.createTransferTokenLockSql());
                long newTableSerial = this.countModification();
                if (withTableSerial) {
                    this.setTableSerial(newTableSerial);
                }
                int ndx = 0;
                st.setLong(++ndx, userId);
                if (withTableSerial) {
                    st.setLong(++ndx, this.getTableSerial());
                }
                st.setLong(++ndx, this.getId());
                st.setLong(++ndx, this.getSerial());
                this.assertThisRowAffected(st.executeUpdate());
                this.setSerial(this.getSerial() + 1L);
                if (userId != 0L) {
                    this.updateTokenLock(DateHelper.now((long)this.getTokenLockTimeout()), userId, DateHelper.now());
                }
                this.getSession().commit(txVoucher);
            }
            catch (RuntimeException ex) {
                this.setPersistable(false);
                this.getSession().rollback(txVoucher);
                if (ex instanceof PersistenceException) {
                    ((PersistenceException)((Object)ex)).updateDbObject((Identifiable)this);
                    throw (PersistenceException)((Object)ex);
                }
                throw new PersistenceException((Identifiable)this, (Throwable)ex);
            }
        }
        return this.pdo;
    }

    public Object getTransientData() {
        return null;
    }

    public void setTransientData(Object data) {
    }

    public AbstractPersistentObjectRemoteDelegate<T, P> getRemoteDelegate() {
        return (AbstractPersistentObjectRemoteDelegate)super.getRemoteDelegate();
    }

    public Class<? extends ValidationScope>[] getDefaultScopes() {
        return new Class[]{PersistenceScope.class, MandatoryScope.class, ChangeableScope.class};
    }

    public List<ValidationResult> validate(String validationPath, ValidationScope scope) {
        return ValidationUtilities.getInstance().validate(this.getPdo(), validationPath, scope);
    }

    public void validate() {
        this.validated = false;
        String validationPath = ValidationUtilities.getInstance().getDefaultValidationPath(this.pdo);
        List<ValidationResult> results = this.validate(validationPath, (ValidationScope)ValidationScopeFactory.getInstance().getPersistenceScope());
        if (ValidationUtilities.getInstance().hasFailed(results)) {
            throw new ValidationFailedException("validation of " + this.pdo.toGenericString() + " as " + validationPath + " failed:\n" + ValidationUtilities.getInstance().resultsToString(results), results);
        }
        this.validated = true;
    }

    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this.validated = !modified;
    }

    public boolean isReadAllowed() {
        return (boolean)((PersistentObjectClassVariables)this.getClassVariables()).isReadAllowed(this);
    }

    public boolean isWriteAllowed() {
        return (boolean)((PersistentObjectClassVariables)this.getClassVariables()).isWriteAllowed(this);
    }

    public boolean isViewAllowed() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).isViewAllowed(this);
    }

    public boolean isEditAllowed() {
        return ((PersistentObjectClassVariables)this.getClassVariables()).isEditAllowed(this);
    }

    protected void assertWritePermission() {
        if (!this.isWriteAllowed()) {
            throw new SecurityException((Identifiable)this, "no write permission");
        }
    }

    protected void assertReadPermission() {
        if (!this.isReadAllowed()) {
            throw new SecurityException((Identifiable)this, "no read permission");
        }
    }
}

