/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.ns.pdo;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.IdentifiableMap;
import org.tentackle.misc.TrackedArrayList;
import org.tentackle.misc.TrackedList;
import org.tentackle.ns.pdo.NumberPool;
import org.tentackle.ns.pdo.NumberPoolPersistence;
import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.ns.pdo.rmi.NumberPoolRemoteDelegate;
import org.tentackle.pdo.AbstractPersistentObject;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.Persistent;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.PersistentObjectClassVariables;
import org.tentackle.pdo.PersistentObjectService;
import org.tentackle.pdo.Session;
import org.tentackle.persist.PreparedStatementWrapper;
import org.tentackle.persist.ResultSetWrapper;
import org.tentackle.persist.StatementId;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationUtilities;

@PersistentObjectService(value=NumberPool.class)
public class NumberPoolPersistenceImpl
extends AbstractPersistentObject<NumberPool, NumberPoolPersistenceImpl>
implements NumberPoolPersistence {
    private static final long serialVersionUID = -1178387730540795339L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberPoolPersistenceImpl.class);
    public static final PersistentObjectClassVariables<NumberPool, NumberPoolPersistenceImpl> CLASSVARIABLES = new PersistentObjectClassVariables<NumberPool, NumberPoolPersistenceImpl>(NumberPool.class, NumberPoolPersistenceImpl.class, "npool", null, null);
    public static final String CN_NAME = "name";
    public static final String CN_REALM = "realm";
    public static final String CN_DESCRIPTION = "description";
    public static final String CN_ONLINE = "poolonline";
    public static final String CN_LOWWATERMARK = "lowmark";
    public static final String CN_REQUESTSIZE = "reqsize";
    public static final String CN_UPLINK = "uplink";
    @Persistent(value="the number pool name")
    private String name;
    private boolean nameModified;
    private String namePersisted;
    @Persistent(value="pool realm, optional")
    private String realm;
    private boolean realmModified;
    private String realmPersisted;
    @Persistent(value="short description")
    private String description;
    private boolean descriptionModified;
    private String descriptionPersisted;
    @Persistent(value="true if online, else offline")
    private boolean online;
    private boolean onlineModified;
    private boolean onlinePersisted;
    @Persistent(value="minimum number count before request to fill up from uplink, 0 if disable")
    private long lowWaterMark;
    private boolean lowWaterMarkModified;
    private long lowWaterMarkPersisted;
    @Persistent(value="number count to request from uplink, 0 if disable")
    private long requestSize;
    private boolean requestSizeModified;
    private long requestSizePersisted;
    @Persistent(value="uplink configuration (optional)")
    private String uplink;
    private boolean uplinkModified;
    private String uplinkPersisted;
    private static final StatementId SELECT_BY_UNIQUE_DOMAIN_KEY_STMT = new StatementId();
    @Persistent(value="numberRange")
    private TrackedList<NumberRange> numberRangeList;
    private boolean numberRangeListLoaded;
    private transient TrackedList<NumberRange> numberRangeListSnapshot;
    private static final StatementId SELECT_BY_NAME_REALM_STMT = new StatementId();

    @Override
    public PersistentObjectClassVariables<NumberPool, NumberPoolPersistenceImpl> getClassVariables() {
        return CLASSVARIABLES;
    }

    public NumberPoolPersistenceImpl(NumberPool pdo, DomainContext context) {
        super(pdo, context);
    }

    public NumberPoolPersistenceImpl(NumberPool pdo, Session session) {
        super(pdo, session);
    }

    public NumberPoolPersistenceImpl(NumberPool pdo) {
        super(pdo);
    }

    public NumberPoolPersistenceImpl() {
    }

    @Override
    public boolean isUpdatingSerialEvenIfNotModified() {
        return false;
    }

    @Override
    public NumberPoolRemoteDelegate getRemoteDelegate() {
        return (NumberPoolRemoteDelegate)super.getRemoteDelegate();
    }

    @Override
    public boolean isRootEntity() {
        return true;
    }

    @Override
    public boolean isTracked() {
        return true;
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (!modified) {
            this.nameModified = false;
            this.namePersisted = this.name;
            this.realmModified = false;
            this.realmPersisted = this.realm;
            this.descriptionModified = false;
            this.descriptionPersisted = this.description;
            this.onlineModified = false;
            this.onlinePersisted = this.online;
            this.lowWaterMarkModified = false;
            this.lowWaterMarkPersisted = this.lowWaterMark;
            this.requestSizeModified = false;
            this.requestSizePersisted = this.requestSize;
            this.uplinkModified = false;
            this.uplinkPersisted = this.uplink;
        }
    }

    @Override
    public void getFields(ResultSetWrapper rs) {
        super.getFields(rs);
        if (rs.configureSection(CLASSVARIABLES)) {
            rs.configureColumn(CN_NAME);
            rs.configureColumn(CN_REALM);
            rs.configureColumn(CN_DESCRIPTION);
            rs.configureColumn(CN_ONLINE);
            rs.configureColumn(CN_LOWWATERMARK);
            rs.configureColumn(CN_REQUESTSIZE);
            rs.configureColumn(CN_UPLINK);
            rs.configureColumn("id");
            rs.configureColumn("serial");
        }
        if (rs.getRow() <= 0) {
            throw new PersistenceException((Session)this.getSession(), "no valid row");
        }
        this.name = rs.getString();
        this.realm = rs.getString(true);
        this.description = rs.getString();
        this.online = rs.getBoolean();
        this.lowWaterMark = rs.getLong();
        this.requestSize = rs.getLong();
        this.uplink = rs.getString();
        this.setId(rs.getLong());
        this.setSerial(rs.getLong());
    }

    @Override
    public int setFields(PreparedStatementWrapper st) {
        int ndx = super.setFields(st);
        st.setString(++ndx, this.name);
        st.setString(++ndx, this.realm, true);
        st.setString(++ndx, this.description);
        st.setBoolean(++ndx, this.online);
        st.setLong(++ndx, this.lowWaterMark);
        st.setLong(++ndx, this.requestSize);
        st.setString(++ndx, this.uplink);
        st.setLong(++ndx, this.getId());
        st.setLong(++ndx, this.getSerial());
        return ndx;
    }

    @Override
    public String createInsertSql() {
        return "INSERT INTO " + this.getTableName() + " (" + CN_NAME + "," + CN_REALM + "," + CN_DESCRIPTION + "," + CN_ONLINE + "," + CN_LOWWATERMARK + "," + CN_REQUESTSIZE + "," + CN_UPLINK + "," + "id" + "," + "serial" + ") VALUES (" + "?," + "?," + "?," + "?," + "?," + "?," + "?," + "?," + "?" + ") ";
    }

    @Override
    public String createUpdateSql() {
        return "UPDATE " + this.getTableName() + " SET " + CN_NAME + "=?," + CN_REALM + "=?," + CN_DESCRIPTION + "=?," + CN_ONLINE + "=?," + CN_LOWWATERMARK + "=?," + CN_REQUESTSIZE + "=?," + CN_UPLINK + "=?," + "serial" + "=" + "serial" + "+1" + " WHERE " + "id" + "=?" + " AND " + "serial" + "=?";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.assertMutable();
        if (!Objects.equals(this.name, name)) {
            this.setModified(true);
            this.nameModified = true;
            this.firePropertyChange(CN_NAME, this.name, name);
        }
        this.name = name;
    }

    public boolean isNameModified() {
        return this.nameModified;
    }

    public String getNamePersisted() {
        return this.namePersisted;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.assertMutable();
        if (!Objects.equals(this.realm, realm)) {
            this.setModified(true);
            this.realmModified = true;
            this.firePropertyChange(CN_REALM, this.realm, realm);
        }
        this.realm = realm;
    }

    public boolean isRealmModified() {
        return this.realmModified;
    }

    public String getRealmPersisted() {
        return this.realmPersisted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.assertMutable();
        if (!Objects.equals(this.description, description)) {
            this.setModified(true);
            this.descriptionModified = true;
            this.firePropertyChange(CN_DESCRIPTION, this.description, description);
        }
        this.description = description;
    }

    public boolean isDescriptionModified() {
        return this.descriptionModified;
    }

    public String getDescriptionPersisted() {
        return this.descriptionPersisted;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.assertMutable();
        if (this.online != online) {
            this.setModified(true);
            this.onlineModified = true;
            this.firePropertyChange("online", this.online, online);
        }
        this.online = online;
    }

    public boolean isOnlineModified() {
        return this.onlineModified;
    }

    public boolean isOnlinePersisted() {
        return this.onlinePersisted;
    }

    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setLowWaterMark(long lowWaterMark) {
        this.assertMutable();
        if (this.lowWaterMark != lowWaterMark) {
            this.setModified(true);
            this.lowWaterMarkModified = true;
            this.firePropertyChange("lowWaterMark", this.lowWaterMark, lowWaterMark);
        }
        this.lowWaterMark = lowWaterMark;
    }

    public boolean isLowWaterMarkModified() {
        return this.lowWaterMarkModified;
    }

    public long getLowWaterMarkPersisted() {
        return this.lowWaterMarkPersisted;
    }

    public long getRequestSize() {
        return this.requestSize;
    }

    public void setRequestSize(long requestSize) {
        this.assertMutable();
        if (this.requestSize != requestSize) {
            this.setModified(true);
            this.requestSizeModified = true;
            this.firePropertyChange("requestSize", this.requestSize, requestSize);
        }
        this.requestSize = requestSize;
    }

    public boolean isRequestSizeModified() {
        return this.requestSizeModified;
    }

    public long getRequestSizePersisted() {
        return this.requestSizePersisted;
    }

    public String getUplink() {
        return this.uplink;
    }

    public void setUplink(String uplink) {
        this.assertMutable();
        if (!Objects.equals(this.uplink, uplink)) {
            this.setModified(true);
            this.uplinkModified = true;
            this.firePropertyChange(CN_UPLINK, this.uplink, uplink);
        }
        this.uplink = uplink;
    }

    public boolean isUplinkModified() {
        return this.uplinkModified;
    }

    public String getUplinkPersisted() {
        return this.uplinkPersisted;
    }

    protected void createAttributesInSnapshot(NumberPoolPersistenceImpl snapshot) {
        super.createAttributesInSnapshot(snapshot);
    }

    protected void revertAttributesToSnapshot(NumberPoolPersistenceImpl snapshot) {
        super.revertAttributesToSnapshot(snapshot);
        this.name = snapshot.name;
        this.nameModified = snapshot.nameModified;
        this.namePersisted = snapshot.namePersisted;
        this.realm = snapshot.realm;
        this.realmModified = snapshot.realmModified;
        this.realmPersisted = snapshot.realmPersisted;
        this.description = snapshot.description;
        this.descriptionModified = snapshot.descriptionModified;
        this.descriptionPersisted = snapshot.descriptionPersisted;
        this.online = snapshot.online;
        this.onlineModified = snapshot.onlineModified;
        this.onlinePersisted = snapshot.onlinePersisted;
        this.lowWaterMark = snapshot.lowWaterMark;
        this.lowWaterMarkModified = snapshot.lowWaterMarkModified;
        this.lowWaterMarkPersisted = snapshot.lowWaterMarkPersisted;
        this.requestSize = snapshot.requestSize;
        this.requestSizeModified = snapshot.requestSizeModified;
        this.requestSizePersisted = snapshot.requestSizePersisted;
        this.uplink = snapshot.uplink;
        this.uplinkModified = snapshot.uplinkModified;
        this.uplinkPersisted = snapshot.uplinkPersisted;
    }

    public NumberPool selectByUniqueDomainKey(String name) {
        if (this.getSession().isRemote()) {
            try {
                NumberPool obj = this.getRemoteDelegate().selectByUniqueDomainKey(this.getDomainContext(), name);
                this.configureRemoteObject(this.getDomainContext(), obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_UNIQUE_DOMAIN_KEY_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NAME));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx++, name);
        return (NumberPool)this.executeFirstPdoQuery(st);
    }

    public TrackedList<NumberRange> getNumberRangeList() {
        if (!this.numberRangeListLoaded) {
            this.numberRangeList = this.isNew() ? new TrackedArrayList(false) : ((NumberRange)this.on(NumberRange.class)).selectByNumberPoolId(this.getId());
            for (NumberRange obj : this.numberRangeList) {
                obj.setNumberPool((NumberPool)this.pdo());
            }
            if (this.isImmutable()) {
                this.numberRangeList.setImmutable(true);
            }
            this.numberRangeListLoaded = true;
        }
        return this.numberRangeList;
    }

    public TrackedList<NumberRange> getNumberRangeListBlunt() {
        if (!this.numberRangeListLoaded) {
            this.numberRangeList = new TrackedArrayList(false);
            this.numberRangeListLoaded = true;
        }
        return this.numberRangeList;
    }

    @Override
    public void setSession(Session session) {
        super.setSession(session);
        session.applyTo(this.numberRangeList);
    }

    @Override
    public void setDomainContext(DomainContext context) {
        super.setDomainContext(context);
        context.applyTo(this.numberRangeList);
    }

    @Override
    public void deleteReferencingRelations() {
        super.deleteReferencingRelations();
        this.deleteReferencingRelations(true);
    }

    private void deleteReferencingRelations(boolean delete) {
        if (delete) {
            this.delete(this.getNumberRangeList());
        }
        if (this.numberRangeList != null && this.numberRangeList.isSomeRemoved()) {
            this.delete(this.numberRangeList.getRemovedObjects());
        }
    }

    @Override
    public void saveReferencingRelations(boolean update) {
        super.saveReferencingRelations(update);
        if (update) {
            this.deleteReferencingRelations(false);
        }
        if (this.numberRangeList != null) {
            this.getDomainContext().applyTo(this.numberRangeList);
            for (NumberRange obj : this.numberRangeList) {
                obj.setNumberPool((NumberPool)this.pdo());
            }
            this.save(this.numberRangeList, true);
        }
    }

    @Override
    public List<ValidationResult> validate(String validationPath, ValidationScope scope) {
        List<ValidationResult> results = super.validate(validationPath, scope);
        if (this.numberRangeList != null) {
            results.addAll(ValidationUtilities.getInstance().validateCollection(this.numberRangeList, validationPath + ".numberRangeList", scope));
        }
        return results;
    }

    @Override
    public void setImmutable(boolean immutable) {
        super.setImmutable(immutable);
        if (this.numberRangeList != null) {
            this.numberRangeList.setImmutable(immutable);
        }
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.isModified(this.numberRangeList);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public IdentifiableMap<? extends PersistentDomainObject<?>> loadComponents(boolean onlyLoaded) {
        IdentifiableMap components = new IdentifiableMap();
        this.addComponents(components, onlyLoaded);
        return components;
    }

    @Override
    public int addComponents(IdentifiableMap<PersistentDomainObject<?>> components, boolean onlyLoaded) {
        int count = 0;
        count += super.addComponents(components, onlyLoaded);
        if (!onlyLoaded || this.numberRangeListLoaded) {
            count += this.addComponents(components, (Collection<? extends PersistentDomainObject<?>>)this.getNumberRangeList(), onlyLoaded);
        }
        return count;
    }

    @Override
    public void insertPlainWithComponents() {
        this.insertPlain();
        this.insertPlainWithComponents((Collection<? extends PersistentDomainObject<?>>)this.getNumberRangeList());
    }

    @Override
    public void deletePlainWithComponents() {
        this.deletePlainWithComponents((Collection<? extends PersistentDomainObject<?>>)this.getNumberRangeList());
        this.deletePlain();
    }

    @Override
    public void markDeleted() {
        super.markDeleted();
        this.markDeleted(this.numberRangeList);
    }

    protected void createComponentsInSnapshot(NumberPoolPersistenceImpl snapshot) {
        super.createComponentsInSnapshot(snapshot);
        if (this.numberRangeList != null) {
            snapshot.numberRangeListSnapshot = (TrackedList)this.numberRangeList.createSnapshot();
        }
    }

    protected void revertComponentsToSnapshot(NumberPoolPersistenceImpl snapshot) {
        super.revertComponentsToSnapshot(snapshot);
        this.numberRangeList = snapshot.numberRangeList;
        if (this.numberRangeList != null) {
            this.numberRangeList.clear();
            this.numberRangeList.addAll(snapshot.numberRangeListSnapshot);
        }
        this.numberRangeListLoaded = snapshot.numberRangeListLoaded;
    }

    public NumberPool selectByNameRealm(String name, String realm) {
        if (this.getSession().isRemote()) {
            try {
                NumberPool obj = this.getRemoteDelegate().selectByNameRealm(this.getDomainContext(), name, realm);
                this.configureRemoteObject(this.getDomainContext(), obj);
                return obj;
            }
            catch (RemoteException e) {
                throw PersistenceException.createFromRemoteException((Object)this, (RemoteException)e);
            }
        }
        PreparedStatementWrapper st = this.getPreparedStatement(SELECT_BY_NAME_REALM_STMT, () -> {
            StringBuilder sql = this.createSelectAllInnerSql();
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_NAME));
            sql.append("=?");
            sql.append(" AND ");
            sql.append(this.getColumnName(CN_REALM));
            sql.append("=?");
            this.getBackend().buildSelectSql(sql, false, 0, 0);
            return sql.toString();
        });
        int ndx = 1;
        st.setString(ndx++, name);
        st.setString(ndx++, realm, true);
        return (NumberPool)this.executeFirstPdoQuery(st);
    }

    public void reloadRanges() {
        this.numberRangeListLoaded = false;
        this.numberRangeList = null;
    }
}

