/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.app;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.misc.ApplicationException;
import org.tentackle.pdo.SessionInfo;

public class SessionCache {
    private final ConcurrentHashMap<Object, SoftReference<SessionInfo>> userInfoMap = new ConcurrentHashMap();
    private CleanupThread cleanupThread;

    public void startup(long cleanupInterval) throws ApplicationException {
        if (cleanupInterval <= 0L) {
            throw new IllegalArgumentException("cleanupInterval must be > 0");
        }
        if (this.cleanupThread != null && this.cleanupThread.isAlive()) {
            throw new ApplicationException("session cache cleanup thread already running");
        }
        this.cleanupThread = new CleanupThread(cleanupInterval);
        this.cleanupThread.start();
    }

    public void terminate() throws ApplicationException {
        if (this.cleanupThread != null) {
            boolean isAlive = this.cleanupThread.isAlive();
            if (isAlive) {
                this.cleanupThread.requestToStop();
                try {
                    this.cleanupThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cleanupThread = null;
            if (!isAlive) {
                throw new ApplicationException("session cache cleanup thread died");
            }
        } else {
            throw new ApplicationException("session cache cleanup thread hasn't been started");
        }
    }

    public void addSession(Object sessionKey, SessionInfo userInfo) {
        this.userInfoMap.put(sessionKey, new SoftReference<SessionInfo>(userInfo));
    }

    public void removeSession(Object sessionKey) {
        this.userInfoMap.remove(sessionKey);
    }

    public SessionInfo getSession(Object sessionKey) {
        SessionInfo userInfo;
        SoftReference<SessionInfo> userInfoRef = this.userInfoMap.get(sessionKey);
        if (userInfoRef != null && (userInfo = userInfoRef.get()) != null) {
            return userInfo;
        }
        return null;
    }

    private class CleanupThread
    extends Thread {
        private final long ms;
        private boolean stop;

        CleanupThread(long ms) {
            this.ms = ms;
            this.setDaemon(true);
        }

        void requestToStop() {
            this.stop = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!CleanupThread.interrupted() && !this.stop) {
                try {
                    CleanupThread.sleep(this.ms);
                    Iterator iter = SessionCache.this.userInfoMap.values().iterator();
                    while (iter.hasNext()) {
                        SoftReference ref = (SoftReference)iter.next();
                        if (ref.get() != null) continue;
                        iter.remove();
                    }
                }
                catch (InterruptedException ex) {
                    if (!this.stop) continue;
                    break;
                }
            }
        }
    }
}

