/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.app;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.tentackle.app.AbstractApplication;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.LoggerOutputStream;
import org.tentackle.misc.ApplicationException;
import org.tentackle.misc.CommandLine;
import org.tentackle.misc.StringHelper;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoTracker;
import org.tentackle.pdo.PersistenceException;
import org.tentackle.pdo.SessionInfo;
import org.tentackle.pdo.SessionManager;
import org.tentackle.pdo.SessionManagerProvider;
import org.tentackle.pdo.SessionPool;
import org.tentackle.pdo.SessionPoolProvider;
import org.tentackle.persist.ConnectionManager;
import org.tentackle.persist.Db;
import org.tentackle.persist.DefaultDbPool;
import org.tentackle.persist.MpxConnectionManager;
import org.tentackle.persist.rmi.DbServer;
import org.tentackle.persist.rmi.RemoteDbConnectionImpl;
import org.tentackle.persist.rmi.RemoteDbSessionImpl;
import org.tentackle.prefs.PersistedPreferencesFactory;
import org.tentackle.reflect.ReflectionHelper;

public abstract class ServerApplication
extends AbstractApplication
implements SessionPoolProvider,
SessionManagerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerApplication.class);
    private final Class<? extends RemoteDbConnectionImpl> connectionClass;
    private CommandLine cmdLine;
    private DbServer dbServer;
    private String sessionPropsName;
    private SessionManager sessionManager;
    private Db serverDb;
    private SessionPool sessionPool;
    private boolean stopping;

    public static ServerApplication getServerApplication() {
        return (ServerApplication)ServerApplication.getRunningApplication();
    }

    public ServerApplication(String name, Class<? extends RemoteDbConnectionImpl> connectionClass) {
        super(name);
        this.connectionClass = connectionClass;
    }

    public CommandLine getCommandLine() {
        return this.cmdLine;
    }

    public DbServer getDbServer() {
        return this.dbServer;
    }

    public boolean isServer() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args) {
        ServerApplication serverApplication = this;
        synchronized (serverApplication) {
            this.cmdLine = new CommandLine(args);
            this.setProperties(this.cmdLine.getOptionsAsProperties());
            try {
                LOGGER.fine("register application server", new Object[0]);
                this.register();
                LOGGER.fine("initialize application server", new Object[0]);
                this.doInitialize();
                LOGGER.fine("login to backend", new Object[0]);
                this.doLogin();
                LOGGER.fine("configure application server", new Object[0]);
                this.doConfigureApplication();
                LOGGER.fine("finish startup", new Object[0]);
                this.doFinishStartup();
                LOGGER.fine("start services", new Object[0]);
                this.doStartDbServer();
            }
            catch (Exception e) {
                this.doStop(3, e);
            }
        }
    }

    public void start() {
        this.start(null);
    }

    public void stop() {
        try {
            this.doStop(0);
        }
        catch (Exception e) {
            LOGGER.logStacktrace((Throwable)e);
        }
        finally {
            try {
                this.unregister();
            }
            catch (ApplicationException ex) {
                LOGGER.logStacktrace((Throwable)ex);
            }
        }
    }

    protected void configurePreferences() {
        super.configurePreferences();
        PersistedPreferencesFactory.getInstance().setSystemOnly(true);
    }

    protected DbServer createDbServer(Class<? extends RemoteDbConnectionImpl> connectionClass) throws ApplicationException {
        return new DbServer(this.getSessionInfo(), connectionClass);
    }

    public SessionManager createSessionManager() {
        return new MpxConnectionManager(this.serverDb);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public SessionPool createSessionPool() {
        return new DefaultDbPool((ConnectionManager)this.getSessionManager(), this.getSessionInfo()){

            @Override
            public Db getSession() {
                Db db = super.getSession();
                SessionInfo sessionInfo = this.getSessionInfo().clone();
                db.setSessionInfo(sessionInfo);
                sessionInfo.setUserId(0L);
                sessionInfo.setUserClassId(0);
                sessionInfo.setUserName(null);
                return db;
            }
        };
    }

    public SessionPool getSessionPool() {
        return this.sessionPool;
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        if (sessionInfo == null) {
            throw new NullPointerException("userinfo must not be null");
        }
        if (this.getSessionInfo() != null) {
            throw new PersistenceException("userinfo already set, cannot be changed in a running server");
        }
        sessionInfo.setImmutable(true);
        super.setSessionInfo(sessionInfo);
    }

    protected void doLogin() throws ApplicationException {
        char[] passwd;
        String username = this.getProperty("user");
        char[] password = StringHelper.toCharArray((String)this.getProperty("password"));
        this.sessionPropsName = this.getProperty("backend");
        SessionInfo sessionInfo = this.createSessionInfo(username, password, this.sessionPropsName);
        Properties sessionProps = null;
        try {
            sessionProps = sessionInfo.getProperties();
        }
        catch (PersistenceException e1) {
            sessionInfo.setProperties(this.getProperties());
        }
        if (sessionProps != null) {
            for (String key : this.getProperties().stringPropertyNames()) {
                sessionProps.setProperty(key, this.getProperties().getProperty(key));
            }
            sessionInfo.setProperties(sessionProps);
        }
        if (sessionInfo.getApplicationName() == null) {
            sessionInfo.setApplicationName(ReflectionHelper.getClassBaseName(((Object)((Object)this)).getClass()));
        }
        sessionInfo.applyProperties();
        if (this.serverDb != null) {
            throw new ApplicationException("only one server application instance allowed");
        }
        this.serverDb = (Db)this.createSession(sessionInfo);
        username = this.serverDb.getBackendInfo().getUser();
        if (username != null) {
            sessionInfo.setUserName(username);
        }
        if ((passwd = this.serverDb.getBackendInfo().getPassword()) != null && passwd.length > 0 && passwd[0] != '\u0000') {
            sessionInfo.setPassword(passwd);
        }
        this.serverDb.open();
        this.serverDb.makeCurrent();
        this.setSessionInfo(sessionInfo);
        DomainContext context = this.createDomainContext(this.serverDb);
        if (context == null) {
            throw new ApplicationException("creating the database context failed");
        }
        this.setDomainContext(context);
    }

    protected void doFinishStartup() throws ApplicationException {
        super.doFinishStartup();
        PdoTracker.getInstance().addShutdownRunnable(() -> this.stop());
        this.sessionManager = this.createSessionManager();
        this.sessionPool = this.createSessionPool();
        this.dbServer = this.createDbServer(this.connectionClass);
    }

    protected void doStartDbServer() throws ApplicationException {
        this.dbServer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(int exitValue, Exception ex) {
        ServerApplication serverApplication = this;
        synchronized (serverApplication) {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
        }
        LOGGER.info("terminating server {0} with exit value {1} ...", new Object[]{this.getName(), exitValue});
        if (ex != null) {
            LoggerOutputStream.logException((Exception)ex, (Logger)LOGGER);
        }
        try {
            for (RemoteDbSessionImpl session : RemoteDbSessionImpl.getOpenSessions()) {
                try {
                    session.close();
                }
                catch (RuntimeException rex) {
                    LOGGER.warning("closing pending session " + session + " failed:", (Throwable)rex);
                }
            }
            Pdo.terminateHelperThreads();
            RemoteDbSessionImpl.stopCleanupThread();
            if (this.sessionPool != null) {
                this.sessionPool.shutdown();
                this.sessionPool = null;
            }
            if (this.serverDb != null) {
                this.serverDb.close();
                this.serverDb = null;
            }
            if (this.sessionManager != null) {
                this.sessionManager.shutdown();
                this.sessionManager = null;
            }
            if (this.dbServer != null) {
                this.dbServer.stop();
                this.dbServer = null;
            }
            if (this.isRunningInContainer()) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                while (drivers.hasMoreElements()) {
                    Driver driver = drivers.nextElement();
                    if (driver.getClass().getClassLoader() == cl) {
                        try {
                            LOGGER.info("deregistering JDBC driver {0}", new Object[]{driver});
                            DriverManager.deregisterDriver(driver);
                        }
                        catch (SQLException sx) {
                            LOGGER.severe("failed to deregister JDBC driver {0}", new Object[]{driver, sx});
                        }
                        continue;
                    }
                    LOGGER.fine("JDBC driver {0} skipped because it does not belong to this webapp's ClassLoader", new Object[]{driver});
                }
            }
        }
        catch (Exception anyEx) {
            LOGGER.severe("server application stopped ungracefully", (Throwable)anyEx);
        }
        if (!this.isRunningInContainer()) {
            System.exit(exitValue);
        }
    }

    protected void doStop(int exitValue) {
        this.doStop(exitValue, null);
    }
}

