/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.persist;

import java.util.List;
import java.util.Objects;
import org.tentackle.dbms.AbstractDbOperation;
import org.tentackle.dbms.Db;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainDelegate;
import org.tentackle.pdo.Operation;
import org.tentackle.pdo.OperationMethodCache;
import org.tentackle.pdo.OperationMethodCacheProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistenceDelegate;
import org.tentackle.pdo.PersistentOperation;
import org.tentackle.persist.PersistentOperationClassVariables;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.session.PersistenceException;
import org.tentackle.session.Session;
import org.tentackle.session.SessionHolder;

public abstract class AbstractPersistentOperation<T extends Operation<T>, P extends AbstractPersistentOperation<T, P>>
extends AbstractDbOperation<P>
implements PersistenceDelegate<T>,
PersistentOperation<T>,
EffectiveClassProvider<T>,
OperationMethodCacheProvider<T> {
    private static final long serialVersionUID = 1L;
    private DomainContext context;
    private transient boolean contextImmutable;
    private T operation;

    public AbstractPersistentOperation(T operation, DomainContext context) {
        this.operation = operation;
        this.setDomainContext(context);
    }

    public AbstractPersistentOperation(T operation, Session session) {
        super((Db)session);
        this.operation = operation;
    }

    public AbstractPersistentOperation(T operation) {
        this.operation = operation;
    }

    public AbstractPersistentOperation() {
    }

    public DomainDelegate<T> getDomainDelegate() {
        return this.operation.getDomainDelegate();
    }

    public Class<T> getEffectiveClass() {
        return this.operation.getEffectiveClass();
    }

    public List<Class<? super T>> getEffectiveSuperClasses() {
        return this.operation.getEffectiveSuperClasses();
    }

    public PersistentOperationClassVariables<T, P> getClassVariables() {
        throw new PersistenceException("classvariables undefined for " + ((Object)((Object)this)).getClass());
    }

    public OperationMethodCache<T> getOperationMethodCache() {
        return this.getClassVariables().methodCache;
    }

    public void setSession(Session session) {
        if (this.context != null) {
            this.context.setSession(session);
        }
        super.setSession(session);
    }

    public void setDomainContext(DomainContext context) {
        if (this.context != context) {
            this.assertDomainContextMutable();
            this.context = Objects.requireNonNull(context, "context");
            this.setSessionHolder((SessionHolder)context);
            this.determineContextId();
        }
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    public T me() {
        return this.operation;
    }

    public T getOperation() {
        return this.operation;
    }

    public void setOperation(T operation) {
        this.operation = operation;
    }

    public void determineContextId() {
    }

    public long getContextId() {
        return -1L;
    }

    public DomainContext getBaseContext() {
        return this.getDomainContext();
    }

    public DomainContext createValidContext() {
        Object session = Session.getCurrentSession();
        session = session != null ? null : this.getSession();
        return Pdo.createDomainContext((Session)session);
    }

    public boolean isDomainContextImmutable() {
        return this.contextImmutable;
    }

    public void setDomainContextImmutable(boolean contextImmutable) {
        this.contextImmutable = contextImmutable;
    }

    protected void assertDomainContextMutable() {
        if (this.isDomainContextImmutable()) {
            throw new PersistenceException((Session)this.getSession(), "domain context is immutable");
        }
    }
}

